/*********************************************************
     This is code for read-in tables in XPP  
     This should probably be accessible from within the program
     as well.  It will probably be added to the Numerics Menu

     The files consist of y-values of a function evaluated at
     equally spaced points as well as some header information.  
     They are ascii files of the form:

     npts <-- Integer
     xlo <--- fp
     xhi <--  fp
     y1  <-- fp
     y2
     ...
     yn

     Thus   dx = (xhi-xlo)/(npts-1)


  In the creation of the file, one can instead use the following:
  
 table <name> % numpts xlo xhi formula

 to create a "formula" table which is linearly interpolated

**************************************************************/

#include <math.h>
#include <stdio.h>
#define MAX_TAB 50
typedef struct {
  double xlo,xhi,dx;
  double *y;
  int n,flag;  /* flag=0 if virgin array, flag=1 if already allocated */
  char filename[80];
}TABULAR;

TABULAR my_table[MAX_TAB];

double atof();
double get_ivar();
double evaluate();

extern int NTable;

extern int NCON,NSYM,NCON_START,NSYM_START;

new_lookup()
{
 char file[100];
 char name[10];
 int index;
 double xlo,xhi;
 int npts;
 char newform[80];
 if(NTable==0)return;
 while(1){
   name[0]=0;
   new_string("Lookup name ",name);
   if(strlen(name)==0)return;
   index=find_lookup(name);
   if(index!=-1){
     if(my_table[index].flag==1){
       if(new_string("Filename:",file)){
	 load_table(file,index);
       }
     }
     if(my_table[index].flag==2){
       npts=my_table[index].n;
       xlo=my_table[index].xlo;
       xhi=my_table[index].xhi;
       strcpy(newform,my_table[index].filename);
       new_int("NPts: ",&npts);
       new_float("Xlo: ",&xlo);
       new_float("Xhi: ",&xhi);
       new_string("Formula :",newform);
       create_fun_table(npts,xlo,xhi,newform,index);
       
     }
   }
   else err_msg("Not a Table function");
 }
}
   

double lookup(x,index)
     int index;
     double x;
{
  double xlo=my_table[index].xlo,xhi=my_table[index].xhi,dx=my_table[index].dx;
  double *y;
  double x1,y1,y2;
  int i1,i2,n=my_table[index].n;
  y=my_table[index].y;
  if(my_table[index].flag==0)return(0.0); /* Not defined   */
  i1=(int)((x-xlo)/dx);
  i2=i1+1;
    if(i1>-1&&i2<n){
    x1=dx*i1+xlo;
    y1=y[i1];
    y2=y[i2];
    return(y1+(y2-y1)*(x-x1)/dx);
  }
  if(i1<0)return(y[0]+(y[1]-y[0])*(x-xlo)/dx);
  if(i2>=n)return(y[n-1]+(y[n-1]-y[n-2])*(x-xhi)/dx);
}
  
 
init_table()
{
  int i;
  for(i=0;i<MAX_TAB;i++)my_table[i].flag=0;
}

redo_all_fun_tables()
{
  int i;
  for(i=0;i<NTable;i++){
    if(my_table[i].flag==2)
      eval_fun_table(my_table[i].n,my_table[i].xlo,
		     my_table[i].xhi,my_table[i].filename,my_table[i].y);
  }
}

eval_fun_table(n,xlo,xhi,formula,y)
     int n;
     char *formula;
     double xlo,xhi,*y;
{
  int i;
  int ok=0;
  double dx,x;
  double oldt;
  int command[200],ncold=NCON,nsym=NSYM;
  if(add_expr(formula,command,&i)){
    err_msg("Illegal formula...");
    NCON=ncold;
    NSYM=nsym;
    return(0);
  }
  oldt=get_ivar(0);
  dx=(xhi-xlo)/((double)(n-1));
  for(i=0;i<n;i++){
    set_ivar(0,dx*i+xlo);
    y[i]=evaluate(command);
  }
  set_ivar(0,oldt);
  NCON=ncold;
  NSYM=nsym;
  return(1);
}
 
 
create_fun_table(npts,xlo,xhi,formula,index)
     int npts;
     int index;
     double xlo,xhi;
     char *formula;
{
  int i,length=npts;
   if(my_table[index].flag==1){
    err_msg("Not a function table...");
    return(0);
  }
  if(xlo>xhi){
    err_msg("Xlo > Xhi ???");
    return(0);
  }
  if(npts<2){
    err_msg("Too few points...");
    return(0);
  }
  if(my_table[index].flag==0){
   my_table[index].y=(double *)malloc(length*sizeof(double));
   }
  else {
    my_table[index].y=
      (double *)realloc((void *)my_table[index].y,length*sizeof(double));
  }
  if(my_table[index].y==NULL){
     err_msg("Unable to allocate table");
     return(0);
   }
  my_table[index].flag=2;
  if(eval_fun_table(npts,xlo,xhi,formula,my_table[index].y)){
    my_table[index].xlo=xlo;
    my_table[index].xhi=xhi;
    my_table[index].n=npts;
    my_table[index].dx=(xhi-xlo)/((double)(npts-1));
    strcpy(my_table[index].filename,formula);
    return(1);
  }
   return(0);
}





load_table(filename,index)
     char *filename;
     int index; 
{
  int i;
  char bob[100];
  int length;
  double xlo,xhi;
  FILE *fp;
  if(my_table[index].flag==2){
    err_msg("Not a file table...");
    return(0);
  }
  fp=fopen(filename,"r");
  if(fp==NULL){
    err_msg("File not found");
    return(0);
  }
  fgets(bob,100,fp);
  length=atoi(bob);
  if(length<2){
    err_msg("Length too small");
    fclose(fp);
    return(0);
  }
  fgets(bob,100,fp);
  xlo=atof(bob);
  fgets(bob,100,fp);
  xhi=atof(bob);
  if(xlo>=xhi){
    err_msg("xlo >= xhi ??? ");
    fclose(fp); 
    return(0);
  }
  if(my_table[index].flag==0){
   my_table[index].y=(double *)malloc(length*sizeof(double));
   if(my_table[index].y==NULL){
     err_msg("Unable to allocate table");
     fclose(fp); 
     return(0);
   }
   for(i=0;i<length;i++){
     fgets(bob,100,fp);
     my_table[index].y[i]=atof(bob);
   }
   my_table[index].xlo=xlo;
   my_table[index].xhi=xhi;
   my_table[index].n=length;
   my_table[index].dx=(xhi-xlo)/(length-1);
   my_table[index].flag=1;
   strcpy(my_table[index].filename,filename);
   fclose(fp); 
   return(1);
 }
  my_table[index].y=
    (double *)realloc((void *)my_table[index].y,length*sizeof(double));
  if(my_table[index].y==NULL){
     err_msg("Unable to reallocate table");
     fclose(fp);
     return(0);
   }
  for(i=0;i<length;i++){
     fgets(bob,100,fp);
     my_table[index].y[i]=atof(bob);
   }
  my_table[index].xlo=xlo;
  my_table[index].xhi=xhi;
  my_table[index].n=length;
  my_table[index].dx=(xhi-xlo)/(length-1);
  my_table[index].flag=1;
  fclose(fp);
  return(1);
}
   






