#include "volterra.h"

#define MAX_SYMBS 512

#define NEGATE 9
#define MINUS 4
#define LPAREN 0
#define RPAREN 1
#define COMMA  2
#define STARTTOK 10
#define ENDTOK 11
#define UFUN   4
#define MAXUFUN 50
#define ENDEXP 999
#define ENDFUN 998
#define STARTDELAY 980
#define FUNTYPE 4
#define VARTYPE 2
#define CONTYPE 3
#define DELSYM  42
#define ENDDELAY 996
#define MYIF  995
#define MYELSE 993
#define MYTHEN 994
#define LASTTOK 249


#define CONV 2
#define STDSYM 59

#define MAX_TAB 50


typedef struct
        {
         char name[10];
         int len;
         int com;
         int arg;
         int pri;
        } SYMBOL;

SYMBOL my_symb[MAX_SYMBS]=
{
   "(",1,999,0,1,      /*  0   */
   ")",1,999,0,2,
   ",",1,999,0,3,
   "+",1,100,0,4,
   "-",1,101,0,4,
   "*",1,102,0,6,
   "/",1,103,0,6,
   "^",1,105,0,7,
   "**",2,105,0,7,
   "~",1,14,0,6,
   "START",5,-1,0,0,  /* 10  */
   "END",3,999,0,-1,
   "ATAN2",5,104,2,10,
   "MAX",3,106,2,10,
   "MIN",3,107,2,10,
   "SIN",3,0,0,10,
   "COS",3,1,0,10,
   "TAN",3,2,0,10,
   "ASIN",4,3,0,10,
   "ACOS",4,4,0,10,
   "ATAN",4,5,0,10,  /* 20  */
   "SINH",4,6,0,10,
   "TANH",4,7,0,10,
   "COSH",4,8,0,10,
   "ABS",3,9,0,10,
   "EXP",3,10,0,10,
   "LN",2,11,0,10,
   "LOG",3,11,0,10,
   "LOG10",5,12,0,10,
   "SQRT",4,13,0,10,
   "HEAV",4,16,0,10,  /*  30 */
   "SIGN",4,17,0,10,
   "ARG1",4,800,0,10,
   "ARG2",4,801,0,10,
   "ARG3",4,802,0,10,
   "ARG4",4,803,0,10,
   "ARG5",4,804,0,10,
   "ARG6",4,805,0,10,
   "ARG7",4,806,0,10,
   "ARG8",4,807,0,10,
   "FLR",3,18,0,10,  /*  40 */
   "MOD",3,108,2,10, /*  41 */
   "DELAY",5,996,2,10,      /*  42 */   /*  Delay symbol */
   "RAN",3,19,1,10, /* 43 */
    "&",1,109,0,6,  /* logical stuff  */
   "|",1,110,0,4,
   ">",1,111,0,7,
   "<",1,112,0,7,
   "==",2,113,0,7,
   ">=",2,114,0,7,
   "<=",2,115,0,7, /*50 */
   "IF",2,995,1,10, 
   "THEN",4,994,1,10,
   "ELSE",4,993,1,10,
   "!=",2,116,0,7,
   "NOT",3,20,0,6,
   "NORMAL",6,117,2,10, /* returns normally dist number */
   "BESSELJ",7,118,2,10, /* Bessel J   */
   "BESSELY",7,119,2,10, /* Bessel Y */
      };



int NSYM=STDSYM,NCON=0,NVAR=0,NFUN=0;

/*     pointers to functions    */

double (*fun1[25])(/* double */ );
double (*fun2[25])(/* double,double */ );


/*              double functions of two values             */



double dand(),dor(),dge(),dle(),deq(),dne(),dlt(),dgt(),dnot();


double d_if();

double normal();
double max(/* double,double */ );
double min(/* double,double */ );
double neg(/* double */ );
double recip(/* double */ );
double signum(/* double */ );
double heaviside(/* double */ );
double rndom(/* double */ );
double bessel_j();
double bessel_y();
/*****************************************************/

double evaluate(/* int* */ );

double get_ivar(/* int i */ );

double eval_rpn(/* int* */ );
double ker_val();
double pop(  );

int stack_pointer,uptr;
double constants[200];
double variables[100];
int *ufun[MAXUFUN];
char *ufun_def[MAXUFUN];
double stack[200],ustack[200];

KERNEL kernel[MAXKER];
int NKernel;
int MaxPoints;
double *Memory[50];
int NTable;



































