#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <math.h>
#include "browse.h"
extern Window main_win;
extern Display *display;
extern int DCURY;
extern int RandSeed;
#include "struct.h"
extern GRAPH *MyGraph;
#define MAX_LEN_SBOX 25
#define VOLTERRA 6
#define BACKEUL 7
#define BACKVOLT 8
#define GEAR 5
extern int NKernel,MyStart,MaxPoints;


double atof();

/*   This is numerics.c    
 *   The input is primitive and eventually, I want to make it so
	that it uses nice windows for input. 
	For now, I just will let it remain command driven
*/


(*solver)();
extern  double DELTA_T,TEND,T0,TRANS,
	NULL_ERR,EVEC_ERR,NEWT_ERR;
extern double BOUND,DELAY,TOLER,HMIN,HMAX;
float *fft_data,*hist_data,color_scale,min_scale;
extern double POIPLN;

extern double BVP_TOL,BVP_EPS;

extern int NMESH,NJMP,METHOD,NC_ITER;
extern int EVEC_ITER;
extern int BVP_MAXIT,BVP_NL,BVP_NR;

extern int POIMAP,POIVAR,POISGN,SOS;

 extern int HIST,HVAR,hist_ind,FOREVER,INFLAG;
extern int MaxEulIter;
extern double EulTol;

extern int AutoEvaluate;

 gear();
 discrete();
 euler();
 mod_euler();
 rung_kut();
 adams();
 volterra();
 bak_euler();



extern int COLOR,color_total,color_min;
extern Window command_pop;

/*   This is the input for the various functions */

/*   I will need access to storage  */

extern float **storage;
extern int storind;

extern int NODE,NEQ; /* as well as the number of odes etc  */
 check_pos(j)
 int *j;
 {
  if(*j<=0)*j=1;
 }

 get_num_par(ch)
 char ch;

{
  double temp;
  int tmp;
   switch(ch){
               case 'a':
                       make_adj();
		       break;

		case 't': flash(0);
			 /* total */
			 new_float("total :",&TEND);
			  FOREVER=0;
			  if(TEND<0)
			  {
			    FOREVER=1;
			    TEND=-TEND;
                          }


			flash(0);
			break;
		case 's': flash(1);
			 /* start */
			 new_float("start time :",&T0);
			flash(1);
			break;
		case 'r': flash(2);
			 /* transient */
			 new_float("transient :",&TRANS);
			flash(2);
			break;
		case 'd': flash(3);
			 /* DT */
		         temp=DELTA_T;
			 new_float("Delta t :",&DELTA_T);
		         if(DELTA_T==0.0)DELTA_T=temp;
		         if(DELAY>0.0) {
			  free_delay();
			  if(alloc_delay(DELAY)){
			    INFLAG=0; /*  Make sure no last ics allowed */
			  }
			}
			  else 
			    free_delay();
		       if(NKernel>0){
			 INFLAG=0;
			 MyStart=1;
			 alloc_kernels(1);
		       }
		       /* if(NMemory>0){
			  make_kernels();
			  reset_memory();
			  INFLAG=0;
			} */
			flash(3);
			break;
		case 'n': flash(4);
			 /* ncline */
			 new_int("ncline mesh :",&NMESH);
			/* new_float("Error :",&NULL_ERR); */
                          check_pos(&NMESH);

			flash(4);
			break;
		case 'v':
		      /*   new_int("Number Left :", &BVP_NL);
		         new_int("Number Right :", &BVP_NR); */
		        
		         new_int("Maximum iterates :",&BVP_MAXIT);
		         check_pos(&BVP_MAXIT);
		         new_float("Tolerance :",&BVP_TOL);
		         new_float("Epsilon :",&BVP_EPS);
		         reset_bvp();
		         break;
		case 'i': flash(5);
			 /* sing pt */
			 new_int("Maximum iterates :",&EVEC_ITER);
			 check_pos(&EVEC_ITER);
			 new_float("Eigenvector error :",&EVEC_ERR);
			 new_float("Newton Error :",&NEWT_ERR);
			flash(5);
			break;
		case 'o': flash(6);
			 /* noutput */
			new_int("n_out :",&NJMP);
			 check_pos(&NJMP);

			flash(6);
			break;
		case 'b': flash(7);
			 /* bounds */
			new_float("Bounds :",&BOUND); BOUND=fabs(BOUND);

			flash(7);
			break;
		case 'm': flash(8);
			 /* method */
			 get_method();
		        if(METHOD==VOLTERRA&&NKernel==0)METHOD=4;
		       if(NKernel>0)METHOD=VOLTERRA;
			if(METHOD==GEAR)
		{
		 new_float("Tolerance :",&TOLER);
		 new_float("minimum step :",&HMIN);
		 new_float("maximum step :",&HMAX);
		}
		       if(METHOD==BACKEUL||METHOD==VOLTERRA){
			 new_float("Tolerance :",&EulTol);
			 new_int("MaxIter :",&MaxEulIter);
		       }
		       if(METHOD==VOLTERRA){
			 tmp=MaxPoints;
			 new_int("MaxPoints:",&tmp);
			 new_int("AutoEval(1=yes) :",&AutoEvaluate);
			 allocate_volterra(tmp,1);
		       }
			 
			 

			flash(8);
			break;
		case 'e': flash(9);
			 /* delay */
			new_float("Maximal delay :",&DELAY);
		        if(DELAY>0.0) {
			  free_delay();
			  if(alloc_delay(DELAY)){
			    INFLAG=0; /*  Make sure no last ics allowed */
			  }
			}
			  else 
			    free_delay();
			  
			flash(9);
			break;
		case 'c': flash(10);
			 /* color */
			 if(COLOR==0)break;
			  set_col_par();
			flash(10);
			break;
		    case 'h': flash(11);
		          do_stochast();
		          flash(11);
		          break;      
		case 'f': flash(11);
			 /* FFT */
			flash(11);
			break;
		case 'p': flash(12);
			 /*Poincare map */
		        get_pmap_pars();
			flash(12);
			break;
		case 'u': flash(13);
			 /* ruelle */
                       ruelle();
			flash(13);
			break;
		case 'k': flash(14);
			 /*lookup table */
                        new_lookup();
			flash(14);
			break;
		case 27: 
		       do_meth();
		      TEND=fabs(TEND);
		    
			help();
			break;

		}  /* End num switch */
	   } 


ruelle()
{
   new_int("x-axis shift ",&(MyGraph->xshft));
   new_int("y-axis shift ",&(MyGraph->yshft));
   new_int("z-axis shift",&(MyGraph->zshft));
   if(MyGraph->xshft<0)MyGraph->xshft=0;
   if(MyGraph->yshft<0)MyGraph->yshft=0;
   if(MyGraph->zshft<0)MyGraph->zshft=0;
}

init_numerics()
/*    these are the default values of the numerical parameters   */
{

  DELTA_T=.05;
TEND=20.0;
T0=0.0;
TRANS=0.0;
 NULL_ERR=.001;
 EVEC_ERR=.001;
 NEWT_ERR=.001;
 BOUND=100.0;
 DELAY=0.0;
TOLER=.00001;
HMIN=.001;
HMAX=1.0;

POIPLN=0.0;
 NMESH=50;
NJMP=1;
 METHOD=4;
NC_ITER=100;
EVEC_ITER=100;

POIMAP=0;
POIVAR=1;
POISGN=1;
SOS=0;

}

 
get_pmap_pars()
{
 static char *map[]={"(N)one","(S)ection","(M)ax/min"};
 static char mkey[]="nsm";
 char ch;
 static char *n[]={"Variable","Section","Direction (+1,-1,0)","Stop on sect(y/n)"};
 char values[4][MAX_LEN_SBOX];
 static char *yn[]={"N","Y"};
 int status,i;
 char n1[15];
 int i1=POIVAR;
 Window temp=main_win;

 ch=(char)pop_up_list(&temp,"Poincare map",map,mkey,3,13,POIMAP,10,6*DCURY+8);
 POIMAP=0;
 if(ch=='s')POIMAP=1;
 if(ch=='m')POIMAP=2;
 
 if(POIMAP==0)return;
   
 ind_to_sym(i1,n1);
 sprintf(values[0],"%s",n1);
 sprintf(values[1],"%.16g",POIPLN);
 sprintf(values[2],"%d",POISGN);
 sprintf(values[3],"%s",yn[SOS]);
 status=do_string_box(4,4,1,"Poincare map",n,values,45);
 if(status!=0){
              find_variable(values[0],&i1);
	      if(i1<0) { POIMAP=0;
			 return;
		       }
	      POIVAR=i1;
	      POISGN=atoi(values[2]);
	      if(values[3][0]=='Y'||values[3][0]=='y')SOS=1;
	      else SOS=0;
	      POIPLN=atof(values[1]);
	    }
}



/*  Using check boxes -- no KB shortcuts !!   

get_method()
{
  static char *n[]={"Discrete","Euler","Mod. Euler",
	"Runge-Kutta","Adams","Gear","Volterra","BackEul"};
  static int check[]={0,0,0,0,0,0,0,0};
  int status,i;
  check[METHOD]=1;
  status=base_choice("Method",8,1.52,n,check,0);
  if(status!=0){
   for(i=0;i<8;i++)if(check[i]==1)METHOD=i;
   
   }

}

*/

get_method()
{
 char ch;
 int i;
 Window temp=main_win;
 static char *n[]={"(D)iscrete","(E)uler","(M)od. Euler",
	"(R)unge-Kutta","(A)dams","(G)ear","(V)olterra","(B)ackEul"};
 static char key[]="demragvb";
 ch = (char)pop_up_list(&temp,"Method",n,key,8,14,METHOD,10,10*DCURY+8);
 for(i=0;i<8;i++)
 if(ch==key[i])METHOD=i;
	/* XDestroyWindow(display,temp); */
 }

 
  set_col_par()
   {
    char ch;
    Window tempw=main_win;
    static char *n[]={"(N)o color","(V)elocity","(Z)-axis"};
    static char key[]="nvz";
    int i,j,koff;
    double temp[2];
    float maxder=0.0,minder=0.0,sum=0.0;
    ch=(char)pop_up_list(&tempw,"Color code",n,key,
	3,11,MyGraph->ColorFlag,10,12*DCURY+8);
    /* XDestroyWindow(display,tempw); */
    for(i=0;i<3;i++)if(ch==key[i])MyGraph->ColorFlag=i;
   if(MyGraph->ColorFlag==0){
   /* set color to black/white */
    return;
    }

    
   /*   This will be uncommented    ..... */
    ch=two_choice("(O)ptimize","(C)hoose","Color","oc",0,0,main_win);
 
    if(ch=='c')
    {
     temp[0]=MyGraph->min_scale;
     temp[1]=MyGraph->min_scale+MyGraph->color_scale;
     new_float("Min :",&temp[0]);
     new_float("Max :",&temp[1]);
     if(temp[1]>temp[0]&&((MyGraph->ColorFlag==2)
     ||(MyGraph->ColorFlag==1&&temp[0]>0.0)))
     {
      MyGraph->min_scale=temp[0];
      MyGraph->color_scale=(temp[1]-temp[0]);
     }
     return;
    }
    if(MyGraph->ColorFlag==1)
    {
    if(storind<2)return;
    maxder=0.0;
    minder=1.e20;
  for(i=1;i<storind;i++)
  {
   sum=0.0;
   for(j=0;j<NODE;j++)
   sum+=(float)fabs((double)(my_browser.data[1+j][i]-my_browser.data[1+j][i-1]));
   if(sum<minder)minder=sum;
   if(sum>maxder)maxder=sum;
  }
  if(minder>=0.0&&maxder>minder)
  {
   MyGraph->color_scale=(maxder-minder)/(fabs(DELTA_T*NJMP)*NODE);
   MyGraph->min_scale=minder/(fabs(DELTA_T*NJMP)*NODE);
  }
 }
 else
 {
  get_max(MyGraph->zv[0],&temp[0],&temp[1]);
  MyGraph->min_scale=temp[0];
  MyGraph->color_scale=(temp[1]-temp[0]);
  if(MyGraph->color_scale==0.0)MyGraph->color_scale=1.0;
 }
  
}
 


do_meth()
{
 if(NKernel>0)METHOD=VOLTERRA;
 switch(METHOD)
 {
  case 0: solver=discrete; POIMAP=0;break;
  case 1: solver=euler;break;
  case 2: solver=mod_euler;break;
  case 3: solver=rung_kut;break;
  case 4: solver=adams;break;
  case 5: NJMP=1;break;
  case 6: solver=volterra;break;
  case BACKEUL: solver=bak_euler;break;
  default: solver=adams;
 }
}




