#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include "help_defs.h"
#include "graph.bitmap"
#include "struct.h"
#define MAXPOP  11
#define MAXLAB 50

LABEL lb[MAXLAB];
GRAPH graph[MAXPOP];
GRAPH *MyGraph;
extern int help_menu,screen;
extern int SCALEY;

extern int storind;

extern Display *display;
extern Window main_win,draw_win,menu_pop,command_pop;
int current_pop;
extern unsigned long MyBackColor,MyForeColor,GrFore,GrBack;
extern GC gc, gc_graph,small_gc;
extern int COLOR,color_min;
extern int xor_flag,DCURX,DCURY;
int num_pops;
text_abs();


make_icon(icon,wid,hgt,w)
char *icon;
Window w;
int wid,hgt;
{
Pixmap icon_map; 
XWMHints wm_hints;
 icon_map=XCreateBitmapFromData(display,w,icon,wid,hgt);
wm_hints.initial_state=NormalState;
wm_hints.input=True;
wm_hints.icon_pixmap=icon_map;
 wm_hints.flags=StateHint|IconPixmapHint|InputHint;

XSetWMProperties(display,w,NULL,NULL,NULL,0,NULL,&wm_hints,NULL);

}


 title_text(string)
 char *string;
 {
  XTextProperty wname,iname;
  GrCol();
  if(draw_win!=graph[0].w){
  XStringListToTextProperty(&string,1,&wname);
  XStringListToTextProperty(&string,1,&iname);
 XSetWMProperties(display,draw_win,&wname,&iname,NULL,0,NULL,NULL,NULL);
  }
  else
  {
  int len=strlen(string);
  int x,y,w,h,bw,de;
 int xs,ys=2;
 Window root;
 XGetGeometry(display,draw_win,&root,&x,&y,&w,&h,&bw,&de);
 xs=(w-len*DCURX)/2;
 if(xs<0)xs=0;
 ftext(xs,ys,string,draw_win);
 set_color(0);
 line(0,18,w,18,draw_win);
 }
BaseCol();
 }




 restore_off()
{
 MyGraph->Restore=0;
 /* MyGraph->Nullrestore=0; */
 }

 restore_on()
{
  MyGraph->Restore=1;
/*  MyGraph->Nullrestore=1; */

}
 
  
add_label(s,x,y)
char *s;
int x,y;
{ int i;
 float xp,yp;
 scale_to_real(x,y,&xp,&yp);
 for(i=0;i<MAXLAB;i++)
 {
  if(lb[i].use==0){
	lb[i].use=1;
	lb[i].x=xp;
	lb[i].y=yp;
	lb[i].w=draw_win;
	strcpy(lb[i].s,s);
        return;
  }
 }
}

destroy_label(w)
Window w;
{
  int i;
  for(i=0;i<MAXLAB;i++){
  if((lb[i].use==1)&&(lb[i].w==w)){
	lb[i].use=0;
	lb[i].w=(Window)0;
   }
  }
}
 
draw_label(w)
Window w;
{
 int i;
 GrCol();
 for(i=0;i<MAXLAB;i++){
	if((lb[i].use==1)&&(lb[i].w==w))
	text_abs(lb[i].x,lb[i].y,lb[i].s);
 }
 BaseCol();
}

do_windows()
{
 char ch;
 static char *list[]={"(C)reate","(K)ill all","(D)estroy","(B)ottom",
		"(A)uto","(M)anual"};
 static char key[]="ckdbam";
 static char title[]="Halfwindow";

 Window temp=main_win;
 ch=(char)pop_up_list(&temp,title,list,key,6,11,0,10,14*DCURY+8);
 switch(ch){
        case 27: break;
	
	case 'c': create_a_pop();
         		break;
 	case 'k': 
		if(yes_no_box())kill_all_pops();
		break;
	case 'b': 
		 XLowerWindow(display,draw_win);
		break;
	case 'd': destroy_a_pop();
		break;
	case 'm': set_restore(0);
		 break;
        case 'a': set_restore(1);
		 break;
        default: create_a_pop();
                 break;
	}
       /* 	XDestroyWindow(display,temp);   */
	
}

  set_restore(flag)
  {
   int i;
      for(i=0;i<MAXPOP;i++){
    if(graph[i].w==draw_win){
	    graph[i].Restore=flag;
	    graph[i].Nullrestore=flag;
	return;
	}
  }
  }

 destroy_a_pop()
 {
  int i;
  if(draw_win==graph[0].w)
  {
   respond_box(main_win,0,0,"Okay","Can't destroy big window!");
   return;
  }
  for(i=1;i<MAXPOP;i++)
   if(graph[i].w==draw_win)break;
  if(i>=MAXPOP)return;
   select_window(graph[0].w);
  graph[i].Use=0;
  destroy_label(graph[i].w);
  XDestroyWindow(display,graph[i].w);
  num_pops--;
  }


init_grafs(x,y,w,h)
int x,y,w,h;
{
 int i;
 GrCol();
 for(i=0;i<MAXLAB;i++)
 {
  lb[i].use=0;
  lb[i].w=(Window)0;
 } 
 for(i=0;i<MAXPOP;i++)
 graph[i].Use=0;
 init_all_graph();
  graph[0].w=XCreateSimpleWindow(display,main_win,x,y,w,h,2,GrFore,GrBack);
 graph[0].Use=1;
 graph[0].Restore=1;
 graph[0].Nullrestore=1;
 graph[0].x0=x;
 graph[0].y0=y;
 graph[0].Height=h;
 graph[0].Width=w;
 XSelectInput(display,graph[0].w,KeyPressMask|ButtonPressMask|ExposureMask);
 num_pops=1;
 XMapWindow(display,graph[0].w);
 draw_win=graph[0].w;
 current_pop=0;
 select_sym(graph[0].w);
 BaseCol();
}

 draw_help()
{
 	switch(help_menu){
		case MAIN_HELP: help(); break;
		case NUM_HELP : help_num();break;
		case THREED_HELP: help_3d();break;
		case FILE_HELP: help_file();break;
		case GRAPH_HELP: help_gr();break;
}
}

 ps_restore()
{
 do_axes();
 restore(0,storind);
 ps_setcolor(0);
 if(MyGraph->Nullrestore)restore_nullclines();
 draw_label(draw_win);
 ps_end();
}

 do_expose(ev)
 XEvent ev;
 {
  int i;
  int cp=current_pop;
  Window temp;
  temp=draw_win;
  expose_my_browser(ev);
  draw_eq_list(ev.xany.window);
  draw_eq_box(ev.xany.window);
  do_box_expose(ev.xany.window);
  if(ev.xexpose.window==menu_pop){
	draw_help();
 	
   return;
    }
  
  GrCol();
     for(i=0;i<MAXPOP;i++){
      
	if((graph[i].Use)&&(ev.xexpose.window==graph[i].w)){
		current_pop=i;
		MyGraph=&graph[i];
		draw_win=graph[i].w;
  		get_draw_area();
 		do_axes();
  		if(graph[i].Restore)restore(0,storind);
		draw_label(graph[i].w);
		if(graph[i].Nullrestore)restore_nullclines();
	}
   }
   draw_win=temp;
   MyGraph=&graph[cp];
   current_pop=cp;
   hi_lite(draw_win);
   get_draw_area();
   BaseCol();
 
	
	



  }


resize_all_pops(wid,hgt)
int wid,hgt;
{
 int i;
 int ox=graph[0].x0;
 int nx,ny,wp,hp;
 int oy=graph[0].y0;
 int ow=graph[0].Width,oh=graph[0].Height;
 int nw=wid-16-16*DCURX,nh=hgt-5*DCURY-16;
 XResizeWindow(display,graph[0].w,nw,nh);
 graph[0].Width=nw;
 graph[0].Height=nh;
  get_draw_area();
}

kill_all_pops()
{
 int i;
 select_window(graph[0].w);

 for(i=1;i<MAXPOP;i++)
 if(graph[i].Use){
   graph[i].Use=0; 
   destroy_label(graph[i].w);
	XDestroyWindow(display,graph[i].w);
      
 }
 num_pops=1;
}



 create_a_pop()
 {
  int i,index;
  int x,y,xp,yp,h,w;
  int xg,yg,hg,wg,bw,de;
  Window root;
  Window temp=main_win;
  for(i=1;i<MAXPOP;i++)
  if(graph[i].Use==0)break;
  if(i>=MAXPOP)
  {
   respond_box(main_win,0,0,"Okay","Too many windows!");
   return;
  }
index=i;


graph[index].w=XCreateSimpleWindow(display,RootWindow(display,screen),0,0,200,200,2,GrFore,GrBack);

  copy_graph(index,current_pop);
  graph[index].Width=200;
  graph[index].Height=200;
  graph[index].x0=0;
  graph[index].y0=0;
  num_pops++;
  make_icon(graph_bits,graph_width,graph_height,graph[index].w);
  XSelectInput(display,graph[index].w,KeyPressMask|ButtonPressMask|ExposureMask);
  XMapWindow(display,graph[index].w);
  XRaiseWindow(display,graph[index].w);
 
  select_window(graph[index].w);
 /*  XDestroyWindow(display,temp); */
}

GrCol()
{
 XSetForeground(display,gc,GrFore);
 XSetBackground(display,gc,GrBack);
 
}

BaseCol()
{
 XSetForeground(display,gc,MyForeColor);
 XSetBackground(display,gc,MyBackColor);
}

SmallGr()
{
 XSetForeground(display,small_gc,GrFore);
 XSetBackground(display,small_gc,GrBack);
}

SmallBase()
{
 XSetForeground(display,small_gc,MyForeColor);
 XSetBackground(display,small_gc,MyBackColor);
}


select_window(w)
Window w;
{
 int i;

 if(w==draw_win)return;
 GrCol();
 if(w==graph[0].w)current_pop=0;
 else{
 
  for(i=1;i<MAXPOP;i++)if((graph[i].Use)&&(w==graph[i].w))current_pop=i;
 }
 MyGraph=&graph[current_pop];
 lo_lite(draw_win);
 draw_win=w;
 hi_lite(w);
  XRaiseWindow(display,w); 
 get_draw_area();
BaseCol();
}
 
set_gr_fore()
{
 XSetForeground(display,gc,GrFore);
}
set_gr_back()
{
 XSetForeground(display,gc,GrBack);
}

hi_lite(wi)
Window wi;
{
  set_gr_fore();
  select_sym(wi);
 
}

lo_lite(wi)
Window wi;
{
 set_gr_back();
 bar(0,0,5,5,wi);
 
}

select_sym(w)
Window w;
{
 bar(0,0,5,5,w);
}
 
check_draw_button(ev)
XEvent ev;
{
 int k;
 char buf[256];
 char ch;
 int button;
 int i,j;
 float x,y;
 int flag=0;
 Window w;
 button=ev.xbutton.button;
 w=ev.xbutton.window;
 i=ev.xbutton.x;
 j=ev.xbutton.y;
 if(button==1){          /* select window   */

 for(k=1;k<MAXPOP;k++)
 if((graph[k].Use)&&(w==graph[k].w))flag=1;
   if((w==graph[0].w)||(flag==1))select_window(w);
  }
 else  /* any other button   */
 {
   if(w!=draw_win)return;
   scale_to_real(i,j,&x,&y);
 sprintf(buf,"Pointer at: x=%f y=%f ",x,y);
 bottom_msg(2,buf);
  }
}  

 
   
