/*    This makes a big box with windows that have the names of the
       variables and their current initial data
    
	It works with the main program by interfacing with the command
	window and getting values.  If you click on an IC, the IC
        is selected to the command window as an editable object
*/


#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include "ic.bitmap"
#include "param.bitmap"
#include "delay.bitmap"
#include "bc.bitmap"
#include "shoot.h"

extern Display *display;
extern int screen;
extern GC gc, small_gc;
extern int DCURX,DCURXs,DCURY,DCURYs,CURY_OFFs,CURY_OFF;


#define PARAMBOX 1
#define ICBOX 2
#define DELAYBOX 3
#define BCBOX 4
#define BOXEVENT  (ButtonPressMask 	|\
		KeyPressMask		|\
		ExposureMask		|\
		StructureNotifyMask	|\
		LeaveWindowMask		|\
		EnterWindowMask)

#define BOXDONE -2

#define MAXODE 50



extern int NUPAR,NODE,NEQ,NMarkov;
extern char upar_names[200][11],uvar_names[MAXODE][12];
extern char delay_string[MAXODE][80];
extern double default_val[200];
extern double last_ic[MAXODE];
typedef struct {
  		int use,type;
		int n;
		Window base;
                Window done;
		Window w[100];
		} BoxList;

extern BC_STRUCT my_bc[MAXODE];


BoxList ICBox;
BoxList ParamBox;
BoxList DelayBox;
BoxList BCBox;

int BoxMode;

double atof();

find_user_name(type,oname)
int type;
char *oname;
{
 char name[25];
 int j=0,k=0,i=-1;
 for(j=0;j<strlen(oname);j++){
 if(!isspace(oname[j])){name[k]=oname[j];k++;}
}
 name[k]=0;
  
 
 for(i=0;i<NUPAR;i++)
         if((type==PARAMBOX)&&(strcasecmp(upar_names[i],name)==0))break;
 if(i<NUPAR)return(i);
 for(i=0;i<NEQ;i++)
	 if((type==ICBOX)&&(strcasecmp(uvar_names[i],name)==0))break;	
   if(i<NEQ)return(i);
	return(-1);
 }




 

/*     The rest of the code is good     
                    |
                    V
  */
initialize_box()
{
 
 make_box_list(&ICBox,"Initial Data","ICs",NODE+NMarkov,ICBOX,1);
 if(NUPAR>0) make_box_list(&ParamBox,"Parameters","Par",NUPAR,PARAMBOX,1);
 else ParamBox.use=0;
  make_box_list(&DelayBox,"Delay ICs","Delay", NODE,DELAYBOX,1);
  make_box_list(&BCBox,"Boundary Conds","BCs",NODE,BCBOX,1);
 make_icon(ic_bits,ic_width,ic_height,ICBox.base);
if(ParamBox.use) make_icon(param_bits,param_width,param_height,ParamBox.base);
 make_icon(delay_bits,delay_width,delay_height,DelayBox.base);
 make_icon(bc_bits,bc_width,bc_height,BCBox.base);
}

	


make_box_list(b,wname,iname,n,type,use)
BoxList *b;
char *wname,*iname;
int n,type,use;
{
 int nrow,ncol;
 int x,y;
 int i1,i2,i;
 int width,height,wid,hgt;
 double dtemp;
 Window base,w;
  XTextProperty winname,iconame;
   XSizeHints size_hints;
/*   The following makes for pretty ugly boxes, but works:
 
 nrow=n/5+1;
 ncol=n%5;
 if(nrow>1)ncol=5;

*/

/*   This attempts to make a nicer box size...   */
  dtemp=(double)n;
  dtemp=sqrt(dtemp);  /*  approximate square  */
  i1=(int)dtemp;   /* truncate the value   */
  if(i1>6)i1=6;  /* maximum columns   */
  i2=n/i1;  
  if(i2*i1<n)i2++; /*  make sure there is enough  */
  nrow=i2;
  ncol=i1;

 wid=21*DCURXs;
 hgt=DCURYs+4;
 height=(nrow+2)*(hgt+4)+2*hgt;
 width=ncol*(wid+2*DCURXs);

 b->use=use;
 b->type=type;
 b->n=n;
 base=make_window(RootWindow(display,screen),0,0,width,height,4);
 b->base=base;
 XStringListToTextProperty(&wname,1,&winname);
XStringListToTextProperty(&iname,1,&iconame);
 size_hints.flags=PPosition|PSize|PMinSize|PMaxSize;
 size_hints.x=0;
 size_hints.y=0;
 size_hints.width=width;
 size_hints.height=height;
 size_hints.min_width=width;
 size_hints.min_height=height;
 size_hints.max_width=width;
 size_hints.max_height=height;
 XSetWMProperties(display,base,&winname,&iconame,NULL,0,&size_hints,NULL,NULL);
 b->done=make_window(base,width/2-4*DCURXs,5,5*DCURXs,hgt,4);
 for(i=0;i<n;i++){
	i1=i/ncol;
        i2=i%ncol;
        x=i2*(wid+DCURXs)+DCURXs;
	y=DCURYs+(hgt+4)*i1+1.5*hgt;
	b->w[i]=make_window(base,x,y,wid,hgt,1);
	XSelectInput(display,b->w[i],BOXEVENT);

	}
}

 

 
 
 /* this is added to take care of making sure
     exposure of the boxes is easily taken care of
  */

do_box_expose(w)
Window w;
{
 int i;
 if(ICBox.use)display_box(ICBox,w);
 if(BCBox.use)display_box(BCBox,w);
 if(ParamBox.use)display_box(ParamBox,w);
 if(DelayBox.use)display_box(DelayBox,w);
 }

 

do_box_events(ev,index)
int *index;
XEvent ev;
{
 if(ICBox.use)box_list_events(ICBox,ev,index);
 if(BCBox.use)box_list_events(BCBox,ev,index);
 if(ParamBox.use)box_list_events(ParamBox,ev,index);
 if(DelayBox.use)box_list_events(DelayBox,ev,index);
 }


draw_one_box(b,index)
int index;
BoxList b;
{
 Window w=b.w[index];
 char string[80];
 double z;
 switch(b.type){
	case PARAMBOX:
		XClearWindow(display,w);
 		get_val(upar_names[index],&z);
		sprintf(string,"%s=%.4g",upar_names[index],z);
		XDrawString(display,w,small_gc,0,CURY_OFFs,
		string,strlen(string));
		break;
	      case BCBOX:
		XClearWindow(display,w);
		strcpy(string,my_bc[index].name);
		strncat(string,my_bc[index].string,10);
		XDrawString(display,w,small_gc,0,CURY_OFFs,
		string,strlen(string));
		break;
		
	case ICBOX:
		XClearWindow(display,w);
		/* get_val(uvar_names[index],&z); */
		z=last_ic[index];
		sprintf(string,"%s=%.4g",uvar_names[index],z);
		XDrawString(display,w,small_gc,0,CURY_OFFs,
		string,strlen(string));
		break;

	case DELAYBOX:
		XClearWindow(display,w);
  		strcpy(string,uvar_names[index]);
                strcat(string,":");
		strncat(string,delay_string[index],10);
		XDrawString(display,w,small_gc,0,CURY_OFFs,
		string,strlen(string));
		break;
		}
  }


redraw_params()
{
 int i;
 if(ParamBox.use)for(i=0;i<NUPAR;i++)draw_one_box(ParamBox,i);
}

redraw_delays()
{
 int i;
 for(i=0;i<NODE;i++)draw_one_box(DelayBox,i);
}
redraw_ics()
{
 int i;
 for(i=0;i<NODE+NMarkov;i++)draw_one_box(ICBox,i);
}

redraw_bcs()
{
 int i;
 for(i=0;i<NODE;i++)draw_one_box(BCBox,i);
}
display_box(b,w)
BoxList b;
Window w;
{
 int i;
 
 if(b.done==w)XDrawString(display,w,small_gc,DCURXs/2,CURY_OFFs,
	"Done",4);
 for(i=0;i<b.n;i++)
 if(b.w[i]==w){
		draw_one_box(b,i);
		return;
   }
}



find_the_box(b,w,index)
BoxList b;
Window w;
int *index;
{
 int i;
 for(i=0;i<b.n;i++)
 if(w==b.w[i]){
		*index=i;
		return(1);
 }
 *index=-1;
 return(0);
}
 



box_list_events(b,ev,index)
BoxList b;
XEvent ev;
int *index;
{
 
 switch(ev.type){
	
/*	case ConfigureNotify:
	case Expose:                    
	case MapNotify:
 	display_box(b,ev.xany.window);  
	break;    */
	case ButtonPress:
	do_select(b,ev.xbutton.window,index);
	break;
        case EnterNotify:
	 XSetWindowBorderWidth(display,ev.xcrossing.window,2);
	break;
	case LeaveNotify:
	XSetWindowBorderWidth(display,ev.xcrossing.window,1);
	break;
	}
}



do_select(b,w,index)
BoxList b;
Window w;
int *index;
{

 double z;
 switch(BoxMode){
	case PARAMBOX:
		if(b.type!=PARAMBOX)return; 
		if(w==b.done){
		*index=BOXDONE;
		return;
		}
		find_the_box(b,w,index);
		break;
	case ICBOX:
		if(b.type!=ICBOX)return; 
		if(w==b.done){
		*index=BOXDONE;
		return;
		}
		find_the_box(b,w,index);
		break;
	case DELAYBOX:
		if(b.type!=DELAYBOX)return;
		if(w==b.done){
		*index=BOXDONE;
		return;
		}
		find_the_box(b,w,index);
		break;
       case BCBOX:
		if(b.type!=BCBOX)return;
		if(w==b.done){
		*index=BOXDONE;
		return;
		}
		find_the_box(b,w,index);
		break;
                
	case 0: /*  Not in any mode, but will head there */
		if(find_the_box(b,w,index)){
			ping();
			BoxMode=b.type;
			if(b.type==DELAYBOX)
			new_delay(*index);
			if(b.type==PARAMBOX)
			change_par(*index);
			if(b.type==ICBOX)
			new_ic(*index);
			if(b.type==BCBOX)
			new_bc(*index);
			}
			break;
	   }
    
}


/*       The main loops for changing parameters and initial data   */



man_ic()
{
 BoxMode=ICBOX;
 new_ic(0);
}

new_ic(i)
int i;
{
 new_data(i,ICBOX);

}


new_bc(i)
int i;
{
 new_data(i,BCBOX);
}
new_delay(i)
int i;
{
 new_data(i,DELAYBOX);

}

new_data(i,type)
 int i,type;
{
 int current_index=i;
 int new_index,done=0,pos,col;
 char name[20];
 char value[80];
 double z;
 XEvent ev;
 BoxMode=type;
 
 init_ic_string(current_index,name,value,&pos,&col,type);


 while(1){
	  XNextEvent(display,&ev);
	  new_index=-1;
          if(ev.type==ButtonPress){
             if(type==ICBOX)
	     do_select(ICBox,ev.xbutton.window,&new_index);
	     else 
              if(type==DELAYBOX)
	      do_select(DelayBox,ev.xbutton.window,&new_index);
	      else
		if(type==BCBOX)
		  do_select(BCBox,ev.xbutton.window,&new_index);
	    
	     if(new_index==BOXDONE){
	     
		save_current_ic(current_index,value,type);
		
		break;
              }
	     if((new_index>=0)&&(new_index!=current_index)){
	     
	     save_current_ic(current_index,value,type);
	     clr_command();
	     current_index=new_index;
	     init_ic_string(current_index,name,value,&pos,&col,type);
	     }
	}  /*  not a button on param box    */
	if(ev.type== EnterNotify)
	 XSetWindowBorderWidth(display,ev.xcrossing.window,2);

	if(ev.type==LeaveNotify)
	XSetWindowBorderWidth(display,ev.xcrossing.window,1);


       /*  go ahead and edit whatever   */
      edit_command_string(ev,name,value,&done,&pos,&col);
	if(done==1){  /* A CR was hit   */
	          save_current_ic(current_index,value,type);
		     current_index+=1; /* get next one */
		     done=0;
		     if(current_index>=NODE+NMarkov)break;
			clr_command();
			init_ic_string(current_index,name,value,&pos,&col,type);
	            }
       if(done==-1){
		    save_current_ic(current_index,value,type);
		    break;
		   }
       }/* end while   */
	clr_command();
	BoxMode=0;
  }   
	


 init_ic_string(i,name,value,pos,col,type)
 int i,*pos,*col,type;
 char *name,*value;
 {
  double z;
        if(type==BCBOX){
	  sprintf(name,"%s",my_bc[i].name);
	  sprintf(value,"%s",my_bc[i].string);
	  goto ic;
	}
	sprintf(name,"%s :",uvar_names[i]);
	if(type==ICBOX){
	/* get_val(uvar_names[i],&z); */
	  z=last_ic[i];
	sprintf(value,"%.16g",z);}
	else
	 strcpy(value,delay_string[i]);
  ic:      
	*pos=strlen(value);
	*col=(*pos+strlen(name))*DCURX;
    clr_command();
    display_command(name,value,*pos,0);
 }

 
save_current_ic(i,v,type)
char *v;
int i,type;
{
 double z,nz;
 int flag;
 if(i<0)return;
 if(strlen(v)==0)return;
 if(type==BCBOX){
   
   strcpy(my_bc[i].string,v);
   draw_one_box(BCBox,i);
   return;
 }
 if(type==ICBOX){
 if(v[0]=='%')
 { 
   flag=do_calc(&v[1],&z);
   if(flag==-1)z=last_ic[i];
 }
 else z=atof(v);
 last_ic[i]=z;
/* set_val(uvar_names[i],z); */
 draw_one_box(ICBox,i);
 }
 else{
  strcpy(delay_string[i],v);
  draw_one_box(DelayBox,i);
  }
}






change_par(i)
int i;
{
 int current_index=i;
 int new_index,done=0,pos,col;
 char name[20];
 char value[80];
 double z;
 XEvent ev;
  if(ParamBox.use==0)return;
 BoxMode=PARAMBOX;

 init_param_string(i,name,value,&pos,&col);


 while(1){
	  XNextEvent(display,&ev);
	  new_index=-1;
          if(ev.type==ButtonPress){

	     do_select(ParamBox,ev.xbutton.window,&new_index);
	     if(new_index==BOXDONE){
	     
		save_current_parameter(current_index,value);
		
		break;
              }
	     if((new_index>=0)&&(new_index!=current_index)){
	     
	     save_current_parameter(current_index,value);
	     clr_command();
	     current_index=new_index;
	     init_param_string(current_index,name,value,&pos,&col);
	     }
	}  /*  not a button on param box    */
	if(ev.type== EnterNotify)
	 XSetWindowBorderWidth(display,ev.xcrossing.window,2);

	if(ev.type==LeaveNotify)
	XSetWindowBorderWidth(display,ev.xcrossing.window,1);


       /*  go ahead and edit whatever   */
      edit_command_string(ev,name,value,&done,&pos,&col);
	if(done==1){  /* A CR was hit   */
	            if(current_index==-1){  /*  Nothing yet here  */
			if(strlen(value)==0){
			

			break;
                        }
			/* must have requested a parameter  
			   so get the index    */
			if(strncasecmp(value,"DEFAULT",7  )==0)
			   set_default_params();
			else
			current_index=find_user_name(PARAMBOX,value);
			
			done=0;
			
		     }
		     else { /* accept the value    */
		     save_current_parameter(current_index,value);
		     current_index=-1;
		     done=0;
		     }
			clr_command();
			init_param_string(current_index,name,value,&pos,&col);
	            }
       if(done==-1){
		    save_current_parameter(current_index,value);
		    break;
		   }
       }/* end while   */
	clr_command();
	BoxMode=0;
 re_evaluate_kernels();
 redo_all_fun_tables(); 
  }   
		     
	
 set_default_params()
 {

 int i;
 for(i=0;i<NUPAR;i++)
 set_val(upar_names[i],default_val[i]);
 
 redraw_params();

 }
			
			
			
	
	
           
	     
	
	 


 init_param_string(i,name,value,pos,col)
 int i,*pos,*col;
 char *name,*value;
 {
  double z;
  if(i>=0){
	sprintf(name,"%s :",upar_names[i]);
	get_val(upar_names[i],&z);
	sprintf(value,"%.16g",z);
	*pos=strlen(value);
	*col=(*pos+strlen(name))*DCURX;
	}
  else {
	strcpy(name,"Parameter:");
	strcpy(value,"");
	*pos=0;
	*col=strlen(name)*DCURX;
       }
  clr_command();
 display_command(name,value,*pos,0);
 /* XFlush(display); */

 }

 
save_current_parameter(i,v)
char *v;
int i;
{
 double z;
 int flag;
 if(i<0)return;
 if(strlen(v)==0)return;
 if(v[0]=='%'){
  flag=do_calc(&v[1],&z);
  if(flag==-1)get_val(upar_names[i],&z);
}
 else z=atof(v);
 set_val(upar_names[i],z);
 /* update the PARAMBOX  */
 draw_one_box(ParamBox,i);
}
	
 
 
 





			
	



		
		
		    
 

 

 

















