#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <math.h>
#include "struct.h"
#include "browse.h"
#define MAXODE 50
#define MAX_LEN_SBOX 25

double atof();
extern GRAPH *MyGraph;
extern Display *display;
extern Window main_win,draw_win;
extern int DCURY;
extern int storind;

extern double T0,TEND;
extern float **storage;

int CurrentCurve=0;
extern char this_file[100];

extern char uvar_names[MAXODE][12];

int colorline[]={0,20,21,22,23,24,25,26,27,28,29};

choose_grtype()

{
 Window temp=main_win;
 static char *n[]={"0 None","1 -|- ","2 |__ ", "3 |-- ","4 Box ",
		   " 5 -X- ", "6 \|__ ", "7  X-- ", "8 Cube "};
 static char key[]="012345678"; 
 char ch;
 int i;
 ch=(char)pop_up_list(&temp,"Axes",n,key,9,8,MyGraph->grtype,10,13*DCURY+8);
 
 for(i=0;i<9;i++)
 if(ch==key[i])MyGraph->grtype=i;
 
}
 

 ind_to_sym(ind,str)
 char *str;
 int ind;
{
 if(ind==0)strcpy(str,"T");
 else strcpy(str,uvar_names[ind-1]);
} 

check_flags()
{
  if(MyGraph->grtype>4)MyGraph->ThreeDFlag=1;
  else MyGraph->ThreeDFlag=0;
  if((MyGraph->xv[0]==0)||(MyGraph->yv[0]==0)||
     ((MyGraph->zv[0]==0)&&(MyGraph->ThreeDFlag==1)))MyGraph->TimeFlag=1;
  else MyGraph->TimeFlag=0;
}
  

get_2d_view(ind)
int ind;
{
 static char *n[]={"X-axis","Y-axis","Xmin", "Ymin",
		   "Xmax", "Ymax"};
 char values[6][MAX_LEN_SBOX];
 int  status,i; 
 int i1=MyGraph->xv[ind],i2=MyGraph->yv[ind];
 char n1[15],n2[15];
 ind_to_sym(i1,n1);
 ind_to_sym(i2,n2);
 sprintf(values[0],"%s",n1);
 sprintf(values[1],"%s",n2);
 sprintf(values[2],"%f",MyGraph->xmin);
 sprintf(values[3],"%f",MyGraph->ymin);
 sprintf(values[4],"%f",MyGraph->xmax);
 sprintf(values[5],"%f",MyGraph->ymax);
 MyGraph->ThreeDFlag=0;
 status=do_string_box(6,3,2,"2D View",n,values,31);
 if(status!=0){
		/*  get variable names  */
             find_variable(values[0],&i);
              if(i>-1)
		MyGraph->xv[ind]=i;
	     find_variable(values[1],&i);
              if(i>-1)
		MyGraph->yv[ind]=i;

	      MyGraph->xmin=atof(values[2]);
	      MyGraph->ymin=atof(values[3]);
	      MyGraph->xmax=atof(values[4]);
	      MyGraph->ymax=atof(values[5]);
	      MyGraph->xlo=MyGraph->xmin;
	      MyGraph->ylo=MyGraph->ymin;
	      MyGraph->xhi=MyGraph->xmax;
	      MyGraph->yhi=MyGraph->ymax;
	      check_windows();
/*	      printf(" x=%d y=%d xlo=%f ylo=%f xhi=%f yhi=%f \n",
		     MyGraph->xv[ind],MyGraph->yv[ind],MyGraph->xlo,
		     MyGraph->ylo,MyGraph->xhi,MyGraph->yhi);
*/
		     
	      }
}
	      


get_3d_view(ind)
int ind;
{
 static char *n[]={"X-axis","Y-axis", "Z-axis",
		   "Xmin", "Xmax", "Ymin",
		   "Ymax", "Zmin","Zmax",
		   "XLo", "XHi", "YLo", "YHi"};
 char values[13][MAX_LEN_SBOX];
 int  status,i,i1=MyGraph->xv[ind],i2=MyGraph->yv[ind],i3=MyGraph->zv[ind];
 char n1[15],n2[15],n3[15];
 ind_to_sym(i1,n1);
 ind_to_sym(i2,n2);
 ind_to_sym(i3,n3);
 sprintf(values[0],"%s",n1);
 sprintf(values[1],"%s",n2);
 sprintf(values[2],"%s",n3);
 sprintf(values[3],"%f",MyGraph->xmin);
 sprintf(values[5],"%f",MyGraph->ymin);
 sprintf(values[7],"%f",MyGraph->zmin);
 sprintf(values[4],"%f",MyGraph->xmax);
 sprintf(values[6],"%f",MyGraph->ymax);
 sprintf(values[8],"%f",MyGraph->zmax);
 sprintf(values[9],"%f",MyGraph->xlo);
 sprintf(values[11],"%f",MyGraph->ylo);
 sprintf(values[10],"%f",MyGraph->xhi);
 sprintf(values[12],"%f",MyGraph->yhi);
 MyGraph->ThreeDFlag=1;
 status=do_string_box(13,5,3,"3D View",n,values,31);
 if(status!=0){
		/*  get variable names  */
              find_variable(values[0],&i);
 	      if(i>-1)
		MyGraph->xv[ind]=i;
              find_variable(values[1],&i);
              if(i>-1)
		MyGraph->yv[ind]=i;
              find_variable(values[2],&i);
  		if(i>-1)
		  MyGraph->zv[ind]=i;



	      MyGraph->xmin=atof(values[3]);
	      MyGraph->ymin=atof(values[5]);
	      MyGraph->zmin=atof(values[7]);
	      MyGraph->xmax=atof(values[4]);
	      MyGraph->ymax=atof(values[6]);
	      MyGraph->zmax=atof(values[8]);
	      MyGraph->xlo=atof(values[9]);
	      MyGraph->ylo=atof(values[11]);
	      MyGraph->xhi=atof(values[10]);
	      MyGraph->yhi=atof(values[12]);
              check_windows();
	/*      printf("%f %f %f %f %f %f \n %f %f %f %f",
		     MyGraph->xmin,MyGraph->xmax,
		     MyGraph->ymin,MyGraph->ymax,
		     MyGraph->zmin,MyGraph->zmax,
		     MyGraph->xlo,MyGraph->xhi,
		     MyGraph->ylo,MyGraph->yhi);
*/

	      }
}
	      

check_val(x1,x2,xb,xd)
 double *x1,*x2,*xb,*xd;
{
 double temp;

 if(*x1==*x2){
	     if(*x1==0.0)*x2=1.0;
	     else *x2=*x2+.1*fabs(*x1);
	     }
 if(*x1>*x2){
	     temp=*x2;
             *x2=*x1;
             *x1=temp;
            }
	    *xb=.5*(*x1+*x2);
	    *xd=2.0/(*x2-*x1);

}


  get_max(index, vmin,vmax)
  double *vmax,*vmin;
  int index;
  {
   float x0,x1,z;
   int i;
   x0=my_browser.data[index][0];
   x1=x0;
   for(i=0;i<storind;i++)
   {
    z=my_browser.data[index][i];
    if(z<x0)x0=z;
    if(z>x1)x1=z;
   }
   *vmin=(double)x0;
   *vmax=(double)x1;
 
 }
 
 pretty(x1,x2)
 double *x1,*x2;
{
 double dx=*x2-*x1;
 *x1=*x1-.01*fabs(dx);
 *x2=*x2+.01*fabs(dx);
 
}

 corner_cube(xlo,xhi,ylo,yhi)
 double *xlo,*ylo,*xhi,*yhi;
{
 float x,y;
 float x1,x2,y1,y2;
 threedproj(-1.,-1.,-1.,&x,&y);
 x1=x;
 x2=x;
 y1=y;
 y2=y;
 threedproj(-1.,-1.,1.,&x,&y);
 if(x<x1)x1=x;
 if(x>x2)x2=x;
 if(y<y1)y1=y;
 if(y>y2)y2=y;
 threedproj(-1.,1.,-1.,&x,&y);
 if(x<x1)x1=x;
 if(x>x2)x2=x;
 if(y<y1)y1=y;
 if(y>y2)y2=y;
 threedproj(-1.,1.,1.,&x,&y);
 if(x<x1)x1=x;
 if(x>x2)x2=x;
 if(y<y1)y1=y;
 if(y>y2)y2=y;
 threedproj(1.,-1.,-1.,&x,&y);
 if(x<x1)x1=x;
 if(x>x2)x2=x;
 if(y<y1)y1=y;
 if(y>y2)y2=y;
 threedproj(1.,-1.,1.,&x,&y);
 if(x<x1)x1=x;
 if(x>x2)x2=x;
 if(y<y1)y1=y;
 if(y>y2)y2=y;
 threedproj(1.,1.,1.,&x,&y);
 if(x<x1)x1=x;
 if(x>x2)x2=x;
 if(y<y1)y1=y;
 if(y>y2)y2=y;
 threedproj(1.,1.,-1.,&x,&y);
 if(x<x1)x1=x;
 if(x>x2)x2=x;
 if(y<y1)y1=y;
 if(y>y2)y2=y;
 *xlo=x1;
 *ylo=y1;
 *xhi=x2;
 *yhi=y2;
}
 
 
 




 fit_window()
{
 if(storind<2)return;
 if(MyGraph->ThreeDFlag){
   get_max(MyGraph->xv[0],&(MyGraph->xmin),&(MyGraph->xmax));
   pretty(&(MyGraph->xmin),&(MyGraph->xmax));
   get_max(MyGraph->yv[0],&(MyGraph->ymin),&(MyGraph->ymax));
   pretty(&(MyGraph->ymin),&(MyGraph->ymax));
   get_max(MyGraph->zv[0],&(MyGraph->zmin),&(MyGraph->zmax));
   pretty(&(MyGraph->zmin),&(MyGraph->zmax));
   corner_cube(&(MyGraph->xlo),&(MyGraph->xhi),&(MyGraph->ylo),&(MyGraph->yhi));
   pretty(&(MyGraph->xlo),&(MyGraph->xhi));
   pretty(&(MyGraph->ylo),&(MyGraph->yhi));
   check_windows();
 }
 else  
   {
    get_max(MyGraph->xv[0],&(MyGraph->xmin),&(MyGraph->xmax));
   pretty(&(MyGraph->xmin),&(MyGraph->xmax));
    get_max(MyGraph->yv[0],&(MyGraph->ymin),&(MyGraph->ymax));
     pretty(&(MyGraph->ymin),&(MyGraph->ymax)); 
    MyGraph->xlo=MyGraph->xmin;
    MyGraph->ylo=MyGraph->ymin;
    MyGraph->xhi=MyGraph->xmax;
    MyGraph->yhi=MyGraph->ymax;
    check_windows();
  }
  redraw_the_graph();
}
  






check_windows()
{
 double zip,zap;
 check_val(&MyGraph->xmin,&MyGraph->xmax,&MyGraph->xbar,&MyGraph->dx);
 check_val(&MyGraph->ymin,&MyGraph->ymax,&MyGraph->ybar,&MyGraph->dy);
 check_val(&MyGraph->zmin,&MyGraph->zmax,&MyGraph->zbar,&MyGraph->dz);
 check_val(&MyGraph->xlo,&MyGraph->xhi,&zip,&zap);
 check_val(&MyGraph->ylo,&MyGraph->yhi,&zip,&zap);
} 
	
user_window()
{
 static char *n[]={"X Lo","X Hi","Y Lo","Y Hi"};
 char values[4][MAX_LEN_SBOX];
 int status;
 sprintf(values[0],"%f",MyGraph->xlo);
 sprintf(values[2],"%f",MyGraph->ylo);
 sprintf(values[1],"%f",MyGraph->xhi);
 sprintf(values[3],"%f",MyGraph->yhi);
 status=do_string_box(4,2,2,"Window",n,values,28);
 if(status!=0){
             
	      MyGraph->xlo=atof(values[0]);
	      MyGraph->ylo=atof(values[2]);
	      MyGraph->xhi=atof(values[1]);
	      MyGraph->yhi=atof(values[3]);
	      if(MyGraph->grtype<5){
	      MyGraph->xmin=MyGraph->xlo;
	      MyGraph->xmax=MyGraph->xhi;
	      MyGraph->ymin=MyGraph->ylo;
	      MyGraph->ymax=MyGraph->yhi;
	      }
	      check_windows();
             }
 redraw_the_graph();
}

x_vs_t() /*  a short cut   */
{
 char name[20],value[20];
 int i=MyGraph->yv[0];
 

 ind_to_sym(i,value);
 sprintf(name,"Plot vs t: ");
 new_string(name,value);
 find_variable(value,&i);
 
 if(i>-1){
   MyGraph->yv[0]=i;
   MyGraph->grtype=3;
   MyGraph->xv[0]=0;
   if(storind>=2){
      get_max(MyGraph->xv[0],&(MyGraph->xmin),&(MyGraph->xmax));
   pretty(&(MyGraph->xmin),&(MyGraph->xmax));
    get_max(MyGraph->yv[0],&(MyGraph->ymin),&(MyGraph->ymax));
     pretty(&(MyGraph->ymin),&(MyGraph->ymax)); 
   
    }
   else {
     MyGraph->xmin=T0;
     MyGraph->xmax=TEND;
        }
    MyGraph->xlo=MyGraph->xmin;
    MyGraph->ylo=MyGraph->ymin;
    MyGraph->xhi=MyGraph->xmax;
    MyGraph->yhi=MyGraph->ymax;
    check_windows();
    check_flags();
    redraw_the_graph();
 }
}
 
 

change_view()
{
 choose_grtype();
 if(MyGraph->grtype<5)get_2d_view(CurrentCurve);
 else get_3d_view(CurrentCurve);
 check_flags();
 redraw_the_graph();
}

redraw_the_graph()
{
 blank_screen(draw_win);
 do_axes();
 hi_lite(draw_win);
 restore(0,storind);
 draw_label(draw_win);
 if(MyGraph->Nullrestore)restore_nullclines();
}
get_3d_par()
{
 static char *n[]={"Persp (1=On)","ZPlane","ZView","Theta","Phi"};
 char values[5][MAX_LEN_SBOX];
 int status;
  if(MyGraph->grtype<5)return;
 sprintf(values[0],"%d",MyGraph->PerspFlag);
 sprintf(values[1],"%f",MyGraph->ZPlane);
 sprintf(values[2],"%f",MyGraph->ZView);
 sprintf(values[3],"%f",MyGraph->Theta);
 sprintf(values[4],"%f",MyGraph->Phi);
 status=do_string_box(5,5,1,"3D Parameters",n,values,28);
 if(status!=0){
	       MyGraph->PerspFlag=atoi(values[0]);
	      MyGraph->ZPlane=atof(values[1]);
	      MyGraph->ZView=atof(values[2]);
	      MyGraph->Theta=atof(values[3]);
	      MyGraph->Phi=atof(values[4]);
	     make_rot(MyGraph->Theta,MyGraph->Phi);
	    /*  Redraw the picture   */	
	       redraw_the_graph();
	     }
	     
}


window_zoom()
{
 static char *n[]={"(W)indow","(Z)oom In", "Zoom (O)ut", "(F)it"};
 static char key[]="wzof";
 char ch;
 int i1,i2,j1,j2;
  Window temp=main_win;
   ch=(char)pop_up_list(&temp,"Window",n,key,4,13,0,10,13*DCURY+8);
  switch(ch){
	    case 'w':user_window(); break;
	    case 'z':if(rubber(&i1,&j1,&i2,&j2,draw_win)==0)break;
		     zoom_in(i1,j1,i2,j2);
		     break;
       	    case 'o': if(rubber(&i1,&j1,&i2,&j2,draw_win)==0)break;
		     zoom_out(i1,j1,i2,j2);
		     break;
 	    case 'f': fit_window();
		      break;
            }
}



zoom_in(i1,j1,i2,j2)
int i1,j1,i2,j2;
{
 float x1,y1,x2,y2;
 scale_to_real(i1,j1,&x1,&y1);
 scale_to_real(i2,j2,&x2,&y2);
             
	      MyGraph->xlo=x1;
	      MyGraph->ylo=y1;
	      MyGraph->xhi=x2;
	      MyGraph->yhi=y2;
	      if(MyGraph->grtype<5){
	      MyGraph->xmin=MyGraph->xlo;
	      MyGraph->xmax=MyGraph->xhi;
	      MyGraph->ymin=MyGraph->ylo;
	      MyGraph->ymax=MyGraph->yhi;
	      }
	      check_windows();
              redraw_the_graph();
              draw_help();
}

zoom_out(i1,j1,i2,j2)
{
 float x1,y1,x2,y2;
 float bx,mux,by,muy;
 float dx=MyGraph->xhi-MyGraph->xlo;
 float dy=MyGraph->yhi-MyGraph->ylo;
 scale_to_real(i1,j1,&x1,&y1);
 scale_to_real(i2,j2,&x2,&y2);
 if(x1>x2){bx=x1;x1=x2;x2=bx;}
 if(y1>y2){by=y1;y1=y2;y2=by;}
 if(x1==x2||y1==y2)return;
 /*
 printf("%f %f %f %f \n ",x1,y1,x2,y2);
 printf("%f %f %f %f \n",MyGraph->xlo,MyGraph->ylo,MyGraph->xhi,MyGraph->yhi);

 */
 bx=dx*dx/(x2-x1);
 mux=(x1-MyGraph->xlo)/dx;
 MyGraph->xlo=MyGraph->xlo-bx*mux;
 MyGraph->xhi=MyGraph->xlo+bx;
 
 by=dy*dy/(y2-y1);
 muy=(y1-MyGraph->ylo)/dy;
 MyGraph->ylo=MyGraph->ylo-by*muy;
 MyGraph->yhi=MyGraph->ylo+by;

    if(MyGraph->grtype<5){
	      MyGraph->xmin=MyGraph->xlo;
	      MyGraph->xmax=MyGraph->xhi;
	      MyGraph->ymin=MyGraph->ylo;
	      MyGraph->ymax=MyGraph->yhi;
	      }
	      check_windows();
              redraw_the_graph();
              draw_help();
}
 






find_color(in)
{
 int i;
 for(i=0;i<=10;i++)
 if(in==colorline[i])return(i);
 return(0);
}

alter_curve(title,in_it,n)
char *title;
int in_it,n;
{
 static char *nn[]={"X-axis","Y-axis","Z-axis","Color","Line type"};
 char values[5][MAX_LEN_SBOX];
 int status,i;
 int i1=MyGraph->xv[in_it],i2=MyGraph->yv[in_it],i3=MyGraph->zv[in_it];
 char n1[15],n2[15],n3[15];

 
 ind_to_sym(i1,n1);
 ind_to_sym(i2,n2);
 ind_to_sym(i3,n3);
 sprintf(values[0],"%s",n1);
 sprintf(values[1],"%s",n2);
 sprintf(values[2],"%s",n3);
 sprintf(values[3],"%d",find_color(MyGraph->color[in_it]));
 sprintf(values[4],"%d",MyGraph->line[in_it]);
 status=do_string_box(5,2,3,title,nn,values,15);
 if(status!=0){
		    find_variable(values[0],&i);
 	      if(i>-1)
		MyGraph->xv[n]=i;
              find_variable(values[1],&i);
              if(i>-1)
		MyGraph->yv[n]=i;
              find_variable(values[2],&i);
  		if(i>-1)
		  MyGraph->zv[n]=i;

	       MyGraph->line[n]=atoi(values[4]);
               i=atoi(values[3]);
		    if(i<0||i>10)i=0;
		    MyGraph->color[n]=colorline[i];
		   
		  return(1);
              
              }
 return(0);
}


edit_curve()
{
 char bob[20];
 int crv=0;
 sprintf(bob,"Edit 0-%d :",MyGraph->nvars-1);
 ping();
 new_int(bob,&crv);
 if(crv>=0&&crv<MyGraph->nvars)
   {
     sprintf(bob,"Edit curve %d",crv);
     alter_curve(bob,crv,crv);
   }
}

new_curve()
{
 if(alter_curve("New Curve",0,MyGraph->nvars))
   MyGraph->nvars=MyGraph->nvars+1;
  
 }  

create_ps()
{
 char filename[100];
 sprintf(filename,"%s.ps",this_file);
 ping();
 if(new_string("Filename: ",filename)==0)return;
 if(ps_init(filename)){
   ps_restore();
   ping();
 }
}
 
 
 
add_a_curve()
{
 static char *n[]={"(A)dd curve","(D)elete last","(R)emove all","(E)dit curve",
		   "(P)ostscript"};
 static char key[]="adrep";
 char ch;
 Window temp=main_win;
 ch=(char)pop_up_list(&temp,"Curves",n,key,5,15,0,10,8*DCURY+8);
 switch(ch){
 case 'a': if(MyGraph->nvars>=MAXPERPLOT)
   {
     err_msg("Too many plots!");
     return;
   }
   new_curve();
   break;
 case 'd':if(MyGraph->nvars>1)MyGraph->nvars=MyGraph->nvars-1;
   break;
 case 'r':MyGraph->nvars=1;
   break;
 case 'e': edit_curve();
   break;
 case 'p': create_ps();
   break;
 }
 check_flags();
 redraw_the_graph();
   
}






















