#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/keysymdef.h>
#include <math.h>
#include <ctype.h>
#include "browse.bitmap"
#include "newhome.h"


#define xds(a) { XDrawString(display,w,small_gc,0,CURY_OFFs,a,strlen(a));\
		return;}


#define BMAXCOL 20
#define MAXODE 50


double evaluate();
double atof();
extern int NEQ,MAXSTOR,NMarkov;

extern int NODE,NJMP;

extern double last_ic[MAXODE],DELTA_T;

extern int NSYM,NSYM_START,NCON,NCON_START;

extern Display *display;
extern int screen,storind;
extern GC gc, small_gc;
extern int DCURX,DCURXs,DCURY,DCURYs,CURY_OFFs,CURY_OFF;


extern Window command_pop;

#define MYMASK  (ButtonPressMask 	|\
		KeyPressMask		|\
		ExposureMask		|\
		StructureNotifyMask	|\
		LeaveWindowMask		|\
		EnterWindowMask)

#define SIMPMASK (ButtonPressMask |\
		  KeyPressMask	  |\
		  ExposureMask    |\
                  StructureNotifyMask)



/*  The one and only primitive data browser   */

typedef struct {
		Window base,upper;
		Window find,up,down,pgup,pgdn,home,end,left,right;
		Window first,last,restore,write,get;
		Window load,repl,unrepl;
                Window main;
                Window label[BMAXCOL];
                Window time;
		int dataflag;
		int col0,row0,ncol,nrow;
		int maxrow,maxcol;
                float **data;
		int istart,iend;
                } BROWSER;

BROWSER my_browser;

/*  for purposes of amusement only, we will create some
    false data to use in the browser
 */




extern char uvar_names[MAXODE][12];
float *old_rep;
int REPLACE=0,R_COL=0;

float **storage;

/* DUMMY ROUTINES ...    */

replace_column(var,form,dat,n)
char *form,*var;
float **dat;
int n;
{
 int com[200],i,j;
 int intflag=0;
 int dif_var=-1;
 float old,dt,derv;
 float sum=0.0;
 if(n<2)return;

 dt=NJMP*DELTA_T;
/* first check for derivative or integral symbol */
i=0;
while(i<strlen(form)){
  if(!isspace(form[i]))break;
  i++;
  }
 if(form[i]=='&'){ intflag=1; form[i]=' ';}
 if(form[i]=='@'){
   form[i]=' ';
   find_variable(form,&dif_var);
   if(dif_var<0){
     err_msg("No such variable");
     return;
   }
   
 }
   

/*  first compile formula ... */


 if(dif_var<0){
   if(add_expr(form,com,&i)){
     NCON=NCON_START;
     NSYM=NSYM_START;
     err_msg("Illegal formula...");
     return;
   }
 }
/* next check to see if column is known ... */
 
 find_variable(var,&i);
 if(i<0){
   err_msg("No such column...");
   NCON=NCON_START;
   NSYM=NSYM_START;
   return;
 }
 R_COL=i;   

 /* Okay the formula is cool so lets allocate and replace  */

 wipe_rep();
 old_rep=(float *)malloc(sizeof(float)*n);
 REPLACE=1;
 for(i=0;i<n;i++)
 {
   old_rep[i]=dat[R_COL][i];
   if(dif_var<0){
     for(j=0;j<NODE+1;j++)set_ivar(j,(double)dat[j][i]);
     for(j=NODE;j<NEQ;j++)set_val(uvar_names[j],(double)dat[j+1][i]);
     if(intflag){
       sum+=(float)evaluate(com);
       dat[R_COL][i]=sum*dt;
     }
     else dat[R_COL][i]=(float)evaluate(com);
   }
   else {
     if(i==0)derv=(dat[dif_var][1]-dat[dif_var][0])/dt;
     if(i==(n-1))derv=(dat[dif_var][i]-old)/dt;
     if(i>0&&i<(n-1))derv=(dat[dif_var][i+1]-old)/(2*dt);
     old=dat[dif_var][i];
     dat[R_COL][i]=derv;
   }
 }
 NCON=NCON_START;
 NSYM=NSYM_START;

}



 wipe_rep()
 {
    if(!REPLACE)return;
    free(old_rep);
    REPLACE=0;
  }

unreplace_column()


{
 int i,n=my_browser.maxrow;
 if(!REPLACE)return;
 for(i=0;i<n;i++)my_browser.data[R_COL][i]=old_rep[i];
 wipe_rep();
 
 }




find_value(col,val,row,b)
int col,*row;
float val;
BROWSER b;
{
 int n=b.maxrow;
 int i;
 int ihot=0;
 float err,errm;
 errm=fabs(b.data[col][0]-val);
 for(i=b.row0;i<n;i++){
 err=fabs(b.data[col][i]-val);
 if(err<errm){
	ihot=i;
	errm=err;
        }
  }
 *row=ihot;
}

find_variable(s,col)
char *s;
int *col;
{
 *col=-1;
  if(strcasecmp("T",s)==0){
   *col=0;
    return;
   }
  *col=find_user_name(2,s);
  if(*col>-1)*col=*col+1; 
 } 
   
 
 
 


display_browser(w,b)
Window w;
BROWSER b;
{
  int i,i0;
 if(w==b.find)xds("Find")
 if(w==b.up)xds("Up")
 if(w==b.down)xds("Down")
 if(w==b.pgup)xds("PgUp")
 if(w==b.pgdn)xds("PgDn")
 if(w==b.left)xds("Left")
 if(w==b.right)xds("Right")
 if(w==b.home)xds("Home")
 if(w==b.end)xds("End")
 if(w==b.first)xds("First")
 if(w==b.last)xds("Last")
 if(w==b.restore)xds("Restore")
 if(w==b.write)xds("Write")
 if(w==b.get)xds("Get")
 if(w==b.repl)xds("Replace");
 if(w==b.unrepl)xds("Unrepl");
 if(w==b.load)xds("Load");
 if(w==b.time)xds("Time")
 for(i=0;i<BMAXCOL;i++){
 
    if(w==b.label[i]){
    i0=i+b.col0-1;
     if(i0<b.maxcol-1)	XDrawString(display,w,small_gc,0,CURY_OFFs,
	uvar_names[i0],strlen(uvar_names[i0]));

    }

 }
 if(w==b.main)draw_data(b);
}

 redraw_browser(b)
 BROWSER b;
 {
  int i,i0;
  Window w;
  draw_data(b);
  for(i=0;i<BMAXCOL;i++){
    w=b.label[i];
    i0=i+b.col0-1;
 if(i0<(b.maxcol-1)){
       XClearWindow(display,w);
	XDrawString(display,w,small_gc,0,CURY_OFFs,uvar_names[i0],
	strlen(uvar_names[i0]));
    }

  }
}

 new_browse_dat(new_dat,dat_len)
 int dat_len;
 float **new_dat;
{
 my_browser.data=new_dat;
 refresh_browser(dat_len);
}

 refresh_browser(length)
 int length;
{
 my_browser.dataflag=1;
 my_browser.maxrow=length;
 my_browser.iend=length;
 draw_data(my_browser);
}
 
 draw_data(b)
 BROWSER b;
 {
   int i,i0,j,j0;
  int x0;
 char string[13];
 int dcol=DCURXs*14;
 int drow=(DCURYs+6);
 if(b.dataflag==0)return;  /*   no data  */
  XClearWindow(display,b.main);
 /* Do time data first  */
 for(i=0;i<b.nrow;i++){
	i0=i+b.row0;
        if(i0<b.maxrow){
		sprintf(string,"%.4g",b.data[0][i0]);
		XDrawString(display,b.main,small_gc,DCURXs/2,i*drow+DCURYs
,
		string,strlen(string));
	 }
 }

/* Do data stuff   */
 for(j=0;j<b.ncol;j++)
 {
 x0=(j+1)*dcol+DCURXs/2;
 j0=j+b.col0;
 if(j0>=b.maxcol)return;  /* if this one is too big, they all are  */
 for(i=0;i<b.nrow;i++){
   i0=i+b.row0;
   if(i0<b.maxrow){
                   sprintf(string,"%.5g",b.data[j0][i0]);
		XDrawString(display,b.main,small_gc,x0,i*drow+DCURYs,
		string,strlen(string));
                }
  }

  
}
}

init_browser()
{

 my_browser.dataflag=0;
 my_browser.data=storage;
 my_browser.maxcol=NEQ+1;
 my_browser.maxrow=0;
 my_browser.col0=1;
 my_browser.row0=0;
 my_browser.istart=0;
 my_browser.iend=0;
 make_browser(&my_browser,"Data Viewer","Data",20,5);
}
 

Window br_button(root,row,col,name,iflag)
int row,col,iflag;
 Window root;
 char *name;
{
  Window win;
  int dcol=9*DCURXs;
  int drow=(DCURYs+6);
  int width=strlen(name)*DCURXs;
  int x;
  int y;
  if(iflag==1)dcol=14*DCURXs;
   x=dcol*col+4;
   y=drow*row+4;
   win=make_window(root,x,y,width,DCURYs+1,1);
  XSelectInput(display,win,MYMASK);
 return(win);
 }
    

make_browser(b,wname,iname,row,col)
BROWSER *b;
int row,col;
char *wname,*iname;
{
 int i;
 int ncol=col;
 int width,height;
 Window base,w;

  XTextProperty winname,iconname;
  XSizeHints size_hints;
 int dcol=DCURXs*14;
 int drow=(DCURYs+6);
 int ystart=8;
 int wbut=9*DCURXs;
 if(ncol<5)ncol=5;

 height=drow*(row+6);
 width=ncol*dcol;
 b->nrow=row;
 b->ncol=ncol;
 base=make_window(RootWindow(display,screen),0,0,width,height,4);
 b->base=base;
XSelectInput(display,base,ExposureMask|KeyPressMask|ButtonPressMask|
		StructureNotifyMask);
/* printf("Browser base: %d \n",base); */
  XStringListToTextProperty(&wname,1,&winname);
XStringListToTextProperty(&iname,1,&iconname);
  
 size_hints.flags=PPosition|PSize|PMinSize;
 size_hints.x=0;
 size_hints.y=0;
/* size_hints.width=width;
 size_hints.height=height; */
 size_hints.min_width=width;
 size_hints.min_height=height;
  XSetWMProperties(display,base,&winname,&iconname,NULL,0,&size_hints,NULL,NULL);
 make_icon(browse_bits,browse_width,browse_height,base);
 b->upper=make_window(base,0,0,width,ystart+drow*5,1);
 b->main=make_window(base,0,ystart+drow*5,width,row*drow,1);
 b->find=br_button(base,0,0,"find",0);
 b->get=br_button(base,1,0,"get ",0);
 b->repl=br_button(base,2,0,"replace",0);
 b->restore=br_button(base,0,1,"restore",0);
 b->write=br_button(base,1,1," write ",0);
 b->load=br_button(base,2,1," load  ",0);
 b->first=br_button(base,0,2,"first",0);
 b->last=br_button(base,1,2,"last ",0);
 b->unrepl=br_button(base,2,2,"unrepl",0);
 b->up=br_button(base,0,3," up ",0);
 b->down=br_button(base,1,3,"down",0);
 b->pgup=br_button(base,0,4,"pgup",0);
 b->pgdn=br_button(base,1,4,"pgdn",0);
 b->left=br_button(base,0,5,"left ",0);
 b->right=br_button(base,1,5,"right",0);
 b->home=br_button(base,0,6,"home",0);
 b->end=br_button(base,1,6,"end ",0);
 b->time=br_button(base,4,0,"time ",1);
  XSelectInput(display,b->time,SIMPMASK);

 for(i=0;i<BMAXCOL;i++){
 
 	b->label[i]=br_button(base,4,i+1,"1234567890",1);
	 XSelectInput(display,b->label[i],SIMPMASK);
  }


}

/*   These are the global exporters ...   */

expose_my_browser(ev)
XEvent ev;
{
 expose_browser(ev,my_browser);
}

 my_browse_button(ev)
XEvent ev;
 {
  browse_button(ev,&my_browser);
 }

my_browse_keypress(ev,used)
int *used;
XEvent ev;
{
 browse_keypress(ev,used,&my_browser);
 }

resize_my_browser(win)
Window win;
{
 resize_browser(win,&my_browser);
}





expose_browser(ev,b)
XEvent ev;
BROWSER b;
{
 display_browser(ev.xexpose.window,b);
}

resize_browser(win,b)
Window win;
BROWSER *b;
{
  int w,h,hreal;
  int dcol=14*DCURXs,drow=DCURYs+6;
  int i0,i1;
  int newrow,newcol;
  if(win!=b->base)return;
  /* w=ev.xconfigure.width;
  h=ev.xconfigure.height; */
  get_new_size(win,&w,&h);
  hreal=h;
  /* first make sure the size is is ok  and an integral 
     value of the proper width and height
   */  
 i0=w/dcol;
 if((w%dcol)>0)i0++;
 if(i0>b->maxcol)i0=b->maxcol;

 w=i0*dcol;
 if(i0<5)w=5*dcol;
 newcol=i0;
 h=hreal-8-4*drow;
 i0=h/drow;
 if((h%drow)>0)i0++;
 if(i0>b->maxrow)i0=b->maxrow;
 h=i0*drow+DCURXs/2;
 newrow=i0;
 /*  Now resize everything   */
b->ncol=newcol;
b->nrow=newrow;

 XResizeWindow(display,b->base,w,hreal);
 XResizeWindow(display,b->upper,w,8+drow*3);
 XResizeWindow(display,b->main,w,h);

/* Let the browser know how many rows and columns of data  */
   
  
}

/*  if button is pressed in the browser 
    then do the following  */

browse_button(ev,b)
BROWSER *b;
XEvent ev;
{
 Window w=ev.xbutton.window;
 
 if(w==b->up){data_up(b); return;}

 if(w==b->down){data_down(b); return;}

 if(w==b->pgup){data_pgup(b); return;}

 if(w==b->pgdn){data_pgdn(b); return;}

 if(w==b->left){data_left(b); return;}

 if(w==b->right){data_right(b); return;}

 if(w==b->home){data_home(b); return;}

 if(w==b->end){data_end(b); return;}

 if(w==b->first){data_first(b); return;}

if(w==b->last){data_last(b); return;}

 if(w==b->restore){data_restore(b); return;}

 if(w==b->write){data_write(b); return;}

 if(w==b->get){data_get(b); return;}
 
 if(w==b->find){data_find(b); return;}

 if(w==b->repl){data_replace(b);return;}
 
 if(w==b->load){data_read(b);return; }
 
 if(w==b->unrepl){data_unreplace(b);return;}


}



browse_keypress(ev,used,b)
BROWSER *b;
XEvent ev;
int *used;
{
 Window w=ev.xkey.window;

 int maxlen=64;
      char buf[65];
      XComposeStatus comp;
       KeySym ks;
 Window w2;
 int rev;

*used=0;
 XGetInputFocus(display,&w2,&rev);

 if(w==b->main||w==b->base||w==b->upper||w2==b->base)
 {
  *used=1;
   XLookupString(&ev,buf,maxlen,&ks,&comp);
 

 
   if(ks==XK_Up){data_up(b); return;}

 if(ks==XK_Down){data_down(b); return;}

 if(ks==XK_PgUp){data_pgup(b); return;}

 if(ks==XK_PgDn){data_pgdn(b); return;}

 if(ks==XK_Left){data_left(b); return;}

 if(ks==XK_Right){data_right(b); return;}

 if(ks==XK_Home){data_home(b); return;}

 if(ks==XK_End){data_end(b); return;}

 if(ks==XK_s||ks==XK_S){data_first(b); return;}

if(ks==XK_E||ks==XK_e){data_last(b); return;}

 if(ks==XK_r||ks==XK_R){data_restore(b); return;}

 if(ks==XK_W||ks==XK_w){data_write(b); return;}

 if(ks==XK_g||ks==XK_G){data_get(b); return;}
 
 if(ks==XK_f||ks==XK_F){data_find(b); return;}

 if(ks==XK_l||ks==XK_L){data_read(b);return;}

 if(ks==XK_u||ks==XK_U){data_unreplace(b);return;}

 if(ks==XK_p||ks==XK_P){data_replace(b);return;}
 
 if(ks==XK_Escape){
			XSetInputFocus(display,command_pop,
			RevertToParent,CurrentTime);
		   	return;
                   }
   

}

}


data_up(b)
BROWSER *b;
{
 if(b->row0>0){
	b->row0--;
	draw_data(*b);
        }
}

data_down(b)
BROWSER *b;
{
 if(b->row0<(b->maxrow-1)){
	b->row0++;
	draw_data(*b);
        }
}

data_pgup(b)
BROWSER *b;
{
 int i=b->row0-b->nrow;
 if(i>0){

 b->row0=i;
 draw_data(*b);
 }
}
 
data_pgdn(b)
BROWSER *b;
{
 int i=b->row0+b->nrow;
 if(i<(b->maxrow-1)){
 b->row0=i;
 draw_data(*b);
 }
}

 data_home(b)
BROWSER *b;
{
 b->row0=0;
 b->istart=0;
 b->iend=b->maxrow;
 draw_data(*b);
}
 
 data_end(b)
BROWSER *b;
{
 b->row0=b->maxrow-1;
 draw_data(*b);
}

data_get(b)
BROWSER *b;
{
 int i,in=b->row0;
 set_ivar(0,(double)storage[0][in]);
 for(i=0;i<NODE;i++)
 {
  last_ic[i]=(double)storage[i+1][in];
  set_ivar(i+1,last_ic[i]);
 } 
 for(i=0;i<NMarkov;i++)last_ic[i+NODE]=(double)storage[i+NODE+1][in];
 for(i=NODE+NMarkov;i<NEQ;i++)set_val(uvar_names[i],storage[i+1][in]);

 redraw_ics();
}

data_replace(b)
BROWSER *b;
{
 Window w;
 int rev,status;
 char var[20],form[80];
 XGetInputFocus(display,&w,&rev);
strcpy(var,uvar_names[0]);
strcpy(form,uvar_names[0]);
status=get_dialog("Replace","Variable:",var,"Ok","Cancel",20);
if(status!=0){
 status=get_dialog("Replace","Formula:",form,"Replace","Cancel",80);
 if(status!=0)replace_column(var,form,b->data,b->maxrow);
 draw_data(*b);
}

  XSetInputFocus(display,w,rev,CurrentTime);


 }

data_unreplace(b)
BROWSER *b;
{
 unreplace_column(b->data,b->maxrow);
 draw_data(*b);
}

 

 
data_find(b)
BROWSER *b;
{
 Window w;
 int rev,status;
 char var[50];
 static char *name[]={"Variable","Value"};
 char value[2][25];
 int col,row;
 
 float val;

 sprintf(value[0],uvar_names[0]);
 sprintf(value[1],"0.00");
 XGetInputFocus(display,&w,&rev);
 status=do_string_box(2,2,1,"Find Data",name,value,40);
 
  
 XSetInputFocus(display,w,rev,CurrentTime);

 if(status==0)return;
 val=(float)atof(value[1]);
 find_variable(value[0],&col);
 if(col>=0)find_value(col,val,&row,*b);
 if(row>=0){
	    b->row0=row;
	    draw_data(*b);
	   }

   
  
}


 open_write_file(fp,fil,ok,w)
 FILE **fp;
  char *fil;
  int *ok;
  Window w;
{
 char ans;
 *ok=0;
 *fp=fopen(fil,"r");
	if(*fp!=NULL){
		fclose(*fp); 
		ans=(char)two_choice("Yes","No",
		"File Exists! Overwrite?","yn",0,0,w);
		if(ans!='y')return;
		}	 

			*fp=fopen(fil,"w");
			if(*fp==NULL){
				      respond_box(w,0,0,"Ok",
					"Cannot open file");
				      *ok=0;
				     }
		         else *ok=1;
			 return;
		    
  }




data_read(b)
BROWSER *b;
{
 Window w;
 int rev,status;
 char fil[80];
 char ch;
 FILE *fp;
 int i,j,k;
 int len,count=0,white=1;
 float z;
 int ok;
 XGetInputFocus(display,&w,&rev);
 strcpy(fil,"test.dat");

 status=get_dialog("Load","Filename:",fil,"Ok","Cancel",40);

 XSetInputFocus(display,w,rev,CurrentTime);
if(status==0)return;
 fp=fopen(fil,"r");
 	if(fp==NULL){
				      respond_box(w,0,0,"Ok",
					"Cannot open file");
				     return;
				     }
 /*  Now we establish the width of the file and read it.
      If there are more columns than available we
      ignore them.
     
     if there are fewer rows we read whats necessary
     if there are more rows then read until we 
     are done or MAX_STOR_ROW.
     This data can be plotted etc like anything else
    */
    
 do
   {
    fscanf(fp,"%c",&ch);
    if( !isspace((int)ch)&&(white) )
    {
     white=0;
     ++count;
     }
     if( isspace((int)ch) &&(1-white)) white=1;
   } while(ch != '\n');
 rewind(fp);
 len=0;
 while(!feof(fp))
 {
  for(k=0;k<count;k++)
  {
   fscanf(fp,"%f ",&z);
   if(k<b->maxcol)b->data[k][len]=z;
   }
   ++len;
   if(len>=MAXSTOR)break;
  }
  fclose(fp);
  refresh_browser(len);
  storind=len;
 /*  b->maxrow=len;
 draw_data(*b); */
}
   








 

data_write(b)
BROWSER *b;
{
  Window w;
 int rev,status;
 char fil[80];
 FILE *fp;
 int i,j;
 int ok;
 XGetInputFocus(display,&w,&rev);
 strcpy(fil,"test.dat");

/* 

 XSetInputFocus(display,command_pop,RevertToParent,CurrentTime);
 strcpy(fil,"test.dat");
 new_string("Write to:",fil);
*/
 status=get_dialog("Write","Filename:",fil,"Ok","Cancel",40);

 XSetInputFocus(display,w,rev,CurrentTime);
if(status==0)return;
 open_write_file(&fp,fil,&ok,b->main);
 if(!ok)return;
 for(i=b->istart;i<b->iend;i++){
	for(j=0;j<b->maxcol;j++)fprintf(fp,"%g ",b->data[j][i]);
 	fprintf(fp,"\n");
        }
 fclose(fp);
}
 
 



data_left(b)
BROWSER *b;
{
 int i=b->col0;
 if(i>1){
 b->col0--;
 redraw_browser(*b);
}
}

data_right(b)
BROWSER *b;
{
 int i=b->col0+b->ncol;
 if(i<=b->maxcol){
 b->col0++;
 redraw_browser(*b);
 }
}
 
 data_first(b)
BROWSER *b;
{
 b->istart=b->row0;
}

 data_last(b)
BROWSER *b;
{
 b->iend=b->row0+1;
}

 data_restore(b)
 BROWSER *b;
 {
  restore(b->istart,b->iend);
  
  }







   
  

    

 

