/*    This is the routine for drawing and 
      numbering the axes  in PHASEPLANE
*/
#include <math.h>
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "struct.h"

#define MAXODE 50

#define NOAXES 0
#define CROSS 1
#define TAXIS 3
#define ELAXIS 2
#define BOX 4
#define CROSS3D 5
#define T3D 7
#define EL3D 6
#define CUBE 8

extern GRAPH *MyGraph;
extern GC small_gc;
extern int DCURXs,DCURYs;
extern Display *display;
extern Window draw_win;
extern int DX_0,DY_0,D_WID,D_HGT;
extern int PSFlag;
extern char uvar_names[MAXODE][12];
/* specially formatted number positioning  */
/* flags:
	0 smallest
        1 biggest
        2 middle
        3 2 lines down
*/

put_number_ps(xflag,yflag,fmt,number)
char *fmt;
float number;
int xflag,yflag;
{
 float i,j;
 int n;
 char text[30];
 sprintf(text,fmt,number);
 n=strlen(text);
 /*  do j first   */
 switch(xflag){
		case 0: j=110;
			break;
		case 1: j=600-7*n;
			break;
		case 2: j=350;
			break;
			}
 switch(yflag){
		case 0: i=115;
			break;
		case 1: i=480;
			break;
		case 2: i=350;
			break;
		case 3: i=140;
			break;
			}
  ps_text((float)i,(float)j,text);
}

put_number_pgl(xflag,yflag,fmt,number)
char *fmt;
float number;
int xflag,yflag;
{
 float i,j;
 int n;
 char text[30];
 sprintf(text,fmt,number);
 n=strlen(text);
 /*  do j first   */
 switch(xflag){
		case 0: j=110;
			break;
		case 1: j=600-7*n;
			break;
		case 2: j=350;
			break;
			}
 switch(yflag){
		case 0: i=115;
			break;
		case 1: i=480;
			break;
		case 2: i=350;
			break;
		case 3: i=140;
			break;
			}
/*  pgl_text((float)i,(float)j,text); */
}




put_number(xflag,yflag,fmt,number)
char *fmt;
float number;
int xflag,yflag;
{
 int i,j;
 int n;
 char text[30];
 sprintf(text,fmt,number);
 n=strlen(text);
 if(PSFlag==1){
   put_number_ps(xflag,yflag,fmt,number);
   return;
 }
 if(PSFlag==2){
   put_number_pgl(xflag,yflag,fmt,number);
   return;
 }
 /*  do i first   */
 switch(xflag){
		case 0: i=DX_0+DCURXs;
			break;
		case 1: i=DX_0+D_WID-DCURXs*(n+1);
			break;
		case 2: i=DX_0+D_WID/2+DCURXs;
			break;
			}
 switch(yflag){
		case 0: j=DY_0+DCURYs;
			break;
		case 1: j=DY_0+D_HGT-DCURYs;
			break;
		case 2: j=DY_0+D_HGT/2+DCURYs;
			break;
		case 3: j=DY_0+2*DCURYs;
			break;
			}
  XDrawString(display,draw_win,small_gc,i,j,text,n);
}


re_title()
{
 char bob[40];
 make_title(bob);
 title_text(bob);
}

make_title(str)
char *str;
{
 int i;
 char name1[20];
 char name2[20];
 char name3[20];
 if((i=MyGraph->xv[0])==0)strcpy(name1,"T");
 else strcpy(name1,uvar_names[i-1]);

if((i=MyGraph->yv[0])==0)strcpy(name2,"T");
 else strcpy(name2,uvar_names[i-1]);
 
if((i=MyGraph->zv[0])==0)strcpy(name3,"T");
 else strcpy(name3,uvar_names[i-1]);

 if(MyGraph->grtype>=5)
 sprintf(str,"%s vs %s vs %s",name3,name2,name1);
 else sprintf(str,"%s vs %s",name2,name1);
}

do_axes()
{
    float xmid,ymid;
   
    set_color(0);
    re_title();
    SmallGr();
    switch(MyGraph->grtype)
    {
    case NOAXES: break;  
    case CROSS:         /* -|-  */
           xmid=(float).5*(MyGraph->xlo+MyGraph->xhi);
	   ymid=(float).5*(MyGraph->ylo+MyGraph->yhi);
           qwik_axis(1,xmid,ymid);
	   break;
    case TAXIS: t_axis();break; /* |--- */
    case ELAXIS:  el_axis(); break;  /* |____  */
    case BOX: box(); break; 
    case CROSS3D : axis_3d(); break;  /*   -X-    */
    case T3D:  t_3d();break; /*  X-- */
    case EL3D:  el_3d(); break; /* V_  */
    case CUBE: box_3d();break;

   }
  SmallBase();
 }








/*  Two dimensional axes    */


box()
{
 float x1=MyGraph->xlo,x2=MyGraph->xhi,y1=MyGraph->ylo,y2=MyGraph->yhi;
 float dy=(y2-y1)/24.0;
 float dx=(x2-x1)/24.0;
 line_abs(x1,y1,x1,y2);
 line_abs(x1,y2,x2,y2);
 line_abs(x2,y2,x2,y1);
 line_abs(x2,y1,x1,y1);
/*   
 number_abs(x1+dx,y1+dy,"%.4g",x1);
 number_abs(x2-3*dx,y1+dy,"%.4g",x2);
 
 number_abs(x1+dx,y1+2*dy,"%.4g",y1);
 number_abs(x2-3*dx,y1+2*dy,"%.4g",y2);
*/
 put_number(0,0,"%.4g",x1);
 put_number(1,0,"%.4g",x2);
 put_number(0,3,"%.4g",y1);
 put_number(1,3,"%.4g",y2);


 
}


t_axis()
{
 float x1=MyGraph->xlo,x2=MyGraph->xhi,y1=MyGraph->ylo,y2=MyGraph->yhi;
  float dy=(y2-y1)/24.0;
 float yb=.5*(y1+y2);
 float dx=(x2-x1)/24.0;
 line_abs(x1,y1,x1,y2);
 line_abs(x1,yb,x2,yb);
/*
 number_abs(x1+dx,yb-dy,"%.4g",x1);
 number_abs(x2-3*dx,yb-dy,"%.4g",x2);
 
 number_abs(x1+dx,y1+dy,"%.4g",y1);
 number_abs(x1+dx,y2-dy,"%.4g",y2);
*/
 put_number(0,0,"%.4g",y2);
 put_number(0,1,"%.4g",y1);
 put_number(0,2,"%.4g",x1);
 put_number(1,2,"%.4g",x2);
 }

el_axis()
{
  float x1=MyGraph->xlo,x2=MyGraph->xhi,y1=MyGraph->ylo,y2=MyGraph->yhi;
  float dy=(y2-y1)/24.0;

 float dx=(x2-x1)/24.0;
 line_abs(x1,y1,x1,y2);
 line_abs(x1,y1,x2,y1);
/*
 number_abs(x1+dx,y1+dy,"%.6g",x1);
 number_abs(x2-3*dx,y1+dy,"%.6g",x2);
 
 number_abs(x1+dx,y1+2*dy,"%.6g",y1);
 number_abs(x2-3*dx,y1+2*dy,"%.6g",y2);
 */
 put_number(0,0,"%.4g",x1);
 put_number(1,0,"%.4g",x2);
 put_number(0,3,"%.4g",y1);
 put_number(1,3,"%.4g",y2);



 
}







number_abs(x, y,fmt,value)   /*  put a small number at x,y */
float x,y,value;
char *fmt;
{
 char text[30];
 sprintf(text,fmt,value);
 sm_text_abs(x,y,text);
}








qwik_axis(num,xmid,ymid)
float xmid,ymid;
int num;
{

 float dx,dy,x,y;
 int i;
 line_abs(xmid,(float)MyGraph->ylo,xmid,(float)MyGraph->yhi);
 line_abs((float)MyGraph->xlo,ymid,(float)MyGraph->xhi,ymid);
 dx=.1*(MyGraph->xhi-MyGraph->xlo);
 dy=.1*(MyGraph->yhi-MyGraph->ylo);
 for(i=0;i<=10;i++)
 {
  x=dx*(float)i+MyGraph->xlo;
  y=dy*(float)i+MyGraph->ylo;
  line_abs(x,ymid-.1*dy,x,ymid+.1*dy);
  line_abs(xmid-.066*dx,y,xmid+.066*dx,y);
 }
 if(num)
 {
/*
 number_abs((float)MyGraph->xlo,ymid-.5*dy,"%.4g",(float)MyGraph->xlo);
 number_abs((float)MyGraph->xhi-1.5*dx,ymid-.5*dy,"%.4g",(float)MyGraph->xhi);

 number_abs(xmid+.2*dx,(float)MyGraph->ylo+.25*dy,"%.4g",(float)MyGraph->ylo);
 number_abs(xmid+.2*dx,(float)MyGraph->yhi-.25*dy,"%.4g",(float)MyGraph->yhi);
 */
  
 put_number(2,0,"%.4g",(float)MyGraph->yhi);
 put_number(2,1,"%.4g",(float)MyGraph->ylo);
 put_number(0,2,"%.4g",(float)MyGraph->xlo);
 put_number(1,2,"%.4g",(float)MyGraph->xhi);



 }
}





/*   Three-dimensional axes  --  no numbers !!    */



box_3d()
{
 line3d(-1.,-1.,-1.,1.,-1.,-1.);
 line3d(1.,-1.,-1.,1.,1.,-1.);
 line3d(1.,1.,-1.,-1.,1.,-1.);
 line3d(-1.,1.,-1.,-1.,-1.,-1.);
 line3d(-1.,-1.,1.,1.,-1.,1.);
 line3d(1.,-1.,1.,1.,1.,1.);
 line3d(1.,1.,1.,-1.,1.,1.);
 line3d(-1.,1.,1.,-1.,-1.,1.);
 line3d(1.,1.,1.,1.,1.,-1.);
 line3d(-1.,1.,1.,-1.,1.,-1.);
 line3d(-1.,-1.,1.,-1.,-1.,-1.);
 line3d(1.,-1.,1.,1.,-1.,-1.);
 text3d(.9,-.9,-.9,"x");
 text3d(-.9,-.9,.9,"z");
 text3d(-.8,.9,-.8,"y");

}

axis_3d()
{
 line3d(-1.,0.,0.,1.,0.,0.);
 line3d(0.,-1.,0.,0.,1.,0.);
 line3d(0.,0.,-1.,0.,0.,1.);
 text3d(.9,-.1,-.1,"x");
 text3d(.1,.9,.1,"y");
 text3d(.1,.1,.9,"z");
}

t_3d()
{
 line3d(-1.,0.,-1.,1.,0.,-1.);
 line3d(0.,-1.,-1.,0.,1.,-1.);
 line3d(0.,0.,-1.,0.,0.,1.);
 text3d(.9,.1,-.9,"x");
 text3d(.1,.9,-.9,"y");
 text3d(.1,.1,.9,"z");
}

el_3d()
{
 line3d(-1.,-1.,-1.,1.,-1.,-1.);
 line3d(-1.,-1.,-1.,-1.,1.,-1.);
 line3d(-1.,-1.,-1.,-1.,-1.,1.);
 text3d(.9,-.9,-.9,"x");
 text3d(-.9,-.9,.9,"z");
 text3d(-.8,.9,-.8,"y");

}




























