/************************************************************************
 *                                                                      *
 *  Program package "tooldiag":                                         *
 *                                                                      *
 *                                                                      *
 *  Version 1.3                                                         *
 *  Date: 15 November 1993                                              *
 *                                                                      *
 *  NOTE: This program package is copyrighted in the sense that it      *
 *  may be used for scientific purposes. The package as a whole, or     *
 *  parts thereof, cannot be included or used in any commercial         *
 *  application without written permission granted by the author.       *
 *  No programs contained in this package may be copied for commercial  *
 *  distribution.                                                       *
 *                                                                      *
 *  All comments  concerning this program package may be sent to the    *
 *  e-mail address 'tr@fct.unl.pt'.                                     *
 *                                                                      *
 ************************************************************************/

#include <stdio.h>
#include <string.h>
#include "def.h"

#ifdef DOS
#include <time.h>

static time_t  t1, t2;

void start_timer( s )
char *s;
{
 printf( "%s\n", s );
 time( &t1 );
}

void stop_timer( s )
char *s;
{
 double deltaT;

 time( &t2 );
 deltaT = t2 - t1;
 printf("  --> Elapsed time for: %s %3.0f Seconds\n", s, deltaT );
}
#else

#define CLOCK

#ifdef CLOCK
#ifndef CLOCKS_PER_SEC
#include <time.h>
#endif
#else
#include <sys/types.h>
#include <sys/times.h>
#endif

#ifndef CLOCKS_PER_SEC
#define CLOCKS_PER_SEC 100000
#endif


#ifdef CLOCK
static clock_t _start_time, _stop_time, _diff_time;
#else
#define HZ 60
typedef float f_time;
static f_time _start_time, _stop_time, _diff_time;
static struct tms tbuf;
#endif

void start_timer( s )
char *s;
{
 printf( "%s\n", s );
#ifdef CLOCK
 _start_time = clock();
#else
 (void)times( &tbuf );
 _start_time = ((float)((long)(tbuf.tms_utime)) / ((float)HZ));
#endif
}


void stop_timer( s )
char *s;
{
#ifdef CLOCK
 _stop_time = clock();
 _diff_time = _stop_time - _start_time;
 printf( "%s - CPU Sec*CLOCKS_PER_SEC= %ld  CPU Sec.=%.3f\n",
     s, (long int)_diff_time, (float)_diff_time/(float)CLOCKS_PER_SEC );
#else
 (void)times( &tbuf );
 _stop_time = ((float)((long)(tbuf.tms_utime)) / ((float)HZ));
 _diff_time = _stop_time - _start_time;
 printf( "%s - CPU Sec.: %.3f\n", s, _stop_time );
#endif
}
#endif


void time_string( str )
char *str;
{
 time_t t;

 time( &t );
 strcpy( str, ctime( &t ) );
}
