/************************************************************************
 *                                                                      *
 *  Program package "tooldiag":                                         *
 *                                                                      *
 *                                                                      *
 *  Version 1.3                                                         *
 *  Date: 15 November 1993                                              *
 *                                                                      *
 *  NOTE: This program package is copyrighted in the sense that it      *
 *  may be used for scientific purposes. The package as a whole, or     *
 *  parts thereof, cannot be included or used in any commercial         *
 *  application without written permission granted by the author.       *
 *  No programs contained in this package may be copied for commercial  *
 *  distribution.                                                       *
 *                                                                      *
 *  All comments  concerning this program package may be sent to the    *
 *  e-mail address 'tr@fct.unl.pt'.                                     *
 *                                                                      *
 ************************************************************************/

#include <stdio.h>
#include <string.h>
#include "def.h"

extern universe *U;
extern bool verbose;
extern bool feat_description;
extern char **feature_desc;

static bool done;
static str80 buf, name;
static str100 snnsFile, snnsFileNet, snnsFilePat;


static void gen_snns_network_file( f )
FILE *f;
{
 str80 timeStr, featName;
 int u, i, x, y, feat, hidden, class, links;

 /* Number of input units : Number of features */
 feat = U->nrSelFeat;
 /* Number of hidden units : 2 * feat + 1 (KOLMOGOROV-Recommendation) */
 hidden = 2 * feat + 1;
 /* Number of output units : Number of classes */
 class = U->nrClass;
 /* Network : fully interconnected 3-layer feedforward */
 /* Learning method : Standard Error Backpropagation */

 fprintf( f, "SNNS network definition file V1.4-3D\n" );
 time_string( timeStr );
 fprintf( f, "generated at %s\n", timeStr );
 fprintf( f, "network name : TOOLDIAG\n" );
 fprintf( f, "source files :\n" );
 fprintf( f, "no. of units : %d\n", feat + hidden + class );
 fprintf( f, "no. of connections : %d\n", feat*hidden + hidden*class );
 fprintf( f, "no. of unit types : %d\n", 0 );
 fprintf( f, "no. of site types : %d\n\n\n", 0 );
 fprintf( f, "learning function : Std_Backpropagation\n" );
 fprintf( f, "update function   : Topological_Order\n\n\n" );

 fprintf( f, "unit definition section :\n\n" );
 fprintf( f, "no.    | typeName | unitName        | act      | bias     | ");
     fprintf( f, "st | position | act func | out func | sites\n" );
 fprintf( f, "-------|----------|-----------------|----------|----------|");
   fprintf( f, "----|----------|----------|----------|-------\n" );
 u = 1; x = 3; y = 2;
 for( i = 0; i < feat; i++ )
 {
   featName[0] = '\0';
   if( feat_description )
     strcpy( featName, feature_desc[U->FSV[i].rank] );
   fprintf( f, " %5d |          | %15s | %f | %f | i  | %d, %d, 0 |||\n",
     u, featName, 0.00000, 0.00000, x, y );
   x += 2; 
   u++;
 }
 x = 2; y += 3;
 for( i = 0; i < hidden; i++ )
 {
   fprintf( f, " %5d |          |                 | %f | %f | h  | %d, %d, 0 |||\n",
     u, 0.00000, 0.00000, x, y );
   x += 1;
   u++;
 }
 x = 4; y += 3;
 for( i = 0; i < class; i++ )
 {
   fprintf( f, " %5d |          | %15s | %f | %f | o  | %d, %d, 0 |||\n",
     u, U->C[i].name, 0.00000, 0.00000, x, y );
   x += 2;
   u++;
 }
 fprintf( f, "-------|----------|-----------------|----------|----------|");
   fprintf( f, "----|----------|----------|----------|-------\n" );

 fprintf( f, "\n\nconnection definition section :\n\n" );
 fprintf( f, "target | site | source:weight\n" );
 fprintf( f, "-------|------|---------------------------------------------\n" );
 for( u = feat+1; u < feat+1+hidden; u++ )
 {
   fprintf( f, " %5d |      | ", u );
   for( i = feat; i > 0; i-- )
   {
     if( i > 1 )
       fprintf( f, " %d: 0.00000,", i );
     else
       fprintf( f, " %d: 0.00000", i );
   }
   fprintf( f, "\n" );
 }
 for( u = feat+1+hidden; u < feat+1+hidden+class; u++ )
 {
   fprintf( f, " %5d |      | ", u );
   for( i = feat+hidden; i > feat; i-- )
   {
     if( i > feat+1 )
       fprintf( f, " %d: 0.00000,", i );
     else
       fprintf( f, " %d: 0.00000", i );
   }
   fprintf( f, "\n" );
 }
 fprintf( f, "-------|------|---------------------------------------------\n" );
}


static void gen_snns_pattern_file( f )
FILE *f;
{
 int i, j, k, c;
 str80 timeStr;

 fprintf( f, "SNNS pattern definition file V1.4\n" );
 time_string( timeStr );
 fprintf( f, "generated at %s\n\n", timeStr );
 fprintf( f, "No. of patterns     : %d\n", U->sumSampl );
 fprintf( f, "No. of input units  : %d\n", U->nrSelFeat );
 fprintf( f, "No. of output units : %d\n\n\n", U->nrClass );
 fprintf( f, "#\n#\tPattern file for the universe: %s\n#\n", U->name );

 for( i = 0; i < U->nrClass; i++ )
 {
   fprintf( f, "#\n# %s\n#\n", U->C[i].name );
   for( j = 0; j < U->C[i].numSampl; j++ )
   {
     for( k = 0; k < U->nrSelFeat; k++ )
       fprintf( f, "%f ", U->C[i].S[j*U->nrFeat+U->FSV[k].rank] );
     for( c = 0; c < U->nrClass; c++ )
       if( c == i )
         fprintf( f, "1 " );
       else
         fprintf( f, "0 " );
     fprintf( f, "\n" );
   }
 }
}


static void gen_snns_data()
{
 FILE *snnsNet = NULL, *snnsPat = NULL;

 if( U->nrSelFeat == 0 )
   { printf(" Select features first please!..." ); gets( buf ); return; }

 strcpy( snnsFile, DATA_DIR );
 printf("Saving the net and pattern file in (without extension):\n\t\t%s",
	 snnsFile );
 gets( name );
 if( name[0] != '\0' )
 {
   strcat( snnsFile, name );
   strcpy( snnsFileNet, snnsFile ); strcat( snnsFileNet, ".net" );
   strcpy( snnsFilePat, snnsFile ); strcat( snnsFilePat, ".pat" );
   snnsNet = fopen( snnsFileNet, f_open_text_w );
   if( snnsNet == NULL )
     { printf("Cannot open %s! Exitus...\n", snnsFileNet ); exit(1); }
   snnsPat = fopen( snnsFilePat, f_open_text_w );
   if( snnsPat == NULL )
     { printf("Cannot open %s! Exitus...\n", snnsFilePat ); exit(1); }
   if( verbose )
   {
     printf("Generating Network File: %s\n", snnsFileNet );
     printf("Generating Pattern File: %s\n", snnsFilePat );
   }
   gen_snns_pattern_file( snnsPat );
   gen_snns_network_file( snnsNet );
   fclose( snnsNet ); fclose( snnsPat );
 }
}


static void gen_snns_test()
{
 str80 raw, filtered;
 FILE *r, *f;
 str100 nameBuf;
 int i, j, k, c, class, featDim, nrPat;
 str80 timeStr;
 FeatVector featBuf = NULL;
 bool found;

 if( U->nrSelFeat == 0 )
   { printf(" Select features first please!..." ); gets( buf ); return; }

 printf("Name of the file to be filtered to test file? "); gets( raw );
 r = fopen( raw, f_open_text_r );
 if( r == NULL )
   { printf(" Cannot open %s...", raw ); gets( buf ); return; }

 strcpy( filtered, DATA_DIR );
 printf("Name of the output file with filtered features?\n\t\t%s", filtered );
 gets( buf );
 if( (strcmp(raw,buf) == 0) )
   { printf(" Sorry file names are the same!..." ); gets( buf ); return; }
 strcat( filtered, buf );
 strcat( filtered, ".pat" );
 f = fopen( filtered, f_open_text_w );
 if( f == NULL )
   { printf(" Cannot open %s...", raw ); gets( buf ); return; }

 if( verbose )
   printf("Filtering\n\t\t%s\nTO\n\t\t%s\n", raw, filtered );

 /* try to read the dimension */
 dataline( r, buf ); sscanf( buf, "%d", &featDim );
 if( featDim != U->nrFeat )
   { printf("Universe and file have different feature dimensions: %d != %d...",
	U->nrFeat, featDim  ); gets( buf ); fclose( r ); fclose( f ); return; }
 featBuf = (FeatVector) malloc(sizeof(FeatVector*) * U->nrFeat);

 /* first count the number of samples */
 nrPat = 0;
 while( !feof( r ) )
 {
   for( k = 0; k < U->nrFeat; k++ )
     fscanf( r, "%f", &(featBuf[k]) );
   fscanf( r, "%s", nameBuf );
   if( !feof( r ) )
     nrPat++;
 }
 fclose( r );
 r = fopen( raw, f_open_text_r );
 dataline( r, buf );

 fprintf( f, "SNNS pattern definition file V1.4\n" );
 time_string( timeStr );
 fprintf( f, "generated at %s\n\n", timeStr );
 fprintf( f, "No. of patterns     : %d\n", nrPat );
 fprintf( f, "No. of input units  : %d\n", U->nrSelFeat );
 fprintf( f, "No. of output units : %d\n\n\n", U->nrClass );
 fprintf( f, "#\n#\tTest pattern file for the universe: %s\n#\n", U->name );

 nrPat = 0;
 while( !feof( r ) )
 {
   for( k = 0; k < U->nrFeat; k++ )
   {
     fscanf( r, "%f", &(featBuf[k]) );
     /* normalize, if training data was also normalized */
     if( U->normalized )
       featBuf[k] = (featBuf[k] - U->min[k]) / (U->max[k] - U->min[k]);
   }
   fscanf( r, "%s", nameBuf );
   if( !feof( r ) )
   {
     nrPat++;
     fprintf( f, "# Pattern nr. %d - class=%s\n", nrPat, nameBuf );
     for( i = 0; i < U->nrSelFeat; i++ )
       fprintf( f, "%f ", featBuf[ U->FSV[i].rank ] );
     /* search the class that matches the string */
     found = FALSE; class = 0;
     while( ! found && class < U->nrClass )
     {
       found = strcmp(nameBuf,U->C[class].name)==0;
       if( ! found )
         class++;
     }
     if( class >= U->nrClass )
     {
       printf("\nERROR: Unknown class %s at line %d - exitus...\n",
             nameBuf, nrPat ); exit(1);
     }

     for( c = 0; c < U->nrClass; c++ )
       if( c == class )
         fprintf( f, "1 " );
       else
         fprintf( f, "0 " );
     fprintf( f, "\n" );
   }
 }
 FREE( featBuf );
 fclose( r ); fclose( f );
}


void snnsLoop()
{
 printf("\n>>>>>----- Stuttgart Neural Network Simulator (SNNS) -----<<<<<<\n");
 printf("(1) Generate network and training pattern file\n");
 printf("(2) Filter only selected features from a file and generate");
     printf(" test pattern file\n");
 printf("(Q)uit\n\n");
 printf("Choice: ");

 gets(buf); done = FALSE;
 switch( buf[0] )
  {
   case '?': help( LOOP_SNNS, buf ); break;
   case '1': gen_snns_data(); break;
   case '2': gen_snns_test(); break;
   case 'q': case 'Q': done = TRUE; break;
   default: showUniv( stdout ); break;
  }
}
