/************************************************************************
 *                                                                      *
 *  Program package "tooldiag":                                         *
 *                                                                      *
 *                                                                      *
 *  Version 1.3                                                         *
 *  Date: 15 November 1993                                              *
 *                                                                      *
 *  NOTE: This program package is copyrighted in the sense that it      *
 *  may be used for scientific purposes. The package as a whole, or     *
 *  parts thereof, cannot be included or used in any commercial         *
 *  application without written permission granted by the author.       *
 *  No programs contained in this package may be copied for commercial  *
 *  distribution.                                                       *
 *                                                                      *
 *  All comments  concerning this program package may be sent to the    *
 *  e-mail address 'tr@fct.unl.pt'.                                     *
 *                                                                      *
 ************************************************************************/

#include <stdio.h>
#include "def.h"
#include "featslct.h"

extern universe *U;
extern bool verbose;
extern float selectMultivariate();
extern bool return_log;

static str80 buf;

static FeatSelectVector FSV = NULL;


static void initSFS( crit )
int crit;
{
 switch( crit )
 {
   case PATRICK_FISHER:
     return_log = FALSE;
     printf("Return logaritm of selection criterion instead criterion?");
     printf(" (y/n)n\b"); gets( buf );
     if( buf[0] == 'y' ) return_log = TRUE;
     break;
 }
}


void selectFeaturesSFS( crit )
int crit;
{
 int i, j, maxJ, nrSelectFeat, nrAlreadySelected = 0;
 bool *already_selected = NULL;
 float merit, maxMerit;

 initSFS( crit );

 FSV = (feature*) malloc( sizeof(feature) * U->nrFeat );
 if( FSV == NULL )
    { fprintf( stderr, "Allocation problem - exit...\n" ); exit(1); }
 already_selected = (bool*) malloc( sizeof(bool) * U->nrFeat );
 if( already_selected == NULL )
    { fprintf( stderr, "Allocation problem - exit...\n" ); exit(1); }
 for( j = 0; j < U->nrFeat; j++ )
   already_selected[ j ] = FALSE;

 printf("How many features do you wish to select ? (1-%d): ", U->nrFeat );
 get_d_range( &nrSelectFeat, 1, U->nrFeat, LEFT_CLOSED__RIGHT_CLOSED );

 for( i = 0; i < nrSelectFeat; i++ )
 {
   /* for all available features claculate the criterion together with
      the already selected features */
   maxMerit = -INFINITY;
   for( j = 0; j < U->nrFeat; j++ )
   {
     if( ! already_selected[ j ] )
     {
       /* set up the feature vector */
       FSV[ nrAlreadySelected ].rank = j;
       merit = selectMultivariate( crit, FSV, nrAlreadySelected+1 );
       printf("Feature nr. %4d of %4d-%4d is candidate nr. %4d",
		j+1, U->nrFeat, nrAlreadySelected, i+1 );
       printf("   Criterion=%.4f\r", merit ); fflush( stdout );
       if( verbose ) printf("\n");
       if( merit > maxMerit )
       {
         maxMerit = merit;
         maxJ = j;
       }
     }
   }
   printf("\n");
   /* the feature with the maximum merit is determined */
   already_selected[ maxJ ] = TRUE;
   FSV[ nrAlreadySelected ].rank = maxJ;
   FSV[ nrAlreadySelected ].crit = maxMerit;
   nrAlreadySelected++; 
 }
 printf("\n");
 U->nrSelFeat = nrSelectFeat;
 FREE( U->FSV ); FREE( already_selected );
 U->FSV = (feature*) malloc( U->nrSelFeat * sizeof(struct feature_) );
 for( i = 0; i < U->nrSelFeat; i++ )
   copy_feature( &(FSV[i]), &(U->FSV[i]) );
 show_selected_feats( stdout, U->FSV, U->nrSelFeat );
 FREE( FSV );
}
