/************************************************************************
 *                                                                      *
 *  Program package "tooldiag":                                         *
 *                                                                      *
 *                                                                      *
 *  Version 1.3                                                         *
 *  Date: 15 November 1993                                              *
 *                                                                      *
 *  NOTE: This program package is copyrighted in the sense that it      *
 *  may be used for scientific purposes. The package as a whole, or     *
 *  parts thereof, cannot be included or used in any commercial         *
 *  application without written permission granted by the author.       *
 *  No programs contained in this package may be copied for commercial  *
 *  distribution.                                                       *
 *                                                                      *
 *  All comments  concerning this program package may be sent to the    *
 *  e-mail address 'tr@fct.unl.pt'.                                     *
 *                                                                      *
 ************************************************************************/

#include <stdio.h>
#include "def.h"
#include "featslct.h"

extern universe *U;
extern bool verbose;
extern float selectMultivariate();
extern bool return_log;

static str80 buf;
static FeatSelectVector FSV = NULL;


static void initSBS( crit )
int crit;
{
 switch( crit )
 {
   case PATRICK_FISHER:
     return_log = FALSE;
     printf("Return logaritm of selection criterion instead criterion?");
     printf(" (y/n)n\b"); gets( buf );
     if( buf[0] == 'y' ) return_log = TRUE;
     break;
 }
}


void selectFeaturesSBS( crit )
int crit;
{
 int i, j, k, maxJ, nrSelectFeat, nrAlreadySelected = 0, del;
 int nrDeleteFeat, nrAlreadyDeleted = 0;
 bool *already_deleted = NULL;
 float merit, maxMerit;

 initSBS( crit );

 FSV = (feature*) malloc( sizeof(feature) * U->nrFeat ); CHKPTR( FSV );
 already_deleted = (bool*) malloc( sizeof(bool) * U->nrFeat );
 CHKPTR( already_deleted );
 for( j = 0; j < U->nrFeat; j++ )
   already_deleted[ j ] = FALSE;

 printf("How many features do you wish to select ? (1-%d): ", U->nrFeat );
 get_d_range( &nrSelectFeat, 1, U->nrFeat, LEFT_CLOSED__RIGHT_CLOSED );

 nrDeleteFeat = U->nrFeat - nrSelectFeat;

 for( i = 0; i < nrDeleteFeat; i++ )
 {
   /* for all available features claculate the criterion together with
      the already selected features */
   maxMerit = -INFINITY;
   for( j = U->nrFeat - 1; j >= 0; j-- )
   {
     if( ! already_deleted[ j ] )
     {
       /* prepare the feature vector */
       del = 0;
       for( k = 0; k <  U->nrFeat; k++ )
         if( ! already_deleted[ k ] && k != j )
         {
           FSV[del].rank = k;
           del++;
         }
       FSV[ del ].rank = j; FSV[ del ].crit = (float)EMPTY;

       /* printf("testing:\n");
       show_selected_feats( stdout, FSV, del ); DBG; /**/

       merit = selectMultivariate( crit, FSV, del );
       printf("Feature nr. %4d of %4d-%4d is candidate nr. %4d for deletion\r",
		j+1, U->nrFeat, nrAlreadySelected, i+1 ); fflush(stdout);
       if( verbose ) printf("\n");
       if( merit > maxMerit )
       {
         maxMerit = merit;
         maxJ = j;
       }
     }
   }
   printf("\n");
   /* the feature with the maximum merit is determined */
   already_deleted[ maxJ ] = TRUE;
   /* printf("Deleting feature %d with maxMerit %f", maxJ, maxMerit);
   for( k = 0; k < U->nrFeat; k++ )
     printf("already_deleted[%d] = %d\n", k, already_deleted[k] ); DBG; /**/
 }
 printf("\n");
 U->nrSelFeat = nrSelectFeat;
 FREE( U->FSV );
 U->FSV = (feature*) malloc( U->nrSelFeat * sizeof(struct feature_) );
 CHKPTR( U->FSV );
 del = 0;
 for( i = 0; i < U->nrFeat; i++ )
 {
   if( ! already_deleted[i] )
   {
     U->FSV[del].rank = i;
     U->FSV[del].crit = (float)EMPTY;
     del++;
   }
 }
 show_selected_feats( stdout, U->FSV, U->nrSelFeat );
 FREE( FSV ); FREE( already_deleted );
}
