/************************************************************************
 *                                                                      *
 *  Program package "tooldiag":                                         *
 *                                                                      *
 *                                                                      *
 *  Version 1.3                                                         *
 *  Date: 15 November 1993                                              *
 *                                                                      *
 *  NOTE: This program package is copyrighted in the sense that it      *
 *  may be used for scientific purposes. The package as a whole, or     *
 *  parts thereof, cannot be included or used in any commercial         *
 *  application without written permission granted by the author.       *
 *  No programs contained in this package may be copied for commercial  *
 *  distribution.                                                       *
 *                                                                      *
 *  All comments  concerning this program package may be sent to the    *
 *  e-mail address 'tr@fct.unl.pt'.                                     *
 *                                                                      *
 ************************************************************************/

#include <stdio.h>
#include <string.h>
#include "def.h"

#define ALWAYS 1
#define OPTION 0

#define IN_DATA_DIR	"-dir"     /* name of input data directory */
#define IN_DATA_FILE	"-file"    /* name of input data file */
#define SEL_FILE	"-sel"     /* name of file with selected features */
#define VERBOSE		"-v"
#define FEAT_NAME	"-fnam"    /* name of the feature description */

extern universe *U;
extern str100 dataDir;
extern str100 dataFile;
extern str100 featNameFile;
extern str100 sfName;

static str80 linebuf;
static str30 initial, tool;
static bool load = FALSE;
static char *in_data_dir = NULL;
static char *in_data_file = NULL;
static char *sel_file = NULL;
static char *feat_name_file = NULL;
static bool *visited = NULL;  /* register all pararamters that were detected */

bool verbose = FALSE, feat_description = FALSE;
FILE *infile = NULL;

#define MAXLEN 300
static char *parse_input_param( argc, argv, param, when )
int argc;
char **argv;
char *param;
int when;
{
 int i = 0;
 char str[MAXLEN];

 while ((i < argc) && (strcmp(param, argv[i])))
   i++;
 if (i < argc-1) {
   visited[i] = TRUE;
   if( argv[i+1][0] != '-' )
     visited[i+1] = TRUE;
   else
   {
     fprintf( stderr,
	 "Could not find the argument for parameter %s - exit...\n", param );
     exit( 1 );
   }
   return(argv[i+1]);
 }
 else	/* Did not find parameter */
 {
   if (when == ALWAYS)
   {
     sprintf( str, "Can't find asked option %s", param);
     fprintf( stderr, "%s\n", str );
     exit(1);
   }
 }
 return((char *) NULL);
}

static bool find_input_param( argc, argv, param, when )
int argc;
char **argv;
char *param;
int when;
{
 char str[MAXLEN];
 bool found = FALSE;
 int i = 0;

 while( ! found && i < argc )
 {
   found = (strcmp(argv[i],param)==0);
   if( ! found )
     i++;
 }
 if (when == ALWAYS)
 {
   sprintf( str, "Can't find asked option %s", param);
   fprintf( stderr, "%s\n", str );
   exit(1);
 }
 if( found )
   visited[ i ] = TRUE;
 return( found );
} 

static void usage( argc, argv )
int argc;
char **argv;
{
 fprintf( stderr, "usage: %s [-dir <data-directory> | -file <data-file>]\n", argv[0] );
 fprintf( stderr, "\t[-sel <selected-features-file>] [-v] [-fnam <feature-names-file>]\n\n" );
}


void parse_input( argc, argv )
int argc;
char **argv;
{
 int i;

 visited = (bool*) malloc( argc*sizeof(bool) );
 for( i = 0; i < argc; i++ )
   visited[i] = FALSE;
 visited[ 0 ] = TRUE;	/* argv[0] */

 if( argc == 1 )
   usage( argc, argv );
 verbose = find_input_param( argc, argv, VERBOSE, OPTION );
 in_data_dir = parse_input_param( argc, argv, IN_DATA_DIR, OPTION );
 in_data_file = parse_input_param( argc, argv, IN_DATA_FILE, OPTION );
 if( in_data_dir != NULL && in_data_file != NULL )
 {
   fprintf( stderr, "Choose only one option -file or -dir !; Exitus...\n");
   exit(1);
 }

 if( in_data_dir != NULL )
 {
   load = TRUE;
   strcpy( dataDir, in_data_dir );
   if( verbose )
     printf("Loading data files...\n");
   loadUnivDir();
 }

 if( in_data_file  != NULL )
 {
   load = TRUE;
   strcpy( dataFile, in_data_file );
   loadUnivFile();
 }
 if( load )
 {
   feat_name_file = parse_input_param( argc, argv, FEAT_NAME, OPTION );
   if( feat_name_file != 0 )
   {
     strcpy( featNameFile, feat_name_file );
     load_feat_names( featNameFile );
   }
   sel_file = parse_input_param( argc, argv, SEL_FILE, OPTION );
   if( sel_file != 0 )
   {
     strcpy( sfName, sel_file );
     load_sel( sfName );
   }
 }
 showUniv( stdout );
 /* check if all parameters and arguments were visited */
 for( i = 0; i < argc; i++ )
   if( ! visited[i] )
   {
     fprintf(stderr,"Unknown option \"%s\" or missing parameter - Exit...\n",
		argv[i] );
     FREE( visited );
     exit(1);
   }
 FREE( visited );
}
