/************************************************************************
 *                                                                      *
 *  Program package "tooldiag":                                         *
 *                                                                      *
 *                                                                      *
 *  Version 1.3                                                         *
 *  Date: 15 November 1993                                              *
 *                                                                      *
 *  NOTE: This program package is copyrighted in the sense that it      *
 *  may be used for scientific purposes. The package as a whole, or     *
 *  parts thereof, cannot be included or used in any commercial         *
 *  application without written permission granted by the author.       *
 *  No programs contained in this package may be copied for commercial  *
 *  distribution.                                                       *
 *                                                                      *
 *  All comments  concerning this program package may be sent to the    *
 *  e-mail address 'tr@fct.unl.pt'.                                     *
 *                                                                      *
 ************************************************************************/

#include <stdio.h>
#include <math.h>
#include "def.h"

extern universe *U;

static bool done;
static str80 buf;

/*
 *  Normalize the feature data using the transformation
 *  T(x)  = (x-min) / (max-min )
 *    This scales all values to the interval [0,1]
*/
void normalize()
{
 int i, j, c, k;
 float value, min, max;

 if( U->normalized )
   { printf("Data already normalized..."); gets( buf ); return; }
 if( U->nrClass == 0 )
   { printf("Load first..."); gets( buf ); return; }
 for( k = 0; k < U->nrFeat; k++ )
 {
   min = U->min[k];
   max = U->max[k];
   if( min == max )
   {
     printf("Feature %d has the same min and max value %f\n", k, min );
     printf("Do you wish to continue (y/n)?y\b"); gets( buf );
     if( buf[0] == 'n' )
         { printf("...Exitus...\n"); exit(1); }
   }
 }
 for( c = 0; c < U->nrClass; c++ )
   for( i = 0; i < U->C[c].numSampl; i++ )
   {
     for( k = 0; k < U->nrFeat; k++ )
     {
       value = U->C[c].S[i*U->nrFeat+k];
       min = U->min[k];
       max = U->max[k];
       if( min != max )
         U->C[c].S[i*U->nrFeat+k] = (value-min) / (max-min);
       else
         U->C[c].S[i*U->nrFeat+k] = 0.0;
       /* printf("OLD=%f NEW=%f\n", value, U->C[c].S[i*U->nrFeat+k] ); /**/
       value = U->C[c].S[i*U->nrFeat+k];
       if( value < 0.0 || value > 1.0 )
         { printf("normalize> illegal value=%f; Exitus...\n", value ); exit(1);}
     }
   }
 /* new means and standard deviation */
 for( i = 0; i < U->nrClass; i++ )
   for( k = 0; k < U->nrFeat; k++ )
     { U->C[i].mean[k]=0.0; U->C[i].stddev[k]=0.0; U->C[i].sqrsum[k]=0.0;}
 for( i = 0; i < U->nrClass; i++ )
   for( j = 0; j < U->C[i].numSampl; j++ )
     for( k = 0; k < U->nrFeat; k++ )
     {
       value = U->C[i].S[j*U->nrFeat+k];
       U->C[i].mean[k] = 1.0/((float)(j+1))*(j*U->C[i].mean[k]+value);
       U->C[i].sqrsum[k] += value * value;
       U->C[i].stddev[k] = (float)sqrt(fabs((1.0/(float)(j+1) *
             U->C[i].sqrsum[k] - (U->C[i].mean[k] * U->C[i].mean[k]))));
     }
 U->normalized = TRUE;
}
