/************************************************************************
 *                                                                      *
 *  Program package "tooldiag":                                         *
 *                                                                      *
 *                                                                      *
 *  Version 1.3                                                         *
 *  Date: 15 November 1993                                              *
 *                                                                      *
 *  NOTE: This program package is copyrighted in the sense that it      *
 *  may be used for scientific purposes. The package as a whole, or     *
 *  parts thereof, cannot be included or used in any commercial         *
 *  application without written permission granted by the author.       *
 *  No programs contained in this package may be copied for commercial  *
 *  distribution.                                                       *
 *                                                                      *
 *  All comments  concerning this program package may be sent to the    *
 *  e-mail address 'tr@fct.unl.pt'.                                     *
 *                                                                      *
 ************************************************************************/

#include <stdio.h>
#include <string.h>
#include "def.h"
#include "clasmodl.h"

/* global variables */
extern universe *U;
extern bool is_ascii_file();
extern bool verbose;
extern int classifier_model;
extern int id_one_sample_KNN();

#define MAXSTRLEN 100

static str100 benchFile, nameBuf;
static str80 buf;


static int id_one_sample( sample, name )
FeatVector sample;
char *name;
{
 switch( classifier_model )
 {
   case NEAREST_NEIGHBOR : return( id_one_sample_KNN( sample, name ) ); break;
   case MULTIVARIATE_GAUSSIAN : break;
   default : fprintf(stderr,"What is classifier %d? -exit...\n",
		 classifier_model ); exit(1);
 }
}


static void init_identify()
{
 switch( classifier_model )
 {
   case NEAREST_NEIGHBOR : 
	set_K();
	printf("\n#### Using Nearest-Neighbor Classifier ####\n" ); break;
   case MULTIVARIATE_GAUSSIAN : break;
   default : fprintf(stderr,"What is classifier %d? -exit...\n",
		classifier_model ); exit(1);
 }
}


/* #define COUNTDOWN	/* classify for all selected features from 1 on */
void identify()
{
 FILE *bench = NULL;
 bool ascii_file;
 FeatVector featBuf = NULL;
 int i, j, nsf, k, featDim, nrSmp, nrErr;
 float err;

 if( U->nrSelFeat == 0 )
   { printf("Load universe or select features first..."); gets( buf ); return; }

 printf("Load benchmark data from file? "); gets( benchFile );
 /* strcpy( benchFile, "/usr/users/tr/ai/tooldiag/universes/test.dat" ); /**/

 init_identify();

#ifdef COUNTDOWN
 nsf = U->nrSelFeat;
 for( i = U->nrSelFeat; i >= 1; i-- )
 {
   U->nrSelFeat = i;
   printf("Using the first %d of %d selected features\n", i, nsf );
#endif

   ascii_file = is_ascii_file( benchFile );
   if( ascii_file )
     bench = fopen( benchFile, f_open_text_r ); 
   else
     bench = fopen( benchFile, f_open_bin_r );
   if( bench == NULL )
     { printf("Cannot open %s!...\n", benchFile ); gets(buf); return; }

   /* feature vector dimension */
   dataline( bench, buf ); sscanf( buf, "%d", &featDim );
   if( featDim != U->nrFeat )
     {printf("Universe and file have different feature dimensions: %d != %d...",
          U->nrFeat, featDim  ); gets( buf ); fclose( bench ); return; }

   featBuf = (FeatVector) malloc(sizeof(FeatVector*) * U->nrFeat);

   nrSmp = 0; nrErr = 0;
   while( !feof( bench ) )
   {
     for( k = 0; k < U->nrFeat; k++ )
     {
       if( ascii_file )
         fscanf( bench, "%f", &(featBuf[k]) );
       else
         fread( &(featBuf[k]), sizeof(float), 1, bench );
       /* normalize, if training data was also normalized */
       if( U->normalized )
         featBuf[k] = (featBuf[k] - U->min[k]) / (U->max[k] - U->min[k]);
     }
     if( ascii_file )
       fscanf( bench, "%s", nameBuf );
     else
     {
       j = 0;
       do
       {
         fread( &(nameBuf[j]), sizeof(char), 1, bench );
         if( nameBuf[j] != '\n' )
           j++;
       }
       while( nameBuf[j] != '\n' && j < MAXSTRLEN );
       nameBuf[j] = '\0';
     }
     if( nameBuf[0] == '\0' )   /* empty name, error */
        { fprintf( stderr, "Found an empty class name. Exit...\n"); exit(1); }
     /* else { printf("Name = >>>%s<<<", nameBuf); DBG; }	/**/

     if( !feof( bench ) )
     {
       nrErr += id_one_sample( featBuf, nameBuf );
       nrSmp++;
       fprintf( stderr, " Actual error = %7.2f%%\r",
		 (float)nrErr * 100.0 / (float)nrSmp ); 
     }
   }
   fprintf( stderr, "\n" );
   fclose( bench );
   FREE( featBuf );
   err = (float)nrErr / (float)nrSmp;
   printf("\n --- RESULT for benchmark file %s\n", benchFile );
   printf(" ERROR RATE = %6.2f%% --- ACCURACY %6.2f%% ---  Recognized %d of %d\n", 100.0 * err, 100 * (1.0-err), nrSmp-nrErr, nrSmp );

#ifdef COUNTDOWN
   printf("..."); gets(buf);
 }
#endif

}
