/************************************************************************
 *                                                                      *
 *  Program package "tooldiag":                                         *
 *                                                                      *
 *                                                                      *
 *  Version 1.3                                                         *
 *  Date: 15 November 1993                                              *
 *                                                                      *
 *  NOTE: This program package is copyrighted in the sense that it      *
 *  may be used for scientific purposes. The package as a whole, or     *
 *  parts thereof, cannot be included or used in any commercial         *
 *  application without written permission granted by the author.       *
 *  No programs contained in this package may be copied for commercial  *
 *  distribution.                                                       *
 *                                                                      *
 *  All comments  concerning this program package may be sent to the    *
 *  e-mail address 'tr@fct.unl.pt'.                                     *
 *                                                                      *
 ************************************************************************/

#include <stdio.h>
#include <string.h>
#include "def.h"

static str80 buf;

void help( loop, cmd )
int loop;
char *cmd;
{
 printf("\nhelp> ");
 switch( loop )
 {
   case LOOP_MAIN: 
     switch( cmd[1] )
     {
       case '1':
         switch( cmd[2] )
         {
           case '\0':
             printf("\n a) Load the universe from a directory.\n");
             printf(" A directory will be scanned for files which contain");
             printf(" the samples for one class.\n");
             printf(" The directory may contain only the data files.\n");
             printf(" The format of one data file is as follows:\n");
             printf("\tCLASS_NAME\n\tDIMENSION\n\tNUMBER_OF_SAMPLES\n");
             printf("\tsample1\n\tsample2\n\t...\n\tsampleN\n");
             printf("\n b) Load the universe from a file.\n");
             printf(" The file must have the follwing format:\n");
             printf("\tDIMENSION\n");
             printf("\t<Feature_1> ... <Feature_D>   CLASS_NAME\n");
             printf("\t...\n");
             printf("\t<Feature_1> ... <Feature_D>   CLASS_NAME\n");
             break; 
           case '0':
             printf(" Execute a sequence of commands for demo purpose.\n");
             break;
         } break;
       case '2':
         printf("Normalize each feature individually.\n");
         printf("\t1.) Detect the maximum and minimum of all values for all");
         printf("\tclasses of that feature.\n");
         printf("\t2.) Transform each value x to (x-min)/(max-min).\n");
         break; 
       case '3':
         printf(" Feature selection loop.\n\n");
         printf("\tConsult the book:\n");
         printf("Devijver, P.A., and Kittler, J.,\"Pattern Recognition --\n");
         printf("A Statistical Approach,\" Prentice/Hall Int., London, 1982\n");
	 break;
       case '4':
         printf(" Generate a set of representative prototypes from\n");
         printf("\tthe set of all samples.\n"); break;
       case '5':
         printf(" Use leave-out-out error estimation method.\n"); break;
       case '6':
         printf("Use a simple nearest neighbor classifier to identify\n");
         printf("data from a file. The test data should be independent from\n");
         printf("the training data.\n");
         break; 
       case '7':
         printf(" Generate a 2-dimensional plot of the data.\n");
         printf("\tThe multidimensional sample space which is normally\n");
         printf("\thigher than 2 dimensions is mapped to a plane.\n");
         printf("\tThe selected features are used.\n");
         break; 
       case '8':
         printf(" Do some statistics with the data.\n"); break;
       case '9':
         printf(" Generate input data files for other packages.\n"); break;
       case 'q': case 'Q':
         printf(" Ends the program.\n"); break;
     }
     break;
   case LOOP_FEATSELECT: 
     break;
   case LOOP_INTERFACE: 
     switch( cmd[1] )
     {
       case '1':
         printf("Interface to the LVQ_PAK program.\n"); break;
       case '2':
         printf("Interface to the SNNS program.\n"); break;
       case '3':
         printf("Merge two data files column by column.\n"); break;
       case '4':
         printf("From the actual sample set generate a random split.\n"); break;
       case 'q': case 'Q':
         printf(" Ends the program.\n"); break;
     }
     break;
   case LOOP_LVQ: 
     switch( cmd[1] )
     {
       case '1':
         printf("Generate a input data file for the LVQ_PAK program.\n"); break;
       case '2':
         printf("Open a file, read samples and write new file that only\n");
         printf("\tcontains the selected features (LVQ_PAK file format).\n");
         break;
       case 'q': case 'Q':
         printf(" Ends the program.\n"); break;
     }
     break;
   case LOOP_SNNS: 
     switch( cmd[1] )
     {
       case '1':
         printf("Generate a network and pattern file for the SNNS program.\n");
         break;
       case '2':
         printf("Open a file, read samples and write new pattern file that ");
         printf("only\n\tcontains the selected features.\n");
         printf("Use the format of the the data input files to TOOLDIAG.\n");
         break;
       case 'q': case 'Q':
         printf(" Ends the program.\n"); break;
     }
     break;
   case LOOP_STATS: 
     switch( cmd[1] )
     {
       case '1':
         printf("Calculate and plot linear correlation between 2 features.\n");
         break;
       case 'q': case 'Q':
         printf(" Ends the program.\n"); break;
     }
     break;
   default: fprintf( stderr, "help> unknown loop mode..."); gets( buf ); break;
 }
 printf("\n...<Return> to continue..."); gets(buf);
}
