/************************************************************************
 *                                                                      *
 *  Program package "tooldiag":                                         *
 *                                                                      *
 *                                                                      *
 *  Version 1.3                                                         *
 *  Date: 15 November 1993                                              *
 *                                                                      *
 *  NOTE: This program package is copyrighted in the sense that it      *
 *  may be used for scientific purposes. The package as a whole, or     *
 *  parts thereof, cannot be included or used in any commercial         *
 *  application without written permission granted by the author.       *
 *  No programs contained in this package may be copied for commercial  *
 *  distribution.                                                       *
 *                                                                      *
 *  All comments  concerning this program package may be sent to the    *
 *  e-mail address 'tr@fct.unl.pt'.                                     *
 *                                                                      *
 ************************************************************************/

#include <stdio.h>
#include <string.h>
#include "def.h"

extern universe *U;
extern bool verbose, feat_description;

str100 sfName;
char **feature_desc = NULL;

static bool done;
static str80 buf, name;
static FILE *sf = NULL, *ff = NULL;


/* shows the feature selection vector of size len to the file f */
void show_FeatSelectVector( f, FSV, len )
FILE *f;
FeatSelectVector FSV;
int len;
{
 int i;

 fprintf( f,"#%d: { ", len );
 for( i = 0; i < len; i++ )
   fprintf( f,"%d ", FSV[i].rank );
   /* fprintf( f,"[%d,%f] ", FSV[i].rank, FSV[i].crit );	/**/
 fprintf( f,"}\n");
}

/* Shows all selected features explicitly */
void show_selected_feats( f, FSV, len )
FILE *f;
FeatSelectVector FSV;
int len;
{
 int i;

 fprintf( f, "\n--- SELECTED FEATURES --- : %d\n", len );
 for( i = 0; i < len; i++ )
 {
   fprintf( f, "Nr. %4d = %4d", i+1, FSV[i].rank );
   if( FSV[i].crit != (float)EMPTY )
     fprintf( f, "  --- Criterion = %7.5f",FSV[i].crit );
   if( feat_description )
     fprintf( f, "\tName: %s", feature_desc[FSV[i].rank] );
   fprintf( f, "\n");
 }
}


void copy_feature( f1, f2 )
feature *f1, *f2;
{
  f2->rank = f1->rank;
  f2->crit = f1->crit;
}


void save_selected_feat()
{
 int i;

 strcpy( sfName, DATA_DIR );
 printf("Saving selected feature mask to: %s", sfName );
 gets( name );
 if( name[0] != '\0' )
 {
   strcat( sfName, name );
   sf = fopen( sfName, f_open_text_w );
   if( sf == NULL )
     { printf("Cannot open %s! Exitus...\n", sfName ); exit(1); }

   fprintf( sf, "%s\n", U->name );
   fprintf( sf, "%d\n", U->nrSelFeat );
   fprintf( sf,
	 "# Were the feature values normalized to [0,1] during selection ?\n");
   if( U->normalized )
     fprintf( sf, "normalized\n");
   else
     fprintf( sf, "unnormalized\n");
   for( i = 0; i < U->nrSelFeat; i++ )
   {
     fprintf( sf, "%d\t%f", U->FSV[i].rank, U->FSV[i].crit );
     if( feat_description )
       fprintf( sf, "\t%s", feature_desc[U->FSV[i].rank] );
     fprintf( sf, "\n" );
   }
   fclose( sf );
 }
 else
   printf("\tNothing saved...\n");
}


void load_sel( fname )
char *fname;
{
 int i;

 sf = fopen( fname, f_open_text_r );
 if( sf == NULL )
   {printf("Cannot open %s! nothing done...", fname );gets(buf);return;}

 if( verbose )
   printf("\nLoading selected features from %s\n", fname );
 dataline( sf, buf );
 if( strcmp( buf, U->name ) != 0 )
   {printf("Warning universe names different: %s --- %s\n", buf, U->name );}

 dataline( sf, buf );
 sscanf( buf, "%d", &(U->nrSelFeat) );
 if( U->nrSelFeat > U->nrFeat )
    { printf("\nToo much selected features (%d > %d) in %s\n",
	 U->nrSelFeat , U->nrFeat, fname ); exit(1); }
 /* look if features were normalized */
 dataline( sf, buf );
 if( buf[0] == 'n' )
 {
   fprintf(stderr, "Features were selected from normalized data.\n");
   fprintf(stderr, "  => Feature values will be normalized...");
   gets(buf);
   normalize();
 }
 FREE( U->FSV );
 U->FSV = (feature*) malloc( U->nrSelFeat * sizeof(struct feature_) );
 if( U->FSV == NULL ) { printf("\nError allocating 'U->FSV'\n"); exit(1); }
 printf("\n --- SELECTED FEATURES = %d ---\n", U->nrSelFeat );
 for( i = 0; i < U->nrSelFeat; i++ )
 {
   dataline( sf, buf );
   sscanf( buf, "%d %f", &(U->FSV[i].rank), &(U->FSV[i].crit) );
   printf( "Nr. %4d = %4d", i+1, U->FSV[i].rank );
   if( U->FSV[i].crit != (float)EMPTY )
     printf( "  --- Criterion = %7.5f",U->FSV[i].crit );
   if( feat_description )
     printf("\tName: %s", feature_desc[U->FSV[i].rank] );
   printf("\n");
 }
 fclose( sf );
}


void load_selected_feat()
{
 strcpy( sfName, DATA_DIR );
 printf("Load selected feature mask from: %s", sfName );
 gets( name );
 strcat( sfName, name );
 load_sel( sfName );
}


void load_feat_names( fname )
char *fname;
{
 int i, nrNam;
 str100 featnam;

 ff = fopen( fname, f_open_text_r );
 if( ff == NULL )
   {printf("Cannot open %s! nothing done...", fname );gets(buf);return;}

 if( verbose )
   printf("\nLoading feature description file from %s\n", fname );

 dataline( ff, buf );
 sscanf( buf, "%d", &nrNam );
 if( nrNam != U->nrFeat )
   { printf("\nNr. of feature names unequal nr. of features (%d != %d) in %s\n",
	 nrNam , U->nrFeat, fname ); exit(1); }
 feat_description = TRUE;
 feature_desc = (char**) malloc( nrNam * sizeof(char*) );
 for( i = 0; i < nrNam; i++ )
 {
   dataline( ff, buf );
   sscanf( buf, "%s", featnam );
   feature_desc[i] = (char*) malloc( (1+strlen(featnam)) * sizeof(char) );
   strcpy( feature_desc[i], featnam );
 }
 fclose( ff );
 if( verbose )
 {
   printf("\n --- FEATURE NAMES ---\n");
   for( i = 0; i < nrNam; i++ )
     printf("Nr. %5d:   %s\n", i+1, feature_desc[i] );
 }
}


void free_feat_names()
{
 int i;

 if( feature_desc == NULL )
   return;

 for( i = 0; i < U->nrFeat; i++ )
   FREE( feature_desc[i] );
 FREE( feature_desc );
 feat_description = FALSE;
}


static void show_selected()
{
 int i;

 if( U->nrSelFeat == 0 )
 {
   printf("No features are selected...\n"); gets( buf );
   return;
 }
 show_selected_feats( stdout, U->FSV, U->nrSelFeat );
 printf("\n<Enter> to continue..."); gets( buf );
}


static void set_all_selected()
{
 int i;

 FREE( U->FSV );
 U->nrSelFeat = U->nrFeat;
 U->FSV = (feature*) malloc( U->nrSelFeat * sizeof(struct feature_) );
 for( i = 0; i < U->nrSelFeat; i++ )
 {
   U->FSV[i].rank = i; U->FSV[i].crit = (float)EMPTY;
 }
 show_selected();
}


void featSelectToolsLoop()
{
 printf("\n>>>>>----- FEATURE SELECTION TOOLS (+old algorithms) ---<<<<<<\n\n");
 printf("(1) Load selected features from file\n");
 printf("(2) Set all features as selected\n");
 printf("(3) Show all selected features\n");
 printf("(4) Save all selected features to a file\n\n");
 printf("    Selection criterion    |     Search algorithm\n");
 printf("    -------------------------------------------------------------\n");
 printf("(7) M-COVAR                |     (SFS - Sequential Forward Search)\n");
 printf("(8) UNIVAR                 |     (BF  - Best Features)\n");
 printf("(9) MINERR                 |     (SFS - Sequential Forward Search)\n");
 printf("(Q)uit\n\n");
 printf("Choice: ");

 gets(buf); done = FALSE;
 switch( buf[0] )
  {
   case '?': help( LOOP_FEATSELECT, buf ); break;
   case '1': load_selected_feat(); break;
   case '2': set_all_selected(); break;
   case '3': show_selected(); break;
   case '4': save_selected_feat(); break;

   case '7': featSelectMCOVAR(); break;
   case '8': featSelectCHEBYCHEV(); break;
   case '9': featSelectMinErr_SFS(); break;
   case 'q': case 'Q': done = TRUE; break;
   default: showUniv( stdout ); break;
  }
}


void featSelectTools()
{
 if( U->nrClass > 1 )
   do
   {
     featSelectToolsLoop();
   }
   while( !done );
 else
   { printf(" Please load universe first !..." ); gets( buf ); }
}
