/************************************************************************/
/***** EUCLIDEAN DISTANCES BETWEEN 2 SAMPLES USING SCATTER MATRICES *****/
/* see pp. 235 f. */
/************************************************************************/
#define J1 0
#define J2 1
#define J3 2
#define J4 3

#define NUM_EUCLID_DISTANCES 4



/***************************************/
/***** DISTANCES BETWEEN 2 SAMPLES *****/
/* see pp. 232 */
/***************************************/
#define MINKOWSKI 0
#define CITY_BLOCK 1
#define EUCLIDEAN 2
#define CHEBYCHEV_DIST 3
#define NONLINEAR 4

#define NUM_DISTANCES 5



/***************************************/
/*****     SELECTION CRITERIA      *****/
/***************************************/
#define MINERR 0        /* Minimal error */

/* --- Probabilistic distances, see pp. 260 */
#define CHERNOFF 1
#define BHATTACHARYYA 2
#define BHATTACHARYYA_MATUSITA 3
#define DIVERGENCE 4
#define MAHALANOBIS 5
#define PATRICK_FISHER 6

/* --- Interclass distances, see pp. 229 */
#define INTER_CLASS_DISTANCE 7

#define CHEBYCHEV 8     /* Univariate Chebychev */


#define NUM_CRITERIA 9



/***************************************/
/*****      SEARCH STRATEGIES      *****/
/***************************************/
#define BF 0
#define SFS 1
#define SBS 2
#define B_AND_B 3

#define NUM_STRATEGIES 4
