/************************************************************************
 *                                                                      *
 *  Program package "tooldiag":                                         *
 *                                                                      *
 *                                                                      *
 *  Version 1.3                                                         *
 *  Date: 15 November 1993                                              *
 *                                                                      *
 *  NOTE: This program package is copyrighted in the sense that it      *
 *  may be used for scientific purposes. The package as a whole, or     *
 *  parts thereof, cannot be included or used in any commercial         *
 *  application without written permission granted by the author.       *
 *  No programs contained in this package may be copied for commercial  *
 *  distribution.                                                       *
 *                                                                      *
 *  All comments  concerning this program package may be sent to the    *
 *  e-mail address 'tr@fct.unl.pt'.                                     *
 *                                                                      *
 ************************************************************************/

#include <stdio.h>
#include <string.h>
#include "def.h"

#ifdef DOS
#include <dir.h>
#include <dos.h>

static struct ffblk ffblk;
static bool nomore, firstFile;


void open_directory()
{
 firstFile = TRUE;
}

void close_directory() {}   /* dummy */


bool err_directory()
{
 return( FALSE );
}


bool next_directory( dirName, fileName )
char *dirName;
char *fileName;
{
 bool nomore;
 str100 name;

 strcpy( name, dirName );
 strcat( name, "\\*.*" );
 if( firstFile )
 {
   firstFile = FALSE;
   nomore = findfirst( name, &ffblk, 0 );
   if( nomore )
   {
     fprintf( stderr, "Directory %s empty; exit...\n", dirName );
     exit(1);
   }
 }
 else
   nomore = findnext( &ffblk );
   
 strcpy( fileName, "\\" );
 strcat( fileName, ffblk.ff_name );
 return( ! nomore );
}
#else/*DOS*/

#ifdef _AIX
#define DIRENT
#endif /*_AIX*/

#include <sys/types.h>
#include <sys/dir.h>
#ifdef DIRENT
#include <dirent.h>
#endif


static DIR *dir = NULL;
#ifdef DIRENT
static struct dirent *dp = NULL;
#else
static struct direct *dp = NULL;
#endif


void open_directory( dataDir )
char *dataDir;
{
 dir = (DIR*) malloc( sizeof(DIR) );
 dir = opendir( dataDir );
}


void close_directory()
{
 closedir( dir );
 FREE( dir );
}


bool err_directory()
{
 return( dir == NULL );
}


bool next_directory( dirName, fileName )
char *dirName;	/* here without function */
char *fileName;
{
 do
 {
   dp = readdir( dir );
   if( dp == NULL )
     return( FALSE );
 }
 while( dp->d_name[0]=='.' || (dp->d_name[0]=='.' && dp->d_name[1]=='.') );
 /* printf("Finding: %s\n", dp->d_name ); /**/
 strcpy( fileName, dp->d_name );
 return( TRUE ); 
}
 
#endif/*else DOS*/
