/************************************************************************
 *                                                                      *
 *  Program package "tooldiag":                                         *
 *                                                                      *
 *                                                                      *
 *  Version 1.3                                                         *
 *  Date: 15 November 1993                                              *
 *                                                                      *
 *  NOTE: This program package is copyrighted in the sense that it      *
 *  may be used for scientific purposes. The package as a whole, or     *
 *  parts thereof, cannot be included or used in any commercial         *
 *  application without written permission granted by the author.       *
 *  No programs contained in this package may be copied for commercial  *
 *  distribution.                                                       *
 *                                                                      *
 *  All comments  concerning this program package may be sent to the    *
 *  e-mail address 'tr@fct.unl.pt'.                                     *
 *                                                                      *
 ************************************************************************/

#include <stdio.h>
#include <signal.h>
#include <setjmp.h>
#include <stdlib.h>
#include <string.h>
#include "def.h"

extern universe *U;

static bool done;
static str80 buf;

/*******************************************************/
/*     Routines to handle an interrupt from <Ctrl>-C   */
/*******************************************************/
jmp_buf cmdloopstate; /* to save state in case of a SIGINT */

void restart_from_ctrl_c() /* for a SIGINT, restart in cmdloop */
{
 signal( SIGINT, restart_from_ctrl_c );
 printf( "\n\nProgram interrupted : (M)ain menu , (Q)uit without saving: " );
 gets( buf );
 if( buf[0] == 'q' || buf[0] == 'Q' ) exit(0);
 longjmp( cmdloopstate, 1 );
}


void batch()
{
 if( U->nrClass == 0 )
 {
   printf("--- LOADING:\n");
   loadUniv();
   showUniv( stdout );
 }
 featSelectDEMO();
 showUniv( stdout );
 printf("--- ERROR ESTIMATION:\n");
 est_err_nearneib(); /**/
 printf("--- SAMMON PLOT:\n");
 sammon();
 printf("--- LEARNING WITH Q*:\n");
 learnQ();
}


void testing()
{
 int j, n, k, i, r;

 selectFeaturesSFS( 3 );
}

static bool banner_shown = FALSE;

void mainLoop()
{
 printf("\n>>>>>---------------------------------------------------<<<<<<\n");
 printf(">>>>>                                                   <<<<<<\n");
 printf(">>>>>                     TOOLDIAG                      <<<<<<\n");
 printf(">>>>>           Pattern recognition package             <<<<<<\n");
 if( ! banner_shown )
 { banner_shown = TRUE;
 printf(">>>>>       Copyright (C) 1992, 1993 Thomas W. Rauber   <<<<<<\n");
 printf(">>>>>              Universidade Nova de Lisboa &        <<<<<<\n");
 printf(">>>>>          UNINOVA - Intelligent Robotics Center    <<<<<<\n");
 printf(">>>>>                 E-Mail: tr@fct.unl.pt             <<<<<<\n");
 }
 printf(">>>>>                                                   <<<<<<\n");
 printf(">>>>>---------------------------------------------------<<<<<<\n");
 printf(" --- Type '?' followed by the menu choice for help ---\n");
 printf("(1) Load universe from directory or file\n");
 if( U->normalized )
   printf("--- Data is normalized to [0,1]\n");
 else
   printf("(2) Normalize data to [0,1]\n");
 printf("(3) Feature selection\n");
 printf("(4) Learning with Q* - algorithm\n");
 printf("(5) Error estimation\n");
 printf("(6) Identify from independent data\n");
 printf("(7) Sammon plot for classes\n");
 printf("(8) Statistical analysis\n");
 printf("(9) Interfacing to other systems\n");
 printf("(10) Batch demonstration\n");
 printf("(Q)uit\n\n");
 /* printf("(T)EST\n\n");	/**/
 printf("Choice: ");

 gets(buf); done = FALSE;
 switch( buf[0] )
 {
   case '?': help( LOOP_MAIN, buf ); break;
   case '1': 
     switch( buf[1] )
     {
       case '\0': 
         loadUniv(); showUniv( stdout ); break;
       case '0': 
         batch(); break;
     } break;
   case '2': normalize(); break;
   case '3': featSelectMain(); break;
   case '4': learnQ(); break;
   case '5': est_err_nearneib(); break;
   case '6': identify(); break;
   case '7': sammon(); break;
   case '8': statistics(); break;
   case '9': intface(); break;
   case 'q': case 'Q': done = TRUE; break;
   case 't': case 'T' : testing(); break;
   default: showUniv( stdout ); break;
 }
}


void main( argc, argv )
int argc;
char **argv;
{
 init_random_generator();
 init_admin();
 parse_input( argc, argv );
 do
 {
   signal( SIGINT, restart_from_ctrl_c );
   setjmp( cmdloopstate );
   mainLoop();
 }
 while( !done );
 free_universe();
}
