/*************************************************************************/
/***             Adapt these definitions to your system                ***/
/*************************************************************************/
/* In DOS uncomment the following line */
/* #define DOS		*/

/*---    Where to put the relevant data (selected features etc.)      ---*/
#ifdef DOS
#define DATA_DIR ".\\"
#else
/* #define DATA_DIR "/home/tr/ai/tooldiag/data/"	/**/
#define DATA_DIR "/usr/users/tr/ai/tooldiag/data/"	/**/
#endif /*else DOS*/


/*---    General allocation procedure of the program ---*/
extern void *malloc();	/**/
/* extern char *malloc();	/**/
/* use one of the two previous lines or substitute it by 
#include <malloc.h>
     or
#include <alloc.h>
if you have any problems */


/*---    Random number generation ---*/
/*
   Set the following macro if the machine has only the functions
   rand() and srand()
*/
/* #define ONLY_RAND    /**/


/*************************************************************************/
/*************** END OF USERS DEFINITIONS ********************************/
/*************************************************************************/

/*  The loop identifier for the help function  */
#define LOOP_MAIN 0
#define LOOP_FEATSELECT 1
#define LOOP_INTERFACE 2
#define LOOP_LVQ 3
#define LOOP_SNNS 4
#define LOOP_STATS 5

#define TRUE 1
#define FALSE 0

#define EMPTY (-1)

/* open, closed intervals */
#define LEFT_CLOSED__RIGHT_CLOSED 0
#define LEFT_CLOSED__RIGHT_OPEN 1
#define LEFT_OPEN__RIGHT_CLOSED 2
#define LEFT_OPEN__RIGHT_OPEN 3

#ifdef DOS
#define f_open_bin_w "wb"
#define f_open_bin_r "rb"
#define f_open_text_w "w"
#define f_open_text_r "r"
#else
#define f_open_bin_w "w"
#define f_open_bin_r "r"
#define f_open_text_w "w"
#define f_open_text_r "r"
#endif

#define NL  fprintf(stderr,"\n")
#define DBG  {char _str[1];fprintf(stderr,"...");gets(_str);}

#define FREE(ptr) if(ptr!=NULL){free(ptr);ptr=NULL;}
#define CHKPTR(ptr) if(ptr==NULL){fprintf(stderr,"Allocation problem with \
'ptr' - exitus...\n");exit(1);}

typedef char str20[21];
typedef char str30[31];
typedef char str50[51];
typedef char str80[81];
typedef char str100[101];
typedef int bool;
typedef unsigned char byte;

#define INFINITY (1000000000000.0)

#define MAXCLASS 100
#define MAXFEAT 1000

typedef float *FeatVector;

typedef struct feature_ {
          int rank;	/* selected as the ? best */
          float crit;	/* selection criterion */
        } feature, *FeatSelectVector;

typedef struct Class_ {
          str100 name;    /* name of the class */
          int numSampl;   /* how many samples for this class */
          FeatVector S;   /* all samples for this class */
          FeatVector mean, stddev, sqrsum;  /* mean and standard deviation */
          float a_priori_prob; /* a priori probability of the class */
        } Class,  *Classes;

typedef struct universe_ {
          str100 name;		/* name of the universe */
          int nrClass;		/* How many classes	*/
          int sumSampl;		/* The number of all samples of all classes */
          int nrFeat;		/* How many features are used	*/
          bool normalized;	/* Features in [0,1] ? */
          FeatVector min, max;	/* minimum and maximum values of features */
          int nrSelFeat;	/* How many selected features */
          FeatSelectVector FSV;	/* Pointer to selected features */
          Classes C;		/* Pointer to the classes */
        } universe;
