/************************************************************************
 *                                                                      *
 *  Program package "tooldiag":                                         *
 *                                                                      *
 *                                                                      *
 *  Version 1.3                                                         *
 *  Date: 15 November 1993                                              *
 *                                                                      *
 *  NOTE: This program package is copyrighted in the sense that it      *
 *  may be used for scientific purposes. The package as a whole, or     *
 *  parts thereof, cannot be included or used in any commercial         *
 *  application without written permission granted by the author.       *
 *  No programs contained in this package may be copied for commercial  *
 *  distribution.                                                       *
 *                                                                      *
 *  All comments  concerning this program package may be sent to the    *
 *  e-mail address 'tr@fct.unl.pt'.                                     *
 *                                                                      *
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "def.h"

extern universe *U;
extern bool feat_description;
extern char **feature_desc;

#define MIN_DISPLAY 20
static str80 buf;

static int maxFeat = MAXFEAT, *best = NULL;
static FeatVector CHEBYCHEV = NULL, sortedCHEBYCHEV = NULL;

void featSelectCHEBYCHEV()
{
 int i, j, k, a, b, nrSelectFeat, nrBest, maxIndex;
 bool ok;
 float pd, avgPd, mean1, stddev1, mean2, stddev2, quot, maxPd;

 CHEBYCHEV = (FeatVector) malloc(sizeof(FeatVector*) * U->nrFeat);
 sortedCHEBYCHEV = (FeatVector) malloc(sizeof(FeatVector*) * U->nrFeat);
 best = (int*) malloc(sizeof(int) * U->nrFeat);

 for( k = 0; k < U->nrFeat; k++ )
 {
   avgPd = 0.0;
   for( a = 0; a < U->nrClass-1; a++ )
   {
     for( b = a+1; b < U->nrClass; b++ )
     {
       mean1 = U->C[a].mean[k]; stddev1 = U->C[a].stddev[k]; 
       mean2 = U->C[b].mean[k]; stddev2 = U->C[b].stddev[k]; 
       if( mean1 == mean2 )
       {
         printf("For feature %d the two classes %d and %d", k, a, b );
         printf(" have the same mean %f\n", mean1 );
         printf("Setting the criterion to -INFINITY...\n");
         avgPd = -INFINITY;
       }
       else
       {
         quot = (stddev1 + stddev2) / ( mean1 - mean2 );
         avgPd += 1.0-quot*quot;
       }
       /* printf("d(%d,%d)=%f", a, b, 1-quot*quot ); DBG; /**/
     }
   }
   pd = 2.0*avgPd / (float)( U->nrClass * (U->nrClass-1) );
   CHEBYCHEV[k] = pd;
   printf("Selection criterion[%d] =\t%7.3f", k, pd );
   if( feat_description )
     printf("\tName: %s", feature_desc[k] );
   printf("\n");
 }
 /* sort the features following their quality */
 printf("Sorting..."); fflush( stdout );
 for( i = 0; i < U->nrFeat; i++ )
 {
   maxPd = -INFINITY;
   for( j = 0; j < U->nrFeat; j++ )
   {
     if( CHEBYCHEV[j] > maxPd )
     {
       maxPd =  CHEBYCHEV[j];
       maxIndex = j;
     }
   }
   sortedCHEBYCHEV[i] = maxPd;
   best[i] = maxIndex;
   CHEBYCHEV[maxIndex] = -INFINITY;
 }
 printf(" done.\n");

 if( U->nrFeat > MIN_DISPLAY )
 {
   printf("Want to see the best ? features (1-%d): ", U->nrFeat );
   do
   {
     get_d( &nrBest );
     ok = ( nrBest > 0 && nrBest <= U->nrFeat );
     if( ! ok )
       printf("Invalid value! Again ? ");
   }
   while( ! ok );
   for( k = 0; k < nrBest; k++ )
   {
     printf("Nr. %4d = %4d --- Criterion = %7.5f",
  	 k+1, best[k], sortedCHEBYCHEV[k] );
     if( feat_description )
       printf("\tName: %s", feature_desc[best[k]] );
     printf("\n");
   }
 }
 printf("Want to select the best ? features (1-%d): ", U->nrFeat );
 do
 {
   get_d( &nrSelectFeat );
   ok = ( nrSelectFeat > 0 && nrSelectFeat <= U->nrFeat );
   if( ! ok )
     printf("Invalid value! Again ? ");
 }
 while( ! ok );
 U->nrSelFeat = nrSelectFeat;
 FREE( U->FSV );
 U->FSV = (feature*) malloc( U->nrSelFeat * sizeof(struct feature_) );
 printf("\n--- SELECTED FEATURES --- : %d\n", nrSelectFeat);
 for( k = 0; k < U->nrSelFeat; k++ )
 {
   U->FSV[k].rank = best[k]; U->FSV[k].crit = sortedCHEBYCHEV[k];
   printf("Nr. %4d = %4d  --- Criterion = %7.5f",
	 k+1, U->FSV[k].rank, U->FSV[k].crit );
   if( feat_description )
     printf("\tName: %s", feature_desc[U->FSV[k].rank] );
   printf("\n");
 }
 FREE( CHEBYCHEV ); FREE( sortedCHEBYCHEV ); FREE( best );
 save_selected_feat();
}
