/*  $Id: rnsproc.h,v 1.5 1991/10/10 16:42:52 richard Exp richard $  */

/*  Part of RNS -- Recurrent Network Simulator
 *
 *     by R. Kooijman
 *        T.U. Delft
 *        Faculteit Elektrotechniek
 *        Vakgroep Computerarchitectuur
 *        Sectie Neurale Netwerken
 */


/*  $Log: rnsproc.h,v $
 * Revision 1.5  1991/10/10  16:42:52  richard
 * Switched to UNIX RCS
 * New random bit pattern support
 *
 * Revision 1.4  91/05/09  14:37:40  ROOT_DOS
 * Added nested include file protection
 * 
 * Revision 1.3  91/02/17  14:30:04  ROOT_DOS
 * Added comments
 *
 * Revision 1.2  91/02/05  01:26:41  ROOT_DOS
 * No changes; first check-in
 *
 * Revision 1.1  91/02/05  00:19:29  ROOT_DOS
 * Initial revision
 *   */



/*  procedure versie van RNS, zodat RNS in   */
/*  een ander programma gebruikt kan worden  */


#ifndef _RNSPROC_H
#define _RNSPROC_H


#include "rnsconf.h"


#ifdef DOUBLE            /*  als DOUBLE gedefinieerd is, moeten alle   */
#define FLOAT double     /*  FLOAT's double zijn, anders gewoon float  */
#else
#define FLOAT float
#endif


#define MAXOUTPUT       1    /*  maximale waarde van LOGISTIC neuron output  */
#define MINOUTPUT     (-1)   /*  minimale waarde van LOGISTIC neuron output  */
#define UNDEFINED       0    /*  neutrale waarde van LOGISTIC neuron output  */
#define MAXMINOUT       2    /*  MAXOUTPUT - MINOUTPUT  */
#define DONTCARE        3    /*  "don't care" waarde    */


/*  pointers die in RNSPROC door de gebruiker te zetten zijn  */
#ifdef USEPROTOS

extern FLOAT  (*errorfp)(FLOAT target, FLOAT output, void *erroropt);
extern void  *erroropt;

extern FLOAT  (*derrorfp)(FLOAT target, FLOAT output, void *derroropt);
extern void  *derroropt;

#else

extern FLOAT  (*errorfp)();
extern void  *erroropt;

extern FLOAT  (*derrorfp)();
extern void  *derroropt;

#endif



int rnsproc __((char *in, char *out, char *log, char *options));


#endif  /*  _RNSPROC_H  */

