/*  $Id: noturboc.h,v 1.8 1991/10/10 16:40:15 richard Exp richard $  */

/*  Part of RNS -- Recurrent Network Simulator
 *
 *     by R. Kooijman
 *        T.U. Delft
 *        Faculteit Elektrotechniek
 *        Vakgroep Computerarchitectuur
 *        Sectie Neurale Netwerken
 */


/*  $Log: noturboc.h,v $
 * Revision 1.8  1991/10/10  16:40:15  richard
 * Switched to UNIX RCS
 *
 * Revision 1.7  91/05/09  14:34:21  ROOT_DOS
 * Added nested include file protection
 * 
 * Revision 1.6  91/03/24  15:55:38  ROOT_DOS
 * Changed random number generator on UNIX to 'lrand()'
 *
 * Revision 1.5  91/02/26  21:48:22  ROOT_DOS
 * Added comments
 *
 * Revision 1.4  91/02/17  14:29:52  ROOT_DOS
 * Minor changes
 *
 * Revision 1.3  91/02/05  01:32:03  ROOT_DOS
 * Minor changes
 *
 * Revision 1.2  91/02/01  23:35:03  ROOT_DOS
 * Added labs() and difftime()
 *
 * Revision 1.1  91/01/30  21:42:40  ROOT_DOS
 * Initial revision
 *
 * Revision 1.2  91/01/28  22:19:05  ROOT_DOS
 * Minor changes
 *
 * Revision 1.1  91/01/28  22:01:29  ROOT_DOS
 * Initial revision
 *   */



/*  functies die Turbo C standaard heeft, maar andere compilers niet  */


#ifndef _NOTURBOC_H
#define _NOTURBOC_H      /*  beveilig tegen herhaalde '#include <noturboc.h>'  */


#include "rnsconf.h"


/*  lengtes van bestandsnaam onderdelen  */
#define MAXPATH      255
#define MAXDIR       255
#define MAXFILE       80
#define MAXEXT        80


/*  geef aan of bestandsnaam wildcards, extensie, naam of directory bevat  */
#define WILDCARDS   0x01
#define EXTENSION   0x02
#define FILENAME    0x04
#define DIRECTORY   0x08


/*  absolute waarde van een long, min en max functies  */
#ifndef SOLARIS
#define labs(a)         (((a) > 0) ? (a) : -(a))
#endif
#define max(a,b)        (((a) > (b)) ? (a) : (b))
#define min(a,b)        (((a) < (b)) ? (a) : (b))


/*  Turbo C's 'srand()' en 'random()' functie  */
#define Srand(seed)     srand48(seed)
#define Random(num)     (lrand48() % (num))


/*  Turbo C's 'getch()' is 'getchar()' zonder echo op het scherm  */
#define getch()         getchar()


#ifndef SOLARIS
/*  verschil tussen twee tijden  */
#define difftime(time1, time2)     ((double) ((time1)-(time2)))
#endif


/*  splits een bestandsnaam op in een directory, naam en extensie   */
int fnsplit __((const char *path, char *dir, char *name, char *ext));

/*  voeg een directory, naam en extensie samen in een bestandsnaam  */
void fnmerge __((char *path, const char *dir, const char *name, const char *ext));

/*  toets ingedrukt ?  */
int kbhit __((void));


#endif  /*  _NOTURBOC_H  */
