/*  $Id: noturboc.c,v 1.6 1991/10/10 16:43:48 richard Exp richard $  */

/*  Part of RNS -- Recurrent Network Simulator
 *
 *     by R. Kooijman
 *        T.U. Delft
 *        Faculteit Elektrotechniek
 *        Vakgroep Computerarchitectuur
 *        Sectie Neurale Netwerken
 */


/*  $Log: noturboc.c,v $
 * Revision 1.6  1991/10/10  16:43:48  richard
 * Switched to UNIX RCS
 *
 * Revision 1.5  91/02/26  21:48:00  ROOT_DOS
 * Added comments
 * 
 * Revision 1.4  91/02/17  14:29:46  ROOT_DOS
 * Minor changes
 *
 * Revision 1.3  91/02/01  23:25:28  ROOT_DOS
 * Fixed errors in fnsplit
 *
 * Revision 1.2  91/01/30  22:22:53  ROOT_DOS
 * Added <stddef.h> for NULL
 *
 * Revision 1.1  91/01/30  21:42:06  ROOT_DOS
 * Initial revision
 *
 * Revision 1.2  91/01/28  22:18:47  ROOT_DOS
 * Minor changes
 *
 * Revision 1.1  91/01/28  22:02:19  ROOT_DOS
 * Initial revision
 *   */



/*  functies die Turbo C standaard heeft, maar andere compilers niet  */


#include "noturboc.h"


#if defined(SUNOS) || defined(SOLARIS)
#include <stropts.h>
#endif
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stddef.h>



#ifdef USEPROTOS
int fnsplit(const char *path, char *dir, char *name, char *ext)
#else
int fnsplit(path, dir, name, ext)
       char *path;
       char *dir;
       char *name;
       char *ext;
#endif
{
int flags = 0;

int extindex, filindex;


   if (dir!=NULL)
      dir[0]='\0';                     /*  initialiseer dir   */

   if (name!=NULL)
      name[0]='\0';                    /*  initialiseer name  */

   if (ext!=NULL)
      ext[0]='\0';                     /*  initialiseer ext   */

   if (strspn(path, "*[]?")>0)
      flags|=WILDCARDS;                /*  wildcards in pad   */


   extindex=strlen(path);

   while (extindex>0 && path[extindex]!='.')
      extindex--;                      /*  extensie gaat t/m punt  */

   if (path[extindex]=='.')
   {                                   /*  als er een punt staat   */
      if (ext!=NULL)
      {                                /*  als ext ingevuld mag worden  */
         strcpy(ext, path+extindex);   /*  copieer extensie             */
         if (strlen(ext)>0)
            flags|=EXTENSION;          /*  geef extensie aan            */
      }
   }
   else
      extindex=strlen(path);           /*  begin overnieuw aan einde pad  */


   filindex=extindex;

   while (filindex>0 && path[filindex-1]!='/')
      filindex--;                      /*  basisnaam gaat tot slash  */

   if (name!=NULL)
   {                                   /*  als name ingevuld mag worden  */
      strncpy(name, path+filindex, extindex-filindex);
      name[extindex-filindex]='\0';    /*  copieer basisnaam             */
      if (strlen(name)>0)
         flags|=FILENAME;              /*  geef basisnaam aan            */
   }


   if (dir!=NULL)
   {                                   /*  als dir ingevuld mag worden  */
      strncpy(dir, path, filindex);    /*  copieer directory            */
      dir[filindex]='\0';
      if (strlen(dir)>0)
         flags|=DIRECTORY;             /*  geef directory aan           */
   }

   return(flags);
}


#ifdef USEPROTOS
void fnmerge(char *path, const char *dir, const char *name, const char *ext)
#else
void fnmerge(path, dir, name, ext)
        char *path;
        char *dir;
        char *name;
        char *ext;
#endif
{
   if (path!=NULL)
   {                            /*  als path ingevuld mag worden  */
      strcpy(path, dir);        /*  copieer directory             */
      strcat(path, name);       /*  voeg basisnaam eraan toe      */
      strcat(path, ext);        /*  voeg extensie eraan toe       */
   }
}


#ifdef USEPROTOS
int kbhit(void)
#else
int kbhit()
#endif
{
#if defined(SUNOS) || defined(SOLARIS)
struct strpeek peek;
 
   peek.ctlbuf.maxlen=0;
   peek.databuf.maxlen=0;
   peek.flags=0;
 
   return(ioctl(STDIN_FILENO, I_PEEK, &peek));
#endif
#ifdef LINUX
   if ((stdin)->_gptr <= (stdin)->_egptr)
      return 1;
   return 0;
#endif
}
