/*
 * graph.h
 *    header file which includes X11/X.h only. contains global declarations
 * of the Display, Window and GC.
 */


extern Display *netD; /* display that has a connection to the X server */
extern Window netW;   /* the window where the graphics pop up */
extern GC netGC;      /* the graphics context used in drawing images */
extern Colormap netC; /* the colormap used to allocate new colors */
extern Visual *netV;  /* not used (yet) */
extern GC xorgc;      /* a gc that inverts what it writes over */
extern XFontStruct *netF; /* the font in use for the program */


extern int rubberBand(/* Display * dpy, Window w, XRectangle * rt,
 int exit_button */);
   /* uses button pressing and dragging to visually show and set the size and
    * orientation of rt in w of connection dpy. If the exit_button is pressed
    * (any of Button1, Button2 or Button3), rubberBand returns 0, otherwise
    * 1. Upon exit, the x and y members of rt are set to the last mouse
    * location during the drag and the width and height members are set to the
    * size. */
extern int dragRectangle(/* Display * dpy, Window w, XRectangle * rt,
 int exit_button */);
   /* uses button pressing and dragging to visually show and set the
    * orientation of rt in w of connection dpy. If the exit_button is pressed
    * (any of Button1, Button2 or Button3), dragRectangle returns 0, otherwise
    * 1. The width and height should be preset. Upon exit, the x and y members
    * rt are set to the last mouse location during the drag. */
