/* $Header: /soma/users/miyata/planet/src/RCS/vector.h,v 5.6.0.4 91/02/13 15:42:31 miyata Exp $ */

/* this macro can be modified to define several functions one for each of
 * the different cases, thus making it more efficient. change find_operation
 * function (arith.c) too. -- problem is to have to decide between S and V,
 * and between V and M at run-time. this may not be necessary though*/

#define VectorOperation( func, OP, DECL ) \
func( vector1, vector2, vector, type ) \
VECTOR *vector1, *vector2, *vector; int *type; \
{ \
  int nval = vector->nvalue; \
  register REAL *val1 = vector1->value, *val2 = vector2->value; \
  register REAL *result; \
  register int i,j,ij;  \
  int n1 = vector1->nvalue; int n2 = vector2->nvalue; DECL;\
  if(n1==1 && n2>1) { \
    nval = vector->nvalue = n2;  \
    if( nval <= vector->nalloc ) vector->nvalue = nval; \
    else IfErr( alloc_vector( vector, nval )) return(ERR); \
    result =  vector->value+nval-1; val2 += nval-1; \
    for( i=nval; i; i--, val2--, result-- ) OP( *result,*val1,*val2 );\
    vector->nvalue1=vector2->nvalue1, vector->nvalue2=vector2->nvalue2; \
    return( OK ); \
  } else if(n2==1 && n1>1) {  \
    nval = vector->nvalue = n1; \
    if( nval <= vector->nalloc ) vector->nvalue = nval; \
    else IfErr( alloc_vector( vector, nval )) return(ERR); \
    result =  vector->value+nval-1; val1 += nval-1;\
    for( i=nval; i; i--, val1--, result-- ) OP( *result,*val1,*val2 );\
    vector->nvalue1=vector1->nvalue1, vector->nvalue2=vector1->nvalue2; \
    return( OK ); \
  } else if(vector1->nvalue1 && !vector2->nvalue1) { \
    nval = vector->nvalue = n1; \
    if( nval <= vector->nalloc ) vector->nvalue = nval; \
    else IfErr( alloc_vector( vector, nval )) return(ERR); \
    result =  vector->value+nval-1; val1 += nval-1; \
    for( ij=nval, j=vector1->nvalue1; j; j-- ) \
      for( i=vector2->nvalue, val2=vector2->value+i-1 ; \
	  i && ij ; i--, ij--, val1--,val2--,result-- ) \
	OP(*result, *val1, *val2); \
    vector->nvalue1=vector1->nvalue1, vector->nvalue2=vector1->nvalue2; \
    return( OK ); \
  } else if( !vector1->nvalue1 && vector2->nvalue1) { \
    nval = vector->nvalue = n2; \
    if( nval <= vector->nalloc ) vector->nvalue = nval; \
    else IfErr( alloc_vector( vector, nval )) return(ERR); \
    result =  vector->value+nval-1; val2 += nval-1;\
    for( ij=nval, j=vector2->nvalue1; j; j-- ) \
      for( i=vector1->nvalue, val1=vector1->value+i-1 ; \
	  i && ij ; i--, ij--, val1--,val2--,result-- ) \
	OP(*result, *val1, *val2); \
    vector->nvalue1=vector2->nvalue1, vector->nvalue2=vector2->nvalue2; \
    return( OK ); \
  } else if( vector1->nvalue2==1 && vector1->nvalue1==vector2->nvalue1) { \
    nval = vector->nvalue = n2; \
    if( nval > vector->nalloc && \
      Err( alloc_vector( vector, nval ))) return(ERR); \
    result =  vector->value+nval-1; val2 += nval-1; val1 += vector1->nvalue-1;\
    for( ij=nval, j=vector1->nvalue1; j; j--, val1-- ) \
      for( i=vector2->nvalue2 ; \
	  i && ij ; i--, ij--, val2--,result-- ) \
	OP(*result, *val1, *val2); \
    vector->nvalue1=vector2->nvalue1, vector->nvalue2=vector2->nvalue2; \
    return( OK ); \
  } else if( vector2->nvalue2==1 && vector1->nvalue1==vector2->nvalue1) { \
    nval = vector->nvalue = n1; \
    if( nval > vector->nalloc && \
      Err( alloc_vector( vector, nval ))) return(ERR); \
    result =  vector->value+nval-1; val1 += nval-1; val2 += vector2->nvalue-1;\
    for( ij=nval, j=vector2->nvalue1; j; j--, val2-- ) \
      for( i=vector1->nvalue2 ; \
	  i && ij ; i--, ij--, val1--,result-- ) \
	OP(*result, *val1, *val2); \
    vector->nvalue1=vector1->nvalue1, vector->nvalue2=vector1->nvalue2; \
    return( OK ); \
  } else {   \
    nval = vector->nvalue = n1>n2? n2:n1 ; \
    if( nval <= vector->nalloc ) vector->nvalue = nval; \
    else IfErr( alloc_vector( vector, nval )) return(ERR); \
    if( nval <= 0) Erreturn1("invalid range %d", nval); \
    result =  vector->value+nval-1; val1 += nval-1; val2 += nval-1;\
    for( i=nval; i; i--, val1--, val2--, result-- ) OP(*result,*val1,*val2);\
    vector->nvalue1=vector1->nvalue1, vector->nvalue2=vector1->nvalue2; \
    return( OK ); \
  } \
}
/* NOTE: should handle the case of Matrix[NxM] OP Matrix[1xM] etc.! */

#define Check( COND, MSG ) if( COND ) Erreturn(MSG)

#define UnaryVectorOperation( func, OP, DECL ) \
func( vector1, vector ) \
VECTOR *vector1, *vector; \
{ \
  register REAL *vec1 = vector1->value, *result = vector->value; \
  register int i, nval = vector->nvalue; DECL ; \
  for( i=0; i< nval; i++, vec1++, result++ ) OP(*result, *vec1); \
  return( OK ); \
}

#define UnaryVectorFunction( func, OP ) \
func( vector1, vector ) \
VECTOR *vector1, *vector; \
{ \
  register REAL *vec1 = vector1->value, *result = vector->value; \
  register int i, nval = vector->nvalue; \
  for(i=0; i< nval; i++, vec1++, result++ ) *result = (REAL) OP(*vec1);\
  vector->nvalue1=vector1->nvalue1, vector->nvalue2=vector1->nvalue2; \
  return( OK ); \
}
	/* look-up table implementation of vector function */
#define UnaryFunctionTable( func, OP, nTbl, min, max ) \
REAL func( x ) REAL x; \
{ \
  static	REAL tbl[ nTbl ], base, scale;\
  register int index; static int setup=0;\
  REAL y;\
  if( ! setup ) {\
    scale = ((REAL) nTbl -1) / (max - min) ;\
    for( index = 0; index < nTbl; index++ ) {\
      y = ((REAL) index/ scale ) + min ;\
      tbl[index] = OP( y );\
    }\
    setup = 1;\
  }\
  y = (REAL) ( x - min ) *  scale ;\
  index = (int) y ;\
  if( index >= nTbl -1 ) 	return( tbl[ nTbl -1 ] );\
  if( index < 0 ) 		return( tbl[ 0 ] );\
  return( tbl[index]\
	 + (y - (REAL) index) * (tbl[index+1] - tbl[index]));\
}

#define Vector2ScalorFunction( func, OP ) \
func( vector1, vector ) \
VECTOR *vector1, *vector; \
{ \
  register REAL *vec1 = vector1->value, *result = vector->value; \
  register int i, nval = vector->nvalue; \
  for(i=0; i< nval; i++, vec1++, result++ ) *result = (REAL) OP(*vec1);\
  return( OK ); \
}

#define TrueVal 1.0
#define FalseVal 0.0
#define RandomFunc 10

