/* $Header: /soma/users/miyata/planet/src/RCS/top.c,v 5.6.0.4 91/02/13 15:42:02 miyata Exp $ */
static char rcsid[] = "$Header: /soma/users/miyata/planet/src/RCS/top.c,v 5.6.0.4 91/02/13 15:42:02 miyata Exp $";
/***** UPDATES **********************************************************
top.c:
12/17/90 fixed main() to read in .netinit (changed from .sunnetinit) properly.
12/4/90  align_cwd() to keep track of user's cwd - no need to use 'chd'.
10/18/90 show only available choices in interrupt menu. added (h)elp.
7/2/90 fixed read_line() to increment line count only on reading '\n'.
3/10/90 use full pathname for ports.
2/21/90 fixed read_line() to read \; and \#.
12/7/89 implemented end_socket() to close and unlink port.
************************************************************************/
#include <stdio.h>
#include <signal.h>
#include <sys/param.h>
#include <strings.h>
#ifdef shellinput
#include <fcntl.h>	/* for setting up for receiving SIGURG */
#include <sgtty.h>

#ifndef ttyinput
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#endif ttyinput

#include <sys/stat.h>
#include "port.h"
#endif
#include "command.h"
#include "error.h"
#include "time.h"
#include "alloc.h"
#define AUX 1
#include "history.h"
#include "msg.h"
#ifdef hp
#define getwd(buf) getcwd(buf,sizeof(buf))
#endif

char	Msg[ MSGSIZE ];			/* used for user communication */
char	*MsgP=Msg, *MsgEnd = Msg+MSGSIZE;

#ifdef shellinput
void end_port();
#endif
void exec_csh();
void exec_rsh();
void finish();
void handle();
void add_prompt(), reset_prompt();
/* char pathname[MAXPATHLEN];*/

extern char	Quiet;			/* whether or not to print everything
					 * when reading from file */
extern char	Confirm;		/* whether or not to confirm before 
					 * exec'ing each command in file */
int	INTERRUPT = 0;			/* interrupt from the keyboard */
int	NOINTERRUPT = 0;		/* cannot interrupt if >0 */
unsigned inWhat = 0;			/* used to choose interrupt levels */
void	*onintr();			/* interrupt handling function */

void parse_command();

#ifdef shellinput
int Socket = 0;
char SocketName[128];
int CommandPort;
#endif

int    Nalias = 0;
void print_all_alias(), print_alias(), delete_alias();
void substitute_alias();
ALIAS *Alias[Malias];

void handle_quote();
#define HOME getenv("HOME")

#ifdef allie			/* AllieNet is linked by fortran */
cmain_( argc_p, argv )		/* called by main in fmain.f */
int *argc_p; char *argv[];
{
  int argc = *argc_p;
#else
main(argc, argv)
int argc; char *argv[];
{
#endif

#ifdef shellinput
  int   sock;
  char *getenv();
#endif
  initialize( argc, argv );
  exec_initfile();

#ifdef shellinput
  if( PORT ) strcpy( SocketName, PORT );
  else  sprintf( SocketName, "%s/%s", HOME? HOME:".", DefaultPort );
  Socket = open_socket( SocketName );
#ifdef ttyinput
  CommandPort = Socket;
#endif

/*if( SHELL ) {
    IF(SHELL, "/bin/csh") printf("Run 'source netcsh'.\n" );
    IF(SHELL, "/bin/ksh") printf("Run '. netkorn''.\n" );
  }*/
#endif

#ifdef shellinput
  while(1) interact_port();
#else
  while(1) interact();
#endif
}

exec_initfile()
{
  FILE *fp, *fopen();
  int status;
  if( fp = fopen( ".netinit", "r" ) ) {
    printf("reading .netinit.\n");
    while( EOF != (status = read_eval ( fp ) ) ) 
      IfErr( status ) fprintf( stderr, "%s: in .netinit.\n", ERR_MSG );
    fclose( fp );
  }
}

#ifdef ttyinput
static char line[] = {"/dev/ptypX"};
static int  pty_index=5;		/* better hit rate than 0 */
extern char **environ;

/*	get a pty line */

int
getapty()
   {
   register int i;
   int fd;

   line[5] = 'p';
   for(line[8]='p';line[8]<'r';line[8]+= 1)
      for (i=1;i<=16;i++) {
         line[9]="0123456789abcdef"[(pty_index+i)%16];
         if ((fd = open(line,2)) >= 0) {
            /* pty_index = (pty_index+i)%16;   temp */
            line[5] = 't';
            return(fd);
            }
         }
   return(-1);
   }
      
int getatty()
   {
   int fd;
   line[5]='t';
   fd=open(line,2);
   if (fd<0) {
      sleep(3);
      return (open(line,2));
      }
   return(fd);
   }

char *
last_tty()
   {
   return(line);
   }

open_socket( name )
char *name;
{
  struct stat buf;
  int pty;
  FILE *fopen(), *port_file;

  if( 0 == stat( name, &buf ) ) {
    printf("port %s in use. ", name); 
    if( confirm("override") ) unlink( name );
    else {
      printf("set environment NETPORT to any file name and run again.\n");
      exit(0);
    }
  }
  if( (pty = getapty())< 0) {
    printf("cannot open pty.\n");
    exit(0);
  }
  printf("Server port: %s\n", last_tty() );
  port_file = fopen( name, "w" );
  fprintf( port_file, "%s\n", last_tty() );
  fclose( port_file );

  return( pty );
}

#else
#ifdef shellinput
open_socket( name )
char *name;
{
  int sock;
  struct sockaddr_un server;
  struct stat buf;

  if( 0 == stat( name, &buf ) ) {
    printf("port %s in use. ", name); 
    if( confirm("override") ) unlink( name );
    else {
      printf("set environment NETPORT to any file name and run again.\n");
      exit(0);
    }
  }
  if( (sock = socket( AF_UNIX, SOCK_STREAM, 0) ) < 0 ) {
    perror("opening stream socket");
    exit(1);
  }
  server.sun_family = AF_UNIX;
  strcpy( server.sun_path, name );
  if( bind( sock, &server, strlen(server.sun_path)+2 ) ) {
    perror(server.sun_path);
    perror("binding stream socket");
    exit(1);
  }
  printf("command port: %s\n", server.sun_path );

  listen( sock, 10 );
  return( sock );
}

void end_socket()
{
  if(Socket) { close( Socket );  unlink( SocketName ); }
}

#endif
#endif

interact()
{
  int   status;
  FILE  *input_stream = stdin;

  signal( SIGINT, onintr );
  while( 1 ) {
    INTERRUPT = 0;
    status = read_eval( input_stream );
    if( Err( status ) && !INTERRUPT ) {
      sendMsg1( "\t%s\n", ERR_MSG );
    }
    else if( status == EOF ) {
      sendMsg( "Use 'quit' to quit the program.\n" );
      clearerr( input_stream ); 	/* get rid of EOF */
    }
    if( status == EXIT ) return( EXIT );
    else if( status == CONT ) return( CONT );
    *ERR_MSG = NULL; inWhat = 0;
#if xnet
    clearButton();	/* clear interrupt button click events */
#endif
  }
}

#ifdef shellinput
interact_port()
{
  int   status;
  FILE  *input_stream = stdin;

  signal( SIGINT, onintr );
  while( 1 ) {
    INTERRUPT = 0;
	/* BUG: infinite loop when port is broken */
    status = read_eval_port( Socket );
    if( status == EXIT ) return( EXIT );
    else if( status == CONT ) return( CONT );
    *ERR_MSG = NULL; inWhat = 0; 
#if xnet
    clearButton();	/* clear interrupt button click events */
#endif
  }
}

#define CLOSED (-1)

read_eval_port( sock )
int	sock;	/* command is read from this socket */
{
  char    command[Lcomm], args[Nargs][Largs];	/* command and arguments */
  int     argn;					/* # of arguments	 */
  char    command_line[MSGSIZE];
  int	  status, rval;
  void	  error_port();

#ifndef ttyinput
  CommandPort = CLOSED;
  while( CommandPort == CLOSED ) CommandPort = accept(sock, 0, 0);
#endif

  signal( SIGPIPE, error_port );
#if 0	/* OOB data handling - hasn't been tested (see PS1:8-24) */
  signal( SIGURG, oob );
  if( fcntl(CommandPort, F_SETOWN, getpid()) < 0 ) {
    close(CommandPort); CommandPort=CLOSED; Erreturn("cannot set SETOWN");
  }
  if( fcntl(CommandPort, F_SETFL, FASYNC) < 0 ) {
    close(CommandPort); CommandPort=CLOSED; Erreturn("F_SETFL,FASYNC");
  }
#endif 0
/*  bzero( command_line, ); causes illegal inst?? */

  IfErr( read_port( command_line, sizeof(command_line) ) ) {
    close(CommandPort); CommandPort=CLOSED; Erreturn("cannot read command");
  }

  sendMsg1( pidFmt, getpid() );
  if( Confirm == ON ) {
    IfErr( confirm( command_line ) ) return( OK );;
  }
  substitute_alias( command_line, Alias );
  parse_command( command_line, command, &argn, args );

  if( Err( status = eval_command( command, argn, args )) && !INTERRUPT ) {
    sendMsg1( "\t%s\n", ERR_MSG );
  }
/*  this is ok - c_step may return EOF.
  else if( status == EOF ) sendMsg( "Use 'quit' to quit the program.\n" );
*/
  end_port(status);
  return( status );
}

void error_port()
{
  close(CommandPort); CommandPort=CLOSED;
  fprintf( stderr, "command port broken.\n" );
}

void end_port(status)
int status;
{
  if( CommandPort == CLOSED ) return;
  IfErr( write_port( strcpy(Msg, status? EndComm:ErrComm), sizeof(Msg)) )
    puts("server: couldn't end port.");
  close( CommandPort );  CommandPort=CLOSED;
}

/* write_port() and read_port() allow interaction with the user while in 
 * a command */
write_port( str, size )
char *str; unsigned size;
{
  if( write(CommandPort, str, size ) < 0) Erreturn("couldn't write to port");
  return(OK);
}

read_port( str, size )
char *str; unsigned size;
{
  if( read(CommandPort, str, size ) < 0 ) Erreturn("couldn't read from port");
  return( OK );
}

/* gets_port() sends a request to port and gets an input from it */

gets_port( str, size )
char *str; unsigned size;
{
  char buf[MSGSIZE];	/* cannot use Msg if str == Msg */
  IfErr(write_port( strcpy(buf, InputRequest), sizeof(buf))) return(ERR);
  IfErr(read_port( str, size )) return(ERR);
  IF( str, EndComm ) return(EOF);
  return(OK);
}

read_eval ( command_stream )
FILE	*command_stream; /* command is read from here: stdin means the port */
{
  char    command[Lcomm], args[Nargs][Largs];	/* command and arguments */
  char    command_line[BUFSIZE];
  int     argn;					/* # of arguments	 */
  int	status;

  if( command_stream == stdin ) sendMsg( get_prompt() );
#ifdef shellinput
  if( command_stream == stdin )
    status = gets_port( command_line, MSGSIZE );
  else
#endif shellinput
    status = read_line( command_line, BUFSIZE, command_stream );
  if( status == EOF || status == ERR ) return( status );
	/* otherwise status = no. of lines read */

  if( command_stream != stdin && Confirm == ON ) {
    IfErr( confirm( command_line ) ) return( status );
  }
  substitute_alias( command_line, Alias );

  parse_command( command_line, command, &argn, args );
  return( eval_command( command, argn, args ));
}

#else
/* read_eval reads a line from CommandStream by calling read_line.
 * A line consists of a command and arguments which are evaluated and executed 
 * by calling eval_command. 
 * If command is "source" CommandStream is changed to a file specified by first
 * argument and read_eval is called recursively - command lines are 
 * subsequently read in from this file by the second read_eval. Upon reading
 * EOF read_command called by the second read_eval returns EOF which causes
 * the second read_eval to return EOF to the first read_eval. It causes the 
 * first read_eval to stop calling the second and to return OK which tells the 
 * caller that it finished reading commands from the file.  This process can
 * be repeated recursively for as many levels as needed so that a source file 
 * may contain a source command.	*/

read_eval ( command_stream )
FILE	*command_stream;	/* command is read from here: stdin or a file */
{
  char    command[Lcomm], args[Nargs][Largs];	/* command and arguments */
  char    command_line[BUFSIZE], *line, *next_line;
  int     argn;					/* # of arguments	 */
  int	status;

  if( command_stream == stdin ) printf( get_prompt() );
  status = read_line( command_line, BUFSIZE, command_stream );
  if( status == EOF || status == ERR ) return( status );
	/* otherwise status = no. of lines read */

  for( line = command_line; line ; line = next_line ) {
    if( command_stream != stdin && Confirm == ON )
      IfErr( confirm( line )) return( status );
    substitute_alias( line, Alias );
    handle_quote(line, &next_line);
    parse_command( line, command, &argn, args );
    if( OK != (status = eval_command( command, argn, args )) || INTERRUPT ) 
      return(status);
  }
  return( OK );
}

#endif

/* eval_command evaluates a command line and executes it */

eval_command ( command, argn, args  )
char	*command, args[][Largs];
int	argn;
{
  COMMAND *commandP ;
  FILE	*fp;
  int   status;
  int	n, repeat = 1;			/* # of times command is repeated */
  int	time;
  register int i;
  char	buf[BUFSIZE],*getenv();

  IF ( command, "" ) return ( OK );

  else IF( command, "exit" ) return( EXIT );	/* exit after interrupt */
  else IF( command, "cont" ) return( CONT );	/* continue after interrupt */

  for( i=0; i< argn; i++ ) substitute_parameter_string( args[i] );

/*
.CO "time" "print execution time of command" TOP-COMMAND
.SY "time <command> [arguments ...]"
.BB
Executes <command> with given arguments and print time (msec) spent.
This is elapsed time, not cpu time.
.EE
*/
  IF( command, "time" ) {
    tstart();
    if( Err(eval_command( args[0], argn-1, args[1])) || INTERRUPT) return(ERR);
    msec( time ); 
    sendMsg1("%d msec\n", time);
    return(OK);
  }
/*
.CO "repeat" "repeat a command"		TOP-COMAND
.SY "repeat N <command> [arguments ...]"
.BB
Repeats <command> N times, with given arguments.
.EE
*/
  IF( command, "repeat" ) {
    if( argn < 2 || sscanf( args[0], "%d", &n ) !=1 || n < 1 )
      Erreturn( get_syntax ("repeat") );
    repeat = n;
    while( repeat-- ) {
      if(Err(eval_command( args[1], argn-2, args[2])) ||INTERRUPT) return(ERR);
    }
    return(OK);
  }
/***
.CO "quit" "quit SunNet"	TOP-COMMAND
.SY quit
.BB
quit \fBSunNet\fP.
.EE
***/
  else IF( command, "quit" ) finish( 0 );

/*
.CO "source" "read commands from file"	TOP-COMMAND
.SY "source <file>"
.BB
Reads in commands from <file>. \fBSource\fP can be nested, i.e.
included as a command in a sourced file.  If the system is configured
to receive commands from csh (C-shell), then \fBsource\fP is equivalent to
the source command in csh.  For ksh (Korn shell) use ". <file>".
.EE
 * this is done by setting command_stream to the file pointer 	*
 * and calling read_eval recursively.				*/

  else IF( command, "source" ) {
    if( argn<1 ) Erreturn( "syntax: source file");
    IfErr( fp = fopen(args[0], "r") ) 
      Erreturn1("Cannot open file %s", args[0] );
    
    Starting(inFile);
    for( i=1; (status = read_eval ( fp )) != EOF; i += status ) {
      IfErr( status ) {
	    /* ERR status means error or interrupt at lower level.  */
	    /* return ERR to keep caller from */
	    /*		calling again      */
	Ending(inFile);
	Erreturn3("%s: in %s at line %d",ERR_MSG, args[0], i);
      }
      if( INTERRUPT == INTR_FILE ) {
	sendMsg2("interrupt in %s at line %d.\n", args[0], i );
	if( DoInterrupt(args[0]) == EXIT ) {
	  Ending(inFile);
	  Erreturn1("exit from source %s", args[0] );
	}
      }
    }
    fclose ( fp );
    Ending(inFile);
    return ( OK );			/* finished reading file */
  }

  else if ( commandP = which_command ( command ) )  {
    return ( (*commandP->func) ( argn, args ) );
  }
/***
.CO "help" "print help information"	TOP-COMMAND
.SY "help <command> / help"
.BI
\fBhelp <command>\fP prints an explanation of command.  
.NI
\fBhelp\fP prints a list of all command names.
.EE
***/
  else IF( command, "help" ) {
    if( argn < 1 ) help( "list_names" );
    else help( args[0] );
    return(OK);
  }

/*** 	(whatis and set are defined in sunnet.c) ***/

/*
.CO "alias" "define alias"	TOP-COMMAND
.SY "alias <name> <substitute> / alias"
.BB
Defines a command level alias.  <Substitute> can contain several commands
separated by ;'s, and enclosed between a pair of "'".  Without arguments,
prints a list of currently defined aliases.  Disabled if commands are
received from a shell (use shell aliases instead.)
.EE
*/
  else IF(command, "alias" ) {
    if( argn < 1 ) print_all_alias();
    else if( argn == 1 ) print_alias( args[0] );
    else {
      for( i=1, *buf=NULL ; i<argn; i++ ) sprintf(buf, "%s %s", buf, args[i] );
      make_alias( args[0], buf );
    }
    return(OK);
  }
/*
.CO "unalias" "delete alias"		TOP-COMMAND
.SY "unalias <name>"
.BB
Deletes a command level alias.
.EE
*/
  else IF(command, "unalias" ) { delete_alias( args[0] );return(OK); }
/*
.CO "!" "execute a shell command" TOP-COMMAND
.SY "!<shell command> [argument ...]"
.BB
Executes a shell command via \fIcsh\fP.  Disabled if commands are
received from a shell.
.EE
*/
  else if( command[0]== '!' ) {
#ifdef planet
    if( command[1] == '!' ) exec_rsh( command+2, argn, args );
    else
#endif
    exec_csh( command+1, argn, args );
    return( OK );
  }
/*
.CO "cd" "change working directory" TOP-COMMAND
.SY "cd <directory> / chd <directory>"
.BB
Changes the current working directory to <directory>.  If the system
is configured to receive commands from a shell, use \fBchd\fP instead of
\fBcd\fP.
.EE
*/
  else IF( command, "cd" ) {
    if( argn < 1 ) Erreturn( get_syntax( "cd" ) );
    IfErr( !chdir( args[0] ) ) 
      Erreturn1("cannot change directory to %s", args[0]);
    exec_initfile();
    return(OK);
  }
/*
.CO "pwd" "print working directory" TOP-COMMAND
.SY "pwd"
.BB
Prints the current working directory pathname.
.EE
*/
  else IF( command, "pwd" ) {
    sendMsg1( "%s\n", getwd(buf) );
    return(OK);
  }
  else IF( command, "printenv") {
    if( argn<1 ) Erreturn("syntax: printenv <environment>");
    IfErr( getUserEnv(args[0], buf) ) return(ERR);
    sendMsg1( "%s\n",  buf );
  }
  else IF( command, "pid" ) {
    sendMsg1( "%d\n", getpid() );
  }
  else Erreturn1("%s: command not found", command );
  return( OK );
}

align_pwd()
{
#if shellinput
  char pwd[128];
  if( Socket <= 0 ) return(OK);
  IfErr( getUserEnv("PWD", pwd) ) return(ERR);
  IfErr( !chdir( pwd ) ) Erreturn1("cannot change directory to %s", pwd);
/*exec_initfile(); this can cause infinite loop */
#endif
  return(OK);
}

#if shellinput
getUserEnv( env, str )
char *env, *str;
{
  sprintf(Msg,EnvRequest,env);
  IfErr(write_port(  Msg,  sizeof(Msg))) return(ERR);
  IfErr(read_port( Msg, sizeof(Msg) )) return(ERR);
  strcpy( str, Msg );
  return(OK);
}
#endif

void exec_csh ( command, argn, args )
char	*command, args[][Largs]; int argn;
{
  register int	n;
  char    buffer[ BUFSIZE ] ;
  sprintf ( buffer, "csh -c '%s", command );
  for( n=0; n<argn; n++ ) {
    sprintf( buffer, "%s %s", buffer, args[n] );
  }
  sprintf( buffer, "%s'", buffer );
  system ( buffer );
}

read_command( stream, command, argn, args, prompt, alias )
FILE *stream; int  *argn; char *command, args[][Largs], *prompt;
ALIAS *alias[];
{
  register int i;
  int  status;
  char commandline[ BUFSIZE ]; 

  *command = NULL;
  for( i=0; i< Nargs; i++ ) *args[i] = NULL;
  if( stream == stdin && prompt ) printf( prompt );
  status = read_line( commandline, BUFSIZE, stream );
  if( status == EOF || status == ERR ) return( status );

  if( stream != stdin && Quiet == OFF ) printf( "%s\n", commandline );

  if(alias) substitute_alias( commandline, alias );

  parse_command( commandline, command, &argn, args );
  return( status ); 	/* this is no. of lines read */
}

char commandFmt[ Lcomm+3+(Largs+3)*Nargs+1 ];

void parse_command( command_line, command, argn, args )
int  *argn; char *command_line, *command, args[][Largs];
{
  *command = NULL;
  *argn = sscanf(command_line, commandFmt,
	command, args[0], args[1], args[2], args[3], args[4], args[5], args[6],
	args[7], args[8], args[9], args[10], args[11], args[12], args[13],
	args[14], args[15], args[16], args[17], args[18], args[19], args[20], 
	args[21], args[22], args[23], args[24], args[25], args[26],
	args[27], args[28], args[29], args[30], args[31]) -1 ;
  return;
}

void make_commandFmt()
{
  register int i;
  char buf[Largs+4];
  sprintf(commandFmt, "%%%ds", Lcomm);
  sprintf(buf, " %%%ds", Largs);
  for(i=Nargs;i;i--) strcat(commandFmt, buf);
}

/* read_line() reads in from a stream into buffer up to a ';' or a '\n' 
 * not following '\\' .  Return value: (no. of lines read + 1) */
 
read_line( buffer, bufsize, stream )
char *buffer; int bufsize; FILE *stream;
{
  int nchar=0, lines=1;
  char ch; int escape = 0;
  while( nchar < bufsize ) {
    if( (ch = getc( stream )) == '\n' ) {
      lines++;
      if( escape ) {
	 	 /* newline following '\' -> read next line */
	buffer--;	 /* throw away '\' */
	nchar--;
	escape = 0;
	continue;	 /* ignore newline */
      }
      break;		/* unescaped newline -> stop reading */
    }
#ifdef shellinput		/* normally handled in read_eval */
    if( ch == ';' ) {
      if( escape ) {
	buffer--;
	*(buffer++) = ch;	 /* throw away '\' and read this */
	escape = 0;
	continue;
      }
      break;	/* ';' -> stop reading */
    }
#endif 
    if( ch == EOF ) {		/* return EOF if nothing has been read yet */
      if( nchar == 0 ) return( EOF );
      break;			/* otherwise stop here */
    }
    if( ch == '#' ) { 
      if( escape ) {
	buffer--;
	*(buffer++) = ch;	 /* throw away '\' and read this */
	escape = 0;
	continue;
      }		/* comment -> stop and throw away the rest of the line */
      while( '\n' != (ch=getc( stream )) && ch != EOF ) ;
      lines++;
      break;
    }
    escape = 0;
    if( ch == '\\' ) escape = 1;
    *(buffer++) = ch;
    nchar++;
  }
  if( nchar == bufsize ) Erreturn("line too long");
  *buffer = NULL;
  return( lines );
}

void finish( n ) int	n; {
#ifdef shellinput
  if( Socket > 0 ) {
    end_port(n);
    end_socket();
  }
#endif
  printf( "Quitting - \n" );
  terminate ();
  exit( n );
}

void handle( flag ) int flag; {
    fprintf( stderr, "%s.\n",  ERR_MSG ); 
    finish( 1 ); }

DoInterrupt( str )
char *str;
{
  int status; unsigned inWhatSave = inWhat;
  add_prompt(str);
#if shellinput
/*  status = interact_port();*/
  status = interact();
#else
  status = interact();
#endif
  reset_prompt();
  inWhat = inWhatSave;
  return( status );
}

#if 0
	/* Out-of-band data handling. this hasn't been tested. */
void *oob()
{
  char buf[BUFSIZE],mark;
  puts("receiving OOB MSG");
  for(;;) {
    if(ioctl( CommandPort, SIOCATMARK, &mark )<0) {
      puts("couldn't read port (oob mark)");
      break;
    }
    if( mark ) break;
    (void) read( CommandPort, buf, sizeof(buf) );
  }
  if( recv( CommandPort, &mark, 1, MSG_OOB ) < 0 ) {
    puts("couldn't read port (oob mark)");
    return;
  }
  onintr();
}
#endif 0
/**
.HE "interrupt" "interrupt" INTR-HELP
.BB
You can interrupt a command by hitting the interrupt key (e.g., Ctrl-C),
or in XNet by clicking the small square at the top-left corner.
You will be asked to choose the level of interruption among the choises 
described below.  When you interrupt a command, the execution of the command 
is temporarily suspended and you can execute any other commands.  You can
then resume the execution of the interrupted command by typing \fBcont\fP, or
terminate it by typing \fBexit\fP.  The commands you execute while interrupting
a command can in turn be interrupted.  The choises for interruption levels are:
.BI
(f)ile: when you are reading a file by the command \fBsource, network\fP,
etc., this means to stop before reading the next line in the file.
.NI
(c)ycle: this stops the command \fBcycle\fP before the next step.
.NI
(l)ist: this stops execution of display list, print list, graph list, or plot
list before the next list item.
.NI
(p)attern: this stops the command \fBcycle, present\fP or \fBresponse\fP before
presenting the next pattern.
.NI
(a)ction: this stops the command \fBcycle, present, response\fP or \fBexec\fP
before executing the next action in the current procedure.  You will enter the
\fBdebug mode\fP.  Type \fBhelp debug\fP for details. ~H
\fBdebug mode\fP.  See help for \fBdebug\fP for details. ~R
.NI
(e)mergency: this stops any command immediately.
.NI
(n)o interrupt: continue execution without interrupting it.
.NI
(h)help: this prints brief descriptions of the choises.
.NI
When the command is executed from a shell, an interrupt is sent to the
main program (eg. SunNet) only when the command prints out something.
If you cannot wait for that, click the interrupt button in XNet.  In
SunNet or StarNet, you have to do (1) suspend the command (hit Ctrl-Z);
(2) interrupt the main program directly with 'kill -INT'; and (3) resume
the command (type 'fg'). 
.EE
**/

void *onintr () 
{ 
  char menu[BUFSIZE], input[BUFSIZE];
  INTERRUPT = 0;
  *ERR_MSG = NULL;
  strcpy( menu, "Where to interrupt?\n");
  if( inWhat&inFile ) strcat(menu,"(f)ile ");
  if( inWhat&inCycle ) strcat(menu,"(c)ycle ");
  if( inWhat&inList ) strcat(menu,"(l)ist ");
  if( inWhat&inPattern ) strcat(menu,"(p)attern ");
  if( inWhat&inProc ) strcat(menu,"(a)ction ");
  strcat( menu, "(e)mergency (n)o interrupt (h)elp: ");
/*strcpy( menu, "Interrupt Level?\n(f)ile (c)ycle (l)ist (p)attern (a)ction (e)mergency (n)o interrupt : ");*/
  while( 1 ) {
    askUserInput( menu, sizeof(menu), input, sizeof(input) );
    if( !strlen(input) ) { INTERRUPT = INTR_ACT; return; }
    switch(input[0]) {
    case 'f': 
      if( inWhat&inFile ) { INTERRUPT = INTR_FILE; return; }
      sendMsg("Not in a file..\n"); continue;
    case 'c':
      if( inWhat&inCycle ) { INTERRUPT = INTR_CYC; return; }
      sendMsg("Not in cycle..\n"); continue;
    case 'p':
      if( inWhat&inPattern ) { INTERRUPT = INTR_PAT; return; }
      sendMsg("Not in patterns..\n"); continue;
    case 'a':
      if( inWhat&inProc ) { INTERRUPT = INTR_ACT; return; }
      sendMsg("Not in procedure..\n"); continue;
    case 'l':
      if( inWhat&inList ) { INTERRUPT = INTR_LIST; return; }
      sendMsg("Not in list..\n"); continue;
    case 'n':	 return;		/* no interrupt */
    case 'e': 	 	/* emergency -> return to top-level */
      if( NOINTERRUPT ) {
	sendMsg("Cannot interrupt now. Please wait and try again.\n");
	return;
      }
      if( DoInterrupt("emergency") == CONT ) return; /* continue this command*/
				/* otherwise finish this command */
      sendMsg("exit from emergency interrupt");
      sigsetmask( sigblock(0) & ~2 ); /*unblock SIGINT (turn off 2nd bit)*/
#ifdef shellinput
      end_port(ERR);		/* finished with this command */
      while(1) interact_port();
#else
      while(1) interact();
#endif
    case 'h':	/* help */
      sendMsg("Type one of the characters in () and 'return'.\n");
      if( inWhat&inFile ) 
	sendMsg("(f)ile: stop before reading the next line in the file.\n");
      if( inWhat&inCycle ) 
	sendMsg("(c)ycle: stop the command cycle before the next step.\n");
      if( inWhat&inList ) 
	sendMsg("(l)ist: stop execution of display list, print list, graph list, or plot list\nbefore the next list item.\n");
      if( inWhat&inPattern ) 
	sendMsg("(p)attern: stop the command before presenting the next pattern.\n");
      if( inWhat&inProc ) 
	sendMsg("(a)ction: stop the current procedure before the next action.\n");
      sendMsg("(e)mergency: stop any command immediately.\n");
      sendMsg("(n)o interrupt: continue execution without interrupting it.\n\n");
    }
  }
}

COMMAND *
which_command ( name )
char	*name;
{
  register int i;
   	/* BUG - put the name back when I change it */
  IF( name, "set" ) strcpy( name, "nset" );
  for ( i=0; i< Ncommand ; i++ )
    IF ( name, Command[i].name ) return ( Command[i].func? &Command[i] : ERR );
  return ( ERR );
}

getUserInput( buf, size )
char *buf; unsigned size;
{
#ifdef shellinput
  if( CommandPort > 0 ) return( gets_port( buf, size ) );
#endif
  if( fgets( buf, size, stdin )) return( OK );
  return( EOF );
}

sendUserOutput( str, size )
char *str; unsigned size;
{
#ifdef shellinput
  if( CommandPort > 0 ) return( write_port( str, size ) );
#endif
  printf( str ); fflush( stdout ); return( OK );
}

askUserInput( msg, msgsize, str, strsize )
char *msg, *str; unsigned msgsize, strsize;
{
#ifdef shellinput
  if( CommandPort > 0 ) {
    IfErr( write_port( msg, msgsize )) return(ERR);
    return( gets_port( str, strsize ));
  }
#endif
  printf( str ); fflush( stdout );
  if( fgets( str, strsize, stdin )) return(OK);
  return(  EOF );
}

confirm( msg )
char *msg;
{
#ifdef demo
  printf( "%s? [y/n] ", msg );  fflush( stdout );
  await_any_button();
  puts(""); return( OK );
#else
  int status, i;
  sendMsg1( "%s? [y/n] ", msg );
  /* this line causes xfc1 to crash on allie. */
  /* while( getUserInput( Msg, sizeof(Msg))) {  */
  for(i=10;i;i--) {
    IfErr( status = getUserInput( Msg, sizeof(Msg))) return( ERR );
    IfEOF( status ) return( ERR );/* assume 'no' */
    if( Msg[0] == 'n' ) return( ERR );
    if( Msg[0] == 'y' ) return( OK );
    sendMsg( "please type 'yes' or 'no' ");
  }
  sendMsg( "giving up.. assuming 'no'" );
  return( ERR );
#endif
}

make_alias( str1, str2 )
char *str1, *str2;
{
  register int n;
  ALIAS *alias;
  for( n=0; n < Nalias; n++ )
    IF( str1, Alias[n]->name ) break;
  if( n < Nalias ) alias = Alias[n];
  else {
    if(Nalias>=Malias) Erreturn1("sorry, no more than %d aliases", Malias);
    IfErr( Alias[Nalias] ) Alias[Nalias] = new(ALIAS) ;
    alias = Alias[Nalias];
    Nalias++;
  }
  alias->name = new_string( str1, alias->name );
  alias->substitute = new_string( str2, alias->substitute );
  alias->leng = strlen(str1);
  return( OK );
}

void print_all_alias()
{
  register int n;
  for( n = 0 ; n < Nalias; n++ ) 
    printf( "%s\t%s\n", Alias[n]->name, Alias[n]->substitute );
}

void print_alias( name )
char *name;
{
  register int n;
  for( n = 0 ; n < Nalias; n++ ) 
    IF(Alias[n]->name, name) {
      puts( Alias[n]->substitute );
      return;
    }
}

void delete_alias( name )
{
  register int n;
  ALIAS *tmp;
  if( strlen(name) == 0 ) return;
  for( n=0; n < Nalias; n++ )
    IF( name, Alias[n]->name ) {
      tmp = Alias[n];
      break;
    }
  if( n < Nalias ) {
    for( ; n < Nalias-1; n++ ) Alias[n] = Alias[n+1];
    Nalias-- ;
    Alias[Nalias] = tmp;	/* keep this allocated space for next alias */
  }
}

void substitute_alias( string, alias )
char *string;
ALIAS *alias[];
{
  register int i;
  int  leng, changed;
  char word[128], *end, *index();
  for( changed=1 ; changed; ) {
    if( Err(string) || 0 == strlen( string ) ) return;
    while( *string == ' '||*string == '\t' ) string++; /* trim leading whites*/
    IfErr(sscanf( string, "%s", word )) return;
    if( end = index( word, ';' ) ) *end = '\0';
    leng = strlen( word );
    for( i=0, changed=0; i < Nalias; i++ ) {
      if( leng == alias[i]->leng ) IF( word, alias[i]->name ) {
	replace_string( string, alias[i]->substitute, leng ); 
	sscanf( string, "%s", word );  leng = strlen( word );
        changed = 1;
      }
    }
  }
}

#ifdef shellinput
void
handle_quote(line, next_line) 
char *line,**next_line;
{ *next_line = NULL; }

#else
void
handle_quote(separated_command, separater_p)
char                separated_command[];
char                **separater_p;
{
  char                *index(),*search_quote();
  
  if ( *separater_p = index(separated_command, ';') ) {
    if ( in_quote(separated_command, *separater_p) ) {
      *(*separater_p = search_quote(separated_command, *separater_p)) = NULL;
      (*separater_p)++;
    } else {
      *((*separater_p)++) = NULL;
    }
  } else  {
    *separater_p == NULL;
  }
}

in_quote(command_buffer, point)
char                *command_buffer;
char                *point;
{
  char                *index();
  char                *quote;

  if ( (quote = index(command_buffer, '\'')) && quote < point ) {
    if ( index(point + 1, '\'') ) {
      return( OK );
    }
  }
  return( ERR );
}
void
store_history(str)
        char                *str;
{
        register int        i,j;

        while ( *str == ' ' || *str == '\t' ) ++str;
        if ( *str == '\0' ) return;
	if ( current_history_number >= HISLEVEL ){
	  for ( i = current_history_number ; i >= HISLEVEL; --i ) 
	    for ( j = 1 ; j < i ; ++j ) {
	      strcpy(History[j-1].value, History[j].value);
	      History[j-1].level = History[j].level;
	    }
	  strcpy(History[HISLEVEL-1].value, str);
	  History[HISLEVEL-1].level = ++current_level;
	  current_history_number = HISLEVEL;
	} else {
	  strcpy(History[current_history_number].value, str);
	  History[current_history_number].level = ++current_level;
	  ++current_history_number; 
	}
}

delete_quote(stream, command_buffer)
char                *command_buffer;
FILE                *stream;
{
  char                *index(), *quote1, *quote2;
  IF( command_buffer, "" ) return(OK);
  IfErr( quote1 = index(command_buffer, '\'') ) {
    if( stream == stdin ) store_history( command_buffer );
    return( OK );
  } else IfErr( quote2 = index( quote1+1, '\'') ) {
    Erreturn( "mismatch ' " );
  } else {
    if( stream == stdin ) store_history( command_buffer );
    *quote1 = *quote2 = ' ';
    return( OK );
  }
}
char *
search_quote(command_buffer, point)
        char                *command_buffer;
        char                *point;
{
        char                *index();

        char                *last_quote;
        
        *index(command_buffer, '\'') = ' ';
        *(last_quote = index(point, '\'')) = ' ';
        return( last_quote );
} 
#endif shellinput
