/* $Header: /soma/users/miyata/planet/src/RCS/sunnetparam.c,v 5.6.0.4 91/02/13 15:42:01 miyata Exp $ */
static char rcsid[] = "$Header: /soma/users/miyata/planet/src/RCS/sunnetparam.c,v 5.6.0.4 91/02/13 15:42:01 miyata Exp $";
#include "parameter.h"
#include "net.h"

/****************************************************************************
To define a parameter, declare&initialize it below, define its features at the 
bottom.  It should be declared as an external in other files where it is used.
****************************************************************************/

/* default network parameters */
NETPARAM netparam_ = {
	 1.0 ,	/* MAXACTV */
	 0.0 ,	/* MINACTV */
	 0.5 ,	/* INITWEIGHT */
	 0.2 ,	/* ETA */
	 0.9 ,	/* ALPHA */
	 5.0 ,	/* NETMAX */
	 1.0 ,	/* DELTADECAY */
	 1.0 ,	/* NETDECAY */
	 1.0 ,	/* CAREOFF */
	 1.0 ,	/* MAXBOUND */
	 1.0 	/* MAXBOUND0 */
};

/* interface parameters */
REAL	Step = 0;		/* learning steps */

int	StepPrint = 1;		/* in 'cycle', error is printed
				 * every StepPrint steps (0->no print)*/
int	StepSave = 0;		/* weights are saved into file
				 * every StepSave steps (0->no save)*/
int	StepError = 0;		/* error is saved into file
				 * every StepError steps (0->no save)*/
BINARY	SaveAppend = ON;	/* save at the end of file */

int	StepCommand = 0;	/* items in command list are exec'ed 
				   every StepCommand steps */
BINARY	Randomize = OFF;	/* whether or not to present patterns
				 * in random order.  */
REAL	ErrLimit = 0.0001;	/* 'cycle' stops when Error reaches *
				 * ErrLimit */
BINARY   FloatPattern = OFF ;   /* patterns are specified by floating *
				 * point numbers */
int	 Pprecision = 4;		/* precision for printing.  */

BINARY	DeBug = OFF ;		/* step through actions in procedure */

BINARY	Quiet = ON ;		/* be quiet while clist/ source */

BINARY	Confirm = OFF ;		/* confirm each command in source file */

#if sunnet|planet|xnet|mgr
int	StepGraph = 1 ;
int     StepMark = 200 ;
int	StepPlot = 0;
int     StepDisplay = 1;

int	Ncol = 0 ;	 	/* Patterns are displayed in
				 * Ncol x Npattern/Ncol matrix.   */
BINARY	Normalize = OFF ;	/* whether or not to normalize 
			 	 * values in displays */
float	Threshold = 0.0 ;	/* display below-threshol values 
			 	 * in different color */
BINARY	GraphLog = OFF ;	/* graph in log scale */

BINARY	Square = ON ;		/* display values in squares instead of bars*/

BINARY  Erase = ON ;		/* erase window before display */

BINARY	MeshPlot = OFF;		/* mesh all items in plot */

BINARY  Label = ON;             /* whether or not to print label *
				 * below displayed objects       */
BINARY	Number = ON;		/* whether or not to print numbers *
				 * for displayed matrix */
BINARY  Transpose = OFF;	/* transpose display matrix */
float	Unit = 1.0 ;		/* display unit value */
#endif 

#if sunnet|planet|xnet|mgr
#define Nparameter 36
#else
#define Nparameter 24
#endif

#define p(name, var, type, desc) { name, (float*) &var, type, desc },
int	Npara = Nparameter ;

PARA Para[ Nparameter ] = {
/* name,	variable,    type,	description 		*/

p("eta", 	ETA,	     "float",	"learning rate" )
p("alpha", 	ALPHA, 	     "float",	"momentum" )
p("max", 	MAXACTV,     "float",	"maximum activation" )
p("min", 	MINACTV,     "float",	"minimum activation" )
p("netmax", 	NETMAX,	     "float",	"maximum net input" )
/* not used anymore.
p("deltadecay", DELTADECAY,  "float", 	"decay of previous delta" )
p("netdecay",	NETDECAY,    "float",	"decay of previous net input" )
*/
p("weight",	INITWEIGHT,  "float",	"initial weight variance" )
p("careoff",	CAREOFF,     "float",	"how much to care if output is off")
p("bound", 	MAXBOUND,    "float",	"bound for bound() function" )
p("bound0", 	MAXBOUND0,   "float",	"upper bound for bound0() function" )
p("randomize", 	Randomize,   "BINARY",	"random presentation" )
p("epoch",	Step,	     "float",	"current epoch number" )
p("print",	StepPrint,   "int",	"freq of printing" )
p("precision",	Pprecision,  "int",	"precision for printing" )
p("save",	StepSave,    "int",   	"freq of saving weights" )
p("errorsave",	StepError,   "int",   	"freq of saving error" )

p("saveappend", SaveAppend,  "BINARY",	"append to end when saving")
p("command",	StepCommand, "int",	"freq of exec'ing command list" )
p("errlimit",	ErrLimit,    "float", 	"error to terminate cycle" )
p("floatpattern",FloatPattern,"BINARY",	"floating number patterns" )
p("debug",      DeBug,       "BINARY",  "step through procedure actions")
p("quiet",	Quiet,       "BINARY",	"be quiet in source/clist")
p("confirm",	Confirm,     "BINARY",	"confirm each command in source")
#if sunnet|planet|xnet|mgr
p("normalize",	Normalize,   "BINARY",	"normalize display values" )
p("threshold",	Threshold,   "float",	"threshold for display value")
p("graph",	StepGraph,   "int",   	"freq of graphing" )
p("mark",	StepMark,    "int",   	"freq of marking graph" )
p("display",	StepDisplay, "int",   	"freq of displaying state" )
p("plot",	StepPlot,    "int",	"freq of xy-plotting" )
p("matrix",	Ncol, 	     "int",	"#of columns of response matrix")
p("squareshape",Square,	     "BINARY",	"display with squares (not bars)")
p("dunit",	Unit,	     "float",	"display unit value")
p("transpose",	Transpose,   "BINARY",	"transpose weight matrix display")
p("graphlog",	GraphLog,    "BINARY",	"graph in log scale" )
p("label",	Label, 	     "BINARY",	"print label below each display" )
p("number",	Number,	     "BINARY",	"print numbers for display" )
p("erase",	Erase,	     "BINARY",  "erase window before display" )
#endif
};

