/* $Header: /soma/users/miyata/planet/src/RCS/sunnetcomm.c,v 5.6.0.5 91/02/13 15:41:56 miyata Exp $ */
static char rcsid[] = "$Header: /soma/users/miyata/planet/src/RCS/sunnetcomm.c,v 5.6.0.5 91/02/13 15:41:56 miyata Exp $";

/** How to add a command:
  (1) define the function for it (eg c_xx) in sunnet.c or graphcomm.c;
      don't forget to document it.  
Then in this file do the following:
  (2) declare the function as external: extern int c_xx() below.
  (3) increment the Ncomm definition: #define Ncomm 31 ; and
  (4) add to the initialization of Command[] to specify the command name:
	  { "xx", c_xx }, --> "xx" becomes the command name for c_xx ;
 **/
#include <stdio.h>
#include "command.h"

extern int	c_exec();
extern int	c_action();
extern int	c_cycle();
extern int	c_present();
extern int	c_pattern();
extern int	c_save();
extern int	c_savefile();
extern int	c_savelist();
extern int	c_read();
extern int	c_step();
extern int	c_print();
extern int	c_printf();
extern int	c_value();
extern int	c_nset();
extern int	c_whatis();
extern int	c_listproc();
extern int	c_names();
extern int	c_printlist();
extern int	c_printfile();
extern int	c_network();
extern int	c_etascale();
extern int	c_comment();
extern int	c_clist();
extern int	c_wait();
#if sunnet|planet|xnet|mgr
extern int	c_parameter();
extern int	c_graph();
extern int	c_response();
extern int	c_display();
extern int	c_dlist();
extern int	c_glist();
extern int	c_window();
extern int	c_error();
extern int	c_erase();
extern int	c_redraw();
extern int	c_echo();
extern int	c_dmatrix();
extern int	c_screen();
extern int	c_plot();
extern int	c_plotlist();
extern int	c_dprint();
extern int	c_clickLocation();
#if sunnet|xnet
extern int	c_movie();
#endif sunnet
extern int	c_color();
#endif sunnet|planet

#if sunnet|planet|xnet|mgr
#define Ncomm 51
#else
#define Ncomm 30
#endif 

int	Ncommand = Ncomm;

COMMAND	Command[ Ncomm ] = {	/* non-graphic commands */
{ "General:      ",	NULL		},
{ "nset",	c_nset		},
{ "whatis",	c_whatis	},
{ "wait",	c_wait		},
{ "clist",	c_clist		},

{ "Setting Up:   ",	NULL	},
{ "network",	c_network	},
{ "listproc",   c_listproc	},
{ "names",	c_names		},
{ "etascale",	c_etascale	},
{ "pattern",	c_pattern	},

{ "Running:      ",	NULL	},
{ "exec",	c_exec		},
{ "action",	c_action	},
{ "cycle",	c_cycle		},
{ "present",	c_present	},

{ "Printing:     ",	NULL	},
{ "print",	c_print		},
{ "printf",	c_printf	},
{ "printlist",	c_printlist	},
{ "printfile",  c_printfile	},
{ "value",	c_value		},

{ "Saving:       ",	NULL	},
{ "savefile",	c_savefile	},
{ "save",	c_save		},
{ "savelist",	c_savelist	},
{ "comment",	c_comment	},
{ "read",	c_read		},
{ "step",	c_step		}
#if sunnet|planet|xnet|mgr				/* graphics commands */
,
{ "Graph:        ",	NULL	},
{ "graph",	c_graph		},
{ "glist",	c_glist		},
{ "error",	c_error		},

{ "Basic Display:", NULL	},
{ "window",	c_window	},
{ "erase",	c_erase		},
{ "redraw",     c_redraw        },
{ "echo",	c_echo		},
{ "screen",	c_screen	},

{ "Display/Plot: ",	NULL	},
{ "display",	c_display	},
{ "dlist",	c_dlist		},
{ "response",	c_response	},
{ "dmatrix",	c_dmatrix	},
{ "plot",	c_plot		},
{ "plotlist",	c_plotlist	},

{ "Misc. Display:",	NULL	},
{ "dprint",	c_dprint	},
{ "parameter",	c_parameter	},
#if sunnet|xnet
{ "movie",	c_movie		},
#endif sunnet
{ "color",	c_color		},
#endif sunnet|planet
} ;
