/* $Header: /soma/users/miyata/planet/src/RCS/sunnet.c,v 5.6.0.4 91/02/13 15:41:49 miyata Exp $ */
static char rcsid[] = "$Header: /soma/users/miyata/planet/src/RCS/sunnet.c,v 5.6.0.4 91/02/13 15:41:49 miyata Exp $";
/********************** source file sunnet.c ***************************
Sunnet.c contains functions that implements user commands
not involving graphics.  Functions for graphics user commands are in
graphcomm.c.  Each function corresponds to a user command.  E.g., the
function c_cycle is called when the user types in the user command
"cycle".  For each function, the argument argn contains the number of
arguments typed in by the user.  The argument args contains the
arguments typed by the user as an array of character strings.  See
the file sunnetcomm.c for the list of user commands and their
corresponding functions.
*****************************************************************************/
/******************* UPDATES *****************************
sunnet.c:
1/24/91 fixed c_save so savelist items are not appended if saveappend=off.
12/15/90 changed c_step to use setup_network to read weight file.
8/1/90 fixed bug in c_savefile - closing a pipe with fclose().
6/5/90 patterns can be read from a pipe. 'pattern |program ...'
5/9/90  fixed stopif expression bug in c_cycle.
4/30/90 exec can access library procedures.
4/28/90 exec can take procedure arguments.
4/19/90 if cannot read pattern file try to reread as float pattern file.
3/21/90 put $globalError automatically in glist for new network.
1/20/90 implemented c_printf command.
12/7/89 call end_socket in save_net_and_quit to unlink port before dying.
11/17/89 fixed bug in c_step for reading ahead (by Harada).
***********************************************************/
#include <stdio.h>
#include <signal.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>			/* for stat() function */
#include <strings.h>
#include <ctype.h>
#include "version.h"
#include "command.h"
#include "net.h"
#include "alloc.h"
#include "error.h"
#include "parameter.h"
#if sunnet|planet|xnet|mgr
#include "graph.h"
#endif
#include "files.h"
#include "stack.h"
#include "userdefs.h"
#include "msg.h"
#include "sunnet.h"			/* macros and global vars definition *
					 * this should be included last	     */
#define Nfilename Largs			/* max length of file name */
void initialize(), terminate();
void make_commandFmt();
void initialize_prompt(), add_prompt(), reset_prompt();
void print_file_names();
void save_net_and_quit();
void caught_ill(), caught_fpe(), caught_bus(), caught_segv(), caught_sys();
void deleteProcArgs();

char    InFileName[ Nfilename ];		/* file name to read in weights */
char	OutFileName[ Nfilename ];		/* file name to save weights */
FILE    *InFile, *OutFile;		/* file pointers for weight files */
FILE	*fopen(),*open_file();		/* functions for finding files */
long	OutFile_end;			/* current position in OutFile */
char	PatFileName[ Nfilename ];	/* file name to read in patterns */
char	NetFileComm[ BUFSIZE ];		/* command used to read in network */
int	InFileType = 0;			/* indicates input file is a pipe */

NETWORK *Net;				/* network pointer */

NUMBER	Error;				/* average error at output layer */
NUMBER	cumError;			/* cumulative error at output layer */
NUMBER  *ErrPattern;                    /* to store error pattern */

NUMBER	**Input,**Target;		/*2d arrays for input/target patterns*/
char	**Plabel;			/*labels for patterns */

int	N_input=0;			/* # of input elements */
int	N_target=0;			/* # of target elements */
int	Npattern=0;			/* # of patterns. */

int	Step2;				/* step no for alternative network */

/************	These macros are defined in 'sunnet.h'	****************
#if sunnet|planet
#define Graphit		( Graph && StepGraph && Step%StepGraph == 0 )
#endif sun
#define Printit 	( StepPrint && Step%StepPrint == 0 )
#define Saveit  	( StepSave && Step%StepSave == 0 )
#define SaveError  	( StepError && Step%StepError == 0 )
 ************************************************************************/

#ifndef min
#define min(x,y) ((x)<(y)? (x):(y))
#endif

long	PID;		/* process id */
char	HOST[10];		/* host id */
void  Install();
char *index(),*rindex();

void initialize(argc, argv)
int argc; char *argv[];
{
  int  status;
  long getpid();
  float shape = 0.0;
  char progname[64];

  PID = getpid();
  make_commandFmt();
  path2pname( argv[0] );
  sprintf( progname, "%s Version %s", argv[0], VERSION );
  printf( "%s: %s Type 'help' for help.\n", progname, VERSION_DATE );
#if xnet
  initialize_graphics( argc, argv );
#else
#if sunnet|planet|xnet|mgr
  if( argc>1 && Err( AtoF( argv[1], shape )) )  
    fprintf( stderr, "%s: invalid display size" , argv[1] );
  if( GraphicsWindow ) 
    initialize_graphics( shape ), frame_screen( progname );
#endif
#endif
  initialize_prompt();
  Install();	/* install vector functions */
}

path2pname( name )
char *name;
{
  char *s;
  if( s = rindex( name, '/' )) strcpy( name, s+1 );
}

void terminate()
{
/*if( Net ) delete_net( Net );*/
#if sunnet|planet|xnet|mgr
  if( GraphicsWindow ) terminate_display();
#endif
}

#define Lprompt BUFSIZE
static char prompt[ Lprompt ];
STACK *prompt_stack;

void initialize_prompt()
{
  prompt_stack = new( STACK );
  strcpy( prompt, DefaultPrompt );
}  

void reset_prompt()
{
  char *str;
  if( empty(prompt_stack) ) return;
  IfErr(str = pop( prompt_stack )) return;
  strcpy( prompt, str );
  free( str );
}

void add_prompt( str )
char *str;
{
  push( new_string( prompt, NULL ), prompt_stack );
  sprintf( prompt, "%sin %s: ", prompt, str );
}

char *
get_prompt()
{
  static char str[Lprompt];
  strcpy( str, prompt );
  substitute_parameter_string( str );
  return( str );
}
/** 
.CO "present" "present patterns and execute procedure"	RUN-COMMAND
.SY "present {all/N/N1-N2/+/\(mi/=} [<procedure>]"
.BI
Presents one or more pattern(s) to network, and executes <procedure> for
each pattern.  Pattern numbers can be specified either as \fBall\fP (all
patterns), \fBN\fP (pattern #N), \fBN1-N2\fP (patterns #N1 through
#N2), \fB+\fP (next pattern), \fB\(mi\fP (previous pattern), or \fB=\fP (same
pattern).  Remember that the first pattern is pattern #0.
.Ni
Default procedure is the one previously used, or \fIactivate\fP initially.
.Ni
Items in the print list are printed and items in the display list
(dlist) are displayed after presentation of each pattern.  
See \fBprintlist\fP and \fBdlist\fP.
.Ni
If parameter \fIdebug\fP is \fIon\fP, procedure is executed in \fIdebug-mode\fP.
Type \fBhelp debug\fP for details. ~H
See help for \fBdebug\fP below for details. ~R
.EE
**/
c_present( argn, args )
int	argn; char args[][Largs];
{
  static char proc_name[ Lname ]="activate"; /* default procedure name */
  APROC  *aproc;
  void deleteProcArgs();
  static int n_pattern = 0;
  int	 npattern, n1, n2;
  int	 quiet, noprint, nodisp, status;
  register int j;
  static   int *order=NULL, norder=0;
  REAL   error;

  CheckPattern(); CheckNet();
  if( argn < 1 ) Erreturn( get_syntax( "present" ) );
		/* determine which procedure to execute for each pattern */
  if( argn > 1 ) {
    IfErr( aproc = find_procedure( Net, args[1], 0, 1 ) ) return( ERR );
    strcpy( proc_name, args[1] );
  }
  else IfErr( aproc = find_procedure( Net, proc_name, 0, 1 ) ) return( ERR );

  execute_procedure( NULL ); /* clear debug information*/

		/* determine the range of patterns to present */
  IF( args[0], "all" ) n1=0, n2=Npattern-1; 
  else IF( args[0], "+" ) n1=n2=n_pattern=(n_pattern+1)%Npattern ;
  else IF( args[0], "-" ) n1=n2=n_pattern=(n_pattern)? n_pattern-1:Npattern-1;
  else IF( args[0], "=" ) n1=n2=n_pattern;
  else if( find_range( args[0], &n1, &n2 ) );
	/* BUG: what happens to partial match? */
  else if( Plabel && which_pattern( Plabel, Npattern, args[0], &n1 ) )
    n2=n_pattern=n1;	/* specify pattern by name */
  else Erreturn( get_syntax( "present" ) );

  if( n1 < 0 ) Erreturn1("invalid pattern %d", n1 );
  if( n2 >= Npattern ) {
    sendMsg1("warning: only %d patterns.\n", Npattern );
    n2= Npattern-1;
  }
  Starting(inPattern);
  npattern = n2-n1+1;
  if( norder < npattern ) {
    if( order ) free( order );
    order = new_array_of( npattern, int );
    norder = npattern;
  }
  for( j=0; j < npattern; j++ ) order[j] = j+n1;
  if(Randomize==ON) permut( order, Npattern, sizeof(*order) );
  quiet = get_flag( argn-2, args[2], "-quiet");
  noprint = get_flag( argn-2, args[2], "-print");
  nodisp = get_flag( argn-2, args[2], "-display");

  for( j=0, cumError=.0 ; j < npattern; j++, cumError += error )  {
    n_pattern = order[j];
    if(INTERRUPT == INTR_PAT) {
      sendMsg1("interrupt at pattern = %d\n",n_pattern);
      if( DoInterrupt("present") == EXIT ) {
	Ending(inPattern); Erreturn("exit from present");
      }
    }
    if(Err( put_input( Net, Input[n_pattern], N_input ) ) ||
       (N_target && Err( put_target( Net, Target[n_pattern], N_target ))))
      { Ending(inPattern); return( ERR ); }
    clear_delta_net( Net ); 
    IfErr( executeAproc( aproc ) ) {
      Ending(inPattern);
      Erreturn2("%s: in procedure %s", ERR_MSG, proc_name );
    }
    ErrPattern[n_pattern]= error = get_error(Net);
    if( !noprint && Err( print_items( ) ) ) {
      Ending(inPattern);
      Erreturn1("%s: in printing", ERR_MSG );
    }
    if( !quiet ) {
      addMsg1("\tPattern # %d", n_pattern );
      if( Plabel ) addMsg1(" (%s)", Plabel[n_pattern]);
      addMsg1(" Error = %f\n", error );
      endMsg();
    }
#if sunnet|planet|xnet|mgr
    if( !nodisp && Err( display_items( Window ) )) {
      Ending(inPattern);
      Erreturn1("%s: in display", ERR_MSG );
    }
#endif
  }
  if( npattern ) Error = cumError/npattern;
  flush_printfile();
  deleteProcArgs( aproc );
  Ending(inPattern);
  return( OK );
}

/* which_pattern() finds a pattern with a given name */

which_pattern( labels, npat, str, n )
char **labels, *str; int npat, *n;
{
  register int i; int match, max;
  for( i=0, max=0; i< npat; i++ ) {
    match = cmp_str( labels[i], str );
    if( match > max ) { max = match; *n = i; }
  }
  return( max? OK : ERR );
}

/**
.CO "cycle" "repeatedly cycle through patterns"	RUN-COMMAND
.SY "cycle [N / \(miN] [<procedure>] [-B <begin-proc>] [-E <end-proc>] [pN1-N2]"
.BB
Cycles through all patterns, or patterns N1 through N2 if \fBpN1-N2\fP
is given, N (>0, default=1) cycles.  If the first argument is a
negative integer (\(miN), cycle is continued until step N has been reached.
.BI
Each cycle consists of the following three steps:
.sp 0
(1) execute <begin-proc> if given.
.sp 0
(2) present a pattern to network and execute <procedure> - repeat
this step for all patterns.
.sp 0
(3) execute <end-proc> if given.
.Ni
If <procedure> is not given, default procedure is the one previously
used (or \fIlearn\fP initially). If none of <procedure>, <begin-proc>
or <end-proc> is specified, previous ones are used.
.Ni
If \fIerrlimit\fP is set to non-zero (default=0.0001), cycle is terminated
when the error becomes less than that value.
.Ni
More complex stopping criterion can be specified by a flag
\fBstopif<expression>\fP.  Cycle is terminated when <expression>
becomes true (1.0).  For example, \fBcycle 100 stopif(average($err)<0.01)\fP is
usually equivalent to setting \fIerrlimit\fP to 0.01.
.Ni
A flag of the form \fBpatternN-M\fP or \fBpN-M\fP specifies the subset
of the patterns to be presented.  \fBpatternall\fP or \fBpall\fP resets it
to all patterns.  A flag \fBnopattern\fP or \fBnopat\fP means no pattern
is presented - just the procedure is executed at each epoch.
.Ni
The parameters \fIprint\fP, \fIdisplay\fP, \fIcommand\fP, \fIsave\fP,
\fIerrorsave\fP, \fIgraph\fP, and \fImark\fP, can be set to
periodically perform the commands \fBprint\fP, \fBdisplay\fP, \fBclist
do\fP, \fBsave\fP, and saving the error, plotting in graph and marking
in graph, respectively, while running \fBcycle\fP.  See each command,
and the commands \fBprintlist\fP, \fBdlist\fP, \fBsavelist\fP,
\fBclist\fP, and \fBglist\fP for details.
.Ni
Cycle is interruptable at each step (interrupt level = cycle), at each
pattern presentation (interrupt level = pattern), or at each action in 
procedures (interrupt level = action).
.Ni
If the parameter \fIdebug\fP is \fIon\fP, procedure is executed in \fIdebug-mode\fP.
Type \fBhelp debug\fP for details. ~H
See help for \fBdebug\fP below for details. ~R
.EE
**/
c_cycle( argn, args )
int	argn; char args[][ Largs ];
{
  static   char proc_name[ Lname ]="learn"; /* default procedure is "learn"*/
  static   char begin_proc_name[ Lname ];
  static   char end_proc_name[ Lname ];
  APROC   *proc = NULL;
  APROC   *begin_proc = NULL;
  APROC   *end_proc = NULL;
  register int i,j;
  static   int	   n1, n2, npattern, nallpattern;
  int	   n, n_cycle;
  BINARY   changed = OFF; /*indicates default procedure/pattern# has changed */
  NUMBER   err[10] ;
  NUMBER   error ;
  BINARY   printed=OFF;
  static EXPRESS  *stop_ex=NULL; /* expression for stopping criteria */
  EXPRESS  *find_optimize_expression();
  static   int *order=NULL, norder=0;
  int	   status, quiet=0;

  if(nallpattern != Npattern) 
    { npattern = nallpattern = Npattern; n1=0; n2=Npattern-1; }

  CheckNet();
  quiet = get_flag( argn, args, "-quiet");
  if( argn == 0 ) n_cycle = 1;
  else IfErr(eval_expression_value(Net,args[0],&n_cycle) )
/*  else if( AtoI( args[0], n_cycle ) != 1 ) */
    Erreturn1("invalid # of cycles %s", args[0]);
  if( n_cycle < 0 ) n_cycle = - n_cycle - Step ;
					/* cycle until Step=-n */

  if( argn > 2 || (argn==2&&args[1][1]=='p' )) /* expect new procedures */
     { *begin_proc_name = *end_proc_name = NULL; }
  for( i=1; i< argn; i++ ) {	/* interpret arguments ->procedures,patterns */
    IF( args[i], "-quiet" ) quiet=1;
    else IF( args[i], "-B" ) {
      IfErr( begin_proc = find_procedure( Net, args[++i],0,1 ) )
	Erreturn1("procedure %s not defined ", args[i] );
      strcpy( begin_proc_name, args[i] ); changed = ON;
    }
    else IF( args[i], "-E" ) {
      IfErr( end_proc = find_procedure( Net, args[++i], 0,1 ) )
	Erreturn1("procedure %s not defined ", args[i] );
      strcpy( end_proc_name, args[i] ); changed = ON;
    }
    else if(( !strncmp(args[i], "pattern", 7) && 
	      find_range( args[i]+7, &n1, &n2 )) ||
	    ( args[i][0] == 'p' && find_range( args[i]+1, &n1, &n2 ))) {
      if( n1<0 || n2<0 || n1>=Npattern || n2>=Npattern || n1>n2 )
	Erreturn2("invalid range of pattern # %d - %d", n1, n2 );
      npattern = n2-n1+1; changed = ON;
    }
    else if( EQL(args[i], "patternall" ) || EQL(args[i], "pall")) {
      n1=0, n2=Npattern-1, npattern=n2-n1+1; changed = ON;
    }
    else if( EQL(args[i], "nopattern" ) || EQL(args[i], "nopat")) {
      n1= -1, n2= -1, npattern=0; changed = ON;
    }
    else if( !strncmp(args[i], "stopif", 6 ) ) {
      IfErr( stop_ex = find_optimize_expression( Net, args[i]+6 ) )
	Erreturn1("%s: invalid expression for stopif", args[i]+6 );
    }
    else {
      IfErr( proc = find_procedure( Net, args[i],0,1 ) )
	Erreturn1("procedure %s not defined ", args[i] );
      strcpy( proc_name, args[i] ); changed = ON;
    }
  }
  if( proc == NULL ) {
    IfErr( proc = find_procedure( Net, proc_name, 0,1 ) )
      Erreturn1("procedure %s not defined ", proc_name );
    if( *begin_proc_name &&
       Err( begin_proc = find_procedure( Net, begin_proc_name, 0,1 ) ) )
      Erreturn1("procedure %s not defined ", begin_proc_name );
    if( *end_proc_name && 
       Err( end_proc = find_procedure( Net, end_proc_name, 0,1 ) ))
      Erreturn1("procedure %s not defined ", end_proc_name );
  }

  if( !quiet ) {
    IfErr(Input) sendMsg("warning: pattern not defined.\n");
    beginMsg("    cycle procedure: ");
    if( begin_proc ) addMsg1("(begin) %s, ", begin_proc_name );
    addMsg( proc_name );
    if( end_proc ) addMsg1(", (end) %s", end_proc_name ); 
    addMsg("\n");
    if( npattern == 0 ) addMsg("    no pattern\n");
    else if( npattern != Npattern ) addMsg2("    patterns %d - %d\n", n1, n2 );
    endMsg();
  }

  Starting(inCycle); 
  if( npattern > 0 ) Starting(inPattern);

  if( !begin_proc ) *begin_proc_name = NULL;
  if( !end_proc ) *end_proc_name = NULL;

  if( changed==ON && OutFile ) {     /* save new default procedure/pattern# */
    sprintf( args[0], "%d", 0 );
    fprint_command( OutFile, "cycle", argn, args );
  }
	/* presentation order */
  if( norder < npattern ) {
    if( order ) free( order );
    order = new_array_of( npattern, int );
    norder = npattern;
  }
  for( j=0; j < npattern; j++ ) order[j] = j+n1;

  execute_procedure( NULL ); /* clear debug information*/
  for( i=0 ; i<n_cycle ; i++ ) {
    Step ++ ;
    if(Randomize==ON && Input) permut( order, npattern, sizeof(*order) );
    if( begin_proc && Err( executeAproc( begin_proc ) ) ) {
      Ending(inPattern); Ending(inCycle);
      Erreturn2("%s: in procedure %s", ERR_MSG, begin_proc_name );
    }
    for( j=0, cumError=.0 ; j < npattern; j++, cumError += error )  {
      n = order[j];
      if( Err( put_input( Net, Input[n], N_input )) ||
	 (N_target && Err( put_target( Net, Target[n], N_target )))) {
	Ending(inPattern); Ending(inCycle); return( ERR );
      }
      clear_delta_net( Net );
      IfErr( executeAproc( proc ) ) {
	Ending(inPattern); Ending(inCycle);
	Erreturn2("%s: in procedure %s", ERR_MSG, proc_name );
      }
      ErrPattern[n] = error = get_error( Net );
      if( INTERRUPT == INTR_PAT ) {
	sendMsg1("interrupt at pattern %d\n", n );
	if( DoInterrupt("cycle") == EXIT) {
	  Ending(inPattern); Ending(inCycle); Erreturn("exit from cycle" );
	}
      }
    }
    if( npattern == 0 ) {	/* no pattern - just run procedure */
      clear_delta_net( Net );
      IfErr( executeAproc( proc ) ) {
	Ending(inCycle);
	Erreturn2("%s: in procedure %s", ERR_MSG, proc_name );
      }
      Error = cumError = get_error( Net );
    }
    if( end_proc && Err( executeAproc( end_proc ) ) ) {
      Ending(inPattern); Ending(inCycle);
      Erreturn2("%s: in procedure %s", ERR_MSG, end_proc_name );
    }
    if( npattern ) Error = cumError/npattern ;
    if( Printit ) {
      IfErr(print_items( )) {
	Ending(inPattern); Ending(inCycle);
	Erreturn2("%s: at step %g",ERR_MSG, Step);
      }
      if( !quiet ) sendMsg2("epoch=%g error=%f\n", Step, Error );
      printed = ON;
    }
    if( DoCommand && Err( exec_clist( 0 ) )) {
      Ending(inPattern); Ending(inCycle);
      Erreturn2("%s: at step %g",ERR_MSG, Step);
    }
#if sunnet|planet|xnet|mgr
    if( Graphit && 
       Err( graph_items( Graph, (int)Step,(GraphLog==ON)? 1:0,(Markit)? 1:0))){
      Ending(inPattern); Ending(inCycle);
      Erreturn1("%s: in graph", ERR_MSG);
    }
    if( Displayit && Err(display_items( Window ))){
      Ending(inPattern); Ending(inCycle);
      Erreturn1("%s: in display", ERR_MSG);
    }
    if( Plotit && Err( c_plot( 1, "0" ))){
      Ending(inPattern); Ending(inCycle);
      Erreturn1("%s: in plotting", ERR_MSG);
    }
#endif sun
    if(Saveit) {
      if( OutFile == NULL ) {
	Ending(inPattern); Ending(inCycle);
	Erreturn( "Output file not defined. Do 'savefile <file>'."); 
      }
      IfErr( c_save( 0, "" ) ) {
	Ending(inPattern); Ending(inCycle);
	return( ERR );
      }
    }
    if(SaveError && !Saveit ) {
      if( OutFile == NULL ) {
	Ending(inPattern); Ending(inCycle);
	Erreturn( "Do 'savefile <file>' to define output file or 'set save 0' to turn off saving."); 
      }
      fprint_error( OutFile, (int)Step, Error );
/*    OutFile_end = ftell( OutFile );*/
    }
    if( Error < ErrLimit )  {
      if( !quiet ) sendMsg1("reached error limit %f.\n", ErrLimit);
      break ;
    }
    if(stop_ex && eval_expression(stop_ex) && stop_ex->vector->value[0]==1.0) {
      if( !quiet ) 
	sendMsg1( "reached stopping criterion at step %d\n", (int)Step);
      break;
    }
    if(INTERRUPT == INTR_CYC) {
      sendMsg1( "interrupt at step = %d.\n", (int)Step);
      if( DoInterrupt("cycle") == EXIT) {
	Ending(inPattern); Ending(inCycle);
	Erreturn( "exit from cycle" );
      }
    }
  }
  if( printed == ON ) { fflush(stdout); flush_printfile(); }
  if( stop_ex ) { delete_expression( stop_ex ); stop_ex = NULL; }
  Ending(inPattern); Ending(inCycle);
  return( OK );
}
/**
.CO "exec" "execute procedures"		RUN-COMMAND
.SY "exec <procedure> ..."
.BB
Executes one or more procedures.  Procedures must be defined in network
specification file and read in by the command \fBnetwork\fP.  Deltas and net
inputs of all units in the network are cleared only before executing the first
procedure.  Therefore, note that \fBexec proc1 proc2\fP can be different from
\fBexec proc1; exec proc2\fP.  If the parameter \fIdebug\fP is \fIon\fP,
procedures are executed in \fIdebug-mode\fP.
Type \fBhelp debug\fP for details. ~H
See help for \fBdebug\fP below for details. ~R
.EE
**/
c_exec( argn, args )
int	argn; char args[][ Largs ];
{
  register int i;
  APROC *aproc;
  int  status;
  CheckNet();
  clear_delta_net( Net );

  for( i=0; i< argn; i++ ) {
    IfErr( aproc = find_procedure( Net, args[i], 0, 1 ) )
      Erreturn2("%s: in %s", ERR_MSG, args[i]);
    execute_procedure( NULL ); /* clear debug information*/
    status = executeAproc( aproc );
/*  arguments may be used in dlist, etc. within the procedure */
/*  deleteProcArgs( aproc ); */
    IfErr( status )
      Erreturn2("%s: in procedure %s", ERR_MSG, args[i] );
  }
  return(OK);
}
/**
.CO "action" "execute an action"		RUN-COMMAND
.SY "action <action> arguments ..."
.BB
Executes an action with arguments.
.EE
**/
c_action( argn, args )
int	argn; char args[][ Largs ];
{
  register int i;
  PROCED *proc;
  CheckNet();
  proc = new( PROCED );
  proc->name = NULL, proc->iconst = NULL,
  proc->fconst = NULL, proc->action = NULL;
  proc->n_action = proc->n_int = proc->n_float = proc->n_expr = 0;
  if(Err( proc->action = new_array_of( MaxAction, ACTION )) ||
     Err( proc->iconst = new_array_of( MaxProcConst, int )) ||
     Err( proc->fconst = new_array_of( MaxProcConst, float )))
    Erreturn("cannot allocate memory for action");

  if(Err( add_action_to_procedure( stdin, args[0], 
				  args[0], argn-1, args[1], Net, proc, 1)) ||
     Err( execute_procedure( proc ) ) ) {
    delete_procedure( proc ); free( proc );
    return( ERR );
  }
  delete_procedure( proc ); free( proc );
  return( OK );
}
     
/**
.CO "network" "read network file"	SETUP-COMMAND
.SY "network [str1=str2 ..] <file> ... [+] / network reset / network "
.BI
\fBnetwork <file> ...\fP reads in network specification from one or more <file>
and sets up the network and network procedures defined in the file(s).
All the lists, except the command list, are cleared
(see section I-L for the commands for manipulating lists.)~R
(see section I-L of \fBSunNet Reference\fP for the commands for manipulating lists.)~H
See Section III for actions used in procedures.~R
See Section III of \fBSunNet Reference\fP for actions used in procedures.~H
.NI
'network <file> +' adds network specification in <file> to the ~H
\fBnetwork <file> \(pl\fP adds network specification in <file> to the ~R
current network.  This can be used to add additional layers, connections,
arrays, variables, or procedures into the current network.  Procedures can
be redefined by reading in a file containing the new definitions with
'network <file> +'. ~H
\fBnetwork <file> \(pl\fP. ~R
Layers, connections, arrays, and variables cannot be redefined.
.NI
Zero or more arguments of the form \fBstr1=str2\fP can be given before the
network file name, which is equivalent to having a line of the form
\fBdefine str1 str2\fP at the beginning of the file.  This is useful for
parameterizing network files.  For example, the file \fBn.3layer\fP in
the example directory can be read with \fBnetwork Nin=4 Nhid=6 Nout=4
n.3layer\fP. 
.NI
If the file name ends with \fI.m4\fP, the file is piped through the
macro processor program \fBm4\fP.  This provides a useful additional
layer of programming using macros.  Consult Unix Manual PS1:17-1
for using m4.
.NI
\fBnetwork reset\fP re-initializes the network by clearing all units
(activation values, net-inputs, and deltas) and randomizing all
weights and biases.  \fBnetwork reset -sN\fP, where N is an integer,
will use N as the random seed for weights initialization.  This can be
used to run the network multiple times with identical starting weights.
\fBnetwork reset same\fP will use the same random seed as the previous
reset.
.NI
Without arguments, \fBnetwork\fP prints the name of the current
network file.
.EE
**/
NETWORK *Net2;				/* alternative network */
char	NetFileComm2[ BUFSIZE ];	/* alternative network file */
c_network( argn, args )
int	argn; char args[][ Largs ];
{
  FILE	*fp;
  int	n, junk;
  struct stat fstat;
  int	ftype;
  static int seed;
  void  seedrandom(), catch_signal();
  char	fname[Nfilename], *str;
  char  netfilecomm[BUFSIZE];
  NETWORK *netP;
  int additional = get_flag( argn, args, "+"); 

  if(argn < 1 ) {
    IfErr( Net ) Erreturn("network not defined");
    if( NetFileComm ) sendMsg1("network file = %s\n", NetFileComm );
    return( OK );
  }
  else IF( args[0], "switch" ) {
    IfErr( Net2 ) Erreturn("no alternative network");
    netP = Net2; Net2 = Net; Net = netP;
    strcpy( fname, NetFileComm2 ); strcpy( NetFileComm2, NetFileComm );
    strcpy( NetFileComm, fname );
    n = Step2; Step2 = Step; Step = n;
    sendMsg1("network is now %s\n", NetFileComm );
    return( OK );
  }
  else IF( args[0], "reset" ) { 
    CheckNet();
    if( argn > 1 ) {
      IF(args[1], "same") seedrandom( seed );
      else if( get_flag_i( 1, args[1], "s%d", &seed ) ) seedrandom( seed );
      else if( get_flag_i( 1, args[1], "-s%d", &seed ) ) seedrandom( seed );
      else Erreturn( get_syntax("network") );
    }
    else seed = newseed();
    clear_net( Net );
    Step = 0;
    sendMsg1("network file = %s\n", NetFileComm? NetFileComm : "undefined" );
    sendMsg1("pattern file = %s\n", PatFileName? PatFileName : "undefined" );
    return( OK );
  }
  else IF( args[0], "-c" ) {
    if( argn < 2 ) Erreturn("syntax: network -c command [arg ...]");
    return( eval_network_command( args[1], args[2], argn-2, Net, NULL ));
  }
	/* save the command line in netfilecomm[] leaving out flags *
	 * we'll use this to identify network in case -D is given */
  netfilecomm[0] = NULL;
  for( n=0; n< argn; n++ ) {
    if( *args[n]=='-' || *args[n]=='+' || sscanf(args[n],"s%d",&junk))
      continue; /* ignore flags */
    if(index(args[n], '=')) /* define string -> save */
      { sprintf(netfilecomm,"%s %s",netfilecomm,args[n]); continue; }
		/* if file exists, get file type */
    IfErr( ftype = find_file( args[n], 0, NetworkDir, fname, &fstat ) )
      Erreturn1("cannot find file %s", args[n]);
    sprintf(netfilecomm,"%s %s",netfilecomm,fname);/* save file name */
  }
	/* next, we process flags if any*/

	/* if flag "-D" is given, read this network only if it is different
	 * from the current one: BUG-doesn't work if a file is read with
	 * different define's (A=B) or more than two files are read - fixed*/
  if( get_flag( argn, args, "-D" ) && EQL(netfilecomm, NetFileComm)) return(OK);

  /* if flag "+" is not given, delete current network and create a new one. */

  if( !additional ) {
    if( Net ) {
    	/* we should clear all list items with pointers to old network */
	/* BUG: these should be stored when switching nets */
      c_printlist( 1, "clear" ), c_savelist( 1, "clear" );
#if sunnet|planet|xnet|mgr
      c_glist( 1, "clear" ), c_dlist( 1, "clear" ), c_plotlist( 1, "clear" );
#endif
	/* if flag "-switch" is given, save current network -don't delete*/
      if( get_flag( argn, args, "-switch" )) {
	if( Net2 ) delete_net( Net2 );
	strcpy( NetFileComm2, NetFileComm );
	Net2 = Net; Step2 = Step;
      } else { 		/* otherwise, delete current net */
	delete_net( Net ); Net = NULL; NetFileComm[0] = NULL; 
      }
    }
    Step = 0;	/* this net hasn't been trained */
    /* if flag -sN or sN, seed random() with N, otherwise with a new seed */
    if( get_flag_i( argn, args, "s%d", &seed ) ) seedrandom( seed );
    else if( get_flag_i( argn, args, "-s%d", &seed ) ) seedrandom( seed );
    else seed = newseed();
	    /* now create a new empty network */
    IfErr( Net=new_net() ) Erreturn1("%s: in creating network", ERR_MSG );
#if sunnet|planet|xnet|mgr
    c_glist( 1, "error" );	/* put $globalError in glist */
#endif
  }
		/* now start reading each network file */
  sendMsg("reading network file ");
  CheckNet();
  for( n=0; n< argn; n++ ) {
    if( *args[n]=='-' || *args[n]=='+' || sscanf(args[n],"s%d",&junk))
      continue; /* flags - ignore */
	/* parse define strings */
    if( str=index(args[n], '=') ) {
      *str = NULL;
	/* last argument means this is defined online -> cannot override */
      IfErr( make_define( args[n], str+1, ON ) ) return( ERR );
      continue;
    }
		/* if file exists, get file type */
    IfErr( ftype = find_file( args[n], 0, NetworkDir, fname, &fstat ) )
      Erreturn1("cannot find file %s", args[n]);
    IfErr( fp = open_file( fname, ftype ) )/* now try to open the file */
      Erreturn1("cannot open file %s", fname );

    sendMsg1(" %s ", fname );
    catch_signal();
			/* if there's a flag -I, don't initialize weights */
    IfErr(setup_network( fp, Net, get_flag( argn, args, "-I" )? 0:1))  {
      close_file( fp, ftype );  
      if( !additional ) NetFileComm[0] = NULL;
      Erreturn2("%s: in %s", ERR_MSG, fname );
	       		/* better delete Net ? */
    }
    close_file( fp, ftype );
  }			/* we're done with all files */
  sendMsg("\n");
		/* give warning about undefined procedures */
  check_procedure( Net );
  if( !additional )
    strcpy( NetFileComm, netfilecomm );	/* save the command line */
  return( OK );
}

/*
.HE "vector" "definition of vector and matrix" VECTOR-HELP
.BB
A vector is a data object containing a series of one or more floating
point numbers.  A vector is specified by a vector name, optionally
followed by a subscript or a range as explained below.  A vector name
is one of the following:
.BI
\fB<layer>\fP, the name of a layer, specifies the activation values of
the units in the layer.  \fB<layer>:delta\fP, \fB<layer>:bias\fP and
\fB<layer>:net\fP, as in \fBHidden:delta\fP, specify the delta's, the
biases, and the net inputs, respectively, in the units instead of the
activation values.
.NI
\fB<array>\fP, the name of an array, specifies the values in the array.
.NI
\fBinput\fP and \fBtarget\fP, the input and target buffers.
.NI
\fB<float>\fP, the name of a float variable.
.NI
\fB$<parameter>\fP where \fB<parameter>\fP is a SunNet parameter name
(e.g., $eta).
.NI
\fB$err\fP is a vector whose Nth element is the error for Nth patern
usually computed by the command \fBcycle\fP or \fBpresent\fP.
.NI
\fB$Error\fP (single value) is the mean square error computed by the last
call to the action 'target'.
.NI
\fB$cumError\fP is the cumulative error summed across patterns presented so 
far in 'cycle' and in 'present'.
.NI
\fB$globalError\fP is the error averaged across patterns presented during
the last step (epoch) in 'cycle' and in 'present'.
.NI
\fB$mouseClick\fP returns a vector when a mouse button is clicked, whose first,
second, and third elements are the X and Y coordinates of the mouse cursor and
the mouse button number that is clicked.
.NI
\fB$windowClick\fP returns a scaler when a mouse button is clicked, which
is the window number that is clicked.  -1 is returned if the user clicks at
a location where there is no window.
.EI
.NB
A vector can be subscripted as follows, where <vector> is a vector
name as explained above, and the subscripts N and M can each be either
a constant, a variable (float variables (not int variable), single
element of vector or a matrix) or an expression that evaluates to a
single value.
Type \fBhelp expression\fP for expressions. ~H
See helpfor \fBexpression\fP below about expressions. ~R
A float value is rounded into an intger value when used as a subscript.
An invalid (e.g., negative) subscript will generate an error.
.BI
\fB<vector>[N]\fP : the Nth element of <vector>.
.NI
\fB<vector>[N\(mi>M]\fP : the Nth through Mth elements <vector>.  Note
that the form \fB[N-M]\fP used in older versions will be interpreted
as N minus M.
.BI
For example, \fBarray[0\(mi>3]\fP specifies the first four elements in
\fBarray\fP.  \fBHidden:delta[2\(mi>5]\fP specifies the values of
delta's in the 2nd through 5th units in layer Hidden.
\fBarray[sizeof(array)-1]\fP specifies the last element of
\fBarray\fP.  Since an expression can contain a subscripted vector,
subscripts like \fBOutput[index[n]\(mi>index[n+1]]\fP are possible.
Here, \fPn\fP can be a float variable, or another expression
evaluating to a single value, which in turn may contain subscripts.
.EI
.NB
A matrix is specified by a matrix name, optionally followed by
subscript(s) and/or a range as explained below.  A matrix name is
either <matrix>, the name of a matrix, or <connection>, the name of a
connection, which specifies the weight matrix in the connection.
<connection>:delta specifies the change to the weights usually
computed by the action \fBlearn\fP.
.BI
A matrix can be subscripted as follows.  As in subscripts for a
vector, N, M, and K can each be either a positive integer, a variable
(float variables (not int variable), single element of vector or a
matrix) or an expression that evaluates to a single value.  A float
value is rounded into an int value.
.NI
\fB<matrix>[N]\fP : the Nth column of the matrix \fB<matrix>\fP, which
is a vector.
.NI
\fB<matrix>[N\(mi>M]\fP : a submatrix of <matrix> composed of the
Nth through Mth columns of <matrix>.
.NI
\fB<matrix>[N][M]\fP : the Mth element of the Nth column of
<matrix>, which is a single value.
.NI
\fB<matrix>[N][M\(mi>K]\fP : the Mth through Kth elements of the
Nth column of <matrix>, which is a vector.
.NI
\fB<connection>[N], <connection>[N][M]\fP and
\fB<connection>[N][M\(mi>K]\fP : \fB<connection>\fP is a connection name
and works the same way as matrices.  The first subscript \fBN\fP specifies
the unit receiving the connection.
.EE

.HE "expression" "expression syntax" VECTOR-HELP
.BB
Expressions are the most basic level of computation in SunNet.  In
procedures, <variable> = <expression> is used to assign the result of
evaluating <expression> into <variable>.  Also, many
SunNet commands accepts and evaluates an expression.
.BI
An expression consists of constants, variables, vectors, and matrices,
(vectors and matrices can be subscripted (see vectors)), combined with
the following set of operations, with the same priorities as in C
programming language.:
.Bi
Arithmetic operators: \(pl,  \(mi,  \(**,  \(sl,  ^  (power operator),
and \(**\(** (matrix product, see below)
.Ni
Comparison operators:  \(eq\(eq,  !\(eq,  >,  <,  >\(eq, and <\(eq
.Ni
Logical operators: &&, \(or\(or, &, and \(or
.NI
Various non-linear functions are available.  
Type \fBhelp function\fP for the list of functions. ~H
See help for \fBfunction\fP below for the list of functions. ~R
.NI
When an expression is evaluated, it yields either a constant, a
vector, or a matrix.  By default, the operators are applied in an
element-by-element manner.  For example, the result of evaluating an
expression of the form <vector1>+<vector2> is a vector whose elements
are the sums of the corresponding elements in <vector1> and <vector2>
(usual vector sum).
.NI
When two objects with different dimensions (e.g., a vector and a matrix,
or a variable and a vector) are combined with an operator, the object
with the lower dimension is duplicated as many times as necessary to make
it compatible with the higher dimension object.  For example, when an
expression of the form <vector>+<matrix> is evaluated, <vector> is added
to every row vector in <matrix> to yield a matrix as the result.
.NI
One exception to this rule is the matrix product operator
\(**\(**.  A\(**\(**B is interpreted as the product of two matrices
A and B.  The number of columns in matrix A must equal to the number
of rows in matrix B.  \fBA\(**\(**B\fP is a vector matrix
product if B has only one column and evaluates to another
column vector.  If B is a row vector, as vectors are by default,
\fBA\(**\(**T(B)\fP will achieve this (the function \fItranspose()\fP
or \fIT()\fP transposes a vector or a matrix.)  If A and B are both row vectors,
\fBT(A)\(**\(**B\fP is the outer product; and \fBA\(**\(**T(B)\fP is the inner product.
.NI
The logical and comparison operators evaluate to 1 (TRUE) or 0 (FALSE)
and they can be intermixed with the arithmetic operators.  For
example, the expression \fB(abs(targ-output)<0.5)*output\fP, where
\fBoutput\fP and \fBtarget\fP are vectors, evaluates to a vector which
is identical to \fBoutput\fP except those elements in \fBoutput\fP
that differ from corresponding elements in \fBtarget\fP by more than
0.5 are turned zero.  The expression \fBX&&Y\fP is TRUE if and only if
X != 0 and Y != 0.  \fBX\(or\(orY\fP is TRUE if and only if X != 0 or
Y != 0.  The semantics of the operations \fB&\fP and \fB\(or\fP
have not been decided yet.
.NI
Vectors and matrices can be subscripted by constants, any variables,
i.e., float variables, or single elements in vectors or matrices, or
any expressions which evaluate to single values.
Type \fBhelp vector\fP for details. ~H
See help for \fBvector\fP above for details. ~R
.NI
Like vectors and matrices an expression can also be subscripted.  For example,
\fBT(<matrix>)[N]\fP evaluates to a row vector which is identical to the Nth column 
of <matrix> which in turn is equivalent to \fBT(<matrix>[][N])\fP.
.NI
In the current implementation, when an expression is entered as an
argument for a command, it should not contain white spaces.  If the
system is configured to receive commands from a shell, it is a good
idea to surround any expression with a pair of single quotes, "'", in
order to keep the shell from interpreting the operators such as
\fB>\fP or \fB&\fP.  Expressions used in procedure definitions can contain
white spaces.
.EE

.CO "pattern" "read pattern file"	SETUP-COMMAND
.SY "pattern <file> / pattern"
.BI
\fBpattern <file>\fP reads in a set of input-target pairs from named
file.  Patterns are specified in the file using one of two formats:
digit representation or floating point number representation.
.Ni
In digit representation, which is the default, each line in the
pattern file consists of two strings of digits separated by white
space(s) representing a pair of input and target patterns.  Each digit
represents an activation level of an input or an output unit. \fI0\fP
corresponds to the minimum activation level and \fIa\fP (for decimal
10) corresponds to the maximum activation level, and other digits (1,
2, ..., 9) corresponds to intermediate activation levels.
.Ni
To change maximum/minimum activation levels, do \fBset min\fP and/or
\fBset max\fP BEFORE reading patterns with \fBpattern\fP.
.Ni
If \fIfloatpattern\fP is \fIon\fP, input/target patterns are specified
in pattern file as floating point numbers separated by white space(s).
The first line in the pattern file must consist of two integers (N and
M) specifing the lengths of input and target vectors, respectively.
Then, the next N strings are interpreted as N floating point numbers
specifying the first input pattern, the next M strings the first
target pattern, the N and the next M strings the second input and the
second target patterns, and so on until the end of the file.
.NI
Large pattern files may be compressed or compacted.  If the file name
ends with \fI.Z\fP, it is assumed to be a compressed file and is
automatically uncompressed.  A file ending with \fI.C\fP is
automatically uncompacted.
.NI
\fBpattern\fP prints current pattern file name, number of patterns,
and input/target sizes.
.NI
When the requested file name is the same as one of the files that have
been read so far and the file has not been modified since it was last
read, patterns stored internally are used instead of reading the file
again.  This allows rapid switching between pattern files.  A flag
"+read" can force reading from the disk.
.EE
**/
c_pattern( argn, args )
int	argn; char args[][ Largs ];
{
  FILE	*pfile;
  int	pipe=0, status;
  int	npat_prev;
  int	ptype;
  char	fname[BUFSIZE];
  struct stat	fstat;
  time_t date;

  if( argn < 1 ) {
    CheckPattern();
    sendMsg4("%d patterns from file %s: size %d input %d target.\n",
	     Npattern, PatFileName, N_input, N_target );
    return( OK );
  }
  if( argn>1 && EQL(args[1], "-D" ) && EQL( args[0], PatFileName )) return(OK);

  npat_prev = Npattern;
	/* check if there's the pattern file on disk */
  ptype = find_file( args, argn, PatternDir, fname, &fstat );

	/* check if patterns from same file has been stored */
  if( find_pattern( ptype? fname : args[0], PatFileName, &Npattern, 
		     &Input, &Target, &N_input, &N_target, &Plabel, &date )) {
    if( ptype && date < fstat.st_mtime ) {
		/* pattern was stored but older than disk file */
      sprintf(Msg,"file %s modified since last read. read again",PatFileName);
      if( !get_flag(argn,args,"+read") && !confirm( Msg )) {
	/* go ahead and use the stored patterns */
	sendMsg1("Use patterns from %s ..", PatFileName);
	ptype = NULL;	/* don't read file */
      }
    }
    else if( !get_flag(argn,args,"+read") ) { 
	/* pattern file not on disk or not modified since last read 
	 * and flag "+read" is not given -> use stored pattern */
      sendMsg1( "Use patterns from %s ..", PatFileName );
      ptype = NULL;	/* don't read file */
    }
  }	
		/* pattern not stored nor found on disk */
  else IfErr( ptype ) Erreturn1("cannot find pattern file %s", args[0]);

  if( ptype ) {		/* need to read pattern file */
    IfErr( pfile = open_file( fname, ptype ) )
      Erreturn1("cannot open file %s", fname);
    sendMsg1("Reading patterns from %s .. ", fname);
	/* BUG: need to clear PLabel here? */
    status = ( FloatPattern == ON )?
      read_float_pattern_file( pfile, &Npattern,&Input,&Target,
			      &N_input,&N_target,&Plabel ):
      read_pattern_file( pfile, &Npattern,&Input,&Target,
		      	      &N_input,&N_target,&Plabel);
    close_file(pfile, ptype);
    if ( Err( status ) &&
        !strncmp( ERR_MSG, "'set floatpattern", strlen("'set floatpattern"))) {
      sendMsg("Rereading as floating point pattern file..  ");
      IfErr( pfile = open_file( fname, ptype ) )
        Erreturn1("cannot open file %s", fname);
      status = read_float_pattern_file( pfile, &Npattern,&Input,&Target,
				        &N_input,&N_target,&Plabel );
      close_file(pfile, ptype);
    }
    IfErr( status ) Erreturn1("%s: cannot read patterns", ERR_MSG );

    strcpy( PatFileName, fname );
    	/* store patterns internally for later use */

    IfErr( store_pattern( args[0],  fname, Npattern, Input, Target, 
			  N_input, N_target, Plabel, fstat.st_mtime ) ) 
      return(ERR);
  }
	/* BUG - should take care of $err pointer when freeing ErrPattern */
  if( Npattern > npat_prev ) {
    if( ErrPattern ) free( ErrPattern );
    IfErr( ErrPattern = new_array_of( Npattern, NUMBER ) ) return( ERR );
  }
  sendMsg3("%d patterns.  size: %d input, %d target\n",
	   Npattern, N_input, N_target );
  if( OutFile && !get_flag(argn,args,"-save") ) { /* save pattern file name */
    strcpy( args[1], "-D" );        /* read pattern only when necessary */
    fprint_command( OutFile, "pattern", argn+1, args );
/*  OutFile_end = ftell( OutFile );*/
  }
  return( OK );
}
/**
.CO "nset" "set parameters and variables"	TOP-COMMAND
.SY "nset X Y [X Y ...]"
.BB
For each pair of arguments X and Y, X is set to the value of Y.
.BI
X can be a SunNet parameter, an int/float variable, a vector or a matrix.
A vector or a matrix can be subscripted by constants, float variables,
or expressions.
See the section for expression and vector/matrix specification. ~R
Type 'help expression' and 'help vector' for details. ~H
.NI
Y can be an int/float constant, 'on/off' (for binary parameters),
int/float variable, a vector, a matrix, or an arbitrary expression.
.NI
If X is a vector or a matrix and Y is a single variable or a constant, all
values in X are set to the value of Y.
.NI
Conversions between int and float are done automatically except that currently
an int parameter such as 'display' cannot be assigned an expression.
The value for a binary parameter must be \fIon\fP or \fIoff\fP.
.NI
If X does not exist, SunNet will try to create a data structure
appropriate for the type of Y.  This may not succeed in all cases,
for example if X is subscripted.
.EE
**/
c_nset( argn, args )
int	argn; char args[][ Largs ];
{
  register int i;
  char *index(), buf[ Largs ];
  EXPRESS *exprL, *exprR, *find_expression(), *find_variable_expression();
  int n0,n1;
  if( argn < 1 )  { print_all_parameters(); return( OK ); }
  if( argn < 2 )  Erreturn( get_syntax("set") );

  for( i=0; i+1 < argn; i+=2 ) {
    IF( args[i+1], "=" ) strcpy(args[i+1], args[i]), i++;

    if( which_parameter(args[i]) ) {
      if( is_float_parameter( args[i] ) )
	 /* change 'set parameter <expr>' to 'set $parameter <expr>' *
	  * BUG - see below */
	sprintf(args[i], "$%s", strcpy( buf, args[i] ));
      else if( set_parameter( args[i], args[i+1] )) {
	/* BUG - cannot set an int parameter (eg display) to expression */
	if( Quiet == OFF ) whatis_parameter( args[i] );
	continue;
      }
      else return( ERR );
    }
		/* parse and evaluate rhs expression */
    IfErr(eval_expression( exprR = find_expression(Net, args[i+1]))) {
      if( exprR ) delete_expression( exprR );
      return(ERR);
    }
		/* parse lhs expression */
    IfErr(exprL = find_variable_expression(Net, args[i])) {
      		/* undefined variable -> new variable or array */
      if( !isalpha(*args[i]) || index( args[i], '[' ) )
		/* name should start with an alphabet and cannot contain '[' */
	Erreturn2("%s: in %s", ERR_MSG, args[i]);
		/* make a single float variable */
      if( exprR->vector->nvalue == 1 ) {
	IfErr( make_float( Net, args[i], NULL )) return( ERR );
	sendMsg2("new variable %s = %s\n", args[i], args[i+1] );
      }
		/* vector -> make an array */
      else if ( exprR->vector->nvalue > 1 ) {
	IfErr( make_array( Net, args[i], exprR->vector->nvalue )) return(ERR);
	sendMsg2("new array %s[%d]\n", args[i], exprR->vector->nvalue );
      }
      else Erreturn1("%s: expression evaluates to no value?", args[i+1] );
      		/* we must have this variable now */
      IfErr(exprL = find_variable_expression( Net, args[i])) return(ERR);
    }
    IfErr( eval_expression( exprL ) ) 
      { if( exprL ) delete_expression( exprL ); return(ERR); }
    		/* both expressions have been evaluated successfully 
		 * now assign exprR to exprL.
		 */
    if( exprR->vector->nvalue == 1 ) 	/* assign single value to vector */
      set_vector_to_float( exprR->vector->value, exprL->vector->value,
			   &exprL->vector->nvalue );
    else {				/* assign vector to vector */
      n1 = min( exprR->vector->nvalue, exprL->vector->nvalue );
      copy_vector_( exprR->vector->value, exprL->vector->value, &n1 );
    }
    		/* we are done with these expressions */
    delete_expression( exprL ); delete_expression( exprR );
		/* save the change to savefile */
    if( OutFile ) {
      /* BUG - '$' attached to <parameter> is interpreted when read in */
      /* FIX - take off $ */
      if( *args[i]=='$' && is_float_parameter(args[i]+1) )
	strcpy(args[i], strcpy( buf, args[i]+1 ));
      fprint_command( OutFile, "set", 2, args[i] );
/*    OutFile_end = ftell( OutFile );*/
    }
  }
  return( OK );
}
/**
.CO "whatis" "print values of parameters and variables"	TOP-COMMAND
.SY "whatis {<parameter>/<variable>} ... "
.BB
Print current value(s) of SunNet parameter(s) or network variable(s)
defined in network file.
.EE
**/
c_whatis( argn, args )
int	argn; char args[][ Largs ];
{
  register int i;
  float x; int n;
  char str[Largs];
  PARA *paramP, *which_parameter();
  if( argn < 1 )  Erreturn( get_syntax( "whatis" ) );
  for( i=0 ; i< argn; i++ ) {
    if( paramP = which_parameter( args[i] ) ) {  /* SunNet parameters*/
      get_parameter_string( args[i], str );
      sendMsg3("\t%s (%s) = %s\n", paramP->name, paramP->longname, str );
    }
    else if( get_variable_string( Net, args[i], str ))	/* network variables*/
      sendMsg2("\tnetwork variable %s = %s\n", args[i], str );
    else sendMsg1( "\t%s not defined.\n", args[i] );
  }
  return( OK );
}
/**
.CO "listproc" "list actions in procedure"	SETUP-COMMAND
.SY "listproc <procedure>"
.BB
Lists actions in <procedure>.  Each action is printed in the form:
.BI
\fB<procedure>[action#] action arguments ...\fP  
.Ni
The actions in while loops, in repeat loops, and actions after 'if .. do'
statements are numbered separately.  Endif, endrepeat, and endwhile
are not printed.
.EE
*/
c_listproc( argn, args )
int	argn; char args[][ Largs ];
{
  PROCED *proc;
  if( argn < 1 ) Erreturn( get_syntax( "listproc" ));
  IfErr(proc=which_procedure( Net, args[0] )) return( ERR );
  list_actions( proc, 0 );
  return( OK );
}
/*
.CO "names" "print names of network objects"		SETUP-COMMAND
.SY "names <data type> ... / names file"
.BB
<data type> is one of \fBlayer, connection, array, float, int, variable,
procedure\fP, and \fBdefine\fP.  Takes a list of data types and prints the names
of the objects of each type defined in the current network.  E.g., \fBnames
layer float\fP prints the layer names and float variable names; \fBnames
scaler\fP prints scaler variable names;  \fBnames vector\fP prints vector
names; \fBnames matrix\ prints matrix names; \fBnames file\fP
prints the names of current network file, pattern file, output (save) file,
input (read) file, and print file.  \fBnames define\fP prints defined strings
and their substitutes (see network command \fBdefine\fP.)
.EE
*/
c_names( argn, args )
int	argn; char args[][ Largs ];
{
  register int i;
  for( i=0; i< argn; i++ ) {
    IF( args[0], "file" ) print_file_names();
    else {
      CheckNet();
      IfErr( print_network( Net, args[i] ) ) sendMsg1("%s.\n", ERR_MSG );
    }
  }
  return(OK);
}

print_network( net, what )
NETWORK *net; char *what;
{
  register int i;
  void print_define();

  IfErr( net ) Erreturn("network not defined");
  IfErr( what ) return( OK );
  IF( what, "layer" ) {
    beginMsg( "layers:");
    for( i=0; i<net->n_layer; i++ ) {
      checkMsg(strlen(net->layer[i].name)+10);
      addMsg2("\t%s[%d]", net->layer[i].name, net->layer[i].n_unit);
    }
    addMsg("\n"); endMsg();
  }
  else IF( what, "connection" ) {
    beginMsg("connections:");
    for( i=0 ; i<net->n_connect; i++ ) {
      checkMsg( strlen(net->connect[i].name)+20 );
      addMsg3("\t%s[%d][%d]", net->connect[i].name, 
	      net->connect[i].to_nunit, net->connect[i].from_nunit );
    }
    addMsg("\n"); endMsg();
  }
  else if( EQL( what, "vector") || EQL( what, "array" )) {
    beginMsg( "vectors:");
    for( i=0; i<net->n_array; i++ ) {
      checkMsg(strlen(net->array[i].name)+10);
      addMsg2("\t%s[%d]",net->array[i].name, net->array[i].n_value);
    }
    addMsg("\n"); endMsg();
  }
  else IF( what, "matrix" ) {
    beginMsg("matrices:");
    for( i=0; i<net->n_matrix; i++ ) {
      checkMsg(strlen(net->matrix[i].name)+20 ) ;
      addMsg3("\t%s[%d][%d]", net->matrix[i].name, 
	      net->matrix[i].n_row, net->matrix[i].n_col );
    }
    addMsg("\n"); endMsg();
  }
  else if(EQL(what, "scaler") || EQL( what, "float" )) {
    sendMsg("scalers:");
    for( i=0; i<net->n_floatvar; i++ ) {
      checkMsg(strlen(net->floatvar[i].name)+1);
      addMsg1("\t%s", net->floatvar[i].name );
    }
    addMsg("\n"); endMsg();
  }
  else IF( what, "int" ) {
    beginMsg("ints:");
    for( i=0; i<net->n_intvar; i++ ) {
      checkMsg(strlen(net->intvar[i].name)+1);
      addMsg1("\t%s",net->intvar[i].name );
    }
    addMsg("\n"); endMsg();
  }
  else IF( what, "procedure" ) {
    beginMsg("procedures:");
    for( i=0; i<net->n_procedure; i++ ) {
      IfErr( its_proc( net->procedure[i].name )) continue; /* not real proc*/
      checkMsg(strlen(net->procedure[i].name)+1);
      addMsg1("\t%s", net->procedure[i].name );
    }
    addMsg("\n"); endMsg();
  }
  else IF( what, "define" ) print_define( net );
  else IF( what, "variable" ) {
    print_network( net, "float");
    print_network( net, "int");
  }
  return( OK );
}

void print_file_names()
{
  char *fname, *whatis_print_file();
  addMsg1("  network file = %s\n", 
	   strlen(NetFileComm)? NetFileComm : "undefined" );
  addMsg1("  pattern file = %s\n",
	  strlen(PatFileName)? PatFileName : "undefined" );
  addMsg1("  output(save) file = %s\n",
	  strlen(OutFileName)? OutFileName : "undefined" );
  addMsg1("  input(read) file = %s\n",
	  strlen(InFileName)? InFileName : "undefined" );
  addMsg1("  print file = %s\n",
	  strlen(fname=whatis_print_file())? fname : "undefined" );
  endMsg();
}

/**
.CO "etascale" "set learning rate scale factor"	SETUP-COMMAND
.SY "etascale <layer> X / etascale <layer>"
.BI
\fBetascale <layer> X\fP sets the learning rate factor for <layer> to
X, which will scale (multiply) the learning rate (eta) when modifying
the weights in connections coming to the layer.  X must be a positive
number.  This can be used to make the learning rate dependent on the
fan-in of each layer.
.NI
\fBetascale <layer>\fP prints the current learning rate factor for the
layer.
.EE
**/
c_etascale( argn, args )
int	argn; char args[][ Largs ];
{
  LAYER *layerP;
  float etascale;
  if( argn < 1 ) Erreturn( get_syntax( "etascale" ) );
  IfErr( layerP = which_layer( Net, args[0] ) ) return( NULL );
  if( argn < 2 ) {
    sendMsg2("learning rate factor for %s is %g\n", args[0], layerP->etascale);
    return( OK );
  }
  if( Err( sscanf( args[1], "%f", &etascale ) || etascale < 0.0 ) )
    Erreturn1("%s: learning rate factor must be a positive number", args[1]);
  layerP->etascale = etascale;
  sendMsg2("learning rate scale for %s is set to %g\n",
	   args[0],layerP->etascale);
  return( OK );
}
/*
.CO "savefile" "open/close file to save network states"	SAVE-COMMAND
.SY "savefile <file> / savefile + / savefile close / savefile "
.BI
\fBsavefile <file>\fP opens <file> as the output file for
subsequently saving network states.  If the parameter \fIsave\fP is
set to N (>0, default=0), weights in the network and any items in
\fIsave list\fP are saved into the file after every N cycles while
running \fBcycle\fP.  See the command \fBsavelist\fP for how to set up
the save list.
.NI
If the parameter \fBsaveappend\fP is \fBon\fP, each saving is appended to the end
of the file, and if it is \fBoff\fP, each saving overwrites the previous one.
.NI
\fBsavefile +\fP can be used to subsequently save weights into the
current input (read) file (see the command \fBread\fP for how to open
an input file).  Writing to the file continues after the point it has
read so far.  This is useful for continuing training from a previously
saved session.  A compressed or compacted file cannot be continued.
.NI
\fBsavefile close\fP closes the current output file.
.NI
\fBsavefile\fP prints the name of the current save file.
.EE
*/
c_savefile( argn, args )
int	argn; char args[][ Largs ];
{
  struct stat fstat;
  char  fname[Nfilename];
  if( argn < 1 ) { 
    if( OutFile == NULL ) Erreturn("Save file not defined");
    sendMsg1("Save file = %s\n", OutFileName);
    return( OK );
  }
					 /* close current OutFile */
  IF( args[0], "close" ) {
    if( OutFile == NULL ) Erreturn("Save file not defined");
    fclose( OutFile ), strcpy( OutFileName, "" ), OutFile = NULL;
    StepSave = 0;
    return( OK );
  }
  	/* append to current position in InFile */
  IF( args[0], "+" ) {
    if( InFile == NULL ) Erreturn( "Input file not defined." );
    if( InFileType != Normal ) 
      Erreturn("cannot append to a compressed/compacted file");
    if( OutFile != NULL ) fclose( OutFile );
    OutFile = InFile ;
    strcpy( OutFileName, InFileName );
    sendMsg1( "\tweights will be saved in %s\n", OutFileName );
    OutFile_end = ftell( OutFile );
    return( OK );
  }
				/* file name is provided. open it  */
  if( OutFile != NULL ) fclose( OutFile );
  if( Normal == find_file( args, argn, WeightsDir, fname, &fstat ) &&
     !get_flag( argn, args, "+write" )) {
    sendMsg("overwrite file ");
    IfErr( confirm( fname )) return(ERR);
  }
  else strcpy( fname, args[0] );

  IfErr(OutFile=fopen( fname, "w")) Erreturn1("\tCannot write file %s.",fname);
  strcpy( OutFileName, fname );
  sendMsg1("\tweights will be saved in %s\n", OutFileName );

  fprintf( OutFile, "command set weight %g max %g min %g eta %g alpha %g\n", 
	  INITWEIGHT, MAXACTV, MINACTV, ETA, ALPHA ); 
  fprintf( OutFile, "command network %s -D -I -s%d\n",NetFileComm, get_seed());
  if(PatFileName[0]) fprintf( OutFile, "command pattern %s -D\n", PatFileName);
  OutFile_end = ftell( OutFile );

  return( OK );
}
/**
.CO "save" "save network states in file" SAVE-COMMAND
.SY "save {<vector>/<variable>} ... / save "
.BI
Saves vectors and/or variables in the network into the current output file.
.NI
\fBsave\fP saves the current set of weights and items in the save list, if any.
.Ni
See \fBsavefile\fP for how to open an output file, and \fBsavelist\fP
for how to set up the save list.
.EE
**/
c_save( argn, args )
int	argn; char args[][ Largs ];
{
  NUMBER *vector; int nvalue;
  register int n;
  if( OutFile == NULL ) Erreturn( "Use 'savefile <file>' to open save file");
  if( SaveAppend == OFF ) fseek( OutFile, OutFile_end, 0 );
  if( argn > 0 ) {
    for( n=0; n< argn; n++ ) {
      IfErr( vector = find_vector( Net, args[n], &nvalue ) ) return( ERR );
      IfErr( fprint_vector( OutFile, args[n], vector, nvalue, 0, "%g " ) ) 
	return( ERR );
/*    OutFile_end = ftell( OutFile );*/
    }
    return( OK );
  }
  OutFile_end = ftell( OutFile );
  fprint_items( OutFile );
/* OutFile_end = ftell( OutFile ); moved to two lines above */
  fprint_error( OutFile, (int)Step, Error );
  fprint_network_weight( OutFile, Net );
/*if( SaveAppend == ON ) OutFile_end = ftell( OutFile );*/
  sendMsg1("saved into file %s\n", OutFileName);
  return( OK );
}
/**
.HE "list" "common syntax for list commands"	LIST-HELP~H
.HE "list commands" "common syntax for list commands"	LIST-HELP~R
.BB
Syntax common to \fBsavelist\fP, \fBclist\fP, \fBprintlist\fP,
\fBdlist\fP, \fBglist\fP, and \fBplotlist\fP. \fBXlist\fP below means
any of these commands.
.BI
\fBXlist\fP prints all items in the list.  Items are numbered as 1, 2, 3,...
.NI
A \fI*\fP after a number means that the item is turned on (they are
all on initially).
.NI
\fBXlist \(mi n1 n2-n3 ..\fP turns off item #n1, item #n2 through #n3, ..
.NI
\fBXlist + n1 n2-n3 ..\fP turns them on.
.NI
\fBXlist \(mi all\fP turns all items off.
.NI
\fBXlist + all\fP turns all items on.
.NI
\fBXlist clear\fP removes all items from the list. 
.EE

.CO "savelist" "specify items to be saved"	LIST-COMMAND
.SY "savelist <vector> "
.BI
\fBsavelist\fP adds a vector to the list of items (save list) to be
saved during \fBcycle\fP or by the command \fBsave\fP.
.Ni
Type \fBhelp vector\fP for how to specify a vector. ~H
See \fBvector specification\fP for how to specify a vector. ~R
.Ni
Type \fBhelp list\fP for how to turn on/off or remove items.~H
See \fBlist commands\fP for how to turn on/off or remove itesm.~R
.Ni
If the parameter \fIsave\fP is set to N >0 (default=0),  items in save list
are saved after every N steps while running \fIcycle\fP. See help for
\fBsavefile\fP.
.EE
*/
c_savelist( argn, args )
int	argn; char args[][ Largs ];
{
  register int i;
  int    nitem;
  if( argn < 1 ) return( print_savelist_names() );
  if( EQL( args[0], "-" ) || EQL( args[0], "+" )) list( "Save", argn, args );
  else if( argn < 3 ) return( save_list( Net, args[0], args[1] )) ;
  else Erreturn( get_syntax( "savelist" ) );
  return( OK );
}
/**
.CO "comment" "write comment in save file"	SAVE-COMMAND
.SY "comment <comments>"
.BB
Writes a comment in the current save file. The number of words 
is limited to 15.
.EE
**/
c_comment( argn, args )
int	argn; char args[][ Largs ];
{
    IfErr( OutFile ) puts("Output file not opened: cannot write comment");
    fprint_command( OutFile? OutFile: stdout, "comment", argn, args );
    return( OK );
}
/**
.CO "read" "read in network states saved in file" SAVE-COMMAND
.SY "read <file>"
.BB
\fBRead <file>\fP opens named file <file> for reading in previously
saved network states, reads in network specification file creating new
network if different from the current network file, and reads in
patterns from pattern file if different from the current pattern file.
.BI
Network states at different steps (cycles) that are saved in the file
can be retrieved by \fBstep\fP.
.NI
Large save files may be compressed or compacted.  If the file name
ends with \fI.Z\fP, it is assumed to be a compressed file and is
automatically uncompressed.  If it ends with \fI.C\fP, it is
automatically uncompacted.
.EE
**/
c_read( argn, args )
int	argn; char args[][ Largs ];
{
  struct stat fstat;
  char   fname[BUFSIZE];
  if( argn < 1 ) Erreturn( get_syntax( "read" ));
			
  if( InFile ) close_file(InFile, InFileType);/* close current InFile */

  IfErr( InFileType = find_file( args, argn, WeightsDir, fname, &fstat )) 
    Erreturn1("cannot find file %s", args[0] );
  IfErr( InFile = open_file( fname, InFileType ) )
    Erreturn1("cannot open file %s", fname );

  strcpy( InFileName, fname ); 		/* name of InFile */

  sendMsg1("Reading weights from %s.\n", InFileName);
  Step = 0;
  IfErr( c_step( 1, "1" ) ) return(ERR);       /* read first set of weights */
  return( OK );				       /* OK if c_step() returns EOF */
}
/**
.CO "step" "read in next step from input file"	SAVE-COMMAND
.SY "step N / step"
.BI
\fBstep N\fP moves in current input file to the specified step # N and
reads in errors, weights, vectors and variables, if any, into network.
Interruptable at each step (interrupt level = cycle).
.NI
\fBstep\fP moves to next step in input file.
.EE
**/
c_step( argn, args )
int	argn; char args[][ Largs ];
{
  int	step_to_find,step ;
  int	status;
  IfErr(InFile) Erreturn( "Input file not defined. Do 'read file'");
  if(argn==0) step_to_find  = (int)Step + 1;		/* no argument */
  else if( AtoI( args[0], step_to_find  ) !=1 ) 
    Erreturn1( "invalid step # %s", args[0]);

  if( Step > step_to_find  ) { /* need to move back -> 
				   goto beginnig and move forward */
    if( InFileType == Normal ) {
      IfErr( InFile=freopen( InFileName, "r+", InFile ) ) 
	Erreturn1("can't read file %s.", InFileName);
    }
    else {
      if( InFile ) pclose( InFile );
      IfErr( InFile= open_file( InFileName, InFileType ) ) 
	Erreturn1("can't read file %s.", InFileName);
    }
    Step = -1 ;
  }
			/* move forward in InFile until step becomes \
			\ equal or greater than the specified #.    */
  while( Step < step_to_find  ) {
    IfErr( status = readWeightFile(InFile,&Net,&Step,&Error))
      Erreturn2("%s: in %s", ERR_MSG, InFileName );
    if( status == EOF ) { sendMsg("\tEnd of file.\n"); break; }
    if( status == READWEIGHTS ) {		/* weights were read in */
      clear_dweight( Net );	/* clear previous weight change in connection*/
      sendMsg1("\tweights read at epoch = %d\n", (int)Step );
    }
  }
  sendMsg2("\tepoch=%d Error=%f\n", (int)Step, Error);
  return(OK);
}
#if sunnet|planet|xnet|mgr
/**
.CO "error" "plots in graph errors in input file" SAVE-COMMAND
.SY "error [start_step]"
.BB
Plots errors stored in the current input (read) file in graph. Graph
must be initialized first.  See command \fBgraph\fP for how to
initialize a graph.
.EE
**/
c_error( argn, args )
int	argn; char args[][ Largs ];
{
int	status;
int	line_type = 0;
int	start_step = 0 ;
    if( InFile == NULL ) 
	{ Erreturn("input file not defined. do 'read <file>'"); }
    CheckNet();
    if( Graph == NULL ) { Erreturn("graph not initialized"); }

    if( argn > 0 && Err(AtoI( args[0], start_step ))) 
      Erreturn1("invalid line type %s", args[0] );
    if( argn > 1 && Err(AtoI( args[1], line_type ))) 
      Erreturn1("invalid line type %s", args[1] );
    IfErr( plot_error( Graph, 0, 0, 0.0, 0 ) )
      Erreturn1("%s: cannot initialize plot", ERR_MSG);
    while( (status = c_step( 0 , "" )) != EOF ) {
      IfErr( status ) return( NULL );
      IfErr( plot_error( Graph, 0, (int)Step + start_step,
	    (GraphLog==ON)?(float) log10((double) Error): Error, line_type ))
	Erreturn1("%s: in plotting", ERR_MSG);
    }
    return( OK );
}
#endif sunnet
/*
.CO "printfile" "open/close file to print"	PRINT-COMMAND
.SY "printfile <file> / printfile close / printfile"
.BI
\fBprintfile <file>\fP opens a print file.  
.Ni
While a print file is open, whenever the items in print list are
printed (by the command \fBprint\fP, \fBpresent\fP, or during \fBcycle\fP if
parameter \fIprint\fP is >0) they are also printed into the file.  See
command \fBprintlist\fP, and \fBprint\fP.
.NI
\fBprintfile close\fP closes the current print file.  
.NI
\fBprintfile\fP prints the name of the current print file.
.EE
*/
c_printfile( argn, args )
int	argn; char args[][ Largs ];
{
  char *fname, *whatis_print_file();
  if( argn < 1 ) { 
    sendMsg1("\tprint file = %s\n", 
	     strlen( fname=whatis_print_file())? fname : "undefined");
    return( OK ); 
  }
  IF( args[0] , "close" ) return(close_print_file());
  
  IfErr( open_print_file( args[0] ) ) return( ERR );
  sendMsg1("\tprint to file %s.\n", args[0] );
  return( OK );
}
/**
.CO "print" "print network states"	PRINT-COMMAND
.SY "print {<vector>/<connection>/<expression>} [c(olumn)N] [p(recision)M] / print"
.BI
\fBprint <vector>\fP prints all values in <vector>. \fBprint
<connection>\fP prints the weight matrix in <connection>. \fBprint
<expression>\fP evaluates <expression> and prints the result.
See the section on \fBvector\fP and on \fBexpression\fP.~R
Type 'help vector' or 'help expression' for vector/expression syntax. ~H
.NI
A flag \fBcN\fP or \fBcolumnN\fP specifies the number of columns to print
on each line.  If N is 0, no new-line is printed until the end of the vector.
If N < 0, no new-line is printed even at the end of the vector.
.NI
A flag \fBpN\fP or \fBprecisionN\fP specifies the precision.
.NI
\fBprint <connection>\fP prints the weight matrix in <connection>.
Nth row corresponds to the weights going into the nth unit receiving
<connection>.  The right-most column of each row is the bias of that unit.
.NI
\fBprint\fP prints the items in the \fIprint list\fP.  See
command \fBprintlist\fP for details.
.EE
**/
c_print( argn, args )
int	argn; char args[][ Largs ];
{
  int ncol=0, precision=0;
  if( argn < 1 ) return( print_items() );
  if( argn > 1 ) {
    get_flag_i( argn-1, args[1], "c%d", &ncol );
    get_flag_i( argn-1, args[1], "column%d", &ncol );
    get_flag_i( argn-1, args[1], "p%d", &precision );
    get_flag_i( argn-1, args[1], "precision%d", &precision );
  }
  return( print_it( Net, args[0], ncol, precision ) );
}
/**
.CO "printf" "formatted print"	PRINT-COMMAND
.SY "printf fmt {<vector>/<connection>/<expression>} [c(olumn)N]"
.BI
\fBprintf\fP prints its second argument using the first argument as the 
format specification.  \fBfmt\fP has the same syntax as that of printf()
function in C except it can contain only one item.  \fBfmt\fP can contain
arbitrary character string which will be printed.  '\\s', '\\t', and '\\n'
are replaced by a space, a tab, and a new-line, respectively.
.NI
\fBprintf fmt <vector>\fP prints all values in <vector>. \fBprintf
<connection>\fP prints the weight matrix in <connection>. \fBprintf
<expression>\fP evaluates <expression> and prints the result.
In these cases, \fBfmt\fP is applied to each element in the vector or matrix.
See the section on \fBvector\fP and on \fBexpression\fP.~R
Type 'help vector' or 'help expression' for vector/expression syntax. ~H
.NI
A flag \fBcN\fP or \fBcolumnN\fP specifies the number of columns to print
on each line.  If N is 0, no new-line is printed until the end of the vector.
If N < 0, no new-line is printed even at the end of the vector.  This is
the default.
.NI
The precision can be specified in \fBfmt\fP.
.NI
<connection> is printed in the same way as with the 'print' command
with the biases of the receiving units printed in the right-most column.
.EE
**/
c_printf(argn, args )
int	argn; char args[][ Largs ];
{
  int i,ncol= -1; 	/* default is no newline for printf */
  int nwin;
  char *fmt, str[BUFSIZE],*it,*fmt_next,*it_next;
  if( argn < 1 ) Erreturn("syntax: printf fmt [<expr>/string]");
  replace_escape( args[0] );

  if( argn==1 ) { sendMsg( args[0] ); return( OK ); }
  get_flag_i( argn-2, args[2], "c%d", &ncol );
  get_flag_i( argn-2, args[2], "column%d", &ncol );
#if xnet|sunnet|planet
  if( get_flag_i( argn-1, args[1], "w%d", &nwin ) ||
      get_flag_i( argn-1, args[1], "window%d", &nwin ) ) {
    IfErr(sprintf_it(str,Net,args[1],args[0],ncol)) return(ERR);
    strcpy( args[argn+1], str );
    sprintf( args[argn], "%d", nwin );
    return( c_echo( 2, args[argn] ) );
  }
#endif
  return( printf_it( Net, args[1], args[0], ncol ));
}

replace_escape( str )
  char *str;
{
  char *escape, *index();
  for( escape=str; escape=index( escape, '\\'); ++escape ) {
    switch(*(escape+1)) {
    case 'n': replace_string( escape, "\n", 2); break; 
    case 't': replace_string( escape, "\t", 2); break; 
    case 'b': replace_string( escape, "\b", 2); break; 
    case '0': replace_string( escape, "\0", 2); break; 
    case 's': replace_string( escape, " ", 2); break; 
    case '%': replace_string( escape, "%", 2); break; 
    case '\\': replace_string( escape, "\\", 2); break;
    }
  }
}
/**
.CO "printlist" "specify items to be printed"	LIST-COMMAND
.SY "printlist {<vector>/<connection>/<expression>} [c(olumn)N] [p(recision)M]"
.BI
Adds an item to the list of items to be printed after each
presentation (present) or by the command \fBprint\fP.  An item is
either a vector or a connection.
Type 'help vector' or 'help expression' for vector/expression syntax.~H
See the sections on \fBvector\fP and \fBexpression\fP.~R
.Ni
A flag \fBcN\fP or \fBcolumnN\fP specifies the number of columns to print
on each line.  If N is 0, no new-line is printed until the end of the vector.
If N < 0, no new-line is printed even at the end of the vector.
.Ni
A flag \fBpN\fP or \fBprecisionN\fP specifies the precision.
.Ni
If the parameter \fIprint\fP is set to N >0 (default=1), items in
print list are printed after every N steps while running \fBcycle\fP.
See also command \fBprintfile\fP.
.NI
\fBprintlist\fP, without argument, prints a numbered list of current
items.  A \fI*\fP after a number means that that item is turned on.
.Ni
Type \fBhelp list\fP for how to turn on/off or remove items.~H
See \fBlist commands\fP for how to turn on/off or remove itesm.~R
.EE
**/
c_printlist( argn, args )
int	argn; char args[][ Largs ];
{
  register int i;
  int    ncol=0, precision=0;

  if( argn < 1 ) return( print_printlist_names() );
  if( argn == 1 && EQL(args[0], "command")) return(print_printlist_commands());
  if( EQL(args[0], "+") || EQL(args[0], "-") )
    return(list( "Print", argn, args ));
  if( argn > 1 ) {
    get_flag_i( argn-1, args[1], "c%d", &ncol );
    get_flag_i( argn-1, args[1], "column%d", &ncol );
    get_flag_i( argn-1, args[1], "p%d", &precision );
    get_flag_i( argn-1, args[1], "precision%d", &precision );
  }
  return( print_list( Net, args[0], ncol, precision ) );
}
/*
.CO "value" "read in values into a vector/matrix"
.SY "value {<vector>/<matrix>}"
.BB
\fBvalue\fP reads in values into a vector or a matrix from the
standard input (usually the keyboard).  The input is terminated when a
sufficient number of values have been read, or the end-of-file
character (usually Ctrl-D) or a "." by itself on a line is read.  If
the system is configured to receive commands from a shell, the output
of another program can be piped to \fBvalue\fP.
.EE
*/
c_value( argn, args )
     int argn; char args[][ Largs ];
{
  VECTOR *vector; int nvector, nval;
  if( argn < 1 ) Erreturn("syntax: value <vector>");
  IfErr( vector = (eval_expression(find_expression( Net, args[0] ))))
    return( ERR );
  IfErr( nval = read_vector( vector->value, vector->nvalue )) return( ERR );
  if( nval < vector->nvalue ) {
    addMsg2("warning: only %d values read into %s.\n",nval, args[0]);endMsg();
  }
  return(OK);
}
/**
.CO "clist" "specify list of commands to be executed"	LIST-COMMAND
.SY "clist <command> argument ... /clist do {all/{N/N-M ...}} "
.BI
\fBclist <command> <arguments>\fP puts a command line into the command list.
.NI
\fBclist do item#s\fP executes some items in the list. Item #s are specified
as a list of numbers and ranges of numbers as in \fBclist do 1 4-6 3\fP.
.NI
\fBclist do\fP or \fBclist do all\fP executes all items.
.Ni
Set \fIcommand\fP to N to execute command list at every N steps during
\fBcycle\fP.
.NI
\fBclist\fP prints items in command list.  \fB*\fP indicates an
item is turned on.
.Ni
Type \fBhelp list\fP for how to turn on/off or remove items.~H
See \fBlist commands\fP for how to turn on/off or remove itesm.~R
.EE
**/
c_clist( argn, args ) 
int	argn;
char args[][Largs]; 
{
  register int i;
  int nitem, n1, n2;
  if( argn < 1 ) { print_clist(); return( OK ); }
  if( argn == 1 && EQL(args[0], "command") ) return( print_clist_commands() );
  IF( args[0], "do" ) {
    if( argn == 1 || EQL( args[1], "all" )) return( exec_clist( 0 ) );
    for( i=1; i<argn; i++ ) {
      if (Err( find_range( args[i], &n1, &n2 ) || n1 < 1 || n2 < 1 ))
	Erreturn1("%s: invalid item #\n", args[i] );
      for( nitem=n1; nitem <= n2; nitem++ )
	IfErr( exec_clist(nitem)) return( ERR );
    }
    return(OK);
  }
  if( EQL(args[0], "+") || EQL(args[0], "-")) 
    return(list( "Command", argn, args ));
  return( command_list( args[0], argn-1, args[1] ) );
}
/*
.CO "wait" "stop and wait for input"	TOP-COMMAND
.SY "wait"
.BB
Waits until something is typed in from the keyboard.  Userful in command 
scripts.  \fBwait click\fP means to wait for a mouse click instead of
keyboard input.
.EE
*/
c_wait( argn, args )
int	argn;
char args[][Largs]; 
{
  int quiet = get_flag(argn, args, "quiet");
  if( !quiet ) sendMsg( "-> ");
#if sunnet|xnet|mgr
  if( argn && get_flag( argn, args, "click" )) {
    wait_any_button();
    if( !quiet) sendMsg("\n");
  }
  else 
#endif
    getUserInput( Msg, sizeof(Msg) );
  return( OK );
}

void save_net_and_quit(err)
int err;
{
  char fname[BUFSIZE], str[BUFSIZE];
  void end_port(), end_socket();
  switch( err ) {
  case SIGILL: beginMsg( "Illegal instruction\n" ); break;
  case SIGBUS: beginMsg( "Bus Error\n" ); break;
  case SIGFPE: beginMsg( "Floating point exception\n" ); break;
  case SIGSEGV:beginMsg( "Segmentation violation\n" ); break;
  case SIGSYS: beginMsg( "Error in system call\n" ); break;
  }
  addMsg("SunNet: cannot continue execution.\n");
  endMsg();
  if( confirm("Should I try to save the network") ) {
    IfErr( OutFile ) {
      if( askUserInput(strcpy(Msg,"to file: "), sizeof(Msg), 
		       Msg, sizeof(Msg) )) {
	IfErr( c_savefile( 1, Msg ) ) {
	  sendMsg1("%s: couldn't open file for saving.\n", ERR_MSG );
	  finish( 1 );
	}
	sendMsg1( "\tSaving the network in file %s.\n", OutFileName );
      }
    }
    fprint_items( OutFile );
    fprint_error( OutFile, (int)Step, Error );
    fprint_network_weight( OutFile, Net );
    sendMsg1("\tSaving successful. Restart SunNet and type 'read %s'.\n",
	     OutFileName );
  }
  if( confirm("dump core for debugging") ) {
#ifdef shellinput
    end_port(ERR); end_socket();
#endif
    signal( SIGILL, SIG_DFL ); abort();
  }
  finish( 1 );
}

void caught_ill() { save_net_and_quit( SIGILL ); }
void caught_fpe() { save_net_and_quit( SIGFPE ); }
void caught_bus() { save_net_and_quit( SIGBUS ); }
void caught_segv() { save_net_and_quit( SIGSEGV ); }
void caught_sys() { save_net_and_quit( SIGSYS ); }

void catch_signal()
{
  static int setup = 0;
  if( setup ) return;
  signal( SIGILL, caught_ill );
  signal( SIGFPE, caught_fpe );
  signal( SIGBUS, caught_bus );
  signal( SIGSEGV, caught_segv );
  signal( SIGSYS, caught_sys );
  setup = 1;
}

get_flag( argn, args, str )
int	argn;
char args[][Largs]; 
char *str;
{
  register int n;
  for( n=0; n< argn; n++) IF(args[n], str ) return( OK );
  return( ERR );
}

get_flag_i( argn, args, fmt, ip )
int	argn;
char args[][Largs]; 
char *fmt;
int *ip;
{
  register int n;
  for( n=0; n< argn; n++) if(sscanf(args[n], fmt, ip )) return( OK );
  return( ERR );
}

get_flag_ii( argn, args, fmt, ip, jp )
int	argn;
char args[][Largs]; 
char *fmt;
int *ip, *jp;
{
  register int n;
  for( n=0; n< argn; n++) if(2==sscanf(args[n], fmt, ip, jp )) return( OK );
  return( ERR );
}

get_flag_f( argn, args, fmt, fp )
int	argn;
char args[][Largs]; 
char *fmt;
float *fp;
{
  register int n;
  for( n=0; n< argn; n++) if(sscanf(args[n], fmt, fp )) return( OK );
  return( ERR );
}

get_flag_ff( argn, args, fmt, f1, f2 )
int	argn;
char args[][Largs]; 
char *fmt;
float *f1,*f2;
{
  register int n;
  for( n=0; n< argn; n++) if(sscanf(args[n], fmt, f1,f2 )==2) return( OK );
  return( ERR );
}

get_flag_fff( argn, args, fmt, f1, f2, f3 )
int	argn;
char args[][Largs]; 
char *fmt;
float *f1,*f2,*f3;
{
  register int n;
  for( n=0; n< argn; n++) if(sscanf(args[n], fmt, f1,f2,f3 )==3) return( OK );
  return( ERR );
}

get_flag_s( argn, args, fmt, str )
int	argn;
char args[][Largs]; 
char *fmt;
char *str;
{
  register int n;
  for( n=0; n< argn; n++) if(sscanf(args[n], fmt, str )) return( OK );
  return( ERR );
}

cmp_str( s1, s2 )	/* returns no. of matching chars */
char *s1, *s2;
{
  int n;
  for( n=0; *s1, *s2, *s1 == *s2; s1++, s2++, n++ );
  return( n );
}
