/* $Header: /soma/users/miyata/planet/src/RCS/rand.c,v 5.6.0.4 91/02/13 15:41:39 miyata Exp $ */
static char rcsid[] = "$Header: /soma/users/miyata/planet/src/RCS/rand.c,v 5.6.0.4 91/02/13 15:41:39 miyata Exp $";

/*		Copyright (c) 1981 Gary Perlman
This software may be copied freely provided:  (1) it is not used for
personal or material gain, and (2) this notice accompanies each copy.

Disclaimer:  No guarantees of performance accompany this software,
nor is any responsbility assumed on the part of the author.  All the
software has been tested extensively and every effort has been made to
insure its reliability.*/

long random ();

#if	mac|hp		/* Mac II or Bobcat */

#define	random		rand
#define	srandom		srand
#define DIVISOR		32768.0		/* rand() returns 16 bits on Mac II */

#endif	

#ifdef allie
#define DIVISOR		2147483648.0
#endif

#ifndef DIVISOR
#define DIVISOR (4==sizeof(int)? 2147483648.0:32768.0)
#endif

double	divisor = DIVISOR;
	/* the divisor is used to map integers returned by random()
	 * to between zero and one.  It is one larger than the
	 * largest integer on a machine
	 */

char	*malloc ();
static	unseeded = 1;
long	time ();
	/* permut randomizes the order of the elements of array.
	 * array is the base address of the elts to be permuted,
	 * nelem is the number of elements to be permuted, and
	 * width is the size of one array element, so a normal call
	 * would be:
	 * 	permut (order, nstim, sizeof (*order));
	 */
permut (array, nelem, width) char *array;
	{
	char	*temp = malloc ((unsigned) width);
	register j;
	char	*aptr, *rptr;
	int	i;
	if (nelem <= 1 || width < 1) return (1);
	if (unseeded) srandom ((int) time (unseeded = 0));
	for (i = 0; i < nelem-1; i++)
		{
		aptr = array + i*width;
		rptr = aptr + ((int) ((random() / divisor) * (nelem - i)))*width;
		if (aptr != rptr)
		    for (j = 0; j < width; j++)
			{
			temp[j] = aptr[j];
			aptr[j] = rptr[j];
			rptr[j] = temp[j];
			}
		}
	return (0);
	}

	/* urandom returns integers uniformly distributed between low and high
	 * random resets the random number generator if necessary
	 */
urandom (low, high) int low, high;
	{
	if (unseeded) srandom ((int) time (unseeded = 0));
	return ((int) ((random() / divisor) * (high - low + 1) + low));
	}

	/* nrandom returns normal random numbers with mean zero and
	 * variance one using the algorithm in Hastings and Peacock's
	 * "Statistical Distributions"
	 */

double
nrandom ()
	{
	double	sum = 0.0;
	int	i;
	if (unseeded) srandom ((int) time (unseeded = 0));
	for (i = 1; i <= 12; i++)
		sum += random();
	return (sum/divisor-6.);
	}

static int seed;

get_seed()
{
  return( seed );
}

void
seedrandom( s )
int s;
{
  srandom( seed = s ); unseeded = 0;
}

newseed( ) 
{
  srandom( seed = (int) time (0) / urandom( 1, 10 ) ); unseeded = 0;
  return( seed );	/* divide by urandom to get different seed *\
			\* even when time is close		   */
}
