/* $Header: /soma/users/miyata/planet/src/RCS/procedure.c,v 5.6.0.5 91/02/13 15:41:36 miyata Exp $ */
static char rcsid[] = "$Header: /soma/users/miyata/planet/src/RCS/procedure.c,v 5.6.0.5 91/02/13 15:41:36 miyata Exp $";
/**************** UPDATES *************************************************
procedure.c:
11/5/90 fixed bug: 'next' works even with last action in procedure.
10/18/90 fixed bug: dont stop after exit from interrupt.
10/3/90 procedure can be passed to subprocedure as argument - now all 
	subprocedures are exe'ed by executeAprocCheck().
10/1/90 multiple library files.
6/10/90 implemented procedure arguments (layer/connect/expression)
5/4/90  implemented procedure arguments (layer/connect/matrix/vector).
4/30/90 if a procedure is undefined search library file.
	find_library_procedure().
4/28/90 implemented procedure arguments (vector only). execute_procedure_args()
***************************************************************************/
#include <stdio.h>
#include <sys/types.h>	/* for */
#include <sys/stat.h>	/* fstat */
#include "net.h"
#include "command.h"
#include "error.h"
#include "setup.h"
#include "msg.h"
#include "alloc.h"
#include "files.h"	/* file types */
#include "lib.h"	/* library file directory */
#include "userdefs.h"   /* for NetDir for library file */

extern BINARY DeBug;
extern NETWORK *Net;
void list_actions();
void deleteProcArgs();
void *onintr();

execute_procedure ( proc )
PROCED	*proc;
{
  register int i;
  ACTION	*actionP ;
  PROCED *origScope, *setScope();
  char  **arg;
  int	itsProc;
  int	n_action;
  int   status = OK;
  BINARY stopNext=OFF;
			  /* these are flags used for debugging */
  static int globalstop = 0; /* indicates stopping in every procedure */
  int   localstop;   /* stopping point in debugging -only this procedure*/
  			/* top procedure - set flag for debugging */
  if( proc == NULL ) { globalstop = DeBug==ON? 1:0; return(OK); }
  Starting(inProc);		/* we're inside procedure - for interrupt */
  localstop = proc->n_action;	/* don't stop unless told */
  if(itsProc = its_proc( proc->name ))	/* whether its a real procedure */
    origScope = setScope( proc );

  n_action = proc->n_action ;
  actionP = proc->action ;
  for ( i=0; i < n_action ; i++, actionP++ ) {
#if xnet
    if( clickInterrupt() ) onintr();
#endif
    if(INTERRUPT == INTR_ACT || DeBug == ON || globalstop ) {
      /*enter debug mode*/
      if( INTERRUPT == INTR_ACT ) globalstop = 1; /*override previous 'cont' */
      status=debug( proc, i, &localstop, &globalstop); /*debug returns status*/
      if( status == SKIP ) continue;		/* skip next action */
      if( status == END ) {			/* end this procedure */
	if( itsProc ) setScope( origScope ); 
	Ending(inProc); return( OK );
      }
      if( localstop == -END ) stopNext = ON;
      if( status != OK ) {	/* stop or error */
	if( itsProc ) setScope( origScope ); Ending(inProc); return( status );
      }
    }
    arg = actionP->args; 
    switch( actionP->argn ) {
    case 1:
      status = (*actionP->func)(arg[0]); 			    break;
    case 2:
      status = (*actionP->func)(arg[0],arg[1]); 		    break;
    case 3:
      status = (*actionP->func)(arg[0],arg[1],arg[2]);  	    break;
    case 4:
      status = (*actionP->func)(arg[0],arg[1],arg[2],arg[3]);       break;
    case 5:
      status = (*actionP->func)(arg[0],arg[1],arg[2],arg[3],arg[4]); break;
    case 6:
      status = (*actionP->func)(arg[0],arg[1],arg[2],arg[3],arg[4],arg[5]); 
      break;
    case 7:
      status = (*actionP->func)(arg[0],arg[1],arg[2],arg[3],arg[4],arg[5],arg[6]); 
      break;
    case 0:
      status = (*actionP->func)( ) ; break;
    default:
      status = ( *actionP->func ) ( arg[0] );
    }

      /* 'next' on last action -> stop in next procedure */
/*    if( localstop== -END ) globalstop = 1; */

    if( status == OK ) continue;
    if( status == SKIP ) { 			/* skip next action */
      i++ ;
      actionP++ ;
      continue;
    }

 /* if an action returns 'end' in a real procedure, as opposed to a *
  *   pseudo-procedure, such as 'while', 'if', terminate it with  *
  *   'ok' so that calling procedure can proceed normally.	   *
  * if 'end' is returned but not in a real procedure, return 'end' *
  *   so that it can be caught in a procedure at higher level *
  * 'endwhile', 'endrepeat', and 'endif', are caught in the functions that *
  *   implement them, ie, while_do(), etc. in net.c */

    if( itsProc ) setScope( origScope );
    Ending(inProc); 
    if(status==END) return( itsProc? OK:status );
    else if(status == ERR ) Erreturn2("%s: in %s",ERR_MSG,actionP->name );
    return( status );
  }
  if( itsProc ) setScope( origScope );
  if( stopNext==ON ) globalstop = 1;
  Ending(inProc);
  return ( OK );
}

its_proc( name )	/* OK if its a real procedure, ERR otherwise */
char *name;
{
  char *s1, *rindex(); int n;
  IfErr( name ) return( ERR );
  if((s1 = rindex( name, '.' )) && 
     (sscanf( s1, ".if%d",  &n ) ||
      sscanf( s1, ".else%d", &n ) ||
      sscanf( s1, ".while%d", &n ) ||
      sscanf( s1, ".repeat%d", &n ) ))  return( ERR );
  return( OK );
}

/*
.HE "debug" "commands in debug-mode"	RUN-HELP
.BB
If \fIdebug\fP is set to \fIon\fP, or after interrupted at the procedure
level, execution of procedure by commands
\fBcycle, present,\fP or \fBexec\fP is done in \fIdebug mode\fP:
execution stops before each action in procedure (the next action is
printed). Any \fBSunNet\fP command except \fBnetwork\fP can be executed.
In addition, the following special \fIdebug\fP commands are available:
.BI
Simply hitting the \fIreturn\fP key will execute the next action.
.NI
\fBnext\fP is same as \fIreturn\fP except it does not stop in subprocedures,
in while loops, or in \fIif .. then\fP statements. 
.NI
\fBcont\fP turns off debugging mode and continues execution.
.NI
\fBcont N\fP (N\(>=0) continues execution and stops before action # N.
.NI
\fBcont until<expression>\fP continues execution until <expression> is 1.
.NI
\fBskip\fP skips the next action and stops before the following action.
.NI
\fBend\fP ends current procedure without executing the actions.
.NI
\fBexit\fP returns to top-level immediately.
.NI
\fBlist\fP lists actions in the current procedure.  Note that \fIwhile\fP
loops, \fIrepeat\fP loops, and \fIif .. do\fP statements are treated as
subprocedures, and actions in them are numbered separately.  Also,
\fIendwhile\fP, \fIendrepeat\fP, \fIelse\fP and \fIendif\fP are not listed.
.NI
\fBwhere\fP prints the current procedure name, the next action #, and action.
.NI
\fBcall <procedure>\fP calls <procedure>.  This is same as the action 
\fBcall\fP, and different from the command \fBexec\fP which clears net inputs
and deltas in the network before executing the procedure.
.EE
*/
debug( proc, naction, localstop, globalstop )
PROCED *proc; int naction, *localstop, *globalstop;
{
  char  command[Lcomm], args[Nargs][Largs];	/* command and arguments */
  int   argn;					/* # of arguments	 */
  char  buf[BUFSIZE], *line, *next_line;
  int   status;
  static EXPRESS *stopif=NULL;
  PROCED *procP, *which_procedure();
  if( !*globalstop && naction < *localstop &&
      (Err(stopif)|| Err(true_expression(stopif)) )) return(OK);
  *globalstop =1; *localstop = proc->n_action ;
  if(stopif) delete_expression(stopif), stopif=NULL;

  sendMsg1("next action \"%s\"\n", proc->action[naction].name );
  while(1) {
   sendMsg2( "%s[%d]", proc->name, naction );
   INTERRUPT = 0; ERR_MSG[0] = NULL;
   IfErr(getUserInput(buf,sizeof(buf))) return(ERR);

   for( line = buf; line ; line = next_line ) {
    substitute_alias( line, Alias );
    handle_quote(line, &next_line);
    parse_command( line, command, &argn, args );

    IF( command, "" ) return(OK);	/* execute next action */
    IF( command, "where" ) {	/* print procedure name, action #, action */
      sendMsg3("%s[%d] \"%s\"\n", 
	       proc->name,naction, proc->action[naction].name);
      continue;
    }	/* BUG: 'next' doesn't work for last action in procedure -won't stop.*/
	/* problem- cannot set stopping point in next procedure call */
    	/* FIX: return -END if we need to stop in next procedure call *
	 * this will set globalstop=1 when this procedure is done in *
	 * execute_procedure(). */
    IF( command, "next" )    /* continue until the next action */
      { *localstop = naction==proc->n_action-1? -END : naction+1; 
	*globalstop = 0; return(OK); } 	/* -END to stop in next procedure */
    IF( command, "cont" ) {  
      if( argn ) {	/* continue (up to action # if given) */
	if(sscanf( args[0], "%d", localstop )) {
	  if( *localstop <0 || *localstop >= proc->n_action ) {
	    sendMsg1("%s: invalid action # for stopping.\n", args[0]); continue;
	  }
	}
	else if(strncmp( args[0], "until", 5 )==0) {
	  IfErr(args[0]+5) {
	    sendMsg("syntax: cont until<expression>"); continue;
	  }
	  IfErr( stopif = find_optimize_expression(Net,args[0]+5) ) {
	    sendMsg1("%s: invalid stopping criterion.\n", args[0]); continue;
	  }
	}
	else {
	  sendMsg("syntax: cont N / cont until(expression)"); continue;
	}
      }
      *globalstop = 0; return(OK);
    }
    IF( command, "exit" )  /* return to top-level */
      { *globalstop=0; Erreturn("exit");}
    IF( command, "end" ) return( END );	/* end this procedure */
    IF( command, "skip" ) return( SKIP ); 	/* skip this action */
    IF( command, "list" ) { list_actions( proc, naction ); continue; }
					 /* list actions in procedure*/
    IF( command, "call" ) {	/* call a procedure. don't clear */
      if( argn && (procP = which_procedure(Net, args[0])) && 
	  Err( execute_procedure( procP )))
	    sendMsg2("%s: in %s.\n", ERR_MSG, args[0] );
      continue;
    }
    IF( command, "network" ) {		/* its too dangerous */
      sendMsg("Executing a procedure - 'exit' first.\n");
      continue;
    }
    IfErr( eval_command( command, argn, args )) sendMsg1("\t%s\n", ERR_MSG);
   }
  }
}

true_expression(expr)
EXPRESS *expr;
{
  if(expr && eval_expression(expr) && expr->vector->value[0]==1.0) return(OK);
  return(ERR);
}

void
list_actions( proc, naction )
PROCED *proc; int naction;
{
  register int i;
  char  command[Lcomm], args[Nargs][Largs];	/* command and arguments */
  int   argn;					/* # of arguments	 */
  char  *start,*end, *typeString(); int itsProc;
  IfErr( proc ) return;
  if( naction==0 && (itsProc = its_proc( proc->name ))) { /* real procedure */
    /* BUG: we should print local variables too! */
    sendMsg1("procedure %s ", proc->name);
    for( i=0; i<proc->n_parg; i++ )
      sendMsg2("%s %s ",typeString(proc->arg[i].type), proc->arg[i].name);
    sendMsg("\n");
  }
  for( i=naction; i < proc->n_action; i++ ) {
    /*sendMsg3( "%s[%d] %s\n", proc->name, i, proc->action[i].name );*/
    sendMsg1( "%s\n", proc->action[i].name );
    parse_command( proc->action[i].name, command, &argn, args );
    if(argn < 1 ) continue;
    IF( command, "while" ) {
      list_actions( proc->action[i].args[1], 0 );
      for(start=end=proc->action[i].name;*end==' '||*end=='\t'; end++);
      sendMsg2("%.*sendwhile\n",(int) (end-start),start);
    }
    else IF( command, "repeat" ) {
      list_actions( proc->action[i].args[1], 0 );
      for(start=end=proc->action[i].name;*end==' '||*end=='\t'; end++);
      sendMsg2("%.*sendrepeat\n",(int) (end-start),start);
    }
    else if( EQL( command, "if" ) && 
	    (EQL(args[argn-1], "do")||EQL(args[argn-1], "then"))) {
      list_actions( proc->action[i].args[1], 0 );
      for(start=end=proc->action[i].name;*end==' '||*end=='\t'; end++);
      if( proc->action[i].argn == 3 ) { /* if expr then proc2 else proc2 */
	list_actions( proc->action[i].args[2], 0 );
        sendMsg2("%.*sendelse\n",(int) (end-start),start);
      }
      sendMsg2("%.*sendif\n",(int) (end-start),start);
    }
  }
  if( naction==0 && (itsProc = its_proc( proc->name ))) /* real procedure */
    sendMsg("end\n");
}

PROCED *
which_procedure ( net, name )
NETWORK *net;
char	*name;
{
register int i;
    
    if ( net == NULL ) { Erreturn ("network not define"); }
    for( i=0; i < net->n_procedure ; i++ ) {
	if ( !strcmp( net->procedure[i].name, name ) ) 
		return ( &net->procedure[i] );
    }
    Erreturn1("procedure %s not found", name );
}
	/* find procedure name given as a procedure argument */
PROCED **
which_procedure_arg( net, name )
NETWORK	*net; char *name;
{
  register int i;
  PROCARG *parg;

  IfErr( procScope ) return( ERR );
  parg = procScope->arg;
  for( i = 0; i < procScope->n_parg; i++, parg++ ) {
    if( parg->type == ItsProc && EQL(name, parg->name) ) 
      return( (PROCED**) &parg->ptr );
  }
  return( ERR );
}

/* find_procedure(), like which_procedure(), returns procedure with "name". *
 * unlike which_procedure(), "name" can contain arguments in the form       *
 * <procedure-name>(arg1,arg2,....).  It also accesses library procedures.  *
 * it binds the arguments to the procedure so the procedure can be executed *
 * immediately with execute_procedure.  it is intended only for use in      *
 * interpreted mode. */
/* BUG: argument bindings are changed if a procedure is called recursively *
 * arguments should be rebound everytime it is executed. */

APROC *
find_procedure( net, name, addIt, lookLibrary )
NETWORK *net; char *name; int addIt, lookLibrary;
{
  APROC *aproc, *find_procedure_args();
  char pname[Largs];
	/* 'name' is either 'pname' or 'pname(arg,...)' 
	 * parse the arguments part first and put it in aproc. */
  IfErr( aproc = find_procedure_args( net, name, pname ) ) return(ERR);

	/* now we should find a procedure named 'pname' */

	/* pname is argument of the calling procedure - nothing to do now */
  if( aproc->procP = which_procedure_arg( net, pname)) return( aproc );
	/* procedure xx proc pname
	 *      ..; call pname
	 */

  if( aproc->proc = which_procedure( net, pname ) ) { /* procedure defined */
    if( Err(aproc->proc->action) /* dummy procedure */
       && lookLibrary ) { 	/* look in library if we are allowed */
      IfErr( aproc->proc = find_library_procedure(net,pname))
	/* library procedure not found */
	{ deleteProcArgs( aproc ); return(ERR);}
	/* we've found a library procedure */
    }
	/* we have a real procedure now */
  }
  else /* procedure not defined */ {
    if(!lookLibrary ||	/* we cannot look at library yet OR */
       			/* cannot find it in library THEN */
       Err(aproc->proc = find_library_procedure(net,pname)))
    {
      /* not allowed to add dummy procedure - probably not called in file */
      if( !addIt ) { deleteProcArgs( aproc ); return(ERR);}

      if(Err(add_procedure(net,pname)) ||	       /* add dummy procedure*/
	 Err(aproc->proc=which_procedure(net,pname)))  /* it should be there */
	{ 
	  deleteProcArgs(aproc); 
	  Erreturn2("%s: cannot create procedure %s", ERR_MSG, pname); 
	}
	/* we have a dummy procedure now */
      return( aproc ); 	/* no type checking for dummy procedure */
    }
  }
	/* we have a real procedure now -> do type checking */
		/* check no. & types of arguments to the procedure */
  IfErr( checkProcArgs( aproc ))
    { deleteProcArgs( aproc ); return( ERR ); }
  return( aproc );
}
   /* parse arguments part of name(arg1,arg2,...) and get argument pointers 
    * don't care about name yet */
APROC *
find_procedure_args( net, name, pname )
NETWORK *net; char *name, *pname;
{
  int argn; char args[Nargs][Largs];
  PROCARG *getProcArgs();
  APROC *aproc = new(APROC);

		/* parse name into procedure name and argument names */
  IfErr( parseProcArgs( name, pname, &argn, args ) ) return(ERR);
    		/* has arguments- parse the argument names into pointers */
  if( argn ) {
    IfErr( aproc->arg = getProcArgs( net, NULL, argn, args ) ) {
      deleteProcArgs( aproc );
      Erreturn2("%s: in procedure arguments for %s", ERR_MSG, pname );
    }
    aproc->argn = argn;
  }
  else { aproc->arg = NULL; aproc->argn = 0; } /* no arguments */

  return( aproc );
}
	/* parseProcArgs() parses the form name(arg1,arg2,...) and puts the
	 * strings arg1, arg2, ... into array args[][], name into pname. */

parseProcArgs( name, pname, argn, args )
char *name, *pname;
int *argn; char args[][Largs];
{
  char *start, *end, *index(),*rindex();

  if( start = index(name, '(') ) {
    strncpy( pname, name, start-name ), *(pname+(start-name)) = NULL;
    for( *argn=0; end = index(++start,','); (*argn)++, start=end ) 
      strncpy( args[*argn], start, end-start), *(args[*argn]+(end-start))=NULL;

    IfErr( end = rindex(start, ')') ) Erreturn("no closing ')'");
    strncpy( args[*argn],start,end-start), *(args[(*argn)++]+(end-start))=NULL;
  }
  else { strcpy( pname, name ); *argn = 0; }
  return( OK );
}
	/* pass arguments to a procedure without type checking. */
	/* called when a procedure with arguments is executed */
bindProcArgs( aproc )
APROC *aproc;
{
  register int n;
  PROCED *proc= aproc->procP? *aproc->procP:aproc->proc;
  PROCARG *pargs=aproc->arg;	/* args given to this call */
  PROCARG *arg=proc->arg;	/* args defined with proc */
  int n_parg=proc->n_parg;	/* no of args defined */

  for( n=0; n< n_parg; n++, pargs++, arg++ ) {
    if( arg->type == ItsExpr ) {
      IfErr( arg->ptr = (char*) eval_expression((EXPRESS*) pargs->ptr) )
	Erreturn1("error in evaluating argument #%d",n+1);
    } 
      /* argument given is argument of parent procedure. get what it's *
       * pointing to.  */
    else if(pargs->type == ItsProcP ||
	    pargs->type == ItsLayerP ||
	    pargs->type == ItsConnectP ) arg->ptr = (char*) *pargs->ptr;
    else arg->ptr = pargs->ptr;
  }
  return( OK );
}
	/* type checking for procedure arguments */
checkProcArgs( aproc )
APROC *aproc;
{
  register int n;
  PROCED *proc; 
  PROCARG *pargs, *arg;
  char *typeString(); int mismatch=0;

  if( Err(aproc) || 
      (Err( proc=aproc->proc) && Err(proc= *aproc->procP))) return(ERR);
  if( proc->n_parg > aproc->argn )
    Erreturn2("procedure %s requires %d arguments",proc->name,proc->n_parg);
  pargs = proc->arg; /* arguments defined with the procedure */
  arg = aproc->arg;  /* arguments given to this call */
  for( n=0; n<proc->n_parg; n++, pargs++, arg++ ) {
#if DEBUG
    sendMsg3("argument #%d for procedure %s should be %s;",
	     n+1,proc->name, typeString(arg->type));
    sendMsg1(" its %s\n", typeString(pargs->type));
#endif
    if( pargs->type == ItsProc && arg->type == ItsProcP ) continue;
	/* this is OK. argument to the parent procedure is passed to this
	 * subprocedure. 
	 * 	procedure xx procedure yy
	 *		call proc(yy) 
	 *	end
	 *	procedure proc procedure arg
	 * here pargs represents 'yy'; pargs->ptr is yy 	... */
    if( pargs->type == ItsLayer && arg->type == ItsLayerP ) continue;
    if( pargs->type == ItsConnect && arg->type == ItsConnectP ) continue;
    if( pargs->type != arg->type )  {
      sendMsg3("argument #%d for procedure %s should be %s",
		n+1,proc->name,typeString(pargs->type));
      sendMsg1(", not %s", typeString(arg->type));
      mismatch++;
    }
  }
  if( mismatch ) Erreturn("");
  return( OK );
}

PROCED *
find_library_procedure( net, name )
NETWORK	*net;
char *name;
{
  char	command[Lcomm], args[Nargs][Largs];
  char command_line[BUFSIZE], *command_buf, *next_line;
  int	argn, lines, i, status, n;
  FILE *lib, *open_file();
  int  ftype; struct stat fstat;
  char fname[BUFSIZE];

  IfErr( net->n_libfile ) return(ERR);
  for( n=0; n< net->n_libfile; n++ ) {
    if( Err(ftype = find_file( net->libfile[n],0,NetworkDir, fname, &fstat )) &&
	Err(ftype = find_file( net->libfile[n],0,LibDir, fname, &fstat )) ) {
      sendMsg1("cannot find library file %s\n", net->libfile[n]);
      continue;
    }
    IfErr( lib = open_file( fname, ftype)) {
      sendMsg1("cannot open library file %s\n", fname );
      continue;
    }

    for(lines=1; (status = read_line( command_line, BUFSIZE, lib ))
      !=EOF; lines += status ) {

      for( command_buf = command_line; command_buf ; command_buf = next_line ) {
        handle_quote(command_buf, &next_line);
        parse_command( command_buf, command, &argn, args );
        if( EQL( command, "procedure" ) && EQL( args[0], name )) {
		/* found the procedure with name */
    	  if( argn < 1 ) Erreturn("syntax: procedure <name>");
      	  for( i=0; i < argn; i++ ) substitute_defined_str( args[i], net );
    
	  status = define_procedure(lib, net, name, &lines, argn-1, args[1], 1);
	  close_file( lib, ftype );
    	  IfErr( status ) 
	    Erreturn3("%s: in procedure %s in library %s",ERR_MSG, name,fname);
          return( which_procedure( net, name ) );
        }
      }
    }
    close_file( lib, ftype );
  }
  /* couldn't find procedure definition for 'name' */
  Erreturn1("procedure %s not found",name);
}
	/* find types of arguments to be passed to a subprocedure */
	/* return value is an array of arguments specifying types of and *
	 * pointers to the arguments */
	 /* called to parse subprocedure call "call proc(arg,..)" */
PROCARG *
getProcArgs( net, proc, argn, args )
NETWORK *net; PROCED *proc; int argn; char args[][Largs];
{
  register int i; 
  PROCARG *pargs = new_array_of( argn, PROCARG );
  REAL *val; int nval;
  MATRIX *matrix;
  VECTOR *vec;
  for( i=0; i<argn; i++ ) {

	/* NOTE: use which_layer_arg() etc to find procedure arguments *
	 * PROCARG needs a flag to indicate it -> *ptr, not ptr, points *
	 * to the actual object for these cases */
	/* PROBLEM: the above doesn't work for matrix/vector */
	/* SOLUTION: should work if its expression -> use expression *
	 * instead of matrix/vector! */
	/* minor problem: an expression is not always lvalue */
    if( pargs[i].ptr = (char*) which_layer( net, args[i] )) 
      pargs[i].type = ItsLayer;
    else if( pargs[i].ptr = (char*) which_connection( net, args[i] )) 
      pargs[i].type = ItsConnect;
    else if( pargs[i].ptr = (char*) which_layer_arg( net, args[i] )) 
      pargs[i].type = ItsLayerP;
    else if( pargs[i].ptr = (char*) which_connection_arg( net, args[i] )) 
      pargs[i].type = ItsConnectP;
    else if( pargs[i].ptr = (char*) find_optimize_expression( net, args[i] ))
      pargs[i].type = ItsExpr;
    else if( pargs[i].ptr = (char*) which_procedure( net, args[i] ))
      pargs[i].type = ItsProc;
    else if( pargs[i].ptr = (char*) which_procedure_arg( net, args[i] ))
      pargs[i].type = ItsProcP;
    else Erreturn1("%s not found", args[i] );
#if DEBUG
    sendMsg3("argument #%d %s is %s. \n",i+1,args[i],typeString(pargs[i].type));
#endif
  }
  return( pargs );
}	

void deleteProcArgs( aproc )
APROC *aproc;
{
  PROCARG *pargs;
  int n;
  IfErr(aproc) return;
  if( pargs = aproc->arg ) {
    for( n=0; n< aproc->argn; n++, pargs++ ) {
      if( pargs->type == ItsVector || pargs->type == ItsMatrix ) 
	delete_vector_struct( (VECTOR*) pargs->ptr );
      else if( pargs->type == ItsExpr )
	delete_expression( (EXPRESS*) pargs->ptr );
    }
    free( aproc->arg );
  }
  free( aproc );
}  

	/* executeAprocCheck() is called when a subprocedure is exec'ed *
	 * if with arguments: (1) check the no. of arguments, and argument *
	 * types.  (2) pass the actual arguments. (3) exec the procedure */

executeAprocCheck( aproc )
APROC *aproc;
{
  PROCED *proc;		/* procedure ptr */
  if( aproc->procP ) {  /* the procedure is an argument - its a pointer */
    IfErr( proc = *aproc->procP) Erreturn("procedure argument not passed");
  } else proc = aproc->proc;

  if( proc->n_parg ) {  /* procedure has arguments */
	/* run-time type checking. necessary because library procedure isn't *
	 * checked for type at compile time */
    if( Err( checkProcArgs(aproc)) ||
	/* bind the arguments */
       Err(bindProcArgs(aproc))) return(ERR);
  }
  return( execute_procedure( proc ));
}

	/* executeAproc() doesn't do type checking */

executeAproc( aproc )
APROC *aproc;
{
  bindProcArgs( aproc );
  return( execute_procedure( aproc->proc ) );
}

char * typeString( type )
int type;
{
  static char label[12];
  switch( type ) {
  case ItsLayer: strcpy( label, "layer" ); break;
  case ItsConnect: strcpy( label, "connect" ); break;
  case ItsLayerP: strcpy( label, "layer (argument)" ); break;
  case ItsConnectP: strcpy( label, "connect (argument)" ); break;
  case ItsExpr: strcpy( label, "expression" );break;
  case ItsProc: strcpy( label, "procedure" ); break;
  default: strcpy( label, "undefined" ); break;
  }
  return( label );
}
	/* add a dummy procedure with name 'name'.  this happens when *
	 * a procedure is called without being defined.  at the end of *
	 * the file if it's not been defined, we look for it in the *
	 * library (if any) with check_procedure() below. */

add_procedure( net , name )
NETWORK *net; char *name;
{
  if( net->n_procedure >= MaxProcedure )
    Erreturn1("no more than %d procedures for a network", MaxProcedure);
  net->procedure[net->n_procedure++].name = new_string( name, NULL );
  return(OK);
}
	/* look for undefined procedures in library and give warning about 
	 * ones not found. */

check_procedure( net )
NETWORK *net;
{
  register int n; PROCED *proc = net->procedure;
  for( n= Net->n_procedure; n ; n--, proc++ ) {
    IfErr( proc->action ) {
      IfErr( find_library_procedure( net, proc->name ))
        sendMsg2("warning: %s: procedure %s not defined.\n", 
	       ERR_MSG, proc->name);
    }
  }
}
#if 0	/* list of stopping points for debugging - not worked out yet */
#define MaxStopList 32
typedef struct _stoplist {
  PROCED *proc;
  int	naction;
  BINARY   status;
} STOPLIST;
STOPLIST *StopList[MaxStopList];
int Nstoplist;

stop_here( proc, n )
PROCED *proc; int n;
{
  register int i;
  for( i=0; i < Nstoplist; i++ ) 
    if(proc==StopList[i].proc && n==StopList[i].naction ) return( OK );
  return( ERR );
}

stop_list( name, n )
char *name; int n;
{
  STOPLIST *item;
  IF ( name, "clear" ) { Nstoplist = 0; return( OK ); }
  if ( Nstoplist >= MaxStopList ) 
    Erreturn1("Sorry, no more than %d stopping points", MaxStopList );

  if ( StopList[ Nstoplist ] == NULL ) StopList[ Nstoplist ] = new( STOPLIST );
  item = StopList[ Nstoplist ];
  IfErr( item->proc = which_procedure( net, name ) ) return( ERR );
  if( n >= item->proc->n_action ) 
    Erreturn2("only %d actions in procedure %s", item->proc->n_action, name );
    
  item->naction = n ;
  item->status = ON;
  Nstoplist++ ;
  return ( OK );
}

print_stoplist_items( )
{
  register int i;
  STOPLIST    *item;
  if( Nstoplist == 0 ) { puts("no item in stop list."); return(OK);}
  for( i=0; i< Nstoplist; i++ ) {
    item = StopList[i];
    sendMsg2("%d%c ", i+1, item->status==ON? '*' : ' ' );
    printf("%s[%d]\n", item->proc->name, item->naction );
  }  
  return( OK );
}
#endif 0
