/*** netcommand.c : sends SunNet commands from a shell.
***/
/*************** UPDATES ************************************
netcommand.c:
12/8/90 server can ask for the value of PWD environment.
4/26/90 wait for a while if cannot connect to server.
4/26/90 terminate when server dies.
**************************************************************/
#include <stdio.h>
#include <sys/types.h>

#include <sys/socket.h>
#include <sys/un.h>

#include <signal.h>
#include "port.h"

#ifdef allie
#define maskINT 2
#else
#define maskINT sigmask(SIGINT)
#endif

#ifdef hp
#define getwd(buf) getcwd(buf,sizeof(buf))
#endif

void onintr();
int serverID;
int sock; int rval;
char buf[256], *strcpy(), *getenv(), *getwd();

main( argc, argv )
int argc; char *argv[];
{
  register int i;
  char comm[128];
  char sockname[128];
  char EnvStr[64];
  struct sockaddr_un server;
  int monitor=1;

  if( PORT ) strcpy( sockname, PORT );
  else sprintf( sockname, "%s/%s", getenv("HOME"), DefaultPort );

  if((sock = socket(AF_UNIX, SOCK_STREAM, 0)) < 0 ) {
    perror("opening stream socket"); exit(1);
  }
  server.sun_family = AF_UNIX;
  strcpy( server.sun_path, sockname );
  if( connect( sock, &server, strlen(server.sun_path)+2 ) < 0 ) {
    if( PORT ) fprintf(stderr, "cannot find server with port %s.\n",PORT );
    else fprintf(stderr, "server not active.\n");
    fprintf(stderr, "waiting..");
    sleep(5);
    if( connect( sock, &server, strlen(server.sun_path)+2 ) < 0 ) {
      fprintf(stderr, "  unsuccessful.\n");
      close(sock);
      exit(1); 
    }
    fprintf(stderr, "  ok.\n");
  }
  
  buf[0] = '\0';
  for( i=1; i< argc; i++ ) sprintf( buf, "%s %s", buf, argv[i] );

  if( write(sock, buf, sizeof(buf)) < 0 ) {
    perror("cannot talk to server"); exit(1);
  }
  signal( SIGINT, onintr );
  while( 1 ) {
    /* block SIGINT because SIGINT in recv() call breaks the socket */
	/* BUG: cannot interrupt until next output */
    sigblock( maskINT );

    if( (rval = recv( sock, buf, sizeof(buf), 0 )) < 0 ) 
      {	perror("cannot receive from server"); exit(1); }
    sigsetmask( sigblock(0) & ~maskINT );  /* unblock SIGINT */
    /* BUG: should terminate when the server dies instead of keep printing
     * buf for ever. */
    /* FIXED? see below. */
    if( rval == 0 ) /* this seems to happen when the server dies. */
      {	fprintf("%s terminated: server died.\n",argv[1]); 
	close(sock); exit(1); }
    if( !strcmp( buf, EndComm ) ) { close( sock ); exit(0); }
    if( !strcmp( buf, ErrComm ) ) { close( sock ); exit(1); }
    if( !strcmp( buf, InputRequest ) ) {
      if( fgets(buf,sizeof(buf),stdin) == NULL ) { /* EOF or error */
	clearerr(stdin); strcpy(buf, EndComm ); 
      }
      if( (rval = write( sock, buf, sizeof(buf))) < 0 ) {
	sprintf( stderr, "couldn't write on socket"); close( sock ); exit(1);
      }
    }
    else if( sscanf( buf, EnvRequest, EnvStr ) ) {
      if( !strcmp( EnvStr, "PWD" ) ) getwd(buf);
      else strcpy( buf, getenv(EnvStr));
      if( (rval = write( sock, buf, sizeof(buf))) < 0 ) {
	sprintf( stderr, "couldn't write on socket"); close( sock ); exit(1);
      }
    }
    else if( sscanf( buf, pidFmt, &serverID ) );
    else { printf( buf ); fflush( stdout ); }
  }
}

void onintr()
{
  if( !serverID ) { printf("don't know the server's pid.\n"); return; }
  kill( serverID, SIGINT );
#if 0 /* MSG_OOB: this hasn't been tested because kill() works. */
  if( (rval = send( sock, strcpy(buf," "), sizeof(buf), MSG_OOB)) < 0 ) {
    sprintf( stderr, "couldn't write on socket"); close( sock ); exit(1);
  }	
#endif 0
  return;
}

