/* $Header: /soma/users/miyata/planet/src/RCS/net.h,v 5.6.0.4 91/02/13 15:42:51 miyata Exp $ */
#ifndef Lname
#define Lname 32
#endif
#define Margs 8

typedef float	NUMBER;
typedef float	REAL;
typedef REAL	WEIGHT;

#define MaxLayer 64
#define MaxConnect 64
#define MaxProcedure 128
#define	MaxProcConst 64
#define MaxAction 128
#define MaxArray 128
#define MaxIvector 128
#define MaxMatrix 64
#define MaxIntVar 32
#define MaxFloatVar 128
#define MaxExpr 32
#define MaxVector 256
#define MaxConnectPerLayer 32
#define MaxLibFile 16

typedef struct _layer {
	char	*name;
	int	n_unit;
	int	n_alloc;  /* no of units allocated memory for */
	REAL	*actv;
	REAL	*net;
	REAL	*delta;
	REAL	*bias;
	REAL	*d_bias;
	REAL	*user1;
	REAL	*user2;
	REAL	etascale ;
	int	type;
	int	dmatrix;
	char	*connect_above[MaxConnectPerLayer];
	char	*connect_below[MaxConnectPerLayer];
	int	n_connect_above, n_connect_below;
} LAYER;

typedef struct {
	char	*name;
	int	n_value;
	int	n_alloc;
	REAL	*value;
	int	dmatrix;
} ARRAY;

typedef struct {
	char	*name;
	int	n_row, n_col;
	int	n_alloc;
	REAL	*value;
	int	dmatrix;
} MATRIX;

typedef struct {
	char	*name;
	int	value;
} INTVAR ;

typedef struct {
	char	*name;
	REAL	value;
} FLOATVAR ;

typedef struct _vector {
	REAL	*value;
	int	nvalue;		        /* vector size */
	int	nvalue1,nvalue2;	/* matrix size */
	int	nalloc;			/* allocated array size */
	char    *object;		/* general object pointer */
	REAL    *(*accessfunc)();	/* func to access values in object */
	char	*name;
} VECTOR;

typedef struct _expr {
  int	(*func)();
  VECTOR *(*evalfunc)();
  struct _expr *arg1, *arg2;
  VECTOR *vector;
  struct _expr  *start, *end, *row;
  char	*name;
  int	type;
  int	op;
} EXPRESS;

typedef struct {
  EXPRESS *start, *end;
} RANGE;

typedef struct {
  REAL  *value;
  REAL	*index;
  REAL	nvalue;
  int	nindex, dmatrix;
  char	*name;
} IVECTOR;

typedef struct {
	int	(*func)();
	char	*args[ Margs ];
	int	argn;
	char	*name;
} ACTION;

typedef struct {
  int	type;
  char	*name;
  char	*ptr;
} PROCARG;

typedef struct {
	int	n_action;
	ACTION	*action;
	int	n_int;
	int	*iconst;
	int	n_float;
	float	*fconst;
	int	n_expr;
	EXPRESS *expr[ MaxExpr ];
	int	n_vector;
	VECTOR	*vector[ MaxVector ];
	int	n_parg;
	PROCARG *arg;
	char	*name;
	char	*help;
} PROCED;

typedef struct {
	PROCED  *proc, **procP;
	PROCARG *arg;
	int	argn;
} APROC;

typedef struct {
	int	*weight, *from, *to;
	char	*type;
	REAL	*init;
	int	*weight_back, *from_back, *to_back;
#if allie
	int	*fan_out, *fan_in;
#endif allie
	int	n_weight, n_weight_back;
} WINDEX;

typedef struct _connect {
	char	*name;
	int	type;
	int	from_start,to_start;
	int	from_nunit,to_nunit;
	int	n_alloc;
	LAYER	*fromlayer, *tolayer;
	WEIGHT	*weight, *d_weight;
	WEIGHT	*change;
	REAL	*user1, *user2;
	WINDEX	*index;
	struct _connect **arg;
} CONNECT;

typedef struct {
	REAL	*value ;
	int	n_value, n_alloc ;
	REAL	*error ;
	REAL	error_sum ;
	LAYER	*outlayer ;    /* should be somewhere else */
	int	dmatrix; 
} TARGET;

typedef struct {
	REAL	*value ;
	int	n_value, n_alloc ;
	int	dmatrix;
} INPUT;

typedef struct {
	int	n_layer;
	LAYER	layer[ MaxLayer ];
	int	n_connect;
	CONNECT	connect[ MaxConnect ];
	int	n_procedure;
	PROCED	procedure[ MaxProcedure ];
	TARGET	target ;
	INPUT	input ;
	int	n_array;
	ARRAY	array[ MaxArray ];
	int	n_ivector;
	IVECTOR	ivector[ MaxIvector ];
	int	n_matrix;
	MATRIX	matrix[ MaxMatrix ];
	int	n_intvar ;
	INTVAR	intvar[ MaxIntVar ];
	int	n_floatvar;
	FLOATVAR floatvar[ MaxFloatVar ];
	char	*libfile[ MaxLibFile ];
	int	n_libfile;
} NETWORK;

typedef struct {
	REAL	maxactv ;
	REAL	minactv ;
	REAL	initweight ;
	REAL	eta ;
	REAL	alpha ;
	REAL	netmax ;
	REAL	deltadecay ;
	REAL	netdecay ;
	REAL	careoff ;
	REAL	maxbound;
	REAL	maxbound0;
} NETPARAM;
extern	NETPARAM netparam_;

#define MAXACTV		netparam_.maxactv
#define MINACTV 	netparam_.minactv
#define INITWEIGHT 	netparam_.initweight
#define ETA 		netparam_.eta
#define ALPHA 		netparam_.alpha
#define NETMAX 		netparam_.netmax
#define DELTADECAY 	netparam_.deltadecay
#define NETDECAY 	netparam_.netdecay
#define CAREOFF 	netparam_.careoff
#define MAXBOUND	netparam_.maxbound
#define MAXBOUND0	netparam_.maxbound0

#define	ActvRange MAXACTV-MINACTV

#ifndef ON
typedef char BINARY;
#define ON '1'
#define OFF '\0'
#define NO_VALUE (-100.0)
#define DONT_CARE (-1000.0)
#endif

#define SopV 0 		/* scaler-operation-vector */
#define VopS 1		/* vector-operation-scaler */
#define VopV 2		/* vector-operation-vector  */
#define MopV 3		/* matrix-operation-vector */
#define VopM 4		/* vector-operation-matrix */
#define Special 3	/* special operations (one argument) */

extern NETWORK	*new_net();
extern LAYER	*which_layer ();
extern LAYER	**which_layer_arg ();
extern ARRAY	*which_array ();
extern IVECTOR	*which_ivector ();
extern MATRIX	*which_matrix ();
extern INTVAR	*which_intvar ();
extern FLOATVAR	*which_floatvar ();
extern PROCED	*which_procedure ();
extern CONNECT	*which_connection ();
extern CONNECT	**which_connection_arg ();
extern APROC    *find_procedure ();
extern PROCED	*find_library_procedure();
extern REAL	get_error ();

/*** Types of activation functions : attached to each layer ***/
#define Logistic 0
#define Linear 1

#ifndef IF
#define IF(x, y)		if( strcmp(x, y) == NULL )
#endif
	/* used in procedure argument types */
#define ItsVector 4
#define ItsWeight 5
#define ItsExpr 6
#define ItsLayer 7
#define ItsConnect 8
#define ItsLayerP 9
#define ItsConnectP 10 
#define ItsFloat 11
#define ItsMatrix 12
#define ItsWeightP 13
#define ItsProc 14
#define ItsProcP 15

	/*** used in sparse connection specification index */
#define NoConnect 'N'
#define FixConnect 'F'
#define RandConnect 'R'
#define GivenConnect 'G'
#define KeepConnect 'K'

#define SYMMETRIC 1	/* symmetric connection */
#define ASSYMETRIC 2	/* assymetric connection */

extern	REAL *find_vector();
extern  REAL *find_matrix_column();
extern  EXPRESS *find_expression(), *find_optimize_expression();
extern  VECTOR *eval_expression();
