/** mgrcore.h: macros for converting Suncore functions into MGR **/

		/* For generating postscript output */
#define StoP 72.0 	/* Screen to Printer conversion - points per inch */
#define Poffset 20.0	/* Offset for Printer output */

char mMarker[2];
extern float xX, xY,newX, newY;
extern float scaleX,scaleY;
extern int fontX, fontY;

/*
#define coreToX(x) (scaleX*(x))
#define coreToY(y) (scaleY*(YMAX-(y)))
*/
#define coreToX(x) (x)
#define coreToY(y) (YMAX-(y))

	/* segments are not supported in XNet */
#define create_retained_segment(seg)
#define close_retained_segment(seg) 
#define create_temporary_segment() 
#define close_temporary_segment() 
#define delete_retained_segment(seg)
#define delete_all_retained_segments() m_clear()
#define wipe_all_segments(nseg) m_clear()
	/* marker functions */
#define set_marker_symbol(m) sprintf(mMarker,"%c",(m)), \
  Printer? fprintf(Printer, "/mark (%c) def 8 csize\n", m) : 0

#define marker_abs_2(x,y) \
  m_moveprint((int) (xX=coreToX(x))-fontX, (int)(xY=coreToY(y))+fontY,\
	      mMarker), \
  Printer? fprintf(Printer, "%.1f %.1f mark txt\n",\
		   StoP*(x)+Poffset,StoP*(y)+Poffset) : 0

#define marker_abs_2_transform(x,y,xscale,yscale,xshift,yshift) \
  m_moveprint((int)(xX=coreToX((x)*xscale+xshift))-fontX, \
	      (int)(xY=coreToY((y)*yscale+yshift))+fontY, \
	      mMarker), \
  Printer? fprintf(Printer, "%.1f %.1f mark txt\n",\
		   StoP*(xshift+(x)*xscale)+Poffset,\
		   StoP*(yshift+(y)*yscale)+Poffset) : 0
	/* move functions */
#define move_abs_2(x,y) m_go((int)(xX=coreToX(x)),(int)(xY=coreToY(y))), \
  Printer? fprintf(Printer,"%.1f %.1f moveto\n",\
			      StoP*(x)+Poffset,StoP*(y)+Poffset) : 0

#define move_abs_2_transform(x,y,xscale,yscale,xshift,yshift) \
 m_go((int)(xX=coreToX((x)*xscale+xshift)), \
      (int)(xY=coreToY((y)*yscale+yshift))), \
 Printer? fprintf(Printer, "%.1f %.1f moveto\n",\
		  StoP*(xshift+(x)*xscale)+Poffset,\
		  StoP*(yshift+(y)*yscale)+Poffset) : 0

#define move_rel_2(x,y) m_go((int)(xX += scaleX*(x)),(int)(xY -= scaleY*(y))),\
  Printer? fprintf(Printer,"%.1f %.1f rmoveto\n",StoP*(x),StoP*(y)) : 0

	/* line functions */
#define line_abs_2(x,y) \
  m_line((int)xX,(int)xY, \
	 (int)(newX=coreToX(x)),(int)(newY=coreToY(y))),\
  xX=newX, xY=newY, \
  Printer? fprintf(Printer, "%.1f %.1f lineto draw\n",\
		   Poffset+StoP*(x),Poffset+StoP*(y)) : 0

#define line_abs_2_transform(x,y,xscale,yscale,xshift,yshift) \
  m_line((int)xX,(int)xY, \
	 (int)(newX=coreToX((x)*(xscale)+(xshift))), \
	 (int)(newY=coreToY((y)*(yscale)+(yshift)))),\
  xX=newX, xY=newY, \
  Printer? fprintf(Printer,"%.1f %.1f lineto draw\n", \
	  StoP*(xshift+(x)*(xscale))+Poffset,\
	  StoP*(yshift+(y)*(yscale))+Poffset) : 0

#define line_rel_2(x,y) \
  m_line((int)xX,(int)xY,\
	 (int)(newX=xX+scaleX*(x)), (int)(newY=xY-scaleY*(y))),\
  xX=newX, xY=newY, \
  Printer? fprintf(Printer, "%.1f %.1f rlineto draw\n",\
		   (float) StoP*(x),(float) StoP*(y)) : 0

	/* unsupported (yet) functions */
#define new_frame() 		
#define set_charpath_2(x,y)
#define set_charup_2(x,y)
#define set_drag(onoff)
#define set_font( font ) 
#define set_linewidth(x) 
#define set_linestyle(style) 
#define set_charprecision(prec) 
#define set_charsize(x,y) 
#define set_fill_index(color) 
#define set_text_index(color) 
#define set_line_index(color) 
#define set_output_clipping(onoff) 
#define set_window_clipping(onoff) 
#define set_segment_visibility(seg,o) 
#define set_image_transformation_type(i) 
#define set_segment_image_transformation_2(seg,x,y,a,sx,sy) 
#define text(str) m_moveprint((int)xX, (int)xY+fontY, str )
#define inquire_text_extent_2(str,xp,yp) 
#define inquire_retained_segment_names(seg,seg_array,np)
#define get_mouse_state(loc,n,xp,yp,ip)
/***	new functions that are not in SunCore ***/

#define rsh(str)

#define fill_box(x,y,w,h,color) \
  m_fill_box(x,y,w,h,color), \
  Printer? fprintf(Printer,"%.1f %.1f %.1f %.1f %.1f box\n", \
		      StoP*(x)+Poffset,StoP*(y)+Poffset, \
		      StoP*(w), StoP*(h), \
		      ((color)==WHITE)? 1 : ((color)==BLACK)? 0 : 0.6 ) : 0

#define clear_box(x,y,w,h) \
  m_func( B_CLEAR ),\
  m_bitwrite((int)(xX=coreToX(x)),(int)(xY=coreToY((y)+(h))), \
	     (int)(scaleX*(w)),(int)(scaleY*(h)) ), \
  m_func( B_SET )

/*** this is a combination of move_abs_2() and text() ***/

#define text_location(str, x, y) \
  m_moveprint((int)(xX=coreToX(x)), (int)(xY=coreToY(y))+fontY, str),\
  Printer? fprintf(Printer, "%.1f %.1f (%s) txt\n", \
		   StoP*(x)+Poffset, StoP*(y)+Poffset, str ) : 0


