/* $Header: /soma/users/miyata/planet/src/RCS/list.c,v 5.6.0.6 91/02/13 15:41:13 miyata Exp $ */
static char rcsid[] = "$Header: /soma/users/miyata/planet/src/RCS/list.c,v 5.6.0.6 91/02/13 15:41:13 miyata Exp $";
/********* UPDATES ****************************************************
list.c
  12/7/89 implemented matrix plotting and removed meshplot. use matrix
	  to get meshed plotting.
************************************************************************/
#include <stdio.h>
#include <math.h>
#include "net.h"
#if sunnet|planet|xnet|mgr
#include "graph.h"
#endif
#include "command.h"
#include "alloc.h"
#include "error.h"
#include "sunnet.h"
#include "list.h"
#include "msg.h"

extern  int Pprecision;
extern  char Quiet;
	
extern FILE *Pfile;

PLIST *Plist[ MaxPlist ] ;
int N_Plist = 0;

print_printlist_names ( )
{
  register int i;
  if ( N_Plist == 0 ) { 
    sendMsg("no item in print list.\n"); return(OK);
  }
  for ( i=0; i< N_Plist; i++ ) {
    sendMsg5("%d%c %s\tncol=%d precision=%d\n", i+1, 
	     Plist[i]->status==ON? '*' : ' ',
	     Plist[i]->name, Plist[i]->ncol, Plist[i]->precision );
  }  
  return ( OK );
}

print_printlist_commands ( )
{
  register int i;
  sendMsg("printlist clear\n");
  for ( i=0; i< N_Plist; i++ ) {
    sendMsg3("printlist %s c%d p%d\n", 
	     Plist[i]->name, Plist[i]->ncol, Plist[i]->precision );
  }  
  return ( OK );
}

print_list( net, name, ncol, precision )
NETWORK	*net ;
char	name[];
int	ncol, precision;
{
  PLIST *item;
  /* NUMBER *find_vector(); */
  
  IF ( name, "clear" ) { N_Plist = 0; return( OK ); }
  
  if ( N_Plist >= MaxPlist ) 
    Erreturn1("Sorry, cannot print more than %d items", MaxPlist );

  if ( Plist[ N_Plist ] == NULL ) Plist[ N_Plist ] = new ( PLIST );

  item = Plist[ N_Plist ];
  if ( item->ptr = (char *) which_connection ( net, name ) ) 
    item->type = ItsWeight ;
	/* BUG : connect procedure argument is treated as just a matrix */
        /* FIX : this gets procedure argument of type 'connect' */
  else if ( item->ptr = (char *) which_connection_arg ( net, name ) ) 
    item->type = ItsWeightP ;

  else if( item->ptr = (char*) find_optimize_expression(net,name))
    item->type = ItsExpr ;
  else return(ERR);

  item->name = new_string ( name, item->name );
  item->ncol = ncol ;
  item->precision = precision;
  item->status = ON;
  N_Plist++ ;
  return ( OK );
}

print_items ()
{
  REAL	  *value;
  VECTOR  *vector;
  CONNECT *connect;
  WEIGHT *weight;
  PLIST   *item;
  register int k,i,j;
  int	  ncol, precision, status;
  char	  fmt[ 8 ], buf[BUFSIZE];

  if ( Pprecision < 1 ) Erreturn("precision must be positive");
  Starting(inList);
  for ( k = 0; k < N_Plist ; k++ ) {
    if( INTERRUPT == INTR_LIST ) {
      sendMsg1("interrupted at print list item #%d\n",k+1);
      if( DoInterrupt("print list") == EXIT ) {
	Ending(inList);
	Erreturn1("exit at print list item #%d",k+1);
      }
    }
    item = Plist[ k ] ;
    if ( item->status == OFF ) continue;
    precision = item->precision? item->precision : Pprecision;
    sprintf( fmt, "%%%d.%df ", precision, precision-1 );
    ncol = item->ncol ;
    sendMsg2("%s %s", item->name, ncol>0? "\n" : "= " ); 
    switch ( item->type ) {
    case ItsExpr:
      IfErr( vector = eval_expression( (EXPRESS *) item->ptr ) ) {
	Ending(inList);
	Erreturn2("%s: in expression %s", ERR_MSG, item->name );
      }
      fprint_vector( stdout,NULL,vector->value,vector->nvalue,ncol,fmt );
      if( Pfile )
	fprint_vector( Pfile,NULL,vector->value,vector->nvalue,ncol,fmt );
      break;
    case ItsWeight:
      connect = (CONNECT *) item->ptr ;
      fprint_weight(stdout,NULL,(CONNECT *) item->ptr, fmt );
      if( Pfile ) 
	fprint_weight(Pfile,NULL,(CONNECT *) item->ptr, fmt );
      break;
    case ItsWeightP:	/* procedure argument of type 'connect' */
      connect = (CONNECT *) *item->ptr ;
      fprint_weight(stdout,NULL,(CONNECT *) item->ptr, fmt );
      if( Pfile ) 
	fprint_weight(Pfile,NULL,(CONNECT *) item->ptr, fmt );
      break;
    default :
      break;
    }
  }
  Ending(inList);
  return ( OK );
}
	
CLIST *CList[MaxClist];
static int Nclist = 0;
exec_clist( n ) 	/* , cargn, cargs ) argument substitution */
int n; 			/*, cargn; char cargs[][Large]; to be implemented */
{
  int nitem,i, status;
  CLIST *item;
  Starting(inList);
  if( n == 0 ) {		/* execute all items */
    for( nitem=0; nitem< Nclist; nitem++ ) {
      if( INTERRUPT == INTR_LIST ) {
	sendMsg1("interrupt at clist item #%d\n", nitem+1);
	if( DoInterrupt("clist") == EXIT ) {
	  Ending(inList);
	  Erreturn1("exit at clist item #%d", nitem+1);
	}
      }
      item = CList[nitem];
      if( item->status == OFF ) continue;
      IfErr( exec_citem( item, NULL ) ){
	Ending(inList);
	Erreturn2("%s: in clist item #%d", ERR_MSG, nitem+1);
      }
    }
    Ending(inList); return(OK);
  }
  else {			/* execute one item */
    nitem = n-1;
    if( nitem >= Nclist )
      Erreturn1("only %d items in command list", Nclist);
    item = CList[nitem];
    IfErr( exec_citem( item, NULL ) )
      Erreturn2("%s: in clist item #%d", ERR_MSG, nitem+1 );
  }
  Ending(inList); return( OK );
}

exec_citem( item, scope )
CLIST *item;
PROCED *scope;
{
  char args[Nargs][Largs];	/* buffer for arguments */
  PROCED *origScope, *setScope();
  register int i;
  int status;
  IfErr( item ) return( OK );
  if( scope ) origScope = setScope( scope );
  for( i=0; i< item->argn; i++ ) strcpy( args[i], item->args[i] );
  if( Quiet == OFF ) {
    addMsg1("%s", item->command );
    for( i=0; i< item->argn; i++ ) addMsg1(" %s", args[i] );
    addMsg( "\n" ); endMsg();
  }
/*	IfErr(substitute_clist_args( args[i], item->args[i], cargn, cargs ))
	  Erreturn2("%s: in clist item #%d", ERR_MSG, nitem+1);*/
  status = eval_command( item->command, item->argn, args );
  if( scope ) setScope( origScope );
  return( status );
}

substitute_clist_args( arg, str, cargn, cargs )
char *arg, *str, cargs[][Largs]; int cargn;
{
  int n_carg; char *astart, *index();
  while((astart=index( str,'$')) && sscanf(astart, "$%d", &n_carg)) {
    if( --n_carg >= cargn ) 
      Erreturn2("argument %d missing for %s", n_carg+1, str );
    *arg = NULL;
    strncat( arg, str, astart-str );
    strcat( arg, cargs[n_carg-1] );
    strcat( arg, astart+2 );
    strcpy( str, arg );
  }
  strcpy( arg, str );
  return( OK );
}

print_clist()
{
  register int i,n;
  CLIST    *item;
  if ( Nclist == 0 ) { sendMsg("no item in command list.\n"); return(OK);}
  for ( i=0; i< Nclist; i++ ) {
    item = CList[i];
    addMsg3("%d%c %s ", i+1, item->status==ON? '*' : ' ', item->command );
    for( n = 0; n < item->argn; n++ ) addMsg1("%s ", item->args[n] );
    addMsg("\n"); endMsg();
  }  
  return ( OK );
}

print_clist_commands()
{
  register int i,n;
  CLIST    *item;
  sendMsg("clist clear\n");
  for ( i=0; i< Nclist; i++ ) {
    item = CList[i];
    beginMsg("clist");
    addMsg1(" %s", item->command );
    for( n = 0; n < item->argn; n++ ) addMsg1(" %s", item->args[n] );
    addMsg("\n"); endMsg();
  }  
  return ( OK );
}

command_list( command, argn, args )
char *command;
int	argn; char args[][ Largs ];
{
  CLIST *make_citem();
  register int n;
  IF( command, "clear" ) { Nclist = 0; return( OK ); }
  if( Nclist >= MaxClist ) 
    Erreturn1("Sorry, no more than %d items in the list", MaxClist );

  if( CList[ Nclist ] == NULL ) CList[ Nclist ] = new(CLIST);

  IfErr( make_citem( CList[ Nclist ], command, argn, args ) ) return(ERR);
  Nclist++ ;
  return( OK );
}

CLIST *
make_citem( item, command, argn, args )
CLIST *item;
char *command;
int	argn; char args[][ Largs ];
{
  register int n;
  IF( command, "repeat" ) 
    Erreturn("Sorry, 'repeat' cannot be put into command list");
  IF( command, "cycle" )
    puts("Warning: 'clist cycle' may cause infinite loop (cycle may execute clist)");
  if(Err(which_command( command )) && !EQL(command, "quit") &&
     !EQL(command, "source") && command[0] != '!' )
    Erreturn1("%s: not a command", command );

  IfErr(item->command = new_string( command, item->command ))
    Erreturn("not enough core");
  if( item->argn && item->args ) {
    for( n=0; n< item->argn; n++ ) if( item->args[n] ) free( item->args[n] );
    free_2d_array( item->args, item->argn );
  }
  if( argn ) {
    IfErr(item->args =new_array_of( argn, char* )) Erreturn("not enough core");
    for( n=0; n< argn; n++ ) 
      IfErr(item->args[n] = new_string(args[n], NULL)) 
	Erreturn("not enough core");
  }
  item->argn = argn;
  item->status = ON;
  return ( item );
}

SAVELIST *Savelist[ MaxSavelist ] ;
int	N_Savelist = 0;

print_savelist_names ( )
{
  register int i;
  SAVELIST    *item;
  if ( N_Savelist == 0 ) { sendMsg("no item in save list.\n"); return(OK);}
  for ( i=0; i< N_Savelist; i++ ) {
    item = Savelist[i];
    addMsg2("%d%c ", i+1, item->status==ON? '*' : ' ' );
    addMsg1("%s\n", Savelist[ i ]->name ); endMsg();
  }  
  return ( OK );
}

save_list ( net, name )
NETWORK	*net ;
char	name[];
{
  SAVELIST *item;
  NUMBER *find_vector();
  
  IF ( name, "clear" ) { N_Savelist = 0; return( OK ); }
  
  if ( N_Savelist >= MaxSavelist ) 
    Erreturn1("Sorry, no more than %d items in the list", MaxSavelist );

  if( Savelist[ N_Savelist ] == NULL ) Savelist[ N_Savelist ] = new(SAVELIST);

  item = Savelist[ N_Savelist ];
  /* IfErr( item->vector = find_vector ( net, name, &item->nvalue)) 
    Erreturn2 ("%s not found in network", name );   */
  IfErr( item->expr = find_optimize_expression( net, name )) return(ERR);

  item->name = new_string ( name, item->name );
  item->status = ON;
  N_Savelist++ ;
  return ( OK );
}

fprint_items( fp )
FILE *fp;
{
  register int i;
  SAVELIST *item;
  Starting(inList);
  for( i=0; i < N_Savelist ; i++ ) {
    if( INTERRUPT ==INTR_LIST ) {
      sendMsg1("interrupted at save list item #%d\n",i+1);
      if( DoInterrupt("save list") == EXIT ) {
	Ending(inList);
	Erreturn1("exit at save list item #%d",i+1);
      }
    }
    item = Savelist[i];
    if( item->status == OFF ) continue;
    if( Err( evalExpression( item->expr )) ||
    	Err( fprint_vector( fp, item->name, item->expr->vector->value, 
			item->expr->vector->nvalue, 0, "%g "))) {
      Ending(inList);
      return(ERR);
    }
  }
  Ending(inList);  return( OK );
}

#if sunnet|planet|xnet|mgr

DLIST  *Dlist[ MaxDlist ] ;
int N_Dlist;

print_dlist_names( )
{
  register int i;
  DLIST    *item;
  if( N_Dlist == 0 ) { sendMsg("no item in display list.\n"); return(OK);}
  for( i=0; i< N_Dlist; i++ ) {
    item = Dlist[i];
    addMsg2("%d%c ", i+1, item->status==ON? '*' : ' ' );
    addMsg1("%s", item->label );
    addMsg1("\twindow=%s", item->window? item->window->name : "unspecified" );
    addMsg1(", unit=%s", item->unit? item->unit->name : "dunit parameter" );
    if(item->type==ItsVector || item->type==ItsExpr)
      addMsg1(", column=%s",item->ncol? item->ncol->name : "unspecified");
    if(item->flagsOn&TransFlag) addMsg(", transpose");
    if(item->flagsOn&NormFlag) addMsg(", normalize" );
    if(item->flagsOn&SquareFlag) addMsg(", square");
    if(item->flagsOn&EraseFlag) addMsg(", erase" );
    if(item->flagsOn&LabelFlag) addMsg(", label" );
    if(item->flagsOn&NumberFlag) addMsg(", number" );
    if(item->flagsOff&TransFlag) addMsg(", -transpose");
    if(item->flagsOff&EraseFlag) addMsg(", -erase");
    if(item->flagsOff&NumberFlag) addMsg(", -number");
    if(item->flagsOff&LabelFlag) addMsg(", -label");
    if(item->flagsOff&NormFlag) addMsg(", -normalize" );
    if(item->flagsOff&SquareFlag) addMsg(", -square");
    addMsg("\n"); endMsg();
  }  
  return( OK );
}

print_dlist_commands( )
{
  register int i;
  DLIST    *item;
  sendMsg("dlist clear\n");
  for( i=0; i< N_Dlist; i++ ) {
    item = Dlist[i];
    beginMsg("dlist");
    addMsg1(" %s", item->label );
    if(item->window) addMsg1(" win%s", item->window->name );
    if(item->unit) addMsg1(" unit%s", item->unit->name );
    if(item->type==ItsVector || item->type==ItsExpr)
      if(item->ncol) addMsg1(" col%s", item->ncol->name );
    if(item->flagsOn&TransFlag) addMsg(" transpose");
    if(item->flagsOn&NormFlag) addMsg(" normalize" );
    if(item->flagsOn&SquareFlag) addMsg(" square");
    if(item->flagsOn&EraseFlag) addMsg(" erase" );
    if(item->flagsOn&LabelFlag) addMsg(" label" );
    if(item->flagsOn&NumberFlag) addMsg(" number" );
    if(item->flagsOff&TransFlag) addMsg(" -transpose");
    if(item->flagsOff&EraseFlag) addMsg(" -erase");
    if(item->flagsOff&NumberFlag) addMsg(" -number");
    if(item->flagsOff&LabelFlag) addMsg(" -label");
    if(item->flagsOff&NormFlag) addMsg(" -normalize" );
    if(item->flagsOff&SquareFlag) addMsg(" -square");
    addMsg("\n"); endMsg();
  }  
  return( OK );
}

display_list( net, name, window, ncol, unit, flagsOn, flagsOff )
NETWORK *net;
char  *name;
EXPRESS  *window,*ncol, *unit;
unsigned flagsOn,flagsOff;
{
  int i;
  DLIST *item;
  char str[16];
  IF( name, "clear" ) { N_Dlist = 0; return( OK ); }
  if( N_Dlist >= MaxDlist ) 
    Erreturn1("Sorry, cannot display more than %d items", MaxDlist );

  if( Dlist[ N_Dlist ] == NULL ) Dlist[ N_Dlist ] = new( DLIST );

  item = Dlist[ N_Dlist ];
  if( item->type == ItsExpr ) delete_expression( (EXPRESS*) item->ptr );
  if( item->ncol ) delete_expression( item->ncol );
  if( item->window ) delete_expression( item->window );
  if( item->unit ) delete_expression( item->unit );

  if( item->ptr =(char *) which_connection( net, name ) ) {
    item->type = ItsWeight ;
    item->ncol = NULL;
  }
  else if( item->ptr =(char *) which_connection_arg( net, name ) ) {
    item->type = ItsWeightP ;	/* procedure argument of type 'connect' */
    item->ncol = NULL;
  }
  else if( item->ptr = (char *) find_optimize_expression(net,name)) {
    item->type = ItsExpr;
    item->ncol = ncol ;
  }
  else return(ERR);

  item->label = new_string( name, item->label );
  
  item->window = window;
  item->status = ON;
  item->flagsOn = flagsOn;
  item->flagsOff = flagsOff;
  item->unit = unit;

  N_Dlist++ ;
  return( OK );
}

display_items( window )
WINDOW  **window;
{
  register i;
  DLIST *item;
  VECTOR *vector, *vec;
  int   ncol, nwin; REAL unit;
  int   status;
  unsigned flags, flags_default;

  get_default_flags( &flags_default );
  flags_default |= (XnumFlag|YnumFlag);

  Starting(inList);
  for( i=0; i< N_Dlist ; i++ ) {
    if( INTERRUPT == INTR_LIST ) {
      sendMsg1("interrupt at display list item #%d\n",i+1);
      if( DoInterrupt("dlist") == EXIT ) {
	Ending(inList);
	Erreturn1("exit at display list item #%d",i+1);
      }
    }
    item = Dlist[ i ];
    if( item->status == OFF ) continue;	/* display only if status=ON */

    if( Err( vec = eval_expression(item->window) ) ||
	    (nwin= (int) vec->value[0]+.00001)<1 ) {
      Ending(inList);
      Erreturn2("%s: invalid window in dlist item #%d",item->window->name,i+1);
    }
    
    if( item->ncol ) {
      IfErr( vec = eval_expression(item->ncol) ){
	Ending(inList);
	Erreturn1("invalid no. of columns in dlist item #%d",i+1);
      }
      ncol = (int) vec->value[0]+.00001;
    } else ncol = 0;	/* using Ncol here would be too confusing */

    if( item->unit ) {
      IfErr( vec = eval_expression(item->unit) ) {
	Ending(inList);
	Erreturn1("invalid unit in dlist item #%d",i+1);
      }
      unit = vec->value[0];
    } else unit = Unit;
    if( unit <= 0 ) {
      Ending(inList);
      Erreturn1("%d: 'unit' must be positive", unit);
    }

    flags = (flags_default|(item->flagsOn))&(~(item->flagsOff));

	/* this line previously commented out but put here again to fix
	   bug of not erasing window when it should 
	   there may be some problem with it - just redundancy? */
    if( flags&EraseFlag ) wipe_window( window[nwin] );
    if ( item->type == ItsExpr ) {
      IfErr( vector = eval_expression( (EXPRESS *) item->ptr) ) {
	Ending(inList);	Erreturn2("%s: in dlist item #%d", ERR_MSG, i+1 );
      }
      IfErr(display_vector(window[nwin], (REAL*) vector->value,
			   vector->nvalue, 
			   ncol? ncol : vector->nvalue1? 
			   vector->nvalue1 : vector->nvalue, 
			   1, item->label, unit, flags )) {
	Ending(inList);	Erreturn2("%s: in dlist item #%d", ERR_MSG, i+1 );
      }
    }
    else if( item->type == ItsWeight ) {
      IfErr(display_weight( window[nwin], (CONNECT*) item->ptr, unit, flags )){
	Ending(inList);	Erreturn2("%s: in dlist item #%d", ERR_MSG, i+1 );
      }
    }
    else if( item->type == ItsWeightP ) {
      IfErr(display_weight( window[nwin], (CONNECT*)*item->ptr, unit, flags )){
	Ending(inList); Erreturn2("%s: in dlist item #%d", ERR_MSG, i+1 );
      }
    }
  }
  Ending(inList);
  return( OK );
}

GLIST *Glist[ MaxGlist ];
int N_Glist;

print_glist_names( )
{
  register int i;
  GLIST    *item;
  if( N_Glist == 0 ) { sendMsg("no item in graph list.\n"); return(OK);}
  for( i=0; i< N_Glist; i++ ) {
    item = Glist[i];
    addMsg2("%d%c ", i+1, item->status==ON? '*' : ' ' );
    addMsg3("%s\tmarker=%c scale=%g\n",
	    Glist[i]->name, Glist[i]->marker, Glist[i]->scale );
    endMsg();
  }  
  return( OK );
}

print_glist_commands( )
{
  register int i;
  GLIST    *item;
  sendMsg("glist clear\n");
  for( i=0; i< N_Glist; i++ ) {
    item = Glist[i];
    beginMsg("glist");
    addMsg3(" %s %c %g\n",
	    Glist[i]->name, Glist[i]->marker, Glist[i]->scale );
    endMsg();
  }  
  return( OK );
}

graph_list( net, name, marker, scale )
NETWORK *net;
char *name;
char marker;
float scale;
{
  GLIST *item;
  int    n;

  IF( name, "clear" ) { N_Glist = 0; return( OK ); }

  IfErr( net ) Erreturn("Network not defined");
  
  if( N_Glist >= MaxGlist ) 
    Erreturn1("Sorry, cannot plot more than %d items", MaxGlist );

  if( Glist[ N_Glist ] == NULL ) Glist[ N_Glist ] = new( GLIST );

  item = Glist[ N_Glist ];
  
  IF( name, "error" ) {
    IfErr(item->expr = find_optimize_expression( net, "$globalError" ))
      Erreturn("cannot make graph list for error");
    marker = '+';
    scale = 1.0;
  }
  else {
    IfErr( item->expr = find_optimize_expression( net, name ) ) return(ERR);
  }
  IfErr( evalExpression(item->expr) ) return(ERR);

  item->name = new_string( name, item->name );
  item->marker = marker;
  item->scale = scale;
  item->status = ON;
  IfErr( item->n_alloc ) {
    if(Err(item->step_save = new_array_of( nGraphSave, int )) ||
       Err( item->save = new_array_of( nGraphSave, REAL ))) Erreturn("not enough memory");
    item->n_alloc = nGraphSave;
    item->n_save = 0;
  }
  item->step_save[0] = 0;
  item->save[0] = *item->expr->vector->value ;

  N_Glist++ ;
  return( OK );
}

alloc_glist_item( item )
GLIST *item;
{
  if(Err( item->step_save = (int*) change_array_size((char*) item->step_save, 
						    item->n_alloc, item->n_alloc+nGraphSave,
						    sizeof(int))) ||
     Err( item->save = (REAL*) change_array_size((char*) item->save, 
						 item->n_alloc, item->n_alloc+nGraphSave,
						 sizeof(REAL))))
    Erreturn("not enough memory");
  item->n_alloc += nGraphSave;
  return(OK);
}

initialize_graph_list()
{
  register int i; GLIST *item;
  for( i=0; i< N_Glist ; i++ ) {
    item = Glist[ i ];
    item->n_save = 0;
    item->step_save[0] = 0;
  }
}

graph_items( G, step, logscale, markit )
GRAPH  *G;
int    step;
int    logscale, markit;
{
  register int i;
  GLIST *item;
  NUMBER value; int status;
  VECTOR *vec;
  
  Starting(inList);
  for( i=0; i< N_Glist ; i++ ) {
    if( INTERRUPT == INTR_LIST ) {
      sendMsg1("interrupt at glist item #%d\n", i+1 );
      if( DoInterrupt("glist") == EXIT ) {
	Ending(inList);	Erreturn1("exit at glist item #%d", i+1 );
      }
    }
    item = Glist[i] ;
    if( item->status == OFF ) {
      item->step_save[item->n_save] = 0; /* no plotting at 1st step after it gets turned on*/
      continue;
    }
    IfErr( vec = eval_expression( item->expr )) {
      Ending(inList); return(ERR);
    }
    value =(logscale)?(float) log10((double) *vec->value ) : *vec->value ;
    if( item->scale != 1.0) value *= item->scale;
    if( 0 < item->step_save[item->n_save] && item->step_save[item->n_save] < step )
      IfErr( draw_line_in_graph( G,(float) item->step_save[item->n_save], item->save[item->n_save],
				(float) step, value ) ){
	Ending(inList);	Erreturn1("%s: error in plotting", ERR_MSG);
      }
    if( markit ) {
      set_marker( item->marker );
      IfErr( draw_marker_in_graph( G,(NUMBER) step, value ) ){
	Ending(inList);
	Erreturn2("%s: cannot plot marker for %s", ERR_MSG, item->name );
      }
    }
    if( ++item->n_save >= item->n_alloc && Err( alloc_glist_item( item ) )) {
      Ending(inList); return(ERR);
    }
    item->step_save[item->n_save] = step ;
    item->save[item->n_save] = value ;
  }
  Ending(inList);
  return( OK );
}

graph_saved_items( G )
GRAPH  *G;
{
  register int i,j;
  GLIST *item; int *step_save;
  REAL *save;
  
  for( i=0; i< N_Glist ; i++ ) {
    item = Glist[i] ;
    if( item->status == OFF ) continue;
    step_save = item->step_save;
    save = item->save;

    for( j=item->n_save; j; j--, step_save++, save++ ) {
      if( 0 < *step_save && *step_save < *(step_save+1) )
	IfErr( draw_line_in_graph( G,(float) *step_save, *save,
				  (float) *(step_save+1), *(save+1) ) )
	Erreturn1("%s: error in plotting", ERR_MSG);
      if( StepMark && *(step_save+1)%StepMark == 0 ) {
	set_marker( item->marker );
	IfErr( draw_marker_in_graph( G,(float) *(step_save+1), *(save+1) ) )
	  Erreturn2("%s: cannot plot marker for %s", ERR_MSG, item->name );
      }
    }
  }
  return( OK );
}

PLOTLIST *PlotList[ MaxPlotList ];
int  Nplotlist = 0;

print_plotlist_names( )
{
  register int i,j;
  PLOTLIST *item;
  if( Nplotlist == 0 )
    { sendMsg("no item in plot list.\n"); return(OK);}
  for( i=0; i< Nplotlist; i++ ) {
    item = PlotList[i];
    addMsg2("%d%c ", i+1, item->status==ON? '*' : ' ' );
    addMsg2("X: %s Y: %s ", item->x_name, item->y_name );
    if( item->marker != '\n' ) addMsg1("marker=%c ", item->marker );
    if(item->xscale!=1.0 || item->yscale!=1.0)
      addMsg2("xscale=%g yscale=%g",item->xscale,item->yscale);
    addMsg("\n"); endMsg();
  }
  return( OK );
}

print_plotlist_commands( )
{
  register int i,j;
  PLOTLIST *item;
  sendMsg("plotlist clear\n");
  for( i=0; i< Nplotlist; i++ ) {
    item = PlotList[i];
    beginMsg("plotlist");
    addMsg2(" %s %s", item->x_name, item->y_name );
    if( item->marker == '\n' ) addMsg(" line");
    else addMsg1(" %c", item->marker );
    if(item->xscale!=1.0 || item->yscale!=1.0)
      addMsg2(" %g %g",item->xscale,item->yscale);
    addMsg("\n"); endMsg();
  }
  return( OK );
}

#define min( x, y ) ((x)>(y)? (x):(y))
plot_list( net, x_name, y_name, argn, args, nitem )
NETWORK *net;
int argn, nitem;
char *x_name, *y_name, args[][ Largs ];
{
  int	n_x=0, n_y=0;
  PLOTLIST *item;
  IF( x_name, "clear" ) { Nplotlist = 0; return( OK ); }
  IF( args[0], "mesh" ) {
    Erreturn("sorry - use a matrix to do meshed plotting");
  }
  else if( --nitem >= 0 && nitem < Nplotlist ) item = PlotList[nitem];
  else {
    if( Nplotlist >= MaxPlotList ) 
      Erreturn1("Sorry, cannot plot more than %d items", MaxPlotList );
    if(Err( PlotList[ Nplotlist ] ) && 
       Err( PlotList[ Nplotlist ] = new( PLOTLIST )))
      Erreturn( "not enough core" );
    item = PlotList[ Nplotlist++ ];
  }

  if( item->x_expr) delete_expression(item->x_expr);
  if( item->y_expr) delete_expression(item->y_expr);

  IfErr( item->x_expr = find_optimize_expression(net, x_name ))
    Erreturn2("%s: in %s", ERR_MSG, x_name );

  IfErr( item->y_expr = find_optimize_expression(net, y_name ))
    Erreturn2("%s: in %s", ERR_MSG, y_name );

  item->x_name = new_string( x_name, item->x_name );
  item->y_name = new_string( y_name, item->y_name );

  item->xscale = item->yscale = 1.0;		/* default scale */
  if( argn > 1 && Err( AtoF( args[1], item->xscale )) )
    Erreturn(get_syntax("plotlist"));
  if( argn > 2 && Err( AtoF( args[2], item->yscale )) )
    Erreturn(get_syntax("plotlist"));

  if( item->marker = NULL ) item->marker = '\n';
  if( argn > 0 ) {
    IF( args[0], "line" ) item->marker = '\n';
    else IF( args[0], "arrow" ) item->marker = '\t';
    else item->marker = args[0][0];
  }
  item->status = ON;
  return( OK );
}

plot_all_items( plot )
GRAPH *plot;
{
  register int i;
  int istart, maxpoints, status;
  IfErr( plot ) Erreturn("plot not open");
  Starting(inList);
  for( i=0; i < Nplotlist ; i++ ) {
    if( INTERRUPT == INTR_LIST ) {
      sendMsg1("interrupt at plot list item #%d\n", i+1 );
      if( DoInterrupt("plotlist") == EXIT ) {
	Ending(inList);	Erreturn1("exit at plot list item #%d", i+1 );
      }
    }
    if( PlotList[i]->status == OFF ) continue;
    IfErr( plot_item( plot, PlotList[i] ) ) {
      Ending(inList); return( ERR );
    }
  }
  Ending(inList);
  return( OK );
}

plot_item( plot, item )
GRAPH	*plot;
PLOTLIST *item;
{
  register int i,j;
  float xscale,yscale;
  VECTOR *x_vec, *y_vec;
  REAL *x_val, *y_val;
  int  x_nval, y_nval;
  int nrow, ncol, matrix=0;
  int (*draw_func)(), draw_arrow_in_graph(),draw_line_in_graph();

  IfErr( plot ) Erreturn( "plot not open" );
  xscale = item->xscale;
  yscale = item->yscale;

  IfErr(x_vec = eval_expression(item->x_expr))
    Erreturn1("%s: in expression",ERR_MSG);

  IfErr(y_vec =eval_expression(item->y_expr))
    Erreturn1("%s: in expression",ERR_MSG);

  if( item->marker == '\n' || item->marker=='\t' ) {	/* plot with lines */
    draw_func = ( item->marker=='\n' )? draw_line_in_graph :
      					draw_arrow_in_graph ;
    if( ! x_vec->nvalue1 || ! y_vec->nvalue1 ) { /* vectors -> no meshing  */
      item->npoint = min( x_vec->nvalue, y_vec->nvalue );
      x_val = x_vec->value, y_val = y_vec->value;
      for( i= item->npoint-1 ; i ; i--, x_val++, y_val++ ) {
	IfErr( (*draw_func)( plot, xscale * *x_val, yscale * *y_val,
			    xscale * *(x_val+1), yscale * *(y_val+1) ))
	  Erreturn1("%s: error in plot", ERR_MSG );
      }
    }
    else {		/* both matrices -> 2-d meshed plotting */
      if( x_vec->nvalue1 != y_vec->nvalue1 || x_vec->nvalue2 != y_vec->nvalue2)
	Erreturn("incompatible matrix sizes");
      nrow = x_vec->nvalue1, ncol = x_vec->nvalue2;
      for( i=0; i<nrow ; i++ ) {	/* connect points in each row */
	x_val = x_vec->value+i*ncol, y_val = y_vec->value+i*ncol;
	for( j=ncol-1; j ; j--, x_val++, y_val++ )
	  IfErr( (*draw_func)( plot, 
			      xscale * *x_val, yscale * *y_val,
			      xscale * *(x_val+1), yscale * *(y_val+1) ))
	    Erreturn1("%s: error in plot", ERR_MSG );
      }
      for( i=0; i < ncol ; i++ ) {	/* connects points in each column */
	x_val = x_vec->value+i, y_val = y_vec->value+i;
	for( j=nrow-1; j ; j--, x_val += ncol, y_val += ncol )
	  IfErr( (*draw_func)( plot, 
			      xscale * *x_val, yscale * *y_val,
			      xscale * *(x_val+ncol),
			      yscale * *(y_val+ncol) ))
	    Erreturn1("%s: error in plot", ERR_MSG );
      }
    }
    return( OK );
  }
  IfErr( set_marker( item->marker ) )
    Erreturn1("%s: error in setting marker", ERR_MSG);
  for( x_val=x_vec->value, y_val=y_vec->value,
      i= min(x_vec->nvalue, y_vec->nvalue); i ; i--, x_val++, y_val++ )
    IfErr( draw_marker_in_graph( plot, xscale* *x_val, yscale* *y_val ) )
      Erreturn1( "%s: error in plot", ERR_MSG ); 
  return( OK );
}
#endif sunnet|planet|xnet|mgr

list( type, argn, args )
char *type;
int	argn; char	args[][ Largs ];
{
  register int i;
  int	nitem, n1, n2;
  if( argn < 2 ) Erreturn(get_syntax( "list" ));
  IF( args[0], "-" ) {
    for( i=1; i < argn; i++ ) {
      IF( args[i], "all" ) return( list_turnoff_all( type ) );
      if( Err( find_range( args[i], &n1, &n2 )) || n1 < 1 || n2 < 1 )
	{ sendMsg1("\t%s: invalid item #\n", args[i] ); continue; }
      for( nitem=n1; nitem <= n2; nitem++ ) 
	IfErr( list_turnoff( type, nitem ) ) sendMsg1("\t%s.\n",ERR_MSG);
    }
    return( OK );
  }
  IF( args[0], "+" ) {
    for( i=1; i < argn; i++ ) {
      IF( args[i], "all" ) return( list_turnon_all(type) );
      if( Err( find_range( args[i], &n1, &n2 )) || n1 < 1 || n2 < 1 )
	{ sendMsg1("\t%s: invalid item #\n", args[i] ); continue; }
      for( nitem=n1; nitem <= n2; nitem++ ) 
	IfErr( list_turnon( type, nitem ) ) {
	  sendMsg1("\t%s.\n",ERR_MSG);
	}
    }
    return( OK );
  }
  else if( AtoI(args[0], nitem ) ) {
    list_turnoff_all( type );
    IfErr( list_turnon( type, nitem ) ) sendMsg1("\t%s.\n",ERR_MSG);
    for( i=1 ; i < argn; i++ ) {
      if( Err( AtoI( args[i], nitem ) ) || nitem<1 ) 
	 { sendMsg1("\t%s: invalid item #\n", args[i] ); continue; }
      IfErr( list_turnon( type, nitem ) ) sendMsg1("\t%s.\n",ERR_MSG); 
    }
  }
  else IF( args[0], "all" ) return( list_turnon_all(type) );
}

list_turnoff ( type, n )
char *type;
int n;
{
  int nitem = n-1 ;
  IF( type, "Print" ) {
    if ( nitem >= N_Plist ) Erreturn1("item # %d not defined", n );
/*if( Plist[nitem]->status==OFF) Erreturn1("item # %d already turned off",n);*/
    Plist[nitem]->status = OFF;
  }
  else IF( type, "Command" ) {
    if ( nitem >= Nclist ) Erreturn1("item # %d not defined", n );
/*if( CList[nitem]->status==OFF) Erreturn1("item # %d already turned off",n);*/
    CList[nitem]->status = OFF;
  }
  else IF( type, "Save" ) {
    if ( nitem >= N_Savelist ) Erreturn1("item # %d not defined", n );
/*if( Savelist[nitem]->status==OFF) Erreturn1("item # %d already turned off",n);*/
    Savelist[nitem]->status = OFF;
  }
#if sunnet|planet|xnet|mgr
  else IF( type, "Display" ) {
    if( nitem >= N_Dlist ) Erreturn1("item # %d not defined", n );
/*if(Dlist[nitem]->status==OFF) Erreturn1("item # %d already turned off",n);*/
    Dlist[nitem]->status = OFF;
  }
  else IF( type, "Graph" ) {
    if( nitem >= N_Glist ) Erreturn1("item # %d not defined", n );
/*if( Glist[nitem]->status == OFF) Erreturn1("item # %d already turned off",n);*/
    Glist[nitem]->status = OFF;
  }
  else IF( type, "Plot" ) {
    if( nitem >= Nplotlist ) Erreturn1("item %d not defined", n);
/*if( PlotList[nitem]->status == OFF) Erreturn1("item # %d already turned off",n);*/
    PlotList[nitem]->status = OFF;
  }
#endif sunnet|planet|xnet|mgr
  return( OK );
}

list_turnon( type, n )
char *type;
int n;
{
  int nitem = n-1;
  IF( type, "Print" ) {
    if ( nitem >= N_Plist ) Erreturn1("item # %d not defined", n );
    Plist[nitem]->status = ON;
  }
  else IF( type, "Command" ) {
    if ( nitem >= Nclist ) Erreturn1("item # %d not define", n );
    CList[nitem]->status = ON;
  }
  else IF( type, "Save" ) {
    if ( nitem >= N_Savelist ) Erreturn1("item # %d not define", n );
    Savelist[nitem]->status = ON;
  }
#if sunnet|planet|xnet|mgr
  else IF( type, "Display" ) {
    if( nitem >= N_Dlist ) Erreturn1("item # %d not defined", n );
    Dlist[nitem]->status = ON;
  }
  else IF( type, "Graph" ) {
    if( nitem >= N_Glist ) Erreturn1("item # %d not define", n );
    Glist[nitem]->status = ON;
  }
  else IF( type, "Plot" ) {
    if( nitem >= Nplotlist ) Erreturn1("item %d not defined", n);
    PlotList[nitem]->status = ON;
  }
#endif sunnet|planet|xnet|mgr
  return( OK );
}

list_turnoff_all( type )
char *type;
{
  register int i;
  IF( type, "Print" ) for ( i=0; i< N_Plist; i++ ) Plist[i]->status = OFF;
  else IF( type, "Command" ) for( i=0; i< Nclist; i++ ) CList[i]->status = OFF;
  else IF( type, "Save" ) for( i=0; i< N_Savelist; i++ ) Savelist[i]->status = OFF;
#if sunnet|planet|xnet|mgr
  else IF( type, "Display") for( i=0; i< N_Dlist; i++ ) Dlist[i]->status = OFF;
  else IF( type, "Graph" ) for( i=0; i< N_Glist; i++ ) Glist[i]->status = OFF;
  else IF( type, "Plot")
    for( i=0; i< Nplotlist ; i++ ) PlotList[i]->status = OFF;
#endif sunnet|planet|xnet|mgr
  return( OK );
}

list_turnon_all ( type )
char *type;
{
  register int i;
  IF( type, "Print" ) for ( i=0; i< N_Plist; i++ ) Plist[i]->status = ON;
  else IF( type, "Command" ) for( i=0; i< Nclist; i++ ) CList[i]->status = ON;
  else IF( type, "Save" ) for( i=0; i< N_Savelist; i++ ) Savelist[i]->status = ON;
#if sunnet|planet|xnet|mgr
  else IF( type, "Display" ) for( i=0; i< N_Dlist; i++ ) Dlist[i]->status = ON;
  else IF( type, "Graph" ) for( i=0; i< N_Glist; i++ ) Glist[i]->status = ON;
  else IF( type, "Plot" )
    for( i=0; i< Nplotlist ; i++ ) PlotList[i]->status = ON;
#endif sunnet|planet|xnet|mgr
  return( OK );
}

PATTERN *PatternList[MaxPatternList];
int	NPatternList;

find_pattern( name, fname, npattern, input, target, n_input, n_target, label, date )
char *name, *fname; int *npattern, *n_input, *n_target;
NUMBER ***input, ***target; char ***label; long *date;
{
  register int i;
  PATTERN *pattern;
  for( i=0; i< NPatternList; i++ ) {
    pattern = PatternList[i];
    if(EQL( name, pattern->name ) || EQL( name, pattern->fname))  {
      *npattern = pattern->npattern;
      *input = pattern->input;
      *target = pattern->target;
      *n_input = pattern->n_input;
      *n_target = pattern->n_target;
      *label = pattern->label;
      *date = pattern->date;
      strcpy( fname, pattern->fname );
      return( OK );
    }
  }
  return( ERR );
}

store_pattern( name, fname, npattern, input, target, n_input, n_target, label, date )
char *name, *fname; int npattern, n_input, n_target;
NUMBER **input, **target; long date;
char **label;
{
  register int i;
  PATTERN *pat;
  for( i=0; i< NPatternList; i++ ) {	/* check if it's already stored */
    pat = PatternList[i];
    if( EQL( name, pat->name ) || EQL( name, pat->fname)) {
	/* same pattern file stored before -> delete it */
      free_2d_array( pat->input, pat->npattern ); 
      free_2d_array(pat->target, pat->npattern );
      if( pat->label ) { free_2d_array( pat->label, pat->npattern );
			 pat->label = NULL;}
    break;
    }
  }
  if( i == NPatternList ) {    /* not stored yet */
    if( NPatternList >= MaxPatternList ) 
      Erreturn1("no more than %d sets of patterns", MaxPatternList );
    IfErr( pat = PatternList[NPatternList] = new( PATTERN ))
      Erreturn("not enough core");
    NPatternList++ ;
  }
  pat->name = new_string( name, pat->name );
  pat->fname = new_string( fname, pat->fname );
  pat->npattern = npattern;
  pat->n_input = n_input; pat->n_target = n_target;
  pat->input = input; pat->target = target;
  pat->label = label;
  pat->date = date;
  return( OK );
}

