/* $Header: /soma/users/miyata/planet/src/RCS/help.c,v 5.6.0.5 91/02/13 15:41:11 miyata Exp $ */
static char rcsid[] = "$Header: /soma/users/miyata/planet/src/RCS/help.c,v 5.6.0.5 91/02/13 15:41:11 miyata Exp $";
#include <stdio.h>
#include <sys/ioctl.h>
#include "command.h"
#include "error.h"
#if xnet|sunnet|planet
#include "help.h"
#else
#include "starhelp.h"
#endif
#include "msg.h"

#ifndef BUFSIZE
#define BUFSIZE 128
#endif

char *get_termcap();
char SO[16]="???", SE[16];	/* termcap strings for standout and standend */

void
help ( command )
char	*command; 
{
  COMMAND	*commandP ;
  FILE  *fp, *open_pager(), *outf = NULL;
  void close_pager();
  char  *HelpFile;
  char  buf[ BUFSIZE ];
  char  str[ BUFSIZE ];
  register int i;
  
  IF( command, "list_names" ) {
    sendMsg("List of commands - type 'help <command>' for explanation of <command>.\n");
    for ( i=0; i < Ncommand ; i++ ) {
/*    checkMsg( strlen( Command[i].name )+1 );*/
      if( Command[i].func == NULL ) {
	if( i> 0 ) sendMsg("\n");
	sendMsg1("\n%s ", Command[i].name );
      }
      else
	sendMsg1("%s  ", Command[i].name );
    }
/*  if ( Ncommand%6 > 0 ) sendMsg( "\n" );     /* new line if Ncommand != 6N */
    sendMsg("\n\nTop Level:     quit help repeat source time alias unalias !<shell command>\n");
    return;
  }

  IfErr( fp = fopen ( HELPFILE, "r" ) ) {
    sendMsg1( "Cannot open help file %s.\n", HELPFILE );
    return ;
  }

#ifndef shellinput
  IfErr( outf = open_pager() ) outf = stdout;
#endif
  if( !strcmp( SO, "???" ) ) {	/* get termcap for standout/standend */
    *SO = NULL; *SE = NULL;	/* default is no standout */
    if( init_termcap() ) {
      IfErr( get_termcap( "so", SO ) ) *SO = NULL;
      IfErr( get_termcap( "se", SE ) ) *SE = NULL;
    }
  }
  while ( fgets ( buf, BUFSIZE, fp ) ) {
    if(!sscanf(buf, "help: %s", str ) || strcmp(str, command ))
      continue;
    while( fgets( buf, BUFSIZE, fp ) && !sscanf(buf, "help: %s", str)) 
      print_str( buf, outf );
    print_str( "\n", outf );
/*  break;	look for more items with same name */
  }
#ifndef shellinput
  close_pager( outf );
#endif
  fclose ( fp );
}

char *
get_syntax ( command )
char	*command;
{
  static  char	buf[BUFSIZE];
  char    str[BUFSIZE];
  FILE    *fp;

  IfErr( fp = fopen ( HELPFILE, "r" ) ) {
    sendMsg ( "Sorry, couldn't read help file.\n" );
    return ( "" );
  }
  while ( fgets ( buf, BUFSIZE, fp ) ) {
    if(!sscanf(buf, "syntax: %s", str ) || strcmp(str, command ))
      continue;
    fclose ( fp );
    return ( buf );
  }
  return ( "" );
}

#if 0
#ifdef	TIOCGSIZE  /**	Sun version  */
struct ttysize TTYsize;
#define	TTY_COLS	TTYsize.ts_cols
#define TTY_LINES	TTYsize.ts_lines
#define	TIOC_GETWINDOWSIZE	TIOCGSIZE
#endif	TIOCGSIZE

#ifndef TTY_COLS	/*	4.3 version */
/** #ifdef	TIOCGWINSZ conflicts with above on the vax */
struct winsize TTYsize;
#define	TTY_COLS	TTYsize.ws_col
#define TTY_LINES	TTYsize.ws_row
#define	TIOC_GETWINDOWSIZE	TIOCGWINSZ

#endif	TIOCGWINSZ

int	FileDesc = 1;				/* which file to use */

get_lines_in_window()
{
  TTY_LINES = -1;  TTY_COLS = -1;
  if( ioctl( FileDesc,TIOC_GETWINDOWSIZE,&TTYsize ) < 0 ) return(ERR);
  return( TTY_LINES );
}
#endif 0

print_str( str, outf )
char *str; FILE *outf;
{
  char *start;
  if( outf == NULL ) outf = stdout;
  for( start = str ; *str != NULL; str++ ) {
    if( *str == '' ) {
      *str = NULL;
#ifdef shellinput
      sendMsg2( "%s%s", start, SO );
#else
      fprintf ( outf, "%s%s", start, SO );
#endif
      start = str+1;
    }
    else if( *str == '' ) {
      *str = NULL;
#ifdef shellinput
      sendMsg2( "%s%s", start, SE );
#else
      fprintf ( outf, "%s%s", start, SE );
#endif
      start = str+1;
    }
  }
#ifdef shellinput
  sendMsg( start );
#else
  fprintf ( outf, start );
#endif
}

extern	char	*getenv(), *tgetstr(), *index();

init_termcap()
{
  char	*term, *colon;
  char	termname [ 40 ];
  static char	termcap_buffer [ 1024 ];

  IfErr( term = getenv( "TERM" ) )
    Erreturn( "TERM environment variable not set." );
  strcpy ( termname, term );	/* move to a safe place */
  
  if( colon = index( termname, ':' ) )	/* e.g., for "sun:co#80:li#44:" */
    *colon = '\0';		/* truncate to true terminal name */

  switch ( tgetent( termcap_buffer, termname ) ) {
  case -1: Erreturn( "cannot open termcap file" );
  case 0:  Erreturn1( "no entry for terminal '%s'", term );
  case 1:	break;
  };
  return( OK );
}

char *
get_termcap( cap, str )
char *cap, *str;
{
  char buf[16], *bufp = buf;
  IfErr( tgetstr( cap, &bufp ) ) Erreturn1("capability %s not found", cap);
  strcpy( str, buf );
  return( str );
}
