/* $Header: /soma/users/miyata/planet/src/RCS/graphinit.c,v 5.6.0.4 91/02/13 15:42:12 miyata Exp $ */
static char rcsid[] = "$Header: /soma/users/miyata/planet/src/RCS/graphinit.c,v 5.6.0.4 91/02/13 15:42:12 miyata Exp $";
/**** UPDATES *********************************************************
graphinit.c:
2/8/90 no need to specify colorsun - done automatically (get_view_surface())
***********************************************************************/
#include <usercore.h>
#include <colorbuf.h>
#include <sun/fbio.h>
#include <stdio.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sunwindow/window_hs.h>
#ifndef O_NDELAY
#include <sys/fcntl.h>          /* probably sunOS 4.0 */
#endif  /* O_NDELAY */
#include "alloc.h"
#include "error.h"
#include "color.h"
#include "time.h"

#define XRANGE (XMAX-XMIN)	/* range of world coordinates */
#define YRANGE (YMAX-YMIN)
				/* to map from NDC to world coordinates. */
#define	NdcToX XRANGE		/* should be divided by XNDC if its not 1 */
#define NdcToY (YRANGE/YNDC)

float  XNDC, YNDC;
float  XMIN, YMIN, XMAX, YMAX;
int  DisplayON = 0;

#define bound( x, min, max ) x= x<min? min : max<x? max : x

typedef struct _box {
  	float	x,y, width,height;
} BOX;

extern int	bw1dd();	/* Sun-1 monochrome bitmap, raw */
extern int	bw2dd();	/* Sun-2 monochrome bitmap, raw */
extern int	pixwindd();	/* monochrome window -- may be on color dev. */

extern int	cg2dd();	/* Sun Workstation color graphics, raw */
extern int	cg1dd();	/* Sun Workstation color graphics, raw */

extern int	cgpixwindd();	/* color graphics -- must be color device */
extern int	gp1pixwindd();	/* color graphics on Sun-3/160 */

static	void		set_up_suncore_view_surface();

struct	vwsurf	suncolor_vwsurf = NULL_VWSURF;
struct	vwsurf	sunbitmap_vwsurf = NULL_VWSURF;
struct  vwsurf  vwsurf = NULL_VWSURF;
struct	vwsurf	*sun_vwsurf = & vwsurf;

int	which_surface;

#define nColorTable 16
#define nMonoTable 8

/* texture selections color monitor (by Mike Mozer)
	   RED, GREEN, BLUE, YELLOW, PURPLE, AQUA, 
	   last three - WHITE, BLACK, GREY */
float red[nColorTable]=  {1,0,1,0,0,1,1,0,1.,1.,.5,.5,0.,1,0,.5};
float green[nColorTable]={1,0,0,1,0,1,0,1,.5,0.,1.,0.,.5,1,0,.5};
float blue[nColorTable]= {1,0,0,0,1,0,1,1,0.,.5,0.,1.,1.,1,0,.5};
  
/* texture selections monochrome monitor
	   	   BLACK, WHITE,  H_L,   H_R,   W_P,   WAVY,  GREY,  C_H  */
float	red_mono[nMonoTable] =
		{ .0000, .2667, .1334, .1334, .4667, .1334, .5334, .1334 };
float	green_mono[nMonoTable]=
		{ .2667, .4001, .5020, .5020, .5334, .3334, .5334, .5334 };
float	blue_mono[nMonoTable]= 
		{ .3882, .8001, .3529, .6471, .2118, .4001, .4001, .4001 };

#define do_or_die( CALL, MSG, ERRVAL )	\
	if((CALL) != 0 && ERRVAL != 0 )	\
	    {	\
	    fprintf( stderr, "Fatal error from `%s' (#%d)\n", MSG, ERRVAL ); \
	    exit( ERRVAL );	\
	    } else {}

static float Xlow, Xupper; 
static float Ylow, Yupper;

initialize_display( xndc, yndc, xmin, ymin, xmax, ymax )
float  xndc, yndc, xmin, ymin, xmax, ymax;
{
  if( DisplayON ) {
    delete_all_retained_segments();
    return( 1 );
  }

  XNDC = xndc, YNDC = yndc;
  XMIN = xmin, YMIN = ymin, XMAX = xmax, YMAX = ymax;
  Xlow = XNDC*0.007, Xupper = XNDC*0.993; 
  Ylow = YNDC*0.007, Yupper = YNDC*0.993;

/*set_up_suncore_view_surface();*/
  
  do_or_die( get_view_surface( sun_vwsurf, NULL ),
	     "get_vwsurf", 1 );

  if( sun_vwsurf->dd == cgpixwindd ) {
    sun_vwsurf->cmapsize = nColorTable;
    sun_vwsurf->cmapname[0] = '\0';
    which_surface = COLOR;
    fprintf( stderr, "a color monitor.\n");
  } else
    fprintf( stderr, "a monochrome monitor.\n" );

  do_or_die( initialize_core( DYNAMICA, SYNCHRONOUS, TWOD ),
	     "init_core", 1 );

  do_or_die( initialize_view_surface( sun_vwsurf, FALSE ),
	     "init_surf", 2 );

  do_or_die( select_view_surface( sun_vwsurf ), /* physical coordinate */
	     "select_surf", 3 );

  do_or_die( set_ndc_space_2( xndc, yndc ),  /* NDC - normalized coordinate */
	     "set_ndc_space", 4 );

  do_or_die( set_viewport_2( 0.0, xndc, 0.0, yndc ), /* View Port - a region */
	     "set_viewport", 5 );                    /* of NDC that's visible*/

  do_or_die( set_window( xmin, xmax, ymin, ymax ), /* world coordinate */
	     "set_window", 6 );                     /* mapped onto View Port*/

  do_or_die( initialize_device( LOCATOR, 1 ), /* mouse is the locator */
	      "init_device", 0 );		
		
  do_or_die( initialize_device( BUTTON, 1 ), /* left mouse button */
	      "init_device", 0 );		
		
  do_or_die( initialize_device( BUTTON, 2 ), /* middle mouse button */
	      "init_device", 0 );		
		
  do_or_die( initialize_device( BUTTON, 3 ), /* right mouse button */
	      "init_device", 0 );		
		
  do_or_die( set_echo_position( LOCATOR, 1, 0.0, 0.0 ),
	     "set_echo_position", 0 );

  do_or_die( set_echo_surface( LOCATOR, 1, sun_vwsurf ),
	      "set_echo_surface", 0 );

  do_or_die( set_echo( LOCATOR, 1, 1 ),
	      "set_echo", 0 );

  if( which_surface == COLOR ) {
    do_or_die( define_color_indices( sun_vwsurf, 0, nColorTable-1,
				    red, green, blue),
	      "define_color_indices", 0 );
  }
  else {
    do_or_die( define_color_indices( sun_vwsurf, 1, nMonoTable, 
				    red_mono, green_mono, blue_mono),
	      "define_color_indeces", 0 );
  }
  DisplayON = 1;

  return(1);
}

#if 0	/* using get_view_surface() for now.  may need this to
	   reduce size */
static	void	set_up_suncore_view_surface()
{			/* set up the pointer to the appropriate device */

  struct fbtype	fbtype;		/*\ used with call to ioctl, these
				|*| are for frame buffers -- see man
				|*| page for fbio(4S).
				\*/
  struct screen screen;

  int	fd;			/*\ file descriptors returned by
				|*| open(2) for black&white and
				|*| color-graphics display devices.
				\*/
  char *windowName, dev[DEVNAMESIZE], *getenv();

  if( windowName = getenv( "WINDOW_ME" ) ) {	/* in a window */
    if(( fd = open( windowName, O_RDWR, 0 )) < 0 ) {
      fprintf(stderr, "failed opening %s\n", windowName );
      exit( 671 );
    }
    fprintf(stderr, "in a window dev = %s\n", windowName);
    win_screenget(fd, &screen);
    close(fd);
    strncpy( dev, screen.scr_fbname, DEVNAMESIZE );
  }
  else {	/* not in a window.  assume device is /dev/fb */
    strncpy( dev, "/dev/fb", DEVNAMESIZE );
    fprintf(stderr, "not in a window dev = /dev/fb\n");
  }
  if( (fd = open(dev, O_RDWR, 0 )) < 0 ) {
    fprintf(stderr, "failed opening %s\n", dev);
    exit( 661 );
  }
  if( ioctl(fd, FBIOGTYPE, &fbtype ) == -1 ) {
    fprintf( stderr, "failed ioctl on %s\n", dev);
    exit( 662 );
  }
  close(fd);
  if( windowName ) 	/* in a window */
    switch( fbtype.fb_type ) {
    case FBTYPE_SUN1BW:
    case FBTYPE_SUN2BW:
      sunbitmap_vwsurf.dd = pixwindd;
      sun_vwsurf = & sunbitmap_vwsurf;
      which_surface = BITMAP;
      fprintf( stderr, "using %s : a monochrome monitor.\n", dev );
      break;
    case FBTYPE_SUN1COLOR:
    case FBTYPE_SUN2COLOR:
      suncolor_vwsurf.dd = cgpixwindd;
      suncolor_vwsurf.cmapsize = nColorTable;
      suncolor_vwsurf.cmapname[0] = '\0';
      sun_vwsurf = & suncolor_vwsurf;
      which_surface = COLOR;
      fprintf( stderr, "using $s : a color monitor.\n", dev );
      break;
    case FBTYPE_SUN2GP:
      suncolor_vwsurf.dd = gp1pixwindd;
      suncolor_vwsurf.cmapsize = nColorTable;
      suncolor_vwsurf.cmapname[0] = '\0';
      sun_vwsurf = & suncolor_vwsurf;
      which_surface = COLOR;
      break;
    default:
      fprintf(stderr,"unknown fbtype %s\n", dev);
      exit(663);
    }
  else {
    sunbitmap_vwsurf.dd =((fbtype.fb_type == FBTYPE_SUN1BW) ?
			  bw1dd : bw2dd );
    sun_vwsurf = & sunbitmap_vwsurf;
    which_surface = BITMAP;
  }
  return;
}	/*** === end of procedure set_up_suncore_view_surface === ***/
#endif 0

terminate_display()
{
  if( DisplayON == 0 ) return(0);
  delete_all_retained_segments( );
  terminate_view_surface( sun_vwsurf );
  terminate_core();
  DisplayON = 0;
}

wipe_all_segments( lsegment )
int lsegment;
{
  int *segment_array = new_array_of( lsegment , int );
  int i, nsegment ;
  inquire_retained_segment_names( lsegment, segment_array, &nsegment );
  delete_all_retained_segments( );
  for( i=0; i< nsegment ; i++ ) {
    create_retained_segment( segment_array[i] );
    close_retained_segment( segment_array[i] );
  }
  free( segment_array );
}

locate_mouse( x, y, time )
float *x, *y; int time;
{
  int button = 0;
/*  await_any_button_get_locator_2(time, 1, &button, x, y ); doesn't wait 
  map_ndc_to_world_2( *x, *y, x, y ); */
  while( button == 0 ) {
    get_point( x, y, &button );
#ifdef debug
    printf("get: x=%g\ty=%g\tbutton=%d\n", *x, *y, button);
#endif 
  }
}

wait_any_button()
{
  float x,y; int button =0; 
  static int t, timed = 0;
  if( timed == 0 ) tstart();	/* need a basetime */
  for( t=0; t < 500 || button == 0 ; msec(t) ) 
    get_mouse_state( LOCATOR, 1, &x, &y, &button );
  tstart();			/* basetime for next msec(t) */
}

get_point( x, y, button )
float *x, *y; int *button;
{
  get_mouse_state( LOCATOR, 1, x, y, button );
			/* outside display area -> no effect */
  if( *x > Xupper || *x < Xlow || *y > Yupper || *y < Ylow ) button = 0;
  bound( *x, Xlow, Xupper );
  bound( *y, Ylow, Yupper );
  *x *= NdcToX; *y *= NdcToY;
}

fill_box( x, y, width, height, color )
float x, y, width, height; int color;
{
  static	float	yarray [5] = { 0.0, 0.0,  0.0, 0.0, 0.0 };
  static	float	xarray [5] = { 0.0, 0.0,  0.0, 0.0, 0.0 };

  xarray[0] = xarray[3] = xarray[4] = x; 
  xarray[1] = xarray[2] = x+width;
  yarray[0] = yarray[1] = yarray[4] = y; 
  yarray[2] = yarray[3] = y+height;

  move_abs_2( x, y );
  set_fill_index( color );

  polygon_abs_2( xarray, yarray, 4 );

#ifndef sunnet
  if( color == BLACK ) polygon4_abs_2( xarray, yarray );
  else polyline5_abs_2(xarray, yarray );
#endif
  set_fill_index( BLACK );
}

set_background_color(color_ix)
  int color_ix;
{
  int nTable = ColorSun? nColorTable: nMonoTable;
  if( color_ix < 0 || color_ix >= nTable ) return;
  red[0] = red[color_ix];
  green[0] = green[color_ix];
  blue[0] = blue[color_ix];
 
  define_color_indices( sun_vwsurf, 0, 0, red, green, blue);
}

change_color_map( indx, rgb )
int indx; char *rgb;
{
  int nTable = ColorSun? nColorTable: nMonoTable;
  int xred, xblue, xgreen; char r[2],g[2],b[2];
  if( indx < 0 || indx >= nTable ) 
    Erreturn1("%d: index must be between 0 and %d", nTable-1 );
  if( strlen(rgb) < 3 ) Erreturn1("%s: invalid RGB value", rgb);
  r[0] = rgb[0], g[0] = rgb[1], b[0] = rgb[2];
  r[1] = g[1] = b[1] = '\0';
  IfErr(sscanf(r, "%x", &xred)) Erreturn1("%s: invalid RGB value", rgb);
  IfErr(sscanf(g, "%x", &xgreen)) Erreturn1("%s: invalid RGB value", rgb);
  IfErr(sscanf(b, "%x", &xblue)) Erreturn1("%s: invalid RGB value", rgb);
  red[indx] = xred*0.1;
  green[indx] = xgreen*0.1;
  blue[indx] = xblue*0.1;
  define_color_indices( sun_vwsurf, indx, indx, 
		        &red[indx], &green[indx], &blue[indx]);
  return(OK);
}
