/* $Header: /soma/users/miyata/planet/src/RCS/graph.c,v 5.6.0.4 91/02/13 15:42:08 miyata Exp $ */
static char rcsid[] = "$Header: /soma/users/miyata/planet/src/RCS/graph.c,v 5.6.0.4 91/02/13 15:42:08 miyata Exp $";
/**** UPDATES *********************************************************
graph.c:
4/6/90 fixed window frame bug in xnet.
2/9/90 cleaned up flag structure for compilation: sunnet planet xnet mgr
	each represents the individual program.  planet no longer implies
	xnet or mgr.  -- there may be still some confusions.
2/9/90 fixed draw_matrix_in_..() to use larger space if -label is given.
2/8/90 no need to specify colorsun - done automatically (in graphinit.c)
***********************************************************************/
#include <stdio.h>
#include <signal.h>
#include <math.h>
#include <sys/ioctl.h>
#include <sys/file.h>
#include "dprint.h"
#if sunnet
#include <usercore.h>
#include <colorbuf.h>
#include <sun/fbio.h>
#else 
#include "suncorefunc.h"
#if xnet
#include <X11/Xlib.h>  /* get all the X structures */
#include <X11/X.h>     /* types of events we need */
#include <X11/Xutil.h> /*get structures for attributes*/
#include <X11/cursorfont.h> /* cursor constants */
#include "xnetcore.h"
#include "xgraph.h"
#else
#if mgr
#include "term.h"
#include "mgrcore.h"
#else
#include "planetcore.h"
#endif
#endif
#endif
#include "graph.h"
#include "version.h"
#include "color.h"
#include "alloc.h"
#include "error.h"
#include "time.h"
#include "psc.h"
#include "userdefs.h"

#define	abs(x) ((x)>=0?(x):-(x))		/* absolute value macro */
#define min(x,y) ((x)>(y)? (y):(x))
#define bound( x, min, max ) ((x)= (x)<(min)? (min) : (max)<(x)? (max) : (x))
#define IF( x, y ) if( strcmp( x, y ) == 0 )

float XMIN = 0.0;		/* world coordinate */
float XMAX = 10.0;
float YMIN = 0.0;
float   YMAX = 7.5;
#define XNDC 1.00		/*range of normalized device coordinate (NDC)*/
static  float YNDC = 0.75;
#define XRANGE (XMAX-XMIN)	/* range of world coordinates */
#define YRANGE (YMAX-YMIN)
				/* to map from NDC to world coordinates. */
#define	NdcToX XRANGE		/* should be divided by XNDC if its not 1 */
#define NdcToY (YRANGE/YNDC)

#define LeftMargin 0.12
#define BottomMargin 0.12
#define MaxLMargin (XRANGE*0.04)
#define MaxBMargin (YRANGE*0.05)
#define MinLMargin (XRANGE*0.016)
#define MinBMargin (YRANGE*0.02)
#define CharAdjust 0.7		/* proportion of actual size & charsize */
#define LabelMargin 0.6		/* proportion of label & number within */
#define NumberMargin 0.4	/* each margin. should sum to 1.0 */
#define NoSeg (-100)   		/* indicates no segment is currently open */
#define Temporary (-101)	/* indicates a temporary segment is open */
#define BUFSIZE 1024
#define MsgHeight (YRANGE*0.05)
#define MsgWidth (MsgHeight*0.6)

#define NotOpen( W )  ( W->segment_name != Segment_opened  )
#define IsOpen( W )   ( W->segment_name == Segment_opened  )

/* indeces for some texture selections to be used in set_fill_index() 	
 * are defined in graphinit.c */

int positiveColor;
int negativeColor;
int windowColor;
int windowID=0;

void set_default_color() {
#if sunnet|planet

  if( ColorSun ) 
    {
      positiveColor = PositiveColor;
      negativeColor = NegativeColor;
      windowColor = WindowColor;
      set_background_color( BackgroundColor );
      return;
    } 
  set_background_color( BackgroundShade );
#endif sunnet|planet
  positiveColor = PositiveShade;
  negativeColor = NegativeShade;
  windowColor = WindowShade;
}

extern	char	*getenv();

/* static	void		set_up_suncore_view_surface();*/

FILE   *Printer = NULL ;			/* file for saving display */
static int netFont=ROMAN;
static	int Nsegment=2;
static	int Segment_opened = NoSeg ;
float	set_charsize_for_horizontal_text();
float	set_charsize_for_vertical_text();

	/* it is dangerous to interrupt inside SunCore routines */
extern int NOINTERRUPT;		/* declared in top.c */

#define NoInterrupt NOINTERRUPT=1	
#define InterruptOK NOINTERRUPT=0

#if xnet
#define StartGraphics NoInterrupt
#define EndGraphics XFlush(netD); /* This flushes the drawing to the screen */
#else
#if mgr
extern int GWin;
#define graphicsWindow m_selectwin( GWin )
#define textWindow m_selectwin( 0 )
#define StartGraphics NoInterrupt, graphicsWindow
#define EndGraphics InterruptOK, textWindow, m_flush()
#else
#define StartGraphics NoInterrupt
#define EndGraphics InterruptOK
#endif
#endif

/* initialize_graphics() should be called before any other functions in *
 * SunNetCore.  the argument shape specifies the ratio height/width of  *
 * the display region */

#if xnet|mgr
initialize_graphics( argc, argv )
     int argc;
     char *argv[];
{
  initialize_display( &XMAX, &YMAX, argc, argv );
  set_default_color();
  return( OK );
}
#else	/* sunnet|planet */
initialize_graphics( shape )
float shape;
{
  if( shape > 0.0 ) YMAX = XMAX * shape, YNDC = XNDC * shape;
  initialize_display( XNDC, YNDC, XMIN, YMIN, XMAX, YMAX );
  set_default_color();
  return( OK );
}
#endif xnet

#ifndef sunnet		/* defined in graphinit.c for SunNet */
/* terminate_display() should be called before exiting the program */

terminate_display()
{
  delete_all_retained_segments();
  Segment_opened = NoSeg ;
  Nsegment = 2;
#ifdef mgr
  m_destroywin( GWin ); m_flush();
#endif
  return( OK );
}
#endif
/* redraw_display() clears and redraws the current display */

redraw_display()
{
  new_frame();
}

/* frame_screen() draws a frame for the display region and displays label *
 * on top of the frame */

frame_screen( label )
char *label;
{
  BOX box; 
  static int frame_segment=NULL;
  StartGraphics;
  if( Segment_opened != NoSeg ) {
    close_retained_segment( Segment_opened ); Segment_opened = NoSeg;
  }
  set_window_clipping( FALSE );
  wipe_segment( &frame_segment );
  set_linewidth( 1.0 );
  box.x = XMIN; box.y = YMIN;
  box.width = XRANGE; box.height =YRANGE;
  draw_box( &box );
#if demo|xnet|mgr
  set_linewidth( 0.05 );
#else
  set_font( ROMAN );
  set_linewidth( 0.0 );
  set_charprecision( CHARACTER );
  set_charsize_pr( MsgWidth*0.3, MsgHeight*0.3 );
  move_abs_2_pr( XMIN+MsgWidth, YMAX+MsgHeight*0.6 );
  text( label );
  move_abs_2_pr( XMIN-MsgHeight*0.6, YMIN+MsgWidth );
  set_charpath_2_pr( 0.0, 1.0 ); set_charup_2( -1.0, 0.0 );
  text( label );
  set_charpath_2_pr( 1.0, 0.0 ); set_charup_2( 0.0, 1.0 );
#endif
  close_retained_segment( frame_segment ); Segment_opened = NoSeg;
  set_font( netFont );
  set_window_clipping( TRUE );
  EndGraphics;
  return( OK );
}

/* new_window () defines location, size, etc. of a window and returns the *
 * pointer to it.  No segment is attached to window yet.  Wipe_window() must  *
 * called just before something is drawn in it so that a segment is attached.*/

WINDOW *
new_window( start_x, start_y, width, height )
float	start_x, start_y, width, height ;
{
  WINDOW *W = new( WINDOW );
  IfErr( W ) Erreturn("cannot allocate memory for window");
  W->segment_name  = NULL ;
  W->id = windowID++;
  IfErr( set_window_size( W, start_x, start_y, width, height ) ) return(ERR);
  W->status = BLANK ;
  return( W );
}

/* locate_window() determines the location and
   size of a window with the mouse by calling locate_box() */

locate_window( W )
WINDOW * W;
{
  BOX box;
  IfErr( W ) { Erreturn("window not initialized"); }
  IfErr( locate_box( &box ) ) Erreturn1("%s: in locating window", ERR_MSG );
  IfErr(set_window_size( W, box.x, box.y, box.width, box.height )) return(ERR);
  W->status = BLANK ;
  return( OK );
}

/* set_window_size() sets or changes the location/size of a window */

set_window_size( W, start_x, start_y, width, height )
WINDOW  *W;
float	start_x, start_y, width, height ;
{
  IfErr( W ) Erreturn("window not initialized");
  IfErr(define_box( &W->frame, start_x, start_y, width, height )) return(ERR);
#ifdef demo
  W->lmargin = W->bmargin = 0.0;
#else
  W->lmargin = width * LeftMargin ;
  W->bmargin = height * BottomMargin ;
  W->bmargin = MaxBMargin ;
  bound( W->lmargin, MinLMargin, MaxLMargin );
  bound( W->bmargin, MinBMargin, MaxBMargin );
#endif
  IfErr(define_box(&W->data, start_x+W->lmargin, start_y+W->bmargin,
		   width - W->lmargin, height - W->bmargin ))
    return(ERR);
#if sunnet
  if( W->bg ) free_raster( W->bg );
  W->bg = NULL;
#endif sunnet
#if xnet	/* change clip region */
  if( IsOpen( W ) ) select_window( W );
#endif
  return( OK );
}

copy_window_size( Wsrc, Wdst )
WINDOW *Wsrc, *Wdst;
{
  if( Err( Wsrc ) || Err(Wdst) ) Erreturn("window not initialized");
  IfErr(copy_box_size( &Wsrc->frame, &Wdst->frame )) return(ERR);
  Wdst->lmargin = Wsrc->lmargin;
  Wdst->bmargin = Wsrc->bmargin;
  IfErr(copy_box_size( &Wsrc->data, &Wdst->data )) return(ERR);
  return( OK );
}

copy_box_size( Bsrc, Bdst )
BOX *Bsrc, *Bdst ;
{
  IfErr(Bdst) Erreturn("box not initialized");
  IfErr(Bsrc) {		/* return the size of entire display field */
    Bdst->x = XMIN; Bdst->y = YMIN;
    Bdst->height = YMAX-YMIN; Bdst->width = XMAX-XMIN ;
    return( OK );
  }
  Bdst->x = Bsrc->x; Bdst->y = Bsrc->y;
  Bdst->height = Bsrc->height; Bdst->width = Bsrc->width ;
  return( OK );
}

define_box( box, x, y, w, h )
BOX *box;
float x,y,w,h;
{
  IfErr( box ) Erreturn("box not initialized");
  box->x = x; box->y=y;  box->height = h;box->width = w;
  return( OK );
}

/* delete_window() deletes a window */

delete_window( W ) WINDOW *W;{
  if( W == NULL ) return;
  delete_segment( &W->segment_name );
  free( W );
}

/* wipe_window() should be called just before displaying something in *
 * a window.  It basically wipes out whatever is already drawn in it, if  *
 * any,  and gives it an open segment, ie., subsequent drawings will be  *
 * written to that segment */

wipe_window( W )  WINDOW	*W;{
  IfErr( W ) return;
#if xnet|mgr
  StartGraphics;
  clear_box( W->frame.x, W->frame.y, W->frame.width, W->frame.height );
#if xnet
  select_window( W );
#endif
  EndGraphics;
  Segment_opened = W->segment_name;
#endif
  wipe_segment( &W->segment_name ), W->status = BLANK;

}

#if xnet
select_window( W ) WINDOW *W; {
  ClipBox( W->frame.x, W->frame.y, W->frame.width, W->frame.height );
}
#endif

invisible_window( W ) WINDOW *W; {	/* make window invisible */
  if( W == NULL ) return;
  StartGraphics;
  if( W->segment_name != NULL )
    set_segment_visibility( W->segment_name, FALSE );
  EndGraphics;
  return;
}
  
visible_window( W ) WINDOW *W; {	/* make window visible */
  if( W == NULL ) return;
  StartGraphics;
  if( W->segment_name != NULL )
    set_segment_visibility( W->segment_name, TRUE );
  EndGraphics;
  return;
}

inside_window( W, x, y ) /* returns OK if (x,y) is inside W ERR otherwise */
WINDOW *W; float x,y;
{
  IfErr( W ) return( ERR );
  if( x>W->frame.x && x<(W->frame.x+W->frame.width) &&
      y>W->frame.y && y<(W->frame.y+W->frame.height) ) 	return( OK );
  return( ERR );
}

frame_window( W, n ) 	/* draw a frame and a number for a window */
WINDOW *W; int n;
{
  char  buf[ BUFSIZE ];
  if( NotOpen( W ) ) wipe_window( W );
  draw_box( &W->frame );
  if( n < 0 ) return;
  sprintf( buf, "  window %d  ", n );
  text_in_window( W, buf );
}

draw_box_in_window( W )		/* draw a box (not frame) for a window */
WINDOW  *W;
{
  IfErr( W ) Erreturn("window for graph not initialized");
  if( NotOpen( W ) ) wipe_window( W );
  draw_box( &W->data );
  return( OK );
}

/* locate_graph() defines location & size of window of a graph with mouse */
locate_graph( G )
GRAPH *G;
{
  IfErr( G ) Erreturn( "graph not initialized" );
  IfErr( locate_window( G->Window ))
    Erreturn1("%s: error in locating window for graph", ERR_MSG);
  return( OK );
}

initialize_graph( G )
GRAPH *G;
{
  return(set_graph_size( G, .0, .0, .0, .0 ));
}

/* set_graph_size() attaches a window to graph, defines its location & size */
#ifdef demo
#define Grange 1.0
#define Gmargin 0.0
#else
#define Grange 0.8
#define Gmargin 0.1
#endif

set_graph_size( G, start_x, start_y, width, height )
GRAPH *G;
float start_x, start_y, width, height;
{
  IfErr( G ) Erreturn( "graph not initialized" );
  if( Err(G->Window) && Err( G->Window = new( WINDOW ))) 
    Erreturn("not enough core");
  if( width == 0.0 || height == 0.0 ) {	/* use default graph size */
    start_x = XMIN+(XMAX-XMIN)*Gmargin;
    start_y = YMIN+(YMAX-YMIN)*Gmargin;
    width =  (XMAX-XMIN)*Grange;
    height = (YMAX-YMIN)*Grange;
  }

  return( set_window_size( G->Window, start_x, start_y, width, height ));
}

get_graph_size( G, start_x, start_y, width, height )
GRAPH *G;
float *start_x, *start_y, *width, *height;
{
  WINDOW *W;
  if( Err( G )|| Err( W = G->Window)) Erreturn( "graph not initialized" );
  *start_x = W->frame.x, *start_y = W->frame.y,
  *width = W->frame.width, *height = W->frame.height;
  return(OK);
}

/* make_graph() sets up a graph window, calls define_graph() to define
   x-y ranges of values to be graphed */

make_graph( G, min_x, max_x, num_x, min_y, max_y, num_y, label )
GRAPH	*G;  
float	min_x, max_x, min_y, max_y;
float	num_x, num_y;
char	*label;
{
  IfErr( G ) Erreturn( "graph not initialized" );
  if( Err(G->Window) && Err( G->Window = new( WINDOW )))
    Erreturn("not enough core");
  G->label = new_string( label, G->label );
  if( num_x == 0 || num_y == 0 ) Erreturn("zero interval numbering!!");
  define_graph( G, min_x, max_x, num_x,  min_y, max_y, num_y );
  G->visible = TRUE;
  return( OK );
}
/* define_graph() defines x-y ranges of graph */

define_graph( G, min_x, max_x, num_x,  min_y, max_y, num_y )
GRAPH	*G;  
float	min_x, max_x, min_y, max_y;
float	num_x, num_y;
{
  G->origin_x = min_x;
  G->origin_y = min_y;
  G->scale_x = 1.0 /(max_x - min_x);
  G->scale_y = 1.0 /(max_y - min_y);
  G->range_x = max_x - min_x;
  G->range_y = max_y - min_y;
  G->num_x = num_x;
  G->num_y = num_y;
}

/* clear_graph() erases graph and redraws X and Y axes and label */

clear_graph( G )
GRAPH *G;
{
  IfErr( G ) Erreturn("graph not initialized");
  wipe_graph( G );
  return( draw_graph( G ) );
}

draw_graph( G )
GRAPH *G;
{
  if(Err( G )||Err(G->Window)) Erreturn("graph not initialized");
  wipe_window( G->Window );
  draw_axes( G );
  label_graph( G, NULL );
#if sunnet
  add_segment_to_graph( G );
#endif
  return( OK );
}

#define transform_segment( segment, scale_x, scale_y, angle, shift_x, shift_y)\
  set_segment_image_transformation_2( segment, scale_x, scale_y,\
				      angle, shift_x, shift_y )
/* extend_graph() changes the x-y ranges, redraws graph with new scale.
   locate_graph() can be called before this to change location & size */

extend_graph( G, max_x, num_x, max_y, num_y )
GRAPH	*G;  
float	max_x, max_y;
float	num_x, num_y;
{
  WINDOW *W;
  int i;
  float rscale_x, rscale_y;
  float tscale_x, tscale_y;

  IfErr( G ) Erreturn( "Graph not initialized" );
  IfErr( W = G->Window ) Erreturn( "window for graph not initialized");
  if( num_x == 0 || num_y == 0 ) Erreturn("zero interval numbering?");

  G->num_x = num_x; G->num_y = num_y;
  G->range_x = max_x - G->origin_x;	/* new range of x */
  G->range_y = max_y - G->origin_y;	/* new range of y */
  rscale_x = G->range_x * G->scale_x;	/* how much to scale from the */
  rscale_y = G->range_y * G->scale_y;	/* original x-y ranges */
  if( rscale_x > NdcToX )
    Erreturn1("cannot extend to more than %4.2f times larger", NdcToX);
  if( rscale_y > NdcToY )
    Erreturn1("cannot extend to more than %4.2f times larger", NdcToY);
  tscale_x = W->data.width / rscale_x;	/* transformation scale */
  tscale_y = W->data.height / rscale_y;

  wipe_window( W );

  StartGraphics;
  set_output_clipping( TRUE );
#if sunnet
  for( i=0; i < G->n_segment; i++ ) 	/* transform old segments */
    transform_segment(G->segments[i], tscale_x, tscale_y, 0.0,
		      W->data.x/NdcToX, W->data.y/NdcToY );
  					/* transform current segment */
  transform_segment(G->segment_name, tscale_x, tscale_y, 0.0,
		    W->data.x/NdcToX, W->data.y/NdcToY );
#endif sunnet
  draw_axes( G );
  label_graph( G, NULL );
  set_output_clipping( FALSE );
  EndGraphics;
  return( OK );
}

#if sunnet
/* add_segment_to_graph() creates a new segment for graph, puts current segment
   to array segments[] which keeps previous segments.  It should be called 
   whenever current graph segment is interrupted by other displays */

add_segment_to_graph( G )
GRAPH *G;
{
  WINDOW *W;
  if( Err( G ) || Err( W=G->Window ) ) Erreturn("graph or window not initialized");
#ifndef xnet	/* not necessary for XNet */
  if( G->n_segment >= MaxSegment ) 
    Erreturn("too many graph segments. cannot continue.\n");
  if( G->segment_name ) G->segments[ G->n_segment++ ] = G->segment_name ;
#endif
  StartGraphics;
  set_image_transformation_type( XFORM2 );
  G->segment_name = new_segment();
  transform_segment(G->segment_name,
		    W->data.width / (G->range_x * G->scale_x),
		    W->data.height / (G->range_y * G->scale_y), 0.0,
		    W->data.x/NdcToX, W->data.y/NdcToY );
  set_image_transformation_type( NONE );
  if( G->visible == FALSE ) set_segment_visibility( G->segment_name, FALSE );
  EndGraphics;
  return( OK );
}
#endif

/* draw_axes() draws a box in a graph and numbers and tics along the x- and *
 * y-axes */

draw_axes( G )
GRAPH 	*G;
{
  WINDOW *W;
  float	min_x = G->origin_x, max_x = G->origin_x + G->range_x;
  float min_y = G->origin_y, max_y = G->origin_y + G->range_y;
  float	num_x = G->num_x, num_y = G->num_y;
  float	x,y, nx, ny;
  char	number[ 32 ];
  float	adjust;
  float char_x, char_y, tic;
  float scale_x, scale_y;

  if( Err(G) || Err(W = G->Window)) Erreturn("graph not initialized") ;
  if( num_x == 0 || num_y == 0 ) Erreturn("zero numbering!");
  draw_box( &W->data );
			  /* character size for numbers along x-axis */
  char_y = W->bmargin * NumberMargin * CharAdjust;
  char_x = char_y * 0.6 ;
  tic = W->data.height * 0.015 ;

  adjust_set_charsize( &char_x, &char_y,G->range_x/num_x/6, char_y );
					/* draw numbers along x-axis */
  scale_x = W->data.width / G->range_x;
  scale_y = W->data.height / G->range_y;
  x = W->data.x, y = W->data.y - W->bmargin*NumberMargin*0.6 ;
  StartGraphics;
  for( nx= min_x ; nx <= max_x ; nx += num_x ) {
    sprintf( number, "%d",(int) nx );	/* assume x is int */
    x -= adjust = char_x * strlen(number)/2 ;
    text_location_pr( number, x, y );
    x += adjust + num_x * scale_x;
  }
  move_abs_2_pr( W->data.x, W->data.y );	/* tics along x-axis */
  for( nx= min_x ; nx <= max_x ; nx += num_x ) {
    line_rel_2_pr( 0.0, tic );
    move_rel_2_pr( num_x * scale_x, -tic );
  }
  move_abs_2_pr( W->data.x, W->data.y+W->data.height ); /* tics along upper x-axis */
  for( nx= min_x ; nx <= max_x ; nx += num_x ) {
    line_rel_2_pr( 0.0, -tic );
    move_rel_2_pr( num_x * scale_x, tic );
  }
  EndGraphics;

  char_x = W->lmargin/6; char_y = W->data.height/(max_y/num_y);
  adjust_set_charsize( &char_x, &char_y, char_x, char_y );
					/* draw numbers along y-axis */
  x = W->data.x - char_x*6, y = W->data.y ;
  StartGraphics;
  for( ny = min_y ; ny <= max_y ; ny += num_y ) {
    gcvt( ny, 3, number );
    text_location_pr( number, x, y );
    y += num_y * scale_y;
  }
  move_abs_2_pr( W->data.x, W->data.y );	/* tics along y-axis */
  for( ny= min_y ; ny <= max_y ; ny += num_y ) {
    line_rel_2_pr( tic, 0.0 );
    move_rel_2_pr( -tic, num_y * scale_y );
  }
  move_abs_2_pr( W->data.x+W->data.width, W->data.y ); /* tics along right y-axis */
  for( ny= min_y ; ny <= max_y ; ny += num_y ) {
    line_rel_2_pr( -tic, 0.0 );
    move_rel_2_pr( tic, num_y * scale_y );
  }
  EndGraphics;
  return(OK);
}

delete_graph( G ) GRAPH *G;
{
  register int i;
  if( G == NULL ) return;
  if( G->label ) free( G->label );
  if( G->Window ) delete_window( G->Window );
  delete_segment( &G->label_segment );
  delete_segment( &G->segment_name );
  for(i=0; i< G->n_segment ; i++ ) delete_segment( &G->segments[i] );
  G->n_segment = 0;
  free( G );
}

wipe_graph( G ) GRAPH *G;
{
  register int i;
  if( G == NULL ) return;
  delete_segment( &G->label_segment );
  delete_segment( &G->segment_name );
  wipe_window( G->Window );
  for(i=0; i< G->n_segment ; i++ ) delete_segment( &G->segments[i] );
  G->n_segment = 0;
}

invisible_graph( G ) GRAPH *G; {	/* make graph invisible */
  register int i;
  if( G == NULL || G->visible == FALSE ) return;
  StartGraphics;
  if( G->segment_name ) set_segment_visibility( G->segment_name, FALSE);
  for( i=0; i< G->n_segment ; i++ )   /* all previously interrupted segments */
    set_segment_visibility( G->segments[i], FALSE );  
  invisible_window( G->Window );
  set_segment_visibility( G->label_segment, FALSE );
  G->visible = FALSE;
  EndGraphics;
}

visible_graph( G ) GRAPH *G; {	/* make graph visible */
  register int i;
  if( G == NULL || G->visible == TRUE ) return;
  if( G->segment_name ) set_segment_visibility( G->segment_name, TRUE );
  StartGraphics;
  for( i=0; i< G->n_segment ; i++ )   /* all previously interrupted segments */
    set_segment_visibility( G->segments[i], TRUE );  
  visible_window( G->Window );
  set_segment_visibility( G->label_segment, TRUE );
  G->visible = TRUE;
  EndGraphics;
}

/*--------------- D R A W _ M A T R I X _ I N _ W I N D O W ( ) -------------\
Arguments: 	values: 2-d array of values to be displayed
		Nx, Ny: size of the array. values[Nx][Ny]
Returns: none.
Description:  	displays 2-d array of numbers (float) in the form of a matrix
	of bars or squares. The size of each square is proportional to the
	absolute value of the corresponding number. Black/grey bars/squares
	represent positive/negative numbers. Bars/squares are appropriately
	arranged spatially, the array indeces are numbered.
\---------------------------------------------------------------------------*/
#define draw_square( x, y, size, color ) \
	fill_box_pr( x-(size)*0.5, y-(size)*0.5, size, size, color )
#define draw_bar( x, y, size, color ) \
	fill_box_pr( x, y-(size)*0.5, size_x, size, color )

draw_matrix_in_window(W, vec, Nx, Ny, interval, label, threshold,unit,flags)
WINDOW	*W;		/* window in which to display matrix */
float	*vec;		/* array of data to display */
int	Nx, Ny;		/* # of columns & # of rows for matrix */
int	interval;	/* one in every interval values is displayed*/
char	*label;		/* string for labeing; NULL - no labeling */
float	threshold;	/* draw below-threshold value in white */
float	unit;		/* unit display value */
unsigned flags;
{
  int	i,j,ij;
  float	move_x ;			   /* bars/squares are  */ 
  float	move_y ;	   		   /* (move_x, move_y) apart */
  float	size_x;		                   /* size of each bar/square */
  float	size_y;
  float lmargin=.0, bmargin=.0;
  float scale;		              /* bar length/square size of value 1.0 */
  float unit_size;		      /* bar length/square size of Unit */
  float square_size;
  float	max_value = 0.0;
  float x,y, xinit, yinit;
  int  color;
  static char  number[ 32 ];

  if( unit <= 0.0 ) Erreturn1("%g : unit value must be positive", unit);

  if( flags&NumberFlag ) {
    bmargin += W->bmargin*NumberMargin;
    lmargin += W->lmargin*NumberMargin;
  }
  if( (flags&LabelFlag) && label ) {
    bmargin += W->bmargin*LabelMargin;
    lmargin += W->lmargin*LabelMargin;
  }
  W->data.x = W->frame.x + lmargin, W->data.y = W->frame.y + bmargin;
  W->data.width = W->frame.width - lmargin;
  W->data.height = W->frame.height - bmargin;

  move_x = ( W->frame.width - lmargin ) / Nx;
  move_y = ( W->frame.height - bmargin ) / Ny;

  if( flags&SquareFlag ) unit_size = (move_x>move_y)? move_y*0.8 : move_x*0.8;
  else {
    size_x = Nx>1? move_x * 0.8 : move_x; /* use full width if only 1 value */
    size_y = move_y * 0.5;
    unit_size = size_y;
  }
	/* If normalize, scale so that maximum value => unit length */
  if( flags&NormFlag ) {
    for( i=0, ij=0; i< Nx; i++ ) 
      for( j=0; j< Ny; j++, ij += interval ) 
	if( max_value < abs(vec[ij]) ) 
	  max_value = abs(vec[ij]);
    if( max_value )
      scale = unit_size / (flags&SquareFlag? sqrt(max_value):max_value) ;
  }
  else if( unit != 1.0 )
    scale = unit_size / (flags&SquareFlag? sqrt(unit) : unit) ;
  else 
    scale = unit_size;

  if( flags&EraseFlag ) {
#if sunnet
    if( NotOpen( W ) ) /* this is not needed for XNet */
#endif
      wipe_window( W );
  }
  else 
#if xnet
    select_window( W );
#else
    get_temporary_segment();
#endif

  /* BUG - this cannot override when erase is set to off */
  /* ---- fixed */

  if( label && (flags&LabelFlag) ) {
    if( flags&WeightFlag ) 
      label_window_2sides( W, label, label+strlen(label)+1, flags ); 
    						/* label x & y-axis */
    else label_window( W, label, flags );	/* label x-axis only*/
  }
  if( flags&NumberFlag ) draw_numbers_in_window( W, Nx, Ny, flags ); 

  StartGraphics;
				/* grey background  */
  if( flags&BgFlag ) {
    fill_box_pr( W->data.x, W->data.y,
	      W->frame.width-lmargin,W->frame.height-bmargin,
	      windowColor );
  }

  if( flags&NumberFlag ) {
    y = W->data.y + move_y/2;
    for( j=0; j< Ny; j++, y += move_y ) {
      move_abs_2_pr( W->data.x+W->data.width, 
		 flags&SquareFlag? y - unit_size*0.5 : y );
      line_rel_2_pr( 0.0, unit_size );        /* draw a bar with unit length */
    }
    if( flags&NormFlag || unit != 1.0 ) {
      gcvt( flags&NormFlag? max_value:unit, 3, number );
      set_charprecision( CHARACTER );
      set_charsize_pr( W->lmargin/strlen(number), W->bmargin * 0.5 );
      text( number );
    }
  }

  yinit = W->data.y + move_y/2;
  xinit = (flags&SquareFlag)? W->data.x+move_x/2 :
      			      W->data.x+(move_x-size_x)/2;
				
  if( flags&TransFlag )   /* display column by column */
    for( i=0, x = xinit; i<Nx; i++, x += move_x ) 
      for( j=0, y = yinit; j< Ny; j++, y += move_y, vec += interval ) {
	if( *vec == 0.0 ) continue;
	color = *vec>=threshold?  positiveColor : 
	  	flags&BgFlag? negativeColor : EMPTY;
	if( flags&SquareFlag ) {
	  square_size = scale * sqrt( abs(*vec) );
	  draw_square( x, y, square_size, color );
	}
	else {
	  square_size = scale * abs(*vec) * 2;
	  draw_bar( x, y, square_size, color );
	}
      }
  else 		/* display row by row */
    for( j=0, y = yinit; j< Ny; j++, y += move_y )
      for( i=0, x = xinit; i<Nx; i++, x += move_x, vec += interval ) {
	if( *vec == 0.0 ) continue;
	color = *vec>=threshold?  positiveColor : 
	  	flags&BgFlag? negativeColor : EMPTY;
	if( flags&SquareFlag ) {
	  square_size = scale * sqrt( abs(*vec) );
	  draw_square( x, y, square_size, color );
	}
	else {
	  square_size = scale * abs(*vec) * 2;
	  draw_bar( x, y, square_size, color );
	}
      }

#ifndef xnet
  if(!(flags&EraseFlag)) end_temporary_segment();
#endif
  EndGraphics;
}

/* FtoA converts a floating number to ascii string with given number *
 * of significant digits counting from the first non-zero digit      */
#define Mlog 32

FtoA( value, str, prec )
float  value;
char   *str;
int    prec;    /* precision - number of significant digits */
{
  int log_10;     /* locate the first non-zero digit*/
  if( value == 0 ) {
    sprintf( str, "%*.f", prec, value );
    return;
  }
  log_10 = Ilog10( value>0? value : -value );

  if( log_10 >= prec -1 ) sprintf( str, "%*.f", prec, value );
  else if( log_10 >= 0 ) sprintf( str, "%*.*f", prec+1, prec-log_10-1, value );
  else if( log_10 >= -3 )sprintf( str, "%*.*f", prec-log_10+1, prec-log_10-1, value);
  else sprintf( str, "%.*e", prec+1, value );
}

Ilog10( value )
float value;
{
  register int i;
  if( value <= 0.0 ) return( -Mlog );
  if( value >= 1.0 ) 
    for( i=0; i<= Mlog && value >= 10.0 ; i++, value /= 10 ); 
  else if( value > 0.0 )
    for( i=0; i>= -Mlog && value <= 0.1 ; i--, value *= 10 );
  return( i );
}

#define vertical_text() { set_charpath_2_pr(0.0,1.0); set_charup_2(-1.0,0.0); }
#define horizontal_text() { set_charpath_2_pr(1.0,0.0); set_charup_2(0.0,1.0); }

draw_numbers_in_window( W, Nx,Ny, flags )
WINDOW *W; int	Nx, Ny;
unsigned flags;
{
  char	number[10];
  register int	i;
  float x,y;
  float	move_x = W->data.width / Nx ;
  float	move_y = W->data.height / Ny ;
  float	c_width = move_x/4.0 ;
  float	c_height = c_width * 1.6 ;
  float max_height = W->bmargin*NumberMargin*CharAdjust;

/** text is centered for height and left adjusted. Actual character size
  * is about charsize/CharAdjust big. So, to draw a text, set charsize
  * to desired-charsize*CharAdjust, move to (left-end , center) of the
  * fist character and draw*/

  adjust_set_charsize( &c_width, &c_height, c_width, max_height );

  x = W->data.x + move_x/2 - c_width/2;
  y = W->data.y - W->bmargin*NumberMargin*0.5 ;
  StartGraphics;
  if( flags&XnumFlag && Nx > 1 ) {
    for( i=0; i< Nx-1; i++ ) {
      sprintf( number, "%d", i ); 
      text_location_pr( number, x, y );
      x += move_x;
    }
    if(flags&WeightFlag && !(flags&TransFlag)) strcpy( number, "bias" );
    else sprintf(number, "%d", i );
    text_location_pr( number, x, y );
  }
  EndGraphics;

  c_width = move_y/4.0 ;  c_height = c_width * 1.6 ;
  max_height = W->lmargin*NumberMargin*CharAdjust;/*half of actual char size */
  adjust_set_charsize( &c_width, &c_height, c_width, max_height );
  y = W->data.y+move_y/2-c_width/2 ;		/* left-end */
#if xnet
  x = W->data.x - W->lmargin*NumberMargin*0.8;	/* left end of number margin */
#else
  x = W->data.x - W->lmargin*NumberMargin*0.5;	/* center of number margin */
#endif
  StartGraphics;
  vertical_text();
  if( flags&YnumFlag && Ny > 1 ) {
    for( i=0; i< Ny-1; i++ ) {
      (void) sprintf( number, "%d", i );
      text_location_pr( number, x, y );
      y += move_y;
    }
    if(flags&WeightFlag && flags&TransFlag) strcpy( number, "bias" );
    else sprintf( number, "%d", i );
    text_location_pr( number, x, y );
  }
  horizontal_text();
  EndGraphics;
}

/* text_in_window() displays a text in a window.  text is centered vertically *
 * and left adjusted.  the largest font size will be used that will fit in    *
 * the window */

text_in_window( W, str )
WINDOW	*W; char *str;
{
  float size_x, size_y;
  IfErr( W ) Erreturn("window not initialized");
  if( !str || !strlen(str) ) return(OK);
  size_x= W->frame.width * 0.9 / strlen( str );
  size_y= size_x * 1.2 ;
  if( NotOpen( W ) ) wipe_window( W );
  set_charsize_for_horizontal_text( str, &size_x, &size_y, 
				   W->frame.width*0.9,
				   W->frame.height*0.6 );
  return(text_location_in_window(W, W->frame.x, W->frame.y+W->frame.height*0.5,
				 size_x, size_y, str ) );
}

text_location_in_window( W, x, y, char_x, char_y, str )
WINDOW	*W;		/* window */
float   x,y;		/* starting location of text */
float   char_x, char_y; /* character size */
char *str;		/* text to display */
{
  IfErr( W ) Erreturn("window not initialized");
  if( NotOpen( W ) ) wipe_window( W );
  StartGraphics;
  set_charprecision( CHARACTER );
  set_charsize_pr( char_x , char_y  );
  text_location_pr( str, x, y );
  EndGraphics;
  return( OK );
}

float
set_charsize_for_horizontal_text( str, width, height, max_width, max_height )
char *str; float *width, *height;
float max_width, max_height;
{
  float dx, dy;
  horizontal_text();
  StartGraphics;
  set_charprecision( CHARACTER );
#ifdef sunnet
  do {
    *width *= 0.9;
    set_charsize_pr( *width, *height );
    inquire_text_extent_2( str, &dx, &dy );	/* dy is always zero */
  } while( dx > max_width );
#else
  *width = max_width / strlen( str ) ; dx = max_width;
#endif sunnet
  adjust_set_charsize( width, height, *width, max_height );
  EndGraphics;
  return( dx );
}

float
set_charsize_for_vertical_text( str, width, height, max_width, max_height )
char *str; float *width, *height;
float max_width, max_height;
{
  float dx, dy;
  vertical_text();
  StartGraphics;
#ifdef sunnet
  do {
    *width *= 0.9;
    set_charsize_pr( *width, *height );
    inquire_text_extent_2( str, &dx, &dy );	/* dx is always zero */
  } while( dy > max_width );
#else
  *width = max_width / strlen( str ); dy = max_width;
#endif sunnet
  adjust_set_charsize( width, height, *width, max_height );
  EndGraphics;
  return( dy );
}

label_window( W, str, flags )	/* define label for window and draws it */
WINDOW *W; char *str;
unsigned flags;
{
  float	start_x, c_width, c_height, length;

  IfErr( W ) Erreturn("window not initialized");
  IfErr( str ) return( OK );
  c_height = W->bmargin * LabelMargin * CharAdjust ;
  c_width = c_height * 0.6 ;
  length = set_charsize_for_horizontal_text( str, &c_width, &c_height, 
					     W->data.width, c_height );
  start_x = W->data.x +(W->data.width - length)/2 ;

  if( flags&EraseFlag )  {
    if( NotOpen( W ) ) wipe_window( W );
  }
  else
#if xnet
    select_window( W );
#else
    get_temporary_segment();
#endif

  StartGraphics;
  text_location_pr( str, start_x, W->frame.y + W->bmargin * LabelMargin * 0.5 );
  EndGraphics;
  return( OK );
}

label_window_2sides( W, str1, str2, flags )
WINDOW *W; char *str1, *str2;
unsigned flags;
{
#if xnet|mgr
  char buf[BUFSIZE];
  sprintf( buf, "%s (x) %s (y)", str1, str2 );
  label_window( W, buf, flags );
#else
  label_window( W, str1, flags );
  label_window_left( W, str2, flags );
#endif
  return(OK);
}

label_window_left( W, str, flags )/* draw vertical label in left margin  */
WINDOW *W; char *str;
unsigned flags;
{
  int	n_char;
  float	start_y, c_width, c_height, length;

  IfErr( W ) Erreturn("window not initialized");
  IfErr( str ) return( OK );
  c_height = W->lmargin * LabelMargin * CharAdjust ;
  c_width = c_height * 0.6 ; n_char = strlen( str );
  length = set_charsize_for_vertical_text(str, &c_width, &c_height,
					     W->data.height, c_height );
  start_y = W->data.y +(W->data.height - length )/2 ;

  if( flags&EraseFlag ) {
    if( NotOpen( W ) ) wipe_window( W );
  }
  else
#if xnet
    select_window( W );
#else
    get_temporary_segment();
#endif

  StartGraphics;
  vertical_text();
  text_location( str,  W->frame.x + W->lmargin * LabelMargin * 0.5, start_y );
  horizontal_text();
  EndGraphics;
  return( OK );
}

label_graph( G, label )	/* defines and draws label for graph */
GRAPH *G;
char	*label;
{
  int	n_char;
  float	start_x, c_height, c_width, length;
  WINDOW *W;
  IfErr( G ) Erreturn("graph not initialized");
  IfErr( W = G->Window ) Erreturn("window for grpah not initialized");

  if( label ) G->label = new_string( label, G->label );
  else IfErr( G->label ) return( OK );	/* label not defined for graph */

  c_height = W->bmargin * LabelMargin * CharAdjust ;
  c_width = c_height * 0.6 ; n_char = strlen( G->label );
  length = set_charsize_for_horizontal_text( G->label, &c_width, &c_height, 
					     W->data.width, c_height );
  start_x = W->data.x +(W->data.width - length)/2 ;

  wipe_segment( &G->label_segment );
  StartGraphics;
  text_location_pr( G->label,
		start_x, W->frame.y + W->bmargin * LabelMargin * 0.5 );
  EndGraphics;
  return( OK );
}

wipe_graph_label( G )
GRAPH *G;
{
  if( Err(G) || Err( G->label_segment )) return;
  wipe_segment( G->label_segment );
}

set_line_style( style )
char	*style;
{
  StartGraphics;
#ifdef xnet
  IF( style, "solid" ) set_linestyle( LineSolid );
  else IF( style, "dotted" ) set_linestyle( LineOnOffDash );
  else IF( style, "dashed" ) set_linestyle( LineOnOffDash );
  else IF( style, "dotdashed" ) set_linestyle( LineDoubleDash );
  else Erreturn("syntax: linestyle solid/dotted/dashed/dotdashed" ) ;
#else
  IF( style, "solid" ) set_linestyle( SOLID );
  else IF( style, "dotted" ) set_linestyle( DOTTED );
  else IF( style, "dashed" ) set_linestyle( DASHED );
  else IF( style, "dotdashed" ) set_linestyle( DOTDASHED );
  else Erreturn("syntax: linestyle solid/dotted/dashed/dotdashed" ) ;
#endif
  EndGraphics;
  return(OK);
}

set_line_width( width )
float width;
{
  StartGraphics;
  set_linewidth( width );
  EndGraphics;
}

#ifndef xnet		/* defined in xcore.c for XNet */
set_graphics_font( font )
int font;
{
  StartGraphics;
  switch( font ) {
  case 0 : set_font( netFont = ROMAN ); break;
  case 1 : set_font( netFont = GREEK ); break;
  case 2 : set_font( netFont = SCRIPT ); break;
  case 3 : set_font( netFont = OLDENGLISH ); break;
  case 4 : set_font( netFont = STICK ); break;
  case 5 : set_font( netFont = SYMBOLS ); break;
  default: return;
  }
  EndGraphics;
}  
#endif

draw_line_in_graph( G, x1, y1, x2, y2  )
GRAPH	*G;
float	x1,x2;
float	y1,y2;
{
  WINDOW *W;
#if planet|xnet|mgr
  float xscale,yscale,xshift,yshift;
#endif planet|xnet|mgr
  IfErr( G ) Erreturn("graph not initialized");
  IfErr( W = G->Window ) Erreturn("window for grpah not initialized");
#if sunnet
  if( NotOpen(G) && Err( add_segment_to_graph( G ) ))
     Erreturn1("%s: too frequent other displays?", ERR_MSG );
#endif sunnet
  x1 -= G->origin_x; y1 -= G->origin_y;
  x2 -= G->origin_x; y2 -= G->origin_y;
  if( x1 < 0 && x2 < 0 ) return(OK);
  if( y1 < 0 && y2 < 0 ) return(OK);
  if( x1 > G->range_x && x2 > G->range_x ) return(OK);
  if( y1 > G->range_y && y2 > G->range_y ) return(OK);

  StartGraphics;
#ifdef xnet
  ClipBox( W->frame.x, W->frame.y, W->frame.width, W->frame.height );
#else
  set_output_clipping( TRUE );
#endif
#if planet|xnet|mgr
  xscale = W->data.width / (G->range_x * G->scale_x),
  yscale = W->data.height / (G->range_y * G->scale_y),
  xshift = W->data.x, yshift = W->data.y ;
  move_abs_2_transform_pr( x1 * G->scale_x, y1 * G->scale_y, 
		       xscale, yscale, xshift, yshift );
  line_abs_2_transform_pr( x2 * G->scale_x, y2 * G->scale_y,
		       xscale, yscale, xshift, yshift );
#else
  move_abs_2_pr( x1 * G->scale_x, y1 * G->scale_y );
  line_abs_2_pr( x2 * G->scale_x, y2 * G->scale_y );
#endif planet|xnet|mgr
  set_output_clipping( FALSE );
  EndGraphics;
  return( OK );
}

line_in_window( W, x1, y1, x2, y2 ) /* draws a line from (x1,y1) to (x2, y2) */
WINDOW	*W ; float	x1,x2, y1,y2;
{
  IfErr( W ) Erreturn("window not initialized");
  if( NotOpen( W ) ) wipe_window( W );
  StartGraphics;
  move_abs_2_pr( x1, y1 );
  line_abs_2_pr( x2, y2 );
  EndGraphics;
  return( OK );
}

point_in_graph( G,  x2, y2 )
GRAPH	*G;
float	x2,y2;
{
  static	int	count = 0;
  float x,y;

  IfErr( G ) Erreturn("graph not initialized");
  IfErr( G->Window ) Erreturn("window for graph not initialized");
#if sunnet
  if( NotOpen(G) ) add_segment_to_graph( G );
#endif
/* if x2=y2=0.0, going to start a new graph */
  if( x2 == 0.0 && y2 == 0.0 ) {
    count = 0; return( OK );
  }
  x = (x2 - G->origin_x) * G->scale_x ;
  y = (y2 - G->origin_y) * G->scale_y ;
  StartGraphics;
/* if count = 0, it's the first point. move but don't draw line.  */
  if( count == 0 ) move_abs_2_pr( x, y );
  else    line_abs_2_pr( x, y );

  EndGraphics;
  count ++ ;

  return( OK );
}

set_marker( symbol )
char	symbol;
{
  int	marker =(int)(symbol - ' ') + 32 ;
  if( marker < 32 || marker > 127 ) 
    Erreturn1("invalid marker %c", symbol);
  StartGraphics;
  set_marker_symbol_pr( marker );
  EndGraphics;
  return( OK );
}

draw_marker_in_graph( G, x, y )
GRAPH	*G;
float	x, y;
{
  WINDOW *W;
  IfErr( G ) Erreturn("graph not initialized");
  IfErr( W = G->Window ) Erreturn("window for graph not initialized");
#if sunnet
  if( NotOpen(G) ) add_segment_to_graph( G );
#endif
  x -= G->origin_x; y -= G->origin_y;
  if( x < 0 || y < 0 ) return(OK);
  if( x > G->range_x || y > G->range_y ) return(OK);

  StartGraphics;
#if planet|xnet|mgr
  marker_abs_2_transform_pr( x * G->scale_x , y * G->scale_y,
			 W->data.width / (G->range_x * G->scale_x),
			 W->data.height / (G->range_y * G->scale_y),
			 W->data.x, W->data.y);
#else
  marker_abs_2_pr( x * G->scale_x , y * G->scale_y );
#endif
  EndGraphics;
  return( OK );
}

/* adjust size of characters so that width and height satisfy 4 constraints *
 * 1) width<=max_x 2) height<=max_y 3) height>=width 4) height<=width*2     */

adjust_charsize( c_widthP, c_heightP, max_width, max_height )
float	*c_widthP, *c_heightP;
float	max_width, max_height;
{
  if( *c_widthP > max_width ) *c_widthP = max_width ;
  if( *c_heightP > max_height ) *c_heightP = max_height ;
  if( *c_widthP > *c_heightP ) *c_widthP = *c_heightP ;
  if( *c_heightP > *c_widthP * 2.0 ) *c_heightP = *c_widthP * 2.0 ;
}

/* adjust size of characters with adjust_charsize() above and *
 * then set current charsize to be the adjusted width and height */

adjust_set_charsize( c_widthP, c_heightP, max_width, max_height )
float	*c_widthP, *c_heightP;
float	max_width, max_height;
{
  adjust_charsize( c_widthP, c_heightP, max_width, max_height );
  StartGraphics;
  set_charprecision( CHARACTER );
  set_charsize_pr( *c_widthP, *c_heightP ); 
  EndGraphics;
}

/* wipe_segment() should be called just before displaying something in *
 * a segment.  It basically wipes out whatever is already drawn in it. *
 * It deletes that segment and replaces it with an open segment to which *
 * subsequent drawings will be written. */

wipe_segment( segment )
int *segment;
{
  if( *segment != NULL ) {        	/* if segment has already been opened*/
    refresh_segment( *segment ); 	/* erase it and make a fresh segment */
  }  
  else {	                        /* if segment has not been opened*/
    *segment = new_segment() ;    	/* get a new open segment */
  }
}  

/* delete_segment() should be called whenever a segment should be erased *
 * and will not be used any more.  Use it whenever possible to minimize *
 * the number of used segments */

delete_segment( segment_name )
int	*segment_name; 
{
  if( *segment_name == NULL ) return;
  StartGraphics;
  delete_retained_segment( *segment_name );
  if( Segment_opened == *segment_name ) Segment_opened = NoSeg;
  *segment_name = NULL;
  EndGraphics;
}

refresh_segment( segment_name )
int  segment_name;
{
  erase_segment( segment_name );        /* erase content of segment   */
  create_segment( segment_name );        /* recreate segment for subsequent */
}                                         /* drawings */

new_segment( )                           /* pick up a new segment name, */
{                                         /* create a segment with it,   */
  create_segment( Nsegment++ );          /* and return the segment name.*/
  return( Nsegment-1 );                  /* previously open segment, if */
}                                         /* any, will be closed         */

erase_segment( segment_name )
int	segment_name; 
{
  if( segment_name == NULL ) return;
  StartGraphics;
  delete_retained_segment( segment_name );
  if( Segment_opened == segment_name ) Segment_opened = NoSeg;
  EndGraphics;
}

create_segment( segment_name ) 
int	segment_name; {
  if( segment_name == NULL ) return;
  StartGraphics;
					/*if a segment is open, close
					 * it to create a new segment */
  if( Segment_opened != NoSeg ) {
    close_retained_segment( Segment_opened );
    Segment_opened = NoSeg ;
  }					/* create a new segment and note that
					 * it is the one currently open */
  create_retained_segment( segment_name );
  Segment_opened = segment_name;
  EndGraphics;
}

wipe_all_graphics( )	/* delete all display objects */
{
  StartGraphics;
  wipe_all_segments( Nsegment );
/*
  Segment_opened = NoSeg ;
  Nsegment = 2;
*/
  EndGraphics;
  return( OK );
}

get_temporary_segment()
{
  if( Segment_opened == Temporary ) return;
  if( Segment_opened != NoSeg ) {
    close_retained_segment( Segment_opened );
  }	
  create_temporary_segment();
  Segment_opened = Temporary ;
}

end_temporary_segment()
{
  if( Segment_opened != Temporary ) return;
  close_temporary_segment();
  Segment_opened = NoSeg;
}

float xtemp;
#define order( x1, x2 ) if(x1>x2) xtemp=x1, x1=x2, x2=xtemp

#if sunnet
  /**** movie routines are defined below only for SunNet.
   **** for XNet, these routines are defined in xcore.c.
   ****/
extern	struct	vwsurf	*sun_vwsurf;

RASTER *
take_frame( box )
BOX *box;
{
  float x1=box->x,y1=box->y, x2=box->x+box->width,y2=box->y+box->height;
  RASTER *frame = new( RASTER );
  IfErr( frame ) Erreturn("not enough memory");
  if( x1 == 0.0 && x2 == 0.0 ) {
    x1=y1= 0; x2 = XNDC; y2 = YNDC;
  }
  else {
    x1 /=  NdcToX;     x2 /=  NdcToX; 
    y1 /=  NdcToY;     y2 /=  NdcToY; 
  }
  order( x1, x2 ); order( y1, y2 );
  StartGraphics;
  size_raster( sun_vwsurf, x1, x2, y1, y2, frame );
  allocate_raster( frame );
  IfErr( frame->bits ) Erreturn("not enough memory");
  get_raster( sun_vwsurf, x1, x2, y1, y2, 0, 0, frame );
  EndGraphics;
  return( frame );
}

/* copy raster in one box to another */
copy_frame( box1, box2 )
BOX *box1, *box2;
{
  static RASTER *frame=NULL;
  float x1,x2,y1,y2; short *bits;
  start_movie();
  if( frame == NULL ) { 
    frame = new( RASTER );
    size_raster( sun_vwsurf, 0.0, XNDC, 0.0, YNDC, frame );
    allocate_raster( frame );
  }
    x1 = box1->x/  NdcToX;     x2 =  (box1->x+box1->width)/NdcToX; 
    y1 = box1->y/  NdcToY;     y2 = (box1->y+box1->height)/ NdcToY; 
  /* IfErr( frame = take_frame( box1 )) return(ERR); */
  bits = frame->bits;
  size_raster( sun_vwsurf, x1, x2, y1, y2, frame);
  frame->bits = bits;
  get_raster( sun_vwsurf, x1, x2, y1, y2, 0, 0, frame );
  IfErr( show_frame( frame, box2->x, box2->y, 0 )) return(ERR);
  /* erase_frame( &frame ); */
  end_movie();
  return( OK );
}

erase_frame( frame )
RASTER **frame;
{
  IfErr( frame ) return;
  StartGraphics;
  free_raster( *frame );
  free( *frame );
  *frame = NULL;
  EndGraphics;
}

start_movie()
{
  StartGraphics;
  get_temporary_segment();
  EndGraphics;
}

end_movie()
{
  StartGraphics;
  end_temporary_segment();
  EndGraphics;
}

show_frame( frame, x, y, t_frame )
RASTER *frame;
float x,y;		/* lower left corner of frame */
int t_frame;		/* time in msec to show frame */
{
  static int timed=0;
  int tnow=0;
  if( timed == 0 ) tstart();
  if( t_frame > 0 ) while( tnow < t_frame ) msec(tnow);
  tstart(); timed = 1;
  StartGraphics;
  move_abs_2_pr( x, y );
  put_raster( frame );
  EndGraphics;
  return( OK );
}

save_frame( fd, frame )
int fd;
RASTER *frame;
{
  struct {
    int type, nbytes; char *data;
  } map;
  map.type = 1; map.nbytes = 0; map.data = NULL;
  StartGraphics;
  raster_to_file( frame, &map, fd, 1 );
  EndGraphics;
}

read_frame( fd, frame )
int fd;
RASTER **frame;
{
  int status; char buf[1];
  struct {
    int type, nbytes; char *data;
  } map;
  map.type = 0;
  map.data = NULL;	/* otherwise file_to_raster() frees it! */
  if( *frame == NULL ) *frame = new( RASTER );
  else free_raster( *frame );
  IfErr( read(fd, buf, 1) ) return( EOF );
  lseek( fd, -1, L_INCR );
/*  if( 0!=(status = file_to_raster( fd, *frame, &map ))) return(EOF); */
  file_to_raster( fd, *frame, &map );
  IfErr( (*frame)->bits ) Erreturn( "not enough core" );
  return( OK );
}

#endif sunnet	/* end of movie routines */

#if sunnet|planet

set_color( color )
char *color;
{
  int indx;
  if( sscanf( color, "positive%d",     &positiveColor) );
  else if( sscanf( color, "p%d",       &positiveColor) );
  else if( sscanf( color, "negative%d",&negativeColor) );
  else if( sscanf( color, "n%d",       &negativeColor) );
  else if( sscanf( color, "window%d",  &windowColor) );
  else if( sscanf( color, "w%d",       &windowColor) );
  else if( sscanf(color,"background%d",&indx) ) set_background_color(indx);
  else if( sscanf(color, "b%d",	       &indx) ) set_background_color(indx);
  else if( sscanf( color, "line%d",    &indx) ) set_line_index(indx);
  else if( sscanf( color, "l%d",       &indx) ) set_line_index(indx);
  else if( sscanf( color, "text%d",    &indx) ) set_text_index(indx);
  else if( sscanf( color, "t%d",       &indx) ) set_text_index(indx);
/*  else Erreturn1("%s: color flags: xN (x = p n w b l t)", color);*/
  else IF(color, "black") { 
    windowColor = BLACK;
    set_line_index( WHITE );  set_text_index( WHITE );
    return(OK);
  }
  else IF(color, "white") windowColor = WHITE;
  else IF(color, "right") windowColor = HATCH_RIGHT;
  else IF(color, "left") windowColor = HATCH_LEFT;
  else IF(color, "wallpaper") windowColor = WALLPAPER;
  else IF(color, "wavy") windowColor = WAVY;
  else IF(color, "grey") windowColor = GREY;
  else IF(color, "cross") windowColor = CROSS_HATCH;
  else Erreturn1("%s: color not found", color);
  set_line_index( BLACK );  set_text_index( BLACK );
  return(OK);
}

#endif sunnet|planet

#if planet  	/* defined in graphinit.c for non-planet */
change_color_map( indx, rgb )
int indx; char *rgb;
{
  color_map( indx, rgb );
  return(OK);
}
#endif planet

paint_box( box )
BOX *box;
{
  IfErr( box ) fill_box_pr( XMIN, YMIN, XMAX-XMIN, YMAX-YMIN , windowColor );
  else fill_box_pr( box->x, box->y, box->width, box->height, windowColor );
}

draw_box( box )
BOX *box;
{
  IfErr( box ) return;
  StartGraphics;
  move_abs_2_pr( box->x, box->y ); 
  line_rel_2_pr( box->width, 0.0 );
  line_rel_2_pr( 0.0, box->height );
  line_rel_2_pr( -box->width , 0.0 );
  line_rel_2_pr( 0.0, -box->height );
  EndGraphics;
}

#if sunnet|planet	/* defined in mgrinit.c for Mgr, xcore.c for XNet */
#define Twait 500		/* (msec) wait before getting second corner */
locate_box( box )
BOX *box;
{
  int buttons=0;
  int segment =0;	/* use this segment to draw guiding box */
  int tnow=0;
  float x1,y1,x2,y2;
  set_drag( TRUE );
  StartGraphics;
  while( buttons == 0 ) {
    get_point( &x1, &y1, &buttons );
    if( INTERRUPT > 1 ) {
      set_drag( FALSE );
      EndGraphics;
      Erreturn("interrupted");
    }
  }

  tstart(); while( tnow < Twait ) msec(tnow);
  for( buttons = 0; buttons == 0; ) {
    get_point( &x2, &y2, &buttons );
    define_box( box, min(x1,x2), min(y1,y2), abs(x2-x1), abs(y2-y1) );
    wipe_segment( &segment );
    draw_box( box );
    if( INTERRUPT > 1 ) {
      delete_segment( &segment );
      set_drag( FALSE );
      EndGraphics;
      Erreturn("interrupted");
    }
  }
  define_box( box, min(x1,x2), min(y1,y2), abs(x2-x1), abs(y2-y1) );
  delete_segment( &segment );
  set_drag( FALSE );
  EndGraphics;
  return(OK);
}
#endif sunnet|planet

#define Ncircle 32
#define Pi 3.14159274101

draw_circle( W, x, y, r )
WINDOW *W;
float x,y,r;
{
  static float sine[Ncircle], cosine[Ncircle];
  static int compute = 1;
  float xarray[Ncircle], yarray[Ncircle];
  float angle, a_step = 2.0*Pi/(Ncircle-1);
  int i;
  
  if( NotOpen( W ) ) wipe_window( W );

  if( compute ) 
    for(compute=0, i=0, angle = 0.0; i<Ncircle; i++, angle += a_step ) {
      sine[i] = sin( angle ); cosine[i] = cos( angle );
    }
  StartGraphics;
  move_abs_2_pr( x+r, y );
#if sunnet|planet
  if( ColorSun ) {
    for(i=0; i<Ncircle; i++ )
      xarray[i] = x+cosine[i]*r, yarray[i] = y+sine[i]*r;
    set_fill_index( positiveColor );
    polygon_abs_2( xarray, yarray, Ncircle );
  }
  else 
#endif
    for(i=1; i<Ncircle; i++ )
      line_abs_2_pr( x+cosine[i]*r, y+sine[i]*r );

  EndGraphics;
  
  return( OK );
}

draw_arc( W, x, y, r, angle1, angle2 )
WINDOW *W;
float x,y,r;
int angle1,angle2;
{
  static float sine[Ncircle], cosine[Ncircle];
  static int compute = 1;
  float xarray[Ncircle], yarray[Ncircle];
  float angle, a_step = 2.0*Pi/(Ncircle-1);
  int i, start = angle1*Ncircle/360, end = angle2*Ncircle/360;
  
  if( NotOpen( W ) ) wipe_window( W );

  if( compute ) 
    for(compute=0, i=0, angle = 0.0; i<Ncircle; i++, angle += a_step ) {
      sine[i] = sin( angle ); cosine[i] = cos( angle );
    }
  StartGraphics;
  move_abs_2_pr( x+r, y );
#if sunnet|planet
  if( ColorSun ) {
    for(i=start; i<end; i++ )
      xarray[i] = x+cosine[i]*r, yarray[i] = y+sine[i]*r;
    set_fill_index( positiveColor );
    polygon_abs_2( xarray, yarray, Ncircle );
  }
  else 
#endif
    for(i= start; i< end; i++ )
      line_abs_2_pr( x+cosine[i]*r, y+sine[i]*r );

  EndGraphics;
  
  return( OK );
}

#if 0  /* not worked out yet */
arc_two_points( W, x1, y1, x2, y2, radius )
WINDOW *W;
float x1,y1, x2,y2;
float radius;
{
  float angle1,angle2;
  radius = radius*radius;
  angle1 = acos( (2*radius - (x2-x1)**2 - (y2-y1)**2 ) / radius);
}
#endif 0

#ifndef sunnet
		/* these functions are defined in graphinit.c for SunNet */
#ifndef mgr
get_point() {}	/* defined in mgrinit.c for MgrNet*/
#endif
#ifndef xnet
locate_mouse() {}	/* defined in xcore.c for XNet */
#endif

#define Largs 64

void exec_rsh( command, argn, args )	/* remote csh */
char	*command, args[][Largs]; int argn;
{
  register int	n;
  char    buffer[ BUFSIZE ];
  sprintf ( buffer, "csh -c '%s", command );
  for( n=0; n<argn; n++ ) {
    sprintf( buffer, "%s %s", buffer, args[n] );
  }
  sprintf( buffer, "%s'", buffer );
  rsh( buffer );
}

#endif

#define PrintCommand "/usr/ucb/lpr"
char   PrinterName[ 64 ];

open_display_file( fname )
char *fname;
{
  FILE *fp;
  IfErr( fname ) return( ERR );
  if( Printer ) { close_display_printer(); }
  IfErr( fp = fopen( fname, "w" ) ) Erreturn1("cannot open %s",fname);
  Printer = fp;
  strcpy ( PrinterName, fname );
/*  fprintf( Printer, "%%!\n(%s) run\n", PSCFILE );
    this doesn't work if file is run on a remote host */
  IfErr( print_pscdefs( Printer ) ) return(ERR);
  return ( OK );
}

open_display_printer( pname )
char *pname;
{
  FILE *fp; char printcmd[BUFSIZE];
  if( Err( pname ) || Err( strlen(pname) )) Erreturn( "what printer?" );
  if( Printer ) { close_display_printer(); }
  sprintf( printcmd, "%s -P%s", PrintCommand, pname ); 

  IfErr( fp = popen ( printcmd, "w" ) ) Erreturn("cannot open pipe");
  Printer = fp;
  strcpy ( PrinterName, pname );
/*  fprintf( Printer, "%%!\n%s run\n", PSCFILE ); 
    this doesn't work if file is run on a remote host */
  IfErr( print_pscdefs( Printer ) ) return(ERR);
  return ( OK );
}

print_pscdefs( fp )
FILE *fp;
{
  char buf[128];
  FILE *pscfile = fopen(PSCFILE, "r");
  IfErr( pscfile ) Erreturn1("cannot open %s", PSCFILE);
  fputs( "%!\n", fp );
  fputs( "%%BoundingBox: 20 20 720 540\n", fp ); /* not sure about the numbers*/
  while ( fgets( buf, sizeof(buf), pscfile ) )
    if( buf[0] != '%' ) fputs( buf, fp );
#ifdef xnet
  set_charsize_pr(xCharSize,0);	/* set to current char size */
#endif xnet
  return(OK);
}

close_display_printer()
{
  if( Printer==NULL ) Erreturn( "Display file not open. Do 'dprint <file>'" );
  fprintf(Printer, "showpage\n");
  pclose( Printer );
  Printer = NULL ;
  *PrinterName = NULL ;
  return( OK );
}

close_display_file()
{
  if( Printer==NULL ) Erreturn( "Display file not open. Do 'dprint <file>'" );
  fprintf(Printer, "showpage\n");
  fclose( Printer );
  Printer = NULL ;
  *PrinterName = NULL ;
  return( OK );
}

char *
whatis_display_printer() { return (PrinterName);}

void
flush_displayfile ()
{
  if ( Printer ) fflush ( Printer );
}

#if sunnet
text_location( str, x, y )
char *str; float x,y;
{
  StartGraphics;
  move_abs_2_pr( x, y ); text( str );
  EndGraphics;
}
#endif sunnet
