%{
#include <stdio.h>
#include <ctype.h>
#include "alloc.h"
#include "net.h"
#include "arith.h"
#include "error.h"
/* #include "msg.h"  for debugging */
double  atof();
int i, yyDebug;
int yyInProc; /*  procedure arguments parsing */
%}

%start list
%union {
  int	ival;
  float fval;
  VECTOR vval;
  RANGE rval;
  EXPRESS *eval;
  PROCARG *aval;
  int  (*funcval)();
  char  *sval;
  char  cval;
}
%token <ival> INTGR
%token <fval> REAL
%token <vval> VEC
%token <vval> VEC2
%token <ival> OP
%token <ival> MULTI
%token <cval> ASSIGN
%token <cval> CMP
%token <cval> LOGIC
%token <cval> KW_PROC
%token <cval> KW_LAYER
%token <cval> KW_CONNECT
%token <cval> KW_EXPR
%token <sval> NEWNAME
%token <sval> PROCNAME
%token <funcval> FUNC
%token <funcval> RANDOMFUNC
%token <ival> TO
%type <aval> arglist
%type <eval> expr
%type <rval> range
%type <fval> real
%right ASSIGN
%left '&' '|' LOGIC
%left CMP
%left '+' '-'
%left '*' '/' MULTI
%right '^'
%left UMINUS
%%
list :		
 /* list can be empty */
 | expr
	{ Expression = $1; }
 ;
procedure :
 KW_PROC NEWNAME
	{ /* new_procedure( $2, NULL )*/; YYACCEPT; }
 | KW_PROC PROCNAME arglist ')'
	{ /* new_procedure( $2, $3 )*/; YYACCEPT; }
 | KW_PROC NEWNAME '(' arglist ')'
	{ /* new_procedure( $2, $4 )*/; YYACCEPT; }
 ;
arglist : /* this can be empty */
	{ $$ = NULL; }
  | arg
	{ $$ = NULL; }
  | arglist ',' arg
	{ $$ = NULL; }
 ;
arg : /* this cannot be empty */
  NEWNAME
	{ /* Pargs = add_arg_to_pargs( Pargs, ItsExpr, $2 )*/ ; }
  | NEWNAME NEWNAME
	{ /* Pargs = add_arg_to_pargs( Pargs, $1, $2 )*/; }
  ;
expr :
 '(' expr ')'
	{ $$ = $2; }
 | expr ASSIGN expr
	{ IfErr( is_lvalue($1) ) { 
	    $$ = NULL; sprintf(ERR_MSG,"left-side of %c%c is non-lvalue",
				$2, $2=='='? ' ':'=' ); 
	  }
	  else $$ = assignment_expression( $2, $1, $3 ); }
 | expr '+' expr
	{ $$ = op_expression( '+', $1, $3 ); }
 | expr '-' expr
	{ $$ = op_expression( '-', $1, $3 ); }
 | expr '*' expr
	{ $$ = op_expression( '*', $1, $3 ); }
 | expr '/' expr
	{ $$ = op_expression( '/', $1, $3 ); }
 | expr MULTI expr
	{ $$ = multi_expression( $1, $3 ); }
 | expr '^' expr
	{ $$ = op_expression( '^', $1, $3 ); }
 | expr '&' expr
	{ $$ = op_expression( '&', $1, $3 ); }
 | expr '|' expr
	{ $$ = op_expression( '|', $1, $3 ); }
 | expr CMP expr
	{ $$ = op_expression( $2, $1, $3 ); }
 | expr LOGIC expr
	{ $$ = op_expression( $2, $1, $3 ); }
 | '-' expr 	%prec UMINUS
	{ $$ = op_expression( '-', constant_expression( 0.0 ), $2 ); }
 | FUNC  expr ')'
	{ $$ = func_expression( $1, $2 ); }
 | RANDOMFUNC  expr ')'
	{ $$ = randomfunc_expression( $1, $2 ); }
 | expr range
	{ $$ = range_expression($1, &$2); }
 | expr range range
	{ $$ = range2_expression($1, &$2, &$3); }
 | VEC
	{ $$ = terminal_expression( &$1 ); }
 | VEC2 
	{ $$ = terminal_expression(&$1); }
 | expr '[' ']' '[' expr ']'
	{ $$ = column_expression($1,$5); }
 | real
	{ $$ = constant_expression( $1 ); }
 ;
real:
  REAL
	{ $$ = $1; }

 | INTGR
	{ $$ = (float) $1; }
 ;
range:
 '[' expr TO expr ']'
	{ $$.start = $2; $$.end = $4; }
 | '[' expr ']'
	{ $$.start = $2; $$.end = NULL; }
 | '[' INTGR ',' INTGR ']'
	{ $$.start = constant_expression((float)$2); 
	  $$.end = constant_expression((float)$2+$4-1); }
 ;
%%
#include <stdio.h>
#include <strings.h>
#define BUFSIZE 512
EXPRESS *Expression, *ex;
char Buf[BUFSIZE], *NextChar, *OrigStr;
NETWORK *yyNet;
PROCED *yyProc;
void *substitute_defined_str();

EXPRESS *
find_expression( net, str ) 
NETWORK *net;  char *str;
{
  yyNet = net;
  NextChar = strncpy( Buf, OrigStr = str, BUFSIZE );
  substitute_defined_str( Buf, net );
  *ERR_MSG = NULL;
  set_yydebug();	
  Expression = NULL;
  if( yyparse() ) {/* syntax error */ 
    if( Expression ) delete_expression(Expression); Expression=NULL;
    Erreturn2("%s: in %s", ERR_MSG, str );
  }
  IfErr( Expression ) Erreturn2("%s: in %s", ERR_MSG, str );
  Expression->name = new_string( str, Expression->name );
  return( Expression );
}

#define YYDEBUG 1

yyerror(s) char *s; {
	/* fprintf(stderr, "%s in %s\n", s, OrigStr );    */
}
/*
input()
{
  char c;
  if( (c = *NextChar) == NULL ) return(0);
  NextChar++ ;
  return( c );
}
output(c) char c; {}

unput(c) char c; {
  if(NextChar>Buf) *(--NextChar) = c;
}
*/
#include "lex.yy.c"
