/* dprint.h - macros to send display info to ps printer. */
		/* For generating postscript output */
#ifdef xnet
#define StoP 1.2 	/* Screen to Printer conversion - 
			 * 72 pixels per inch x 10 inches / 600 pixels */
#define Poffset 20.0	/* Offset for Printer output */

#else
#define StoP 72.0 	/* Screen to Printer conversion - points per inch */
#define Poffset 20.0	/* Offset for Printer output */
#endif

#define marker_abs_2_pr(x,y) \
  marker_abs_2(x,y), \
  Printer? fprintf(Printer, "%.1f %.1f mark txt\n",\
		   StoP*(x)+Poffset,StoP*(y)+Poffset) : 0
#define marker_abs_2_transform_pr(x,y,xscale,yscale,xshift,yshift) \
  marker_abs_2_transform(x,y,xscale,yscale,xshift,yshift), \
  Printer? fprintf(Printer, "%.1f %.1f mark txt\n",\
		   StoP*(xshift+(x)*xscale)+Poffset,\
		   StoP*(yshift+(y)*yscale)+Poffset) : 0
#define move_abs_2_pr(x,y) \
  move_abs_2(x,y), \
  Printer? fprintf(Printer,"%.1f %.1f mv\n",\
			      StoP*(x)+Poffset,StoP*(y)+Poffset) : 0
#define move_rel_2_pr(x,y) \
  move_rel_2(x,y), \
  Printer? fprintf(Printer,"%.1f %.1f rmv\n",StoP*(x),StoP*(y)) : 0

#define line_abs_2_pr(x,y) \
  line_abs_2(x,y), \
  Printer? fprintf(Printer, "%.1f %.1f line\n",\
		   Poffset+StoP*(x),Poffset+StoP*(y)) : 0
#define line_rel_2_pr(x,y) \
  line_rel_2(x,y), \
  Printer? fprintf(Printer, "%.1f %.1f rline\n",\
		   (float) StoP*(x),(float) StoP*(y)) : 0

#define move_abs_2_transform_pr(x,y,xscale,yscale,xshift,yshift) \
  move_abs_2_transform(x,y,xscale,yscale,xshift,yshift), \
  Printer? fprintf(Printer, "%.1f %.1f mv\n",\
		   StoP*(xshift+(x)*xscale)+Poffset,\
		   StoP*(yshift+(y)*yscale)+Poffset) : 0
#define line_abs_2_transform_pr(x,y,xscale,yscale,xshift,yshift) \
  line_abs_2_transform(x,y,xscale,yscale,xshift,yshift), \
  Printer? fprintf(Printer,"%.1f %.1f line\n", \
	  StoP*(xshift+(x)*xscale)+Poffset,\
	  StoP*(yshift+(y)*yscale)+Poffset) : 0

#define set_charpath_2_pr(x,y) set_charpath_2(x,y), \
  Printer? fprintf(Printer, "%g %g cpath\n", x,y ) : 0
#ifdef xnet
#define set_charsize_pr(x,y) set_charsize(x,y), \
  Printer? fprintf(Printer,"%.1f csize\n",2*StoP*(xCharSize)):0
#else
#define set_charsize_pr(x,y) set_charsize(x,y), \
  Printer? fprintf(Printer,"%g csize\n",StoP*2*x) : 0
#endif

#ifdef xnet
#define set_marker_symbol_pr(m) set_marker_symbol(m), \
  Printer? fprintf(Printer, "/mark (%c) def %.1f csize\n", m, 2*StoP*(xCharSize)) : 0
#else
#define set_marker_symbol_pr(m) set_marker_symbol(m), \
  Printer? fprintf(Printer, "/mark (%c) def 8 csize\n", m) : 0
#endif

/***	new functions that are not in SunCore ***/

/** fill_box() defined in graph.c **/

#define fill_box_pr(x,y,w,h,color) \
  fill_box(x,y,w,h,color), \
  Printer? fprintf(Printer,"%.1f %.1f %.1f %.1f %.1f box\n", \
		      StoP*(x)+Poffset,StoP*(y)+Poffset, \
		      StoP*(w), StoP*(h), \
		      ((color)==WHITE)? 1 : ((color)==BLACK)? 0 : \
		      ((color)==EMPTY)? -1 : 0.6 ) : 0
/* BUG - should convert colors to reasonable grays */

/*** this is a combination of move_abs_2() and text() ***/

#define text_location_pr(str, x, y) \
  text_location(str, x, y), \
  Printer? fprintf(Printer, "%.1f %.1f (%s) txt\n", \
		     StoP*(x)+Poffset, StoP*(y)+Poffset, str ) : 0


