/* $Header: /soma/users/miyata/planet/src/RCS/display.c,v 5.6.0.4 91/02/13 15:42:07 miyata Exp $ */
static char rcsid[] = "$Header: /soma/users/miyata/planet/src/RCS/display.c,v 5.6.0.4 91/02/13 15:42:07 miyata Exp $";
/***** UPDATES ************************************************
display.c
* 2/12/90 fixed display_weight() to transpose properly.
***************************************************************/
#include <stdio.h>
#include <math.h>
#include "net.h"
#include "graph.h"
#include "alloc.h"
#include "error.h"
#include "sunnet.h"
#include "msg.h"

#define weightTrans 1

#ifdef use_mouse
#undef use_mouse
#endif
#if sunnet|xnet
#define use_mouse 1
#endif

extern	int Nwindow;

#define Ntext 100
#define Nlabel 64

#ifdef demo
#define Wspace 0.00		/* spacing between windows */
#else
#define Wspace 0.05		/* spacing between windows */
#endif

/* open n windows and arrange them appropriately in a matrix */

open_windows( Window, nwind, ncol, Mwindow, frame )
WINDOW	**Window;
int	nwind; 				/* # of windows to open */
int	ncol;				/* # of columns (optional) */
BOX	*frame;				/* box to open windows in */
{
  register int	i;
  int	nrow ;				/* # of rows */
  float move_x, move_y;			/* distance between adjacent windows */
  float	x1,y1;				/* location of each window */
  float	width,height ;			/* size of each window */
  BOX   box;				/* box in which windows are opened */

  for( i=0; i<nwind ; i++)  		/* clear all open windows */
    if( Window[i] ) wipe_window( Window[i] );

  if( nwind <= 0  ) Erreturn1("invalid # of window %d", nwind );
  if( ncol == 0 ) {			/* ncol not specified -> compute it */
    for( i=1 ; ; i++ ) if( nwind <= i *( i*2 + 1 ) ) break;
    nrow = i ;			/* # of rows of windows opened */
    ncol =(nwind-1)/nrow + 1;	/* # of windows opened in a row */
  }
  else nrow =(nwind-1) / ncol + 1 ;

  if( frame ) copy_box_size( frame, &box );
  else {
#ifdef use_mouse
    sendMsg("Use mouse button to locate region in which to open windows.\n");
    IfErr( locate_box( &box ) ) Erreturn("cancelled");
#else		/* use the entire display field */
    define_box( &box, XMIN, YMIN, XMAX-XMIN, YMAX-YMIN );
#endif
  }

  move_x = box.width/(ncol-Wspace);	/* why -Wspace ??? */
  move_y = box.height/(nrow-Wspace);
  width = move_x * (1-Wspace);		/* width of each window */
  height = move_y * (1-Wspace);		/* height of each window */

  for( i=0; i< nwind && i< Mwindow ; i++ ) {
    x1 =  box.x+move_x*(i%ncol), y1 = box.y+move_y*(i/ncol);
    if((Window[i] &&
	Err( set_window_size( Window[i], x1, y1, width, height )))
       ||
       Err( Window[i]=new_window( x1, y1, width, height )) )
      Erreturn2("%s: cannot open window #%d", ERR_MSG, i);
  }
  Nwindow = nwind;
  return( ncol );
}

WINDOW **
subwindows_in_window( W, ncol, nwin )
     WINDOW *W;
     int ncol, nwin;
{
  static WINDOW **subwindow = NULL;
  static int nsubwin = 0;
  int n, nrow;
  float width, height;			/* width and height of each subwindow*/
  IfErr( W ) Erreturn("window not initialized");
  if( nwin < 1  ) Erreturn1("%d: # of windows must be positive", nwin );
  if( ncol == 0 ) {			/* ncol not specified -> compute it */
    for( n=1 ; ; n++ ) if( nwin <= n *( n*2 + 1 ) ) break;
    nrow = n ;			/* # of rows of windows opened */
    ncol =(nwin-1)/nrow + 1;	/* # of windows opened in a row */
  }
  else nrow =(nwin-1) / ncol + 1 ;

  if( nsubwin < nwin ) {
    if( subwindow ) {
      for( n=0; n< nsubwin; n++ ) free( subwindow[n] );
      free( subwindow );
    }
    IfErr( subwindow = new_array_of( nwin, WINDOW* )) 
      Erreturn("not enough core");
    for( n=0; n< nwin ; n++ )
      IfErr( subwindow[n] = new( WINDOW )) Erreturn("not enough core");
    nsubwin = nwin;
  }
  width = W->data.width/ncol;		/* width of each window */
  height = W->data.height/nrow;		/* height of each window */
/*  if( NotOpen( W ) ) wipe_window( W ); */

  for( n=0; n< nwin ; n++ ) {
    IfErr( set_window_size( subwindow[n], W->data.x + width*(n%ncol),
			   		  W->data.y + height*(n/ncol),
		      	 		  width*0.9, height*0.9))
      Erreturn2("%s: cannot initialize subwindow #%d", ERR_MSG, n);
    subwindow[n]->segment_name = W->segment_name;
  }
  return( subwindow );
}

display_vector(window, vector, nvalue, ncol, interval, label, unit, flags )
WINDOW	*window;
float   vector[];
int     nvalue, interval;
int     ncol;
char	*label;
float	unit;
long flags;
{
  register int	i,j, n;
  int	nrow;
  NUMBER **values;

  if( nvalue == 0 ) return( OK );
  if( ncol == 0 || ncol > nvalue ) ncol = nvalue ;
  nrow =(nvalue-1) / ncol + 1;
  IfErr( window ) Erreturn( "window not open" );

  draw_matrix_in_window( window, vector, ncol, nrow, interval,
			 (Label==ON)?label: NULL,
			 Threshold, unit>0.0? unit: Unit, flags);
  return( OK );
}

display_weight( W, connectP, unit, flags )
WINDOW	*W;
CONNECT *connectP ;
NUMBER	unit;
long flags;
{
  static WEIGHT *values;
  static int Nvalues = 0;      /* amount of memory pointed to by values */
  int    nvalues;
  WEIGHT *weight = connectP->weight;
  char	label[Nlabel];
  register int i,j,ij;
  int   nweight = connectP->from_nunit * connectP->to_nunit;
  IfErr( W ) Erreturn("window not open");
				/* allocate memory when necessary */
  if( Nvalues < ( nvalues = nweight + connectP->to_nunit ) ) {
    IfErr( values=new_array_of( nvalues, WEIGHT )) Erreturn("not enough core");
    Nvalues = nvalues;
  }

#ifdef weightTrans
  weight = connectP->weight;
  for( j=ij=0; j<connectP->to_nunit ; j++ ) {
    for( i=0; i<connectP->from_nunit ; i++, weight++ )
#else
  for( j=ij=0; j<connectP->to_nunit ; j++ ) {
    weight = &connectP->weight[j];
    for( i=0; i<connectP->from_nunit ; i++, weight += connectP->to_nunit )
#endif weightTrans
      values[ij++] = *weight;
    values[ij++] = connectP->tolayer? connectP->tolayer->bias[j]: 0.0 ;
  }

  if( !(flags&TransFlag) ) {
    sprintf( label, "weights from %s", 
	    connectP->fromlayer? connectP->fromlayer->name:"unknown layer");
    sprintf( label+strlen(label)+1, "to %s", 
	    connectP->tolayer? connectP->tolayer->name:"unknown layer" );
    draw_matrix_in_window(W,values, connectP->from_nunit+1, connectP->to_nunit,
			  1, (Label==ON)? label: NULL, Threshold,
			  unit>0.0? unit : Unit, (long) flags|WeightFlag );
  }
  else {
    sprintf( label, "weights to %s", 
	    connectP->tolayer? connectP->tolayer->name:"unknown layer" );
    sprintf( label+strlen(label)+1, "from %s", 
	    connectP->fromlayer? connectP->fromlayer->name:"unknown layer" );
    draw_matrix_in_window(W, values,connectP->to_nunit, connectP->from_nunit+1,
			  1, (Label==ON)? label: NULL, Threshold,
			  unit>0.0? unit : Unit, (long) flags|WeightFlag );
  }
  return( OK );
}

/* print parameters in text window */
print_para_in_window( TextWindow, Fname, step, Lrate, Alpha, Error )
WINDOW	*TextWindow;
char	*Fname;
int	step;
NUMBER	Lrate, Alpha, Error;
{
  char	text[ Ntext ];
  sprintf(text, "File=%s; step=%d; eta=%3.2f; alpha=%3.2f; Error=%f",
	  Fname,step,Lrate,Alpha, Error);
  IfErr( TextWindow ) Erreturn("text window not open");
  wipe_window( TextWindow );
  text_in_window( TextWindow, text );
}

/* plot one point in error graph by drawing a line from previous to the
 * current points.  For simultanous drawing of several graphs, it keeps track
 * of where it plotted the previous points in these graphs, and draws a line
 * between the previous and the current points.
 * if given step=0 and err=0.0, it initialize its memory.
 */

plot_error( G, n, step, err, marker )
GRAPH	*G;
int	n;
int	step ;
NUMBER	err;
char    marker;
{
  static	NUMBER	err_save = 0;
  static	int	step_save = 0;
  static	int	count = 0;
  if( step == 0 && err == 0.0 ) return( OK );
  if( G == NULL ) { Erreturn( "graph not initialized"); }
  if( step_save < step && count ) {
    IfErr( draw_line_in_graph( G,(float) step_save, err_save,
			      (NUMBER) step, err ) )
      Erreturn1("%s: error in plotting in graph", ERR_MSG);

    if( marker ) {
      set_marker( marker );
      draw_marker_in_graph( G,(NUMBER) step, err );
    }
  }

  count++ ;

  step_save = step ;
  err_save = err ;
    
  return( OK );
}

