/* $Header: /soma/users/miyata/planet/src/RCS/arith.h,v 5.6.0.4 91/02/13 15:42:28 miyata Exp $ */
#define SpecialFunc 0x1	/* ascii for ^A */
#define is_operation(c) (c=='+'||c=='-'||c=='*'||c=='/'||c=='|'||c=='&'|| \
			 c=='^'||c==')'||c=='(')

/** xx_expression() constructs different types of expression - **
 ** called in expr.y */

EXPRESS *op_expression(), *func_expression(), *terminal_expression();
EXPRESS *randomfunc_expression(), *multi_expression(), *column_expression();
EXPRESS *range_expression(), *range2_expression(), *constant_expression();
EXPRESS *assignment_expression();
EXPRESS *find_expression(), *find_variable_expression();
EXPRESS *find_optimize_expression();

/** eval_xx_expression() evaluates an expression tree recursively **/
/** ex->evalfunc **/

VECTOR *eval_expression(),*eval_op_expression(),*eval_func_expression();
VECTOR *eval_terminal_expression(),*eval_multi_expression(),*eval_column_expression();
VECTOR *eval_range_expression(), *eval_range2_expression();
VECTOR *eval_assign_expression(), *eval_increment_expression();
VECTOR *eval_decrement_expression(), *eval_multiply_expression();
VECTOR *eval_divide_expression();

/* Expression Types */
#define Constant 50
#define Terminal 51
#define UnaryFunc 52
#define UnaryRandomFunc 54
#define BinaryOp 55
#define RangeOp 56
#define MultiOp 57
#define ColumnOp 58
#define Assign 59

typedef struct {
  char *name;
  int  (*func)();
} VECTORFUNC;

#define MaxVectorFunction 128
#define MaxRandomFunction 8

extern int add_vector(), minus_vector(), times_vector(), divide_vector();
extern int power_vector();
extern int and_vector(), or_vector(),logic_and_vector(),logic_or_vector();
extern int range_vector();
extern int equal_vector(), nequal_vector(), gt_vector(), geq_vector();
extern int lt_vector(), leq_vector();

#ifndef min
#define min(x,y) ((x)<(y)? (x):(y))
#endif

#define EQ '0'
#define NEQ '1'
#define GT '2'
#define LT '3'
#define GEQ '4'
#define LEQ '5'
#define LAND '6'
#define LOR '7'
