/* $Header: /soma/users/miyata/planet/src/RCS/alloc.c,v 5.6.0.4 91/02/13 15:41:06 miyata Exp $ */
static char rcsid[] = "$Header: /soma/users/miyata/planet/src/RCS/alloc.c,v 5.6.0.4 91/02/13 15:41:06 miyata Exp $";
#include <stdio.h>
#include "alloc.h"
#include "error.h"
void free_2d_array(); void free_3d_array();

/* allocates space for a N1 * N2 * N3 array of specified element size.
	returns the pointer (char*) - type must be casted by the caller */

char ***
calloc_3d ( N1, N2, N3, size )
unsigned N1, N2, N3, size;
{
register int i,j;
char	***ptr = (char***) calloc ( N1, sizeof(char*) );
	if( ptr==NULL )  return( NULL );

	for( i=0; i< N1 ; i++ ) {
	    if(NULL==(ptr[i]= (char**) calloc ( N2, sizeof(char*) ))) 
	    	return( NULL );
	    for( j=0; j< N2; j++)
	    	if(NULL==(ptr[i][j]= calloc ( N3, size ))) 
	    		return( NULL );
	}
	return ( ptr );
}

/* change size of 2d array pointed by "array" from N1xN2 to M1xM2. */
/* contents are undisturbed up to the lesser of N1/M1 and N2/M2 */

char **
realloc_2d ( array, N1, N2, M1, M2, size )
char	**array;
unsigned N1,N2, M1, M2;
unsigned size; 				/* size of one element */
{
  char	**ptr;
  register int i,j;
  int nbyte = size * (N2>M2? N2: M2);
  if(NULL==(ptr = (char**) calloc_2d ( M1, M2, size )))
    return( NULL );
  for( i=0; i < N1 && i < M1 ; i++ ) bcopy(array[i],ptr[i], nbyte);
  free_2d_array ( array, N1 );

  return( ptr );

	/*
	if(NULL==(ptr=(char**)realloc(array, (unsigned) M1 * sizeof(char*))))
		return( NULL );
	if( M1 <= N1 )
	    for( i=0; i < M1; i++ ) 
		if( NULL==(ptr[i]=realloc ( ptr[i] , (unsigned) M2 * size )) )
			return( NULL );
	else {
	    for( i=0; i < N1; i++ )
		if( NULL==(ptr[i]=realloc ( ptr[i] , (unsigned) M2 * size )) )
			return( NULL );
	    for( i=N1; i<M1; i++ )
		if( NULL==(ptr[i]= malloc ( (unsigned) M2 * size )) )
			return( NULL );
	}
	*/
}

/* frees a 2d array.  N is range of 1st index */
 	
void free_2d_array ( array, N )
char	**array;
int	N;
{
  register int i;
  for( i=0; i< N ; i++ ) free ( array[i] );
  free ( (char*) array );
}

/* frees a 3d array.  N1/N2 are ranges of 1st/2nd index */
 	
void free_3d_array ( array, N1, N2 )
char	***array;
int	N1, N2;
{
register int i;
	for( i=0; i< N1 ; i++ ) free_2d_array ( array[i], N2 );
	free ( (char*) array );
}

/* allocates space for a N1 * N2 array of specified element size.
	returns the pointer (char*) - type must be casted by the caller */

char **
calloc_2d ( N1, N2, size )
unsigned N1, N2, size;
{
  register int i;
  char	**ptr = (char**) calloc ( N1, sizeof(char*) );
  if( ptr==NULL )  return( NULL );

  for( i=0; i< N1 ; i++ ) 
    if(NULL==(ptr[i]= calloc ( N2, size ))) return( NULL );
  return ( ptr );
}

char *
new_string( string, buf )
     char   *string, *buf;
{
  if( buf == NULL || strlen(string) > strlen(buf) ) {
    if(buf) free(buf);
    IfErr( buf = new_array_of( strlen(string)+1, char ) ) return( ERR );
  }
  strcpy( buf, string );
  return( buf );
}

char *
change_array_size( array, N1, N2, size )
     char *array;
     int  N1, N2;
     unsigned size;
{
  char *ptr;
  register int i;
  IfErr( ptr = calloc( (unsigned) N2, size  ) ) return( ERR );
  N1 *= size; N2 *= size;
  for( i=0; i < N1 && i < N2 ; i++ ) ptr[i] = array[i];
  free( array );
  return( ptr );
}

