/* $Header: /soma/users/miyata/planet/src/RCS/Solar.c,v 5.6.0.4 91/02/13 15:42:22 miyata Exp $ */
static char rcsid[] = "$Header: /soma/users/miyata/planet/src/RCS/Solar.c,v 5.6.0.4 91/02/13 15:42:22 miyata Exp $";
#include <stdio.h>
#include <signal.h>
#include <sgtty.h>
#include <usercore.h>
#include "suncorefunc.h"
#include "error.h"

#define ESC ''
#define ESC2 '!'

void	*onintr();
int Verbose = 0;
int NoInterrupt = 0;

#define BUFSIZE 1024
char BUF[BUFSIZE];
char junk[BUFSIZE];

main( argc, argv )
int argc; char *argv[];
{
  FILE *fp;
  if( argc > 1 ) {
    sprintf( junk, "/usr/ucb/rlogin %s", argv[1] );
    IfErr( fp = popen( junk, "r" ) ) {
      fprintf( "cannot connect to %s", argv[1] );
      exit( 1 );
    }
  }
  else fp = stdin;
  signal( SIGINT, onintr );
/*
  signal( SIGURG, onurg );
  signal( SIGPIPE, onpipe );*/
  service( fp );
}

service( InStream )
FILE *InStream;
{
  char ch, *buf;
  ioctl( 0, TIOCCBRK, 0 );	/* cbreak mode */
  while( 1 ) {
    bzero(BUF, sizeof(BUF) );
    if( (ch = getc(InStream))== EOF) exit(0);
    if( ch == ESC ) {
      if( (ch = getc(InStream)) != ESC2 ) {
	putchar( ESC ); putchar( ch );
	continue;
      }
      buf = BUF;
      while( (*(buf++) = getc(InStream)) != '\n' );
      *(--buf) = NULL;
      exec_func(BUF);
    }
    else putchar(ch);
  }
}
#define Largs 64
float x[128],y[128], AtoF();

exec_func( str )
char *str;
{
  int register i,j;
  int func, an; char as[20][Largs], *s1, *index();
  int k, n[20];

  an = sscanf(str, "%d%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s", &func,
	 as[0],as[1],as[2],as[3],as[4],as[5],as[6],as[7],as[8],as[9],
	 as[10],as[11],as[12],as[13],as[14],as[15],as[16],as[17],as[18],as[19])
    -1;
  NoInterrupt = 1;
  switch(func) {
  case INITIALIZE:
    initialize_display(AtoF(as[0]),AtoF(as[1]),AtoF(as[2]),
		       AtoF(as[3]),AtoF(as[4]),AtoF(as[5]));
    signal( SIGINT, onintr );	/* initialize_display turns signal off */
    break;
  case CREATE_RETAINED_SEGMENT:
    create_retained_segment(atoi(as[0])); break;
  case CLOSE_RETAINED_SEGMENT:
    close_retained_segment(atoi(as[0])); break;
  case CREATE_TEMPORARY_SEGMENT:
    create_temporary_segment(); break;
  case CLOSE_TEMPORARY_SEGMENT:
    close_temporary_segment(); break;
  case DELETE_RETAINED_SEGMENT:
    delete_retained_segment(atoi(as[0])); break;
  case DELETE_ALL_RETAINED_SEGMENTS: 
    delete_all_retained_segments(); break;
  case WIPE_ALL_SEGMENTS:
    wipe_all_segments(atoi(as[0])); break;
  case GET_MOUSE_STATE:
    get_mouse_state(atoi(as[0]),atoi(as[1]),&x[0],&x[1],&k);
/*    *BUF = NULL; Putfloat(x[0]); Putfloat(x[1]); Putint(k); Send();*/
    break;
  case MARKER_ABS_2:
    marker_abs_2(AtoF(as[0]),AtoF(as[1])); break;
  case MOVE_ABS_2:
    move_abs_2(AtoF(as[0]),AtoF(as[1])); break;
  case MOVE_REL_2:
    move_rel_2(AtoF(as[0]),AtoF(as[1])); break;
  case LINE_ABS_2:
    line_abs_2(AtoF(as[0]),AtoF(as[1])); break;
  case LINE_REL_2:
    line_rel_2(AtoF(as[0]),AtoF(as[1])); break;
  case NEW_FRAME:
    new_frame(); break;
  case POLYGON_REL_2:
    k = atoi(as[j=0]);
    for(i=0; i<k; i++) x[i] = AtoF(as[++j]);
    for(i=0; i<k; i++) y[i] = AtoF(as[++j]);
    polygon_rel_2(x,y,k);
    break;
  case POLYLINE_REL_2:
    k = atoi(as[j=0]);
    for(i=0; i<k; i++) x[i] = AtoF(as[++j]);
    for(i=0; i<k; i++) y[i] = AtoF(as[++j]);
    polyline_rel_2(x,y,k) ;
    break;
  case POLYGON_ABS_2:
    k = atoi(as[j=0]);
    for(i=0; i<k; i++) x[i] = AtoF(as[++j]);
    for(i=0; i<k; i++) y[i] = AtoF(as[++j]);
    polygon_abs_2(x,y,k);
    break;
  case POLYLINE_ABS_2:
    k = atoi(as[j=0]);
    for(i=0; i<k; i++) x[i] = AtoF(as[++j]);
    for(i=0; i<k; i++) y[i] = AtoF(as[++j]);
    polyline_abs_2(x,y,k) ;
    break;
  case SET_CHARPATH_2:
    set_charpath_2(AtoF(as[0]),AtoF(as[1])); break;
  case SET_CHARUP_2:
    set_charup_2(AtoF(as[0]),AtoF(as[1])); break;
  case SET_DRAG:
    set_drag(atoi(as[0])); break;
  case SET_FONT:
    set_font(atoi(as[0])); break; 
  case SET_LINEWIDTH:
    set_linewidth(AtoF(as[0]) ); break;
  case SET_LINESTYLE:
    set_linestyle(atoi(as[0])) ; break;
  case SET_CHARPRECISION:
    set_charprecision(atoi(as[0])) ; break;
  case SET_CHARSIZE:
    set_charsize(AtoF(as[0]),AtoF(as[1]) ); break;
  case SET_FILL_INDEX:
    set_fill_index(atoi(as[0])) ; break;
  case SET_TEXT_INDEX:
    set_text_index(atoi(as[0])) ; break;
  case SET_LINE_INDEX:
    set_line_index(atoi(as[0])) ; break;
  case SET_MARKER_SYMBOL:
    set_marker_symbol(atoi(as[0])) ;break;
  case SET_OUTPUT_CLIPPING:
    set_output_clipping(atoi(as[0])) ; break;
  case SET_WINDOW_CLIPPING:
    set_window_clipping(atoi(as[0])) ; break;
  case SET_SEGMENT_VISIBILITY:
    set_segment_visibility(atoi(as[0]),atoi(as[1])); break;
  case SET_IMAGE_TRANSFORMATION_TYPE:
    set_image_transformation_type(atoi(as[0])); break;
  case SET_SEGMENT_IMAGE_TRANSFORMATION_2:
    set_segment_image_transformation_2(atoi(as[0]),AtoF(as[1]),AtoF(as[2]),
				       AtoF(as[3]),AtoF(as[4]),AtoF(as[5]));
    break;
  case TEXT:
    if(s1 = index(str, '\n')) *s1 = NULL; /* can't display a newline */
    *(str + strlen( str ) - 1) = NULL;	/* get rid of strange character -fix*/
    if(s1 = index(str, ' ')) text( s1+1 ); 
    break;
  case RSH:
    if(s1 = index(str, '\n')) *s1 = NULL; /* can't display a newline */
    *(str + strlen( str ) - 1) = NULL;	/* get rid of strange character -fix*/
    if(s1 = index(str, ' ')) {
      sprintf( junk, "csh -c '%s'", s1+1 );
      system( junk );
    }
    break;
  case INQUIRE_TEXT_EXTENT_2:
    inquire_text_extent_2(as[0],&x[0],&x[1]);
    break;
  case FILL_BOX:
    fill_box( AtoF(as[0]),AtoF(as[1]),AtoF(as[2]),AtoF(as[3]),atoi(as[4]));
    break;
  case SET_BACKGROUND_COLOR:
    set_background_color(atoi(as[0]));
    break;
  case CHANGE_COLOR_MAP:
    change_color_map(atoi(as[0]), as[1]);
    break;
#if 0		/* movie functions - not implemented yet */
  case TAKE_FRAME:
    take_frame(atoi(as[0]),AtoF(as[1]),AtoF(as[2]),AtoF(as[3]),AtoF(as[4]));
    break;
  case READ_FRAME:
    read_frame( as[0] );
    break;
  case SAVE_FRAME:
    save_frame( as[0] );
    break;
  case SHOW_FRAME:
    show_frame( atoi(as[0]),AtoF(as[1]),AtoF(as[2]),atoi(as[3])); break;
#endif 0
/*
  case INQUIRE_RETAINED_SEGMENT_NAMES:
  inquire_retained_segment_names(seg,seg_array,np);
*/
  }
  NoInterrupt = 0;
}

float AtoF(str)
char *str;
{
  float x;
  sscanf(str, "%f", &x);
  return(x);
}

void *onintr()
{
  char buf[BUFSIZE];
  if( NoInterrupt ) {
    printf("cannot interrupt now. try again.");
  }
  else while( 1 ) {
    printf("Solar: ");
    gets(buf);
    if( !strcmp(buf, "quiet") ) Verbose = 0;
    else if( !strcmp(buf, "debug") ) Verbose = 1;
    else if( !strcmp(buf, "quit") ) {
      terminate_display();
      exit(0);
    }
    else if( !strcmp(buf, "cont") ) break;
    else if( !strcmp(buf, "help") ) printf("quiet/debug/cont/quit\n");
  }
}
