# n.plot: routines for plotting 2-d slice of error surface of a network.

#    ######################################################
#    ##### Instructions For Plotting An Error Surface #####
#    ######################################################

# (1) In SunNet, read in your network and pattern files, and then
#     read in this file with:
#
#	network + n.plot
#
# (2) Open plots for displaying the error surfaces, for example:
#	plot 2x3	(to open 6 plots arranged in a 2 by 3 matrix)
#
# (3) Compute the error surface:
#	exec sweep(weightX,weightY)
#
#     where weightX and weightY are the two weights to be varied, for
#     example "exec sweep(InputHidden[0][1],HiddenOutput[1][2])".
#     The procedure 'sweep' computes the error as a function of
#     these two weights while fixing all the other weights constant.
#     This generates the error surface in 3-d.
#
# (4) Display the error surface by:
#	plot N new	(N is the plot number in which to display)
#
#      This plots the error surface.  The mark '+' indicates where the
#      center of the weight space [0,0] is, and '@' shows the current values
#      of the weights on the surface.
#
#  The above steps would generate an error surface display with a set of
#  default settings.  These settings can be changed as follows.
# 
#  ######  [1] Changing The Weight Ranges  ########
#
#     The ranges of the weights for the error surface computation by 'sweep'
#     can be changed.  By default, each weight is varied between -10 and 10.
#     To change the ranges do, for example:
#
#	exec rangeX(-5,5)	# to change range for X weight.
#	exec rangeY(20,0)	# to change range for Y weight.
#	exec sweep(weightX,weightY)
#	plot N new
#
#  ######  [2] Changing The Perspective ###########
#
#     The perspective of the plot can be changed.
#     The default perspective is with viewing angles 30 degrees
#     vertical and -10 degrees horizontal (ie. 10 degree to the
#     left) and viewing distance 2 (that is, 2 times the length of 
#     the X and Y axes, measured from the center of the edge). 
#     For example:
#
#	exec rotate(-20,10)
#
#     will rotate the current view such that the viewing angles are -20
#     degrees horizontal and 10 degrees vertical.
#
#     To change the distance do, for example:
#
#	exec distance(3)
#
#  #######  [3]  Changing The Scale #######
#
#     The error surface can be scaled differently.  By
#     default, the height of the error surface is scaled so that it can be
#     displayed within the plot if all errors are smaller than 1.0.  To
#     change this do, for example (scale the surface by 5):
#
#	exec scale(5)
#
#  #######  [4] Zooming in ########
#
#     Finally, you might want to look closely into finer details of
#     the error surface.  This can be done by zooming into a portion of the
#     computed surface.  Do:
#
#	exec zoom(2)
#
#     This zooms with x2 into the center portion.  To change where to focus, 
#     do "exec focus(x,y)" where x and y (each between 0 and 1)
#     specify the focal point within the plot.
#     For example, the following will zoom in to the lower left quarter:
#
#	exec focus(0.25,0.25)
#
#     To get the original surface back do:
#
#	exec unzoom
#

####  Start of n.plot  #######
define testProcedure activate    # change 'activate' to the name of a 
				 # procedure you use to compute the error.
				 # it should use 'target' to compute the error,
				 # or set the variable $Error to the error.
define errorMeasure $globalError # error measure (average error across patterns)

scalar xstart -10.0; scalar xend 10
scalar ystart -10.0; scalar yend 10   # default weight ranges

procedure rangeX expr x1 expr x2	# change X range
    xstart = x1; xend = x2
end

procedure rangeY expr y1 expr y2	# change Y range
    ystart = y1; yend = y2
end

define Nx 21; define Ny 21

matrix error Nx Ny		# error surface
scalar err0; scalar errC	  # errors with wts [0,0] and with current wts
scalar wXsave; scalar wYsave	# to save current wts values

scalar nX; scalar nY
scalar incX 1; scalar incY 1

matrix Y2d Nx Ny; matrix X2d Nx Ny	# projected 2d base 
scalar X2dC ; scalar Y2dC
scalar X2d0 ; scalar Y2d0
				# compute error surface by varing 2 weights
procedure sweep expr weightX expr weightY
    				# save current weight values
    wXsave = weightX; wYsave = weightY
    
    incX = (xend - xstart)/(Nx-1)
    incY = (yend - ystart)/(Ny-1)
    weightX = xstart
    nX = 0
    while nX<Nx
	weightY = ystart
	nY = 0
	while nY<Ny
	    present all testProcedure -quiet -print
	    error[nX][nY] = errorMeasure	# error for these weights
	    nY = nY+1
	    weightY = weightY + incY	# change y weight
	endwhile
	nX = nX+1
	weightX = weightX + incX	# change x weight
    endwhile
			# compute the error at the Origin of weight space
    weightX = 0; weightY = 0		# set weights to 0,0
    present all testProcedure -quiet -print
    err0 = errorMeasure

    			# restore back the current weight values
    weightX = wXsave; weightY = wYsave
    			# compute error with current weights.
    present all testProcedure -quiet -print
    errC = errorMeasure

		# base for the center of weight space
    X2d0 = (-xstart)/(xend-xstart)
    Y2d0 = (-ystart)/(yend-ystart)
		# base for the current error
    X2dC = (weightX-xstart)/(xend-xstart)
    Y2dC = (weightY-ystart)/(yend-ystart)
end

scalar xCent ;scalar yCent
scalar xCur; scalar yCur

define PI 3.141592654
scalar radian
scalar hangle -10; scalar vangle 30
scalar Xoff; scalar D 2.0; scalar H
scalar scale 1.0

procedure rotate expr horiz_rotate expr vert_rotate
    hangle = horiz_rotate; vangle = vert_rotate
    call view
    command plot = new
end

procedure scale expr x
    scale = x
    command plot = new
end

procedure view		# compute the perspective with given angles.
		# compute Xoff and H from the angles
    radian = vangle * PI / 180
    Xoff = 0.5+D * cos( radian ) * sin( hangle * PI / 180 )
    H = D * sin( radian )
end
		
scalar xfocus 0.5;scalar yfocus 0.5;scalar zoom 2

procedure zoom expr zoomValue	 	# zoom plot
    zoom = zoomValue
    call makeZoom
    command plot = new
end

procedure unzoom
    call makeUnzoom
    command plot = new
end

procedure focus expr x expr y
    xfocus = x; yfocus = y
    call makeZoom
    command plot = new
end

procedure makeUnzoom
    plotlist - all; plotlist + 1-3
end
    
procedure makeZoom
    plotlist - all; plotlist + 4-6
end
		# plot the error surface
define xErr (Y2d*Xoff+X2d*D)/(Y2d+D) 
define yErr (Y2d*H+scale*error*D)/(Y2d+D) 
		# plot the origin of weight space
define xCent (Y2d0*Xoff+X2d0*D)/(Y2d0+D)
define yCent (Y2d0*H+scale*err0*D)/(Y2d0+D)
		# plot the current weight values
define xCur (Y2dC*Xoff+X2dC*D)/(Y2dC+D)
define yCur (Y2dC*H+scale*errC*D)/(Y2dC+D)

procedure make2d		# compute the base plane
    nX = 0
    while nX<Nx
	X2d[nX] = nX/(Nx-1)
	nY = 0
	while nY<Ny
	    Y2d[nX][nY] = nY/(Ny-1)
	    nY = nY+1
	endwhile
	nX = nX+1
    endwhile
end

plotlist clear
plotlist xErr yErr line
plotlist xCent yCent +
plotlist xCur yCur @
plotlist bound01((xErr-xfocus)*zoom+.5) bound01((yErr-yfocus)*zoom+.5) line
plotlist bound01((xCent-xfocus)*zoom+.5) bound01((yCent-yfocus)*zoom+.5) +
plotlist bound01((xCur-xfocus)*zoom+.5) bound01((yCur-yfocus)*zoom+.5) @

exec make2d makeUnzoom view

