
perceptron.test_function(predictor.matrix,response.vector,ptrn)
{
	if(!is.matrix(predictor.matrix))
	{
		stop(" Test data not in matrix format ")
	}
	if(!is.matrix(response.vector))
	{
		stop(" Response data not in matrix format ")
	}
	if(!is.list(ptrn))
	{
		stop(" Net structure data not in list format ")
	}
	tst.vector.nrow_nrow(predictor.matrix)
	tst.vector.ncol_ncol(predictor.matrix)

	tst.adj.class_matrix(response.vector,tst.vector.nrow,1)
	tst.guessed.class_matrix(0,nrow=nrow(response.vector),1)
	minclass_min(tst.adj.class)
	maxclass_max(tst.adj.class)

	tst.adj.class_tst.adj.class-minclass
	tst.vector_matrix(t(predictor.matrix),1)

	inlayer_matrix(0,ptrn$number.input.nodes+1,1)

#
	pnn_.C("perceptron_test",
	as.single(tst.vector),
	as.single(inlayer),
	as.single(ptrn$weights),
	as.integer(tst.adj.class),
	tst.guessed.class=as.integer(tst.guessed.class),
	as.integer(tst.vector.nrow),
	as.integer(ptrn$number.input.nodes),
	as.integer(ptrn$number.output.nodes))

	list( tst.adj.class=tst.adj.class,
		tst.guessed.class=pnn$tst.guessed.class,
		tst.vector.nrow=tst.vector.nrow)
}


perceptron.train_function(predictor.matrix,
response.vector,
number.hidden.nodes,
acceptable.error.rate=.02,
learning.rate=.3,
max.epochs=10000)
{
	if(!is.matrix(predictor.matrix))
	{
		stop(" Training data not in matrix format ")
	}
	if(!is.matrix(response.vector))
	{
		stop(" class vector not in matrix format ")
	}
if(acceptable.error.rate <= 0.0)
	{
		print("Acceptable.error.rate must be ")
		print("between 0 and 1")
		stop()
	}
	
if(acceptable.error.rate >= 1.0)
	{
		print("Acceptable.error.rate must be ")
		print("between 0 and 1")
		stop()
	}
	
	trn.vector.nrow_nrow(predictor.matrix)
	trn.vector.ncol_ncol(predictor.matrix)

	number.input.nodes_trn.vector.ncol
	trn.adj.class_response.vector
	trn.guessed.class_matrix(0,nrow=nrow(response.vector),1)

	minclass_min(trn.adj.class)
	maxclass_max(trn.adj.class)
	number.output.nodes_maxclass-minclass+1
	trn.adj.class_trn.adj.class-minclass

	trn.vector_matrix(t(predictor.matrix),1)

#	now get the weight vector sizes



	inlayer_matrix(0,number.input.nodes,1)

	num.weight.cells_(number.input.nodes+1)*number.output.nodes

	weights_matrix(runif(num.weight.cells),num.weight.cells,1)
	weights_weights-.5
#print(weights)

	number.epochs_0

	pnn_.C("perceptron_train",
	trn.vector=as.single(trn.vector),
	as.single(inlayer),
	weights=as.single(weights),
	as.single(acceptable.error.rate),
	as.single(learning.rate),
	as.integer(trn.adj.class),
	trn.guessed.class=as.integer(trn.guessed.class),
	as.integer(number.input.nodes),
	as.integer(number.output.nodes),
	as.integer(trn.vector.nrow),
	as.integer(max.epochs),
	number.epochs=as.integer(number.epochs))


	list(	trn.adj.class=trn.adj.class,
		trn.guessed.class=pnn$trn.guessed.class,
		number.input.nodes=number.input.nodes,
		number.output.nodes=number.output.nodes,
		weights=pnn$weights,
		acceptable.error.rate=acceptable.error.rate,
		learning.rate=learning.rate,
		number.epochs=pnn$number.epochs)
}

