
bptest_function(predictor.matrix,response.vector,ann)
{
	if(!is.matrix(predictor.matrix))
	{
		stop(" Test data not in matrix format ")
	}
	if(!is.matrix(response.vector))
	{
		stop(" Response data not in matrix format ")
	}
	if(!is.list(ann))
	{
		stop(" Net structure data not in list format ")
	}
	tst.vector.nrow_nrow(predictor.matrix)
	tst.vector.ncol_ncol(predictor.matrix)

	tst.adj.class_matrix(response.vector,tst.vector.nrow,1)
	tst.guessed.class_matrix(0,nrow=nrow(response.vector),1)
	minclass_min(tst.adj.class)
	maxclass_max(tst.adj.class)

	tst.adj.class_tst.adj.class-minclass
	tst.vector_matrix(t(predictor.matrix),1)

inlayer_matrix(0,ann$number.input.nodes+1,1)
hidlayer_matrix(0,ann$number.hidden.nodes,1)
outlayer_matrix(0,ann$number.output.nodes,1)
desired_matrix(0,ann$number.output.nodes,1)

#
	nn_.C("bptest",
	as.single(tst.vector),
	as.single(ann$inhidwgt.vector),
	as.single(ann$hidoutwgt.vector),
	as.single(inlayer),
	as.single(hidlayer),
	as.single(outlayer),
	as.single(desired),
	as.integer(tst.adj.class),
	tst.guessed.class=as.integer(tst.guessed.class),
	as.integer(tst.vector.nrow),
	as.integer(ann$number.input.nodes),
	as.integer(ann$number.hidden.nodes),
	as.integer(ann$number.output.nodes))

	list( tst.adj.class=tst.adj.class,
		tst.guessed.class=nn$tst.guessed.class,
		tst.vector.nrow=tst.vector.nrow)
}


bptrain_function(predictor.matrix,
response.vector,
number.hidden.nodes,
acceptable.error.rate=.02,
learning.rate=.3,
momentum.term=.7,
max.epochs=10000)
{
	if(!is.matrix(predictor.matrix))
	{
		stop(" Training data not in matrix format ")
	}
	if(!is.matrix(response.vector))
	{
		stop(" class vector not in matrix format ")
	}
if(acceptable.error.rate <= 0.0)
	{
		print("Acceptable.error.rate must be ")
		print("between 0 and 1")
		stop()
	}
	
if(acceptable.error.rate >= 1.0)
	{
		print("Acceptable.error.rate must be ")
		print("between 0 and 1")
		stop()
	}
	
	trn.vector.nrow_nrow(predictor.matrix)
	trn.vector.ncol_ncol(predictor.matrix)

	number.input.nodes_trn.vector.ncol
if(missing(number.hidden.nodes)) number.hidden.nodes_trn.vector.ncol

	trn.adj.class_response.vector
	trn.guessed.class_matrix(0,nrow=nrow(response.vector),1)

	minclass_min(trn.adj.class)
	maxclass_max(trn.adj.class)
	number.output.nodes_maxclass-minclass+1

	trn.adj.class_trn.adj.class-minclass

	trn.vector_matrix(t(predictor.matrix),1)

#	now get the weight vector sizes


#print(c("number input nodes: ",number.input.nodes))
#print(c("number hidden nodes: ",number.hidden.nodes))
#print(c("number output nodes: ",number.output.nodes))

inhidcells _ (trn.vector.ncol+1)*number.hidden.nodes
hidoutcells_ number.hidden.nodes*number.output.nodes
inhidwgt.vector_matrix(runif(inhidcells),inhidcells,1)
hidoutwgt.vector_matrix(runif(hidoutcells),hidoutcells,1);
inhidwgt.vector_inhidwgt.vector - .5
hidoutwgt.vector_hidoutwgt.vector - .5

oldinhidwgt.vector_matrix(0,inhidcells,1)
oldhidoutwgt.vector_matrix(0,hidoutcells,1);

inlayer_matrix(0,number.input.nodes+1,1)
hidlayer_matrix(0,number.hidden.nodes,1)
outlayer_matrix(0,number.output.nodes,1)
indelta_matrix(0,number.input.nodes+1,1)
hiddelta_matrix(0,number.hidden.nodes,1)
outdelta_matrix(0,number.output.nodes,1)
desired_matrix(0,number.output.nodes,1)


number.epochs_0

	nn_.C("bptrain",
	trn.vector=as.single(trn.vector),
	inhidwgt.vector=as.single(inhidwgt.vector),
	hidoutwgt.vector=as.single(hidoutwgt.vector),
	as.single(oldinhidwgt.vector),
	as.single(oldhidoutwgt.vector),
	as.single(inlayer),
	as.single(hidlayer),
	as.single(outlayer),
	as.single(indelta),
	as.single(hiddelta),
	as.single(outdelta),
	as.single(desired),
	as.single(acceptable.error.rate),
	as.single(learning.rate),
	as.single(momentum.term),
	as.integer(trn.adj.class),
	trn.guessed.class=as.integer(trn.guessed.class),
	as.integer(number.input.nodes),
	as.integer(number.hidden.nodes),
	as.integer(number.output.nodes),
	as.integer(trn.vector.nrow),
	as.integer(max.epochs),
	number.epochs=as.integer(number.epochs))


	list(	trn.adj.class=trn.adj.class,
		trn.guessed.class=nn$trn.guessed.class,
		number.input.nodes=number.input.nodes,
		number.hidden.nodes=number.hidden.nodes,
		number.output.nodes=number.output.nodes,
		acceptable.error.rate=acceptable.error.rate,
		learning.rate=learning.rate,
		momentum.term=momentum.term,
		max.epochs=max.epochs,
		inhidwgt.vector=nn$inhidwgt.vector,
		hidoutwgt.vector= nn$hidoutwgt.vector,
		number.epochs=nn$number.epochs)
}

