/* NOTE TO MYSELF SWZEEPING THROUGH RECTANGULAR MATRIX MUST
   BE CAREFULL HOW TO INCREMENT PTR */

#include <stdio.h>
#include <math.h>

bptrain(wrkvector,
	inhidwgt,
	hidoutwgt,
	oldinhidwgt,
	oldhidoutwgt,
	inlayer,
	hidlayer,
	outlayer,
	indelta,
	hiddelta,
	outdelta,
	desired,
	acceptable_error_rate,
	learning_rate,
	momentum_term,
	adjclass,
	guessed_class,
	number_input_nodes,
	number_hidden_nodes,
	number_output_nodes,
	wrk_vector_nrow,
	max_epochs,
	number_epochs)



float	wrkvector[];
float	*acceptable_error_rate,
	*learning_rate,
	*momentum_term;
float	inhidwgt[];
float	hidoutwgt[];
float	oldinhidwgt[];
float	oldhidoutwgt[];
float	inlayer[],hidlayer[],outlayer[];
float	desired[];

long	adjclass[];
long	guessed_class[];
long	*number_input_nodes,
	*number_hidden_nodes,
	*number_output_nodes;
long	*max_epochs;
long	*number_epochs;
long	*wrk_vector_nrow;
{
/********************train ****************************/   
register int ido,i,j,wrk_vector_offset;                     
int hidout_offset,inhidwgt_offset;
float	total,error_rate,old_err_rate;
int	number_missclassified;
int	prop();
int	my_epochs;
hidlayer[*number_hidden_nodes] = 1.0;


error_rate=1.0;
old_err_rate = 2.0;
my_epochs = 0;
while ((error_rate > *acceptable_error_rate && my_epochs < *max_epochs))
{
number_missclassified = 0.0;              
total = 0.0;

wrk_vector_offset = 0;
for(ido=0;ido<*wrk_vector_nrow;ido++)
{                         
        	for(i=0;i<*number_input_nodes;i++)
		{
			inlayer[i] = *(wrkvector+wrk_vector_offset);
			wrk_vector_offset++;
		}
        	inlayer[*number_input_nodes] = 1.0;
        	for(i=0;i<*number_output_nodes;i++)
                {
               	 	desired[i] = 0.00;
                	if(i==adjclass[ido]) desired[i] = 1.0;
                }
                total++;                             
		guessed_class[ido] = prop( number_input_nodes,
			number_hidden_nodes,
			number_output_nodes,
			inhidwgt,hidoutwgt,
			inlayer,hidlayer,outlayer);

		if(guessed_class[ido]==-1) return;
                if(adjclass[ido] != guessed_class[ido])
		{
		 number_missclassified++;

		}
                bprop(learning_rate,momentum_term,
		number_input_nodes,
		number_hidden_nodes,
		number_output_nodes,
			inhidwgt,hidoutwgt,
			oldinhidwgt,oldhidoutwgt,
			inlayer,hidlayer,outlayer,
			indelta,hiddelta,outdelta,
			desired);
}       /* end of ido loop */

        error_rate = number_missclassified/total;
  	if(error_rate < old_err_rate) 
	{
	old_err_rate = error_rate;
	}
	my_epochs++;

	if((my_epochs % 10)==0)
	{ 
		/* printf(" error rate: %10.4f num epochs %6ld \n",
		error_rate,my_epochs); */
	} /* end of if on number_epochs */
} /* end of while */

*number_epochs = my_epochs;

/* end of train */
}

int prop( number_input_nodes,
	number_hidden_nodes,
	number_output_nodes,
	inhidwgt,hidoutwgt,
	inlayer, hidlayer, outlayer)

long 	*number_input_nodes,
	*number_hidden_nodes,
	*number_output_nodes;
float	inhidwgt[];
float	hidoutwgt[];
float	inlayer[],hidlayer[],outlayer[];
{
        register int i,j,inhidwgt_offset,hidout_offset;
	float maxval;
	long guess;
	inhidwgt_offset = 0;
        for(j=0;j<*number_hidden_nodes;j++) hidlayer[j]=0.0;		
        for(i=0;i<=*number_input_nodes;i++)
                {
        	for(j=0;j<*number_hidden_nodes;j++)
                {     
			hidlayer[j]+=		
                     	*(inhidwgt+inhidwgt_offset)*inlayer[i];
			inhidwgt_offset++;
                }
                }/* end of loop on i */ 
        
	for(j=0;j<*number_hidden_nodes;j++)
              hidlayer[j]=1.0/(1.0+exp(-hidlayer[j]));


	hidout_offset = 0;
	 for(i=0;i<*number_output_nodes;i++)
         		outlayer[i]= 0.0;
         for(j=0;j<*number_hidden_nodes;j++)
         {
	 	for(i=0;i<*number_output_nodes;i++)
                { 
         		outlayer[i]+= *(hidoutwgt+hidout_offset)
				*hidlayer[j];
			hidout_offset++;
                }
	} /* end of loop on j */


        guess = -1;
        maxval = -99.0;
	for(i=0;i<*number_output_nodes;i++)
	{
                outlayer[i]=1.0/(1.0+exp(-outlayer[i]));
		/* get the guessed class for scoring */
                if(outlayer[i] > maxval)
                {
                maxval = outlayer[i];
                guess = i;
                }
         }/* end of i loop */ 
	if(guess == -1)
	{
		printf(" guessed class = -1 in prop \n");
		printf(" returning \n");
		return(guess);
	}
	return(guess);
}/* return from prop */


bprop(learning_rate,momentum_term,
	number_input_nodes,
	number_hidden_nodes,
	number_output_nodes,
	inhidwgt,hidoutwgt,
	oldinhidwgt,oldhidoutwgt,
	inlayer,
	hidlayer,
	outlayer,
	indelta,
	hiddelta,
	outdelta,
	desired)
float	*learning_rate,*momentum_term;
float	inhidwgt[];
long	*number_input_nodes,*number_hidden_nodes,
	*number_output_nodes;
float	hidoutwgt[];
float	oldinhidwgt[];
float	oldhidoutwgt[];
float	inlayer[],hidlayer[],outlayer[];
float	indelta[],hiddelta[],outdelta[];
float	desired[];

{
        float sum,wgthold;
        register int i,j,inhidwgt_offset,hidout_offset;
   

/* compute output deltas */

        for(j=0;j<*number_output_nodes;j++)
        outdelta[j] = outlayer[j]*(1.0-outlayer[j])*
                        (desired[j]-outlayer[j]);

/* compute hidden deltas */

        /* first compute deltas*hidden weights */
  	hidout_offset = 0; 
        for(j=0;j<*number_hidden_nodes;j++)
        {     
        sum = 0.0;
        for(i=0;i<*number_output_nodes;i++)
	{
                sum+= outdelta[i]* (*(hidoutwgt+hidout_offset));
		hidout_offset++;
  	}
 
        hiddelta[j] = hidlayer[j]*(1.0-hidlayer[j])*sum;
        } /* end of loop on j */
   
/* compute input deltas */
   
        /* first compute deltas*input weights */
	

	inhidwgt_offset=0; 
        for(j=0;j<=*number_input_nodes;j++)
        {     
        sum = 0.0;
        for(i=0;i<*number_hidden_nodes;i++)
	{
                sum+= *(inhidwgt+inhidwgt_offset)*hiddelta[i];
  		inhidwgt_offset++;
	}
 
        indelta[j] = inlayer[j]*(1.0-inlayer[j])* sum;
        } /* end of loop on j */
 
/* now adjust all the synapse weights */
   
        /* adjust hidden to output weights */

  	hidout_offset = 0; 
        for(i=0;i<*number_hidden_nodes;i++)
        {
        for(j=0;j<*number_output_nodes;j++)      
        	{
		wgthold = *(hidoutwgt+hidout_offset)
                        +*learning_rate*outdelta[j]*hidlayer[i]
			+ *momentum_term*
			(*(hidoutwgt+hidout_offset)
			-*(oldhidoutwgt+hidout_offset));

		*(oldhidoutwgt+hidout_offset) = 
			*(hidoutwgt+hidout_offset);
		*(hidoutwgt+hidout_offset) = wgthold;
		hidout_offset++;
		}		
        }
  
        /* adjust input to hidden weights */
  	inhidwgt_offset=0; 
        for(i=0;i<=*number_input_nodes;i++)
        {
        for(j=0;j<*number_hidden_nodes;j++)
		{
                wgthold = *(inhidwgt+inhidwgt_offset)
                        +*learning_rate*hiddelta[j]*inlayer[i]
			+ *momentum_term*
			(*(inhidwgt+inhidwgt_offset)-
			*(oldinhidwgt+inhidwgt_offset));
		*(oldinhidwgt+inhidwgt_offset) =
			 *(inhidwgt+inhidwgt_offset);
		*(inhidwgt+inhidwgt_offset) = wgthold;
		inhidwgt_offset++;
		}
        } /* end of loop on i */
} /* return from bprop */
                 
bptest(wrkvector,
	inhidwgt,hidoutwgt, 
	inlayer,
	hidlayer,
	outlayer,
	desired,
	adjclass,
	guessed_class,
	wrk_vector_nrow,
	number_input_nodes,
	number_hidden_nodes,
	number_output_nodes) 

float	wrkvector[];
long	adjclass[];
long	guessed_class[];
long	*number_input_nodes,*number_hidden_nodes,
	*number_output_nodes;
float	inhidwgt[];
float	hidoutwgt[];
float	inlayer[],desired[];
long	*wrk_vector_nrow;

{
/*************** test **************************/

register int i,j,wrk_vector_offset;
int idum2,ido,k;
float	test_err_rate;
float	number_missclassified,num_cycles;
int	inhidwgt_offset,hidout_offset;


wrk_vector_offset = 0;
for(ido=0;ido<*wrk_vector_nrow;ido++)
        {
        	for(i=0;i<*number_input_nodes;i++)
		{
			inlayer[i] = *(wrkvector+wrk_vector_offset);
			wrk_vector_offset++;
		}
        	inlayer[*number_input_nodes] = 1.0;
        	for(i=0;i<*number_output_nodes;i++)
                {
               	 	desired[i] = 0.00;
                	if(i==adjclass[ido]) desired[i] = 1.0;
                }
                                
		guessed_class[ido]=prop(
			number_input_nodes,
			number_hidden_nodes,
			number_output_nodes,
			inhidwgt,hidoutwgt,
			inlayer,hidlayer,outlayer
			);
		if(guessed_class[ido]==-1)
		{
			printf("guessed class = -1 \n");
			printf("returning \n");
			return(guessed_class[ido]);
		}


        if(adjclass[ido] != guessed_class[ido]) number_missclassified++;
        }                                    
}

